/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.identity;

import com.linkedin.common.UrnArray;
import com.linkedin.common.url.Url;
import com.linkedin.common.url.UrlCoercer;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CorpUserEditableInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.identity/**Linkedin corp user information that can be edited from UI*/@Aspect={\"EntityUrns\":[\"com.linkedin.common.CorpuserUrn\"],\"name\":\"corpUserEditableInfo\"}record CorpUserEditableInfo{/**About me section of the user*/aboutMe:optional string/**Teams that the user belongs to e.g. Metadata*/@Searchable.`/*`.fieldType=\"TEXT\"teams:array[string]=[]/**Skills that the user possesses e.g. Machine Learning*/@Searchable.`/*`.fieldType=\"TEXT\"skills:array[string]=[]/**A URL which points to a picture which user wants to set as a profile photo*/pictureLink:{namespace com.linkedin.common@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}=\"assets/platforms/default_avatar.png\"/**DataHub-native display name*/@Searchable={\"boostScore\":10.0,\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true}displayName:optional string/**DataHub-native Title, e.g. 'Software Engineer'*/title:optional string/**The platforms that the user commonly works with*/@Relationship.`/*`={\"entityTypes\":[\"dataPlatform\"],\"name\":\"IsUserOf\"}platforms:optional array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**The user's persona type, based on their role*/@Relationship={\"entityTypes\":[\"dataHubPersona\"],\"name\":\"IsPersona\"}persona:optional com.linkedin.common.Urn/**Slack handle for the user*/slack:optional string/**Phone number to contact the user*/phone:optional string/**Email address to contact the user*/email:optional string/**Information sources that have been used to populate this CorpUserEditableInfo.\nThese include platform resources, such as Slack members or Looker users.\nThey can also refer to other semantic urns in the future.*/informationSources:optional array[com.linkedin.common.Urn]}", SchemaFormatType.PDL);
    private String _aboutMeField = null;
    private StringArray _teamsField = null;
    private StringArray _skillsField = null;
    private Url _pictureLinkField = null;
    private String _displayNameField = null;
    private String _titleField = null;
    private UrnArray _platformsField = null;
    private Urn _personaField = null;
    private String _slackField = null;
    private String _phoneField = null;
    private String _emailField = null;
    private UrnArray _informationSourcesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_AboutMe = SCHEMA.getField("aboutMe");
    private static final RecordDataSchema.Field FIELD_Teams = SCHEMA.getField("teams");
    private static final StringArray DEFAULT_Teams;
    private static final RecordDataSchema.Field FIELD_Skills;
    private static final StringArray DEFAULT_Skills;
    private static final RecordDataSchema.Field FIELD_PictureLink;
    private static final Url DEFAULT_PictureLink;
    private static final RecordDataSchema.Field FIELD_DisplayName;
    private static final RecordDataSchema.Field FIELD_Title;
    private static final RecordDataSchema.Field FIELD_Platforms;
    private static final RecordDataSchema.Field FIELD_Persona;
    private static final RecordDataSchema.Field FIELD_Slack;
    private static final RecordDataSchema.Field FIELD_Phone;
    private static final RecordDataSchema.Field FIELD_Email;
    private static final RecordDataSchema.Field FIELD_InformationSources;

    public CorpUserEditableInfo() {
        super(new DataMap(), SCHEMA, 6);
        this.addChangeListener(this.__changeListener);
    }

    public CorpUserEditableInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasAboutMe() {
        if (this._aboutMeField != null) {
            return true;
        }
        return this._map.containsKey("aboutMe");
    }

    public void removeAboutMe() {
        this._map.remove("aboutMe");
    }

    @Nullable
    public String getAboutMe(GetMode mode) {
        return this.getAboutMe();
    }

    @Nullable
    public String getAboutMe() {
        if (this._aboutMeField != null) {
            return this._aboutMeField;
        }
        Object __rawValue = this._map.get("aboutMe");
        this._aboutMeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._aboutMeField;
    }

    public CorpUserEditableInfo setAboutMe(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAboutMe(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAboutMe();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aboutMe", value);
                this._aboutMeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aboutMe", value);
                this._aboutMeField = value;
            }
        }
        return this;
    }

    public CorpUserEditableInfo setAboutMe(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aboutMe of com.linkedin.identity.CorpUserEditableInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aboutMe", value);
        this._aboutMeField = value;
        return this;
    }

    public boolean hasTeams() {
        if (this._teamsField != null) {
            return true;
        }
        return this._map.containsKey("teams");
    }

    public void removeTeams() {
        this._map.remove("teams");
    }

    @Nullable
    public StringArray getTeams(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getTeams();
            }
            case NULL: {
                if (this._teamsField != null) {
                    return this._teamsField;
                }
                Object __rawValue = this._map.get("teams");
                this._teamsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._teamsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringArray getTeams() {
        if (this._teamsField != null) {
            return this._teamsField;
        }
        Object __rawValue = this._map.get("teams");
        if (__rawValue == null) {
            return DEFAULT_Teams;
        }
        this._teamsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._teamsField;
    }

    public CorpUserEditableInfo setTeams(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTeams(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field teams of com.linkedin.identity.CorpUserEditableInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "teams", value.data());
                this._teamsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTeams();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "teams", value.data());
                this._teamsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "teams", value.data());
                this._teamsField = value;
            }
        }
        return this;
    }

    public CorpUserEditableInfo setTeams(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field teams of com.linkedin.identity.CorpUserEditableInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "teams", value.data());
        this._teamsField = value;
        return this;
    }

    public boolean hasSkills() {
        if (this._skillsField != null) {
            return true;
        }
        return this._map.containsKey("skills");
    }

    public void removeSkills() {
        this._map.remove("skills");
    }

    @Nullable
    public StringArray getSkills(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getSkills();
            }
            case NULL: {
                if (this._skillsField != null) {
                    return this._skillsField;
                }
                Object __rawValue = this._map.get("skills");
                this._skillsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._skillsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringArray getSkills() {
        if (this._skillsField != null) {
            return this._skillsField;
        }
        Object __rawValue = this._map.get("skills");
        if (__rawValue == null) {
            return DEFAULT_Skills;
        }
        this._skillsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._skillsField;
    }

    public CorpUserEditableInfo setSkills(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSkills(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field skills of com.linkedin.identity.CorpUserEditableInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "skills", value.data());
                this._skillsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSkills();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "skills", value.data());
                this._skillsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "skills", value.data());
                this._skillsField = value;
            }
        }
        return this;
    }

    public CorpUserEditableInfo setSkills(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field skills of com.linkedin.identity.CorpUserEditableInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "skills", value.data());
        this._skillsField = value;
        return this;
    }

    public boolean hasPictureLink() {
        if (this._pictureLinkField != null) {
            return true;
        }
        return this._map.containsKey("pictureLink");
    }

    public void removePictureLink() {
        this._map.remove("pictureLink");
    }

    @Nullable
    public Url getPictureLink(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getPictureLink();
            }
            case NULL: {
                if (this._pictureLinkField != null) {
                    return this._pictureLinkField;
                }
                Object __rawValue = this._map.get("pictureLink");
                this._pictureLinkField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
                return this._pictureLinkField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Url getPictureLink() {
        if (this._pictureLinkField != null) {
            return this._pictureLinkField;
        }
        Object __rawValue = this._map.get("pictureLink");
        if (__rawValue == null) {
            return DEFAULT_PictureLink;
        }
        this._pictureLinkField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
        return this._pictureLinkField;
    }

    public CorpUserEditableInfo setPictureLink(@Nullable Url value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPictureLink(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field pictureLink of com.linkedin.identity.CorpUserEditableInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "pictureLink", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._pictureLinkField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePictureLink();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "pictureLink", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._pictureLinkField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "pictureLink", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._pictureLinkField = value;
            }
        }
        return this;
    }

    public CorpUserEditableInfo setPictureLink(@Nonnull Url value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field pictureLink of com.linkedin.identity.CorpUserEditableInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "pictureLink", DataTemplateUtil.coerceCustomInput(value, Url.class));
        this._pictureLinkField = value;
        return this;
    }

    public boolean hasDisplayName() {
        if (this._displayNameField != null) {
            return true;
        }
        return this._map.containsKey("displayName");
    }

    public void removeDisplayName() {
        this._map.remove("displayName");
    }

    @Nullable
    public String getDisplayName(GetMode mode) {
        return this.getDisplayName();
    }

    @Nullable
    public String getDisplayName() {
        if (this._displayNameField != null) {
            return this._displayNameField;
        }
        Object __rawValue = this._map.get("displayName");
        this._displayNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._displayNameField;
    }

    public CorpUserEditableInfo setDisplayName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDisplayName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDisplayName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
            }
        }
        return this;
    }

    public CorpUserEditableInfo setDisplayName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field displayName of com.linkedin.identity.CorpUserEditableInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "displayName", value);
        this._displayNameField = value;
        return this;
    }

    public boolean hasTitle() {
        if (this._titleField != null) {
            return true;
        }
        return this._map.containsKey("title");
    }

    public void removeTitle() {
        this._map.remove("title");
    }

    @Nullable
    public String getTitle(GetMode mode) {
        return this.getTitle();
    }

    @Nullable
    public String getTitle() {
        if (this._titleField != null) {
            return this._titleField;
        }
        Object __rawValue = this._map.get("title");
        this._titleField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._titleField;
    }

    public CorpUserEditableInfo setTitle(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTitle(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTitle();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
            }
        }
        return this;
    }

    public CorpUserEditableInfo setTitle(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field title of com.linkedin.identity.CorpUserEditableInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "title", value);
        this._titleField = value;
        return this;
    }

    public boolean hasPlatforms() {
        if (this._platformsField != null) {
            return true;
        }
        return this._map.containsKey("platforms");
    }

    public void removePlatforms() {
        this._map.remove("platforms");
    }

    @Nullable
    public UrnArray getPlatforms(GetMode mode) {
        return this.getPlatforms();
    }

    @Nullable
    public UrnArray getPlatforms() {
        if (this._platformsField != null) {
            return this._platformsField;
        }
        Object __rawValue = this._map.get("platforms");
        this._platformsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._platformsField;
    }

    public CorpUserEditableInfo setPlatforms(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPlatforms(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePlatforms();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "platforms", value.data());
                this._platformsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "platforms", value.data());
                this._platformsField = value;
            }
        }
        return this;
    }

    public CorpUserEditableInfo setPlatforms(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field platforms of com.linkedin.identity.CorpUserEditableInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "platforms", value.data());
        this._platformsField = value;
        return this;
    }

    public boolean hasPersona() {
        if (this._personaField != null) {
            return true;
        }
        return this._map.containsKey("persona");
    }

    public void removePersona() {
        this._map.remove("persona");
    }

    @Nullable
    public Urn getPersona(GetMode mode) {
        return this.getPersona();
    }

    @Nullable
    public Urn getPersona() {
        if (this._personaField != null) {
            return this._personaField;
        }
        Object __rawValue = this._map.get("persona");
        this._personaField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._personaField;
    }

    public CorpUserEditableInfo setPersona(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPersona(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePersona();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "persona", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._personaField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "persona", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._personaField = value;
            }
        }
        return this;
    }

    public CorpUserEditableInfo setPersona(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field persona of com.linkedin.identity.CorpUserEditableInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "persona", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._personaField = value;
        return this;
    }

    public boolean hasSlack() {
        if (this._slackField != null) {
            return true;
        }
        return this._map.containsKey("slack");
    }

    public void removeSlack() {
        this._map.remove("slack");
    }

    @Nullable
    public String getSlack(GetMode mode) {
        return this.getSlack();
    }

    @Nullable
    public String getSlack() {
        if (this._slackField != null) {
            return this._slackField;
        }
        Object __rawValue = this._map.get("slack");
        this._slackField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._slackField;
    }

    public CorpUserEditableInfo setSlack(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSlack(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSlack();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "slack", value);
                this._slackField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "slack", value);
                this._slackField = value;
            }
        }
        return this;
    }

    public CorpUserEditableInfo setSlack(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field slack of com.linkedin.identity.CorpUserEditableInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "slack", value);
        this._slackField = value;
        return this;
    }

    public boolean hasPhone() {
        if (this._phoneField != null) {
            return true;
        }
        return this._map.containsKey("phone");
    }

    public void removePhone() {
        this._map.remove("phone");
    }

    @Nullable
    public String getPhone(GetMode mode) {
        return this.getPhone();
    }

    @Nullable
    public String getPhone() {
        if (this._phoneField != null) {
            return this._phoneField;
        }
        Object __rawValue = this._map.get("phone");
        this._phoneField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._phoneField;
    }

    public CorpUserEditableInfo setPhone(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPhone(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePhone();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "phone", value);
                this._phoneField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "phone", value);
                this._phoneField = value;
            }
        }
        return this;
    }

    public CorpUserEditableInfo setPhone(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field phone of com.linkedin.identity.CorpUserEditableInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "phone", value);
        this._phoneField = value;
        return this;
    }

    public boolean hasEmail() {
        if (this._emailField != null) {
            return true;
        }
        return this._map.containsKey("email");
    }

    public void removeEmail() {
        this._map.remove("email");
    }

    @Nullable
    public String getEmail(GetMode mode) {
        return this.getEmail();
    }

    @Nullable
    public String getEmail() {
        if (this._emailField != null) {
            return this._emailField;
        }
        Object __rawValue = this._map.get("email");
        this._emailField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._emailField;
    }

    public CorpUserEditableInfo setEmail(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEmail(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEmail();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "email", value);
                this._emailField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "email", value);
                this._emailField = value;
            }
        }
        return this;
    }

    public CorpUserEditableInfo setEmail(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field email of com.linkedin.identity.CorpUserEditableInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "email", value);
        this._emailField = value;
        return this;
    }

    public boolean hasInformationSources() {
        if (this._informationSourcesField != null) {
            return true;
        }
        return this._map.containsKey("informationSources");
    }

    public void removeInformationSources() {
        this._map.remove("informationSources");
    }

    @Nullable
    public UrnArray getInformationSources(GetMode mode) {
        return this.getInformationSources();
    }

    @Nullable
    public UrnArray getInformationSources() {
        if (this._informationSourcesField != null) {
            return this._informationSourcesField;
        }
        Object __rawValue = this._map.get("informationSources");
        this._informationSourcesField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._informationSourcesField;
    }

    public CorpUserEditableInfo setInformationSources(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setInformationSources(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeInformationSources();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "informationSources", value.data());
                this._informationSourcesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "informationSources", value.data());
                this._informationSourcesField = value;
            }
        }
        return this;
    }

    public CorpUserEditableInfo setInformationSources(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field informationSources of com.linkedin.identity.CorpUserEditableInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "informationSources", value.data());
        this._informationSourcesField = value;
        return this;
    }

    @Override
    public CorpUserEditableInfo clone() throws CloneNotSupportedException {
        CorpUserEditableInfo __clone = (CorpUserEditableInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public CorpUserEditableInfo copy() throws CloneNotSupportedException {
        CorpUserEditableInfo __copy = (CorpUserEditableInfo)super.copy();
        __copy._skillsField = null;
        __copy._personaField = null;
        __copy._teamsField = null;
        __copy._phoneField = null;
        __copy._displayNameField = null;
        __copy._slackField = null;
        __copy._informationSourcesField = null;
        __copy._pictureLinkField = null;
        __copy._titleField = null;
        __copy._emailField = null;
        __copy._aboutMeField = null;
        __copy._platformsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Skills = SCHEMA.getField("skills");
        FIELD_PictureLink = SCHEMA.getField("pictureLink");
        FIELD_DisplayName = SCHEMA.getField("displayName");
        FIELD_Title = SCHEMA.getField("title");
        FIELD_Platforms = SCHEMA.getField("platforms");
        FIELD_Persona = SCHEMA.getField("persona");
        FIELD_Slack = SCHEMA.getField("slack");
        FIELD_Phone = SCHEMA.getField("phone");
        FIELD_Email = SCHEMA.getField("email");
        FIELD_InformationSources = SCHEMA.getField("informationSources");
        Custom.initializeCustomClass(Url.class);
        Custom.initializeCoercerClass(UrlCoercer.class);
        Custom.initializeCustomClass(Urn.class);
        DEFAULT_Teams = FIELD_Teams.getDefault() == null ? null : new StringArray(DataTemplateUtil.castOrThrow(FIELD_Teams.getDefault(), DataList.class));
        DEFAULT_Skills = FIELD_Skills.getDefault() == null ? null : new StringArray(DataTemplateUtil.castOrThrow(FIELD_Skills.getDefault(), DataList.class));
        DEFAULT_PictureLink = DataTemplateUtil.coerceCustomOutput(FIELD_PictureLink.getDefault(), Url.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final CorpUserEditableInfo __objectRef;

        private ChangeListener(CorpUserEditableInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "skills": {
                    this.__objectRef._skillsField = null;
                    break;
                }
                case "persona": {
                    this.__objectRef._personaField = null;
                    break;
                }
                case "teams": {
                    this.__objectRef._teamsField = null;
                    break;
                }
                case "phone": {
                    this.__objectRef._phoneField = null;
                    break;
                }
                case "displayName": {
                    this.__objectRef._displayNameField = null;
                    break;
                }
                case "slack": {
                    this.__objectRef._slackField = null;
                    break;
                }
                case "informationSources": {
                    this.__objectRef._informationSourcesField = null;
                    break;
                }
                case "pictureLink": {
                    this.__objectRef._pictureLinkField = null;
                    break;
                }
                case "title": {
                    this.__objectRef._titleField = null;
                    break;
                }
                case "email": {
                    this.__objectRef._emailField = null;
                    break;
                }
                case "aboutMe": {
                    this.__objectRef._aboutMeField = null;
                    break;
                }
                case "platforms": {
                    this.__objectRef._platformsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec aboutMe() {
            return new PathSpec(this.getPathComponents(), "aboutMe");
        }

        public PathSpec teams() {
            return new PathSpec(this.getPathComponents(), "teams");
        }

        public PathSpec teams(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "teams");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec skills() {
            return new PathSpec(this.getPathComponents(), "skills");
        }

        public PathSpec skills(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "skills");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec pictureLink() {
            return new PathSpec(this.getPathComponents(), "pictureLink");
        }

        public PathSpec displayName() {
            return new PathSpec(this.getPathComponents(), "displayName");
        }

        public PathSpec title() {
            return new PathSpec(this.getPathComponents(), "title");
        }

        public PathSpec platforms() {
            return new PathSpec(this.getPathComponents(), "platforms");
        }

        public PathSpec platforms(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "platforms");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec persona() {
            return new PathSpec(this.getPathComponents(), "persona");
        }

        public PathSpec slack() {
            return new PathSpec(this.getPathComponents(), "slack");
        }

        public PathSpec phone() {
            return new PathSpec(this.getPathComponents(), "phone");
        }

        public PathSpec email() {
            return new PathSpec(this.getPathComponents(), "email");
        }

        public PathSpec informationSources() {
            return new PathSpec(this.getPathComponents(), "informationSources");
        }

        public PathSpec informationSources(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "informationSources");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
        }

        public ProjectionMask withAboutMe() {
            this.getDataMap().put("aboutMe", 1);
            return this;
        }

        public ProjectionMask withTeams() {
            this.getDataMap().put("teams", 1);
            return this;
        }

        public ProjectionMask withTeams(Integer start, Integer count) {
            this.getDataMap().put("teams", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("teams").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("teams").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withSkills() {
            this.getDataMap().put("skills", 1);
            return this;
        }

        public ProjectionMask withSkills(Integer start, Integer count) {
            this.getDataMap().put("skills", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("skills").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("skills").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withPictureLink() {
            this.getDataMap().put("pictureLink", 1);
            return this;
        }

        public ProjectionMask withDisplayName() {
            this.getDataMap().put("displayName", 1);
            return this;
        }

        public ProjectionMask withTitle() {
            this.getDataMap().put("title", 1);
            return this;
        }

        public ProjectionMask withPlatforms() {
            this.getDataMap().put("platforms", 1);
            return this;
        }

        public ProjectionMask withPlatforms(Integer start, Integer count) {
            this.getDataMap().put("platforms", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("platforms").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("platforms").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withPersona() {
            this.getDataMap().put("persona", 1);
            return this;
        }

        public ProjectionMask withSlack() {
            this.getDataMap().put("slack", 1);
            return this;
        }

        public ProjectionMask withPhone() {
            this.getDataMap().put("phone", 1);
            return this;
        }

        public ProjectionMask withEmail() {
            this.getDataMap().put("email", 1);
            return this;
        }

        public ProjectionMask withInformationSources() {
            this.getDataMap().put("informationSources", 1);
            return this;
        }

        public ProjectionMask withInformationSources(Integer start, Integer count) {
            this.getDataMap().put("informationSources", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("informationSources").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("informationSources").put("$count", count);
            }
            return this;
        }
    }
}

