/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.glossary;

import com.linkedin.common.url.Url;
import com.linkedin.common.url.UrlCoercer;
import com.linkedin.common.urn.GlossaryNodeUrn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GlossaryTermInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.glossary/**Properties associated with a GlossaryTerm*/@Aspect.name=\"glossaryTermInfo\"record GlossaryTermInfo includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{/**Optional id for the term*/@Searchable.fieldType=\"TEXT_PARTIAL\"id:optional string/**Display name of the term*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\",\"searchLabel\":\"entityName\",\"searchTier\":1}name:optional string/**Definition of business term.*/@Searchable={}definition:string/**Parent node of the glossary term*/@Relationship={\"entityTypes\":[\"glossaryNode\"],\"name\":\"IsPartOf\"}@Searchable={\"fieldName\":\"parentNode\",\"fieldType\":\"URN\",\"hasValuesFieldName\":\"hasParentNode\"}parentNode:optional{namespace com.linkedin.common/**Business Node*/@java.class=\"com.linkedin.common.urn.GlossaryNodeUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized business node identifier\",\"entityType\":\"glossaryNode\",\"fields\":[{\"doc\":\"The name of business node with hierarchy.\",\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":56,\"name\":\"GlossaryNode\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref GlossaryNodeUrn=string}/**Source of the Business Term (INTERNAL or EXTERNAL) with default value as INTERNAL*/@Searchable.fieldType=\"KEYWORD\"termSource:string/**External Reference to the business-term*/@Searchable.fieldType=\"KEYWORD\"sourceRef:optional string/**The abstracted URL such as https://spec.edmcouncil.org/fibo/ontology/FBC/FinancialInstruments/FinancialInstruments/CashInstrument.*/sourceUrl:optional{namespace com.linkedin.common@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}/**Schema definition of the glossary term*/@deprecated,rawSchema:optional string}", SchemaFormatType.PDL);
    private StringMap _customPropertiesField = null;
    private String _idField = null;
    private String _nameField = null;
    private String _definitionField = null;
    private GlossaryNodeUrn _parentNodeField = null;
    private String _termSourceField = null;
    private String _sourceRefField = null;
    private Url _sourceUrlField = null;
    private String _rawSchemaField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CustomProperties = SCHEMA.getField("customProperties");
    private static final StringMap DEFAULT_CustomProperties;
    private static final RecordDataSchema.Field FIELD_Id;
    private static final RecordDataSchema.Field FIELD_Name;
    private static final RecordDataSchema.Field FIELD_Definition;
    private static final RecordDataSchema.Field FIELD_ParentNode;
    private static final RecordDataSchema.Field FIELD_TermSource;
    private static final RecordDataSchema.Field FIELD_SourceRef;
    private static final RecordDataSchema.Field FIELD_SourceUrl;
    private static final RecordDataSchema.Field FIELD_RawSchema;

    public GlossaryTermInfo() {
        super(new DataMap(12, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public GlossaryTermInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCustomProperties();
            }
            case NULL: {
                if (this._customPropertiesField != null) {
                    return this._customPropertiesField;
                }
                Object __rawValue = this._map.get("customProperties");
                this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._customPropertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        if (__rawValue == null) {
            return DEFAULT_CustomProperties;
        }
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public GlossaryTermInfo setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field customProperties of com.linkedin.glossary.GlossaryTermInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public GlossaryTermInfo setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.glossary.GlossaryTermInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasId() {
        if (this._idField != null) {
            return true;
        }
        return this._map.containsKey("id");
    }

    public void removeId() {
        this._map.remove("id");
    }

    @Nullable
    public String getId(GetMode mode) {
        return this.getId();
    }

    @Nullable
    public String getId() {
        if (this._idField != null) {
            return this._idField;
        }
        Object __rawValue = this._map.get("id");
        this._idField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._idField;
    }

    public GlossaryTermInfo setId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "id", value);
                this._idField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "id", value);
                this._idField = value;
            }
        }
        return this;
    }

    public GlossaryTermInfo setId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field id of com.linkedin.glossary.GlossaryTermInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "id", value);
        this._idField = value;
        return this;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        return this.getName();
    }

    @Nullable
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public GlossaryTermInfo setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public GlossaryTermInfo setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.glossary.GlossaryTermInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasDefinition() {
        if (this._definitionField != null) {
            return true;
        }
        return this._map.containsKey("definition");
    }

    public void removeDefinition() {
        this._map.remove("definition");
    }

    @Nullable
    public String getDefinition(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDefinition();
            }
            case DEFAULT: 
            case NULL: {
                if (this._definitionField != null) {
                    return this._definitionField;
                }
                Object __rawValue = this._map.get("definition");
                this._definitionField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._definitionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getDefinition() {
        if (this._definitionField != null) {
            return this._definitionField;
        }
        Object __rawValue = this._map.get("definition");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("definition");
        }
        this._definitionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._definitionField;
    }

    public GlossaryTermInfo setDefinition(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDefinition(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field definition of com.linkedin.glossary.GlossaryTermInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "definition", value);
                this._definitionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDefinition();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "definition", value);
                this._definitionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "definition", value);
                this._definitionField = value;
            }
        }
        return this;
    }

    public GlossaryTermInfo setDefinition(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field definition of com.linkedin.glossary.GlossaryTermInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "definition", value);
        this._definitionField = value;
        return this;
    }

    public boolean hasParentNode() {
        if (this._parentNodeField != null) {
            return true;
        }
        return this._map.containsKey("parentNode");
    }

    public void removeParentNode() {
        this._map.remove("parentNode");
    }

    @Nullable
    public GlossaryNodeUrn getParentNode(GetMode mode) {
        return this.getParentNode();
    }

    @Nullable
    public GlossaryNodeUrn getParentNode() {
        if (this._parentNodeField != null) {
            return this._parentNodeField;
        }
        Object __rawValue = this._map.get("parentNode");
        this._parentNodeField = DataTemplateUtil.coerceCustomOutput(__rawValue, GlossaryNodeUrn.class);
        return this._parentNodeField;
    }

    public GlossaryTermInfo setParentNode(@Nullable GlossaryNodeUrn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setParentNode(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeParentNode();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "parentNode", DataTemplateUtil.coerceCustomInput(value, GlossaryNodeUrn.class));
                this._parentNodeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "parentNode", DataTemplateUtil.coerceCustomInput(value, GlossaryNodeUrn.class));
                this._parentNodeField = value;
            }
        }
        return this;
    }

    public GlossaryTermInfo setParentNode(@Nonnull GlossaryNodeUrn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field parentNode of com.linkedin.glossary.GlossaryTermInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "parentNode", DataTemplateUtil.coerceCustomInput(value, GlossaryNodeUrn.class));
        this._parentNodeField = value;
        return this;
    }

    public boolean hasTermSource() {
        if (this._termSourceField != null) {
            return true;
        }
        return this._map.containsKey("termSource");
    }

    public void removeTermSource() {
        this._map.remove("termSource");
    }

    @Nullable
    public String getTermSource(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTermSource();
            }
            case DEFAULT: 
            case NULL: {
                if (this._termSourceField != null) {
                    return this._termSourceField;
                }
                Object __rawValue = this._map.get("termSource");
                this._termSourceField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._termSourceField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getTermSource() {
        if (this._termSourceField != null) {
            return this._termSourceField;
        }
        Object __rawValue = this._map.get("termSource");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("termSource");
        }
        this._termSourceField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._termSourceField;
    }

    public GlossaryTermInfo setTermSource(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTermSource(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field termSource of com.linkedin.glossary.GlossaryTermInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "termSource", value);
                this._termSourceField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTermSource();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "termSource", value);
                this._termSourceField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "termSource", value);
                this._termSourceField = value;
            }
        }
        return this;
    }

    public GlossaryTermInfo setTermSource(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field termSource of com.linkedin.glossary.GlossaryTermInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "termSource", value);
        this._termSourceField = value;
        return this;
    }

    public boolean hasSourceRef() {
        if (this._sourceRefField != null) {
            return true;
        }
        return this._map.containsKey("sourceRef");
    }

    public void removeSourceRef() {
        this._map.remove("sourceRef");
    }

    @Nullable
    public String getSourceRef(GetMode mode) {
        return this.getSourceRef();
    }

    @Nullable
    public String getSourceRef() {
        if (this._sourceRefField != null) {
            return this._sourceRefField;
        }
        Object __rawValue = this._map.get("sourceRef");
        this._sourceRefField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._sourceRefField;
    }

    public GlossaryTermInfo setSourceRef(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSourceRef(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSourceRef();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "sourceRef", value);
                this._sourceRefField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "sourceRef", value);
                this._sourceRefField = value;
            }
        }
        return this;
    }

    public GlossaryTermInfo setSourceRef(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field sourceRef of com.linkedin.glossary.GlossaryTermInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "sourceRef", value);
        this._sourceRefField = value;
        return this;
    }

    public boolean hasSourceUrl() {
        if (this._sourceUrlField != null) {
            return true;
        }
        return this._map.containsKey("sourceUrl");
    }

    public void removeSourceUrl() {
        this._map.remove("sourceUrl");
    }

    @Nullable
    public Url getSourceUrl(GetMode mode) {
        return this.getSourceUrl();
    }

    @Nullable
    public Url getSourceUrl() {
        if (this._sourceUrlField != null) {
            return this._sourceUrlField;
        }
        Object __rawValue = this._map.get("sourceUrl");
        this._sourceUrlField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
        return this._sourceUrlField;
    }

    public GlossaryTermInfo setSourceUrl(@Nullable Url value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSourceUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSourceUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "sourceUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._sourceUrlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "sourceUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._sourceUrlField = value;
            }
        }
        return this;
    }

    public GlossaryTermInfo setSourceUrl(@Nonnull Url value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field sourceUrl of com.linkedin.glossary.GlossaryTermInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "sourceUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
        this._sourceUrlField = value;
        return this;
    }

    @Deprecated
    public boolean hasRawSchema() {
        if (this._rawSchemaField != null) {
            return true;
        }
        return this._map.containsKey("rawSchema");
    }

    @Deprecated
    public void removeRawSchema() {
        this._map.remove("rawSchema");
    }

    @Deprecated
    @Nullable
    public String getRawSchema(GetMode mode) {
        return this.getRawSchema();
    }

    @Deprecated
    @Nullable
    public String getRawSchema() {
        if (this._rawSchemaField != null) {
            return this._rawSchemaField;
        }
        Object __rawValue = this._map.get("rawSchema");
        this._rawSchemaField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._rawSchemaField;
    }

    @Deprecated
    public GlossaryTermInfo setRawSchema(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRawSchema(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRawSchema();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "rawSchema", value);
                this._rawSchemaField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "rawSchema", value);
                this._rawSchemaField = value;
            }
        }
        return this;
    }

    @Deprecated
    public GlossaryTermInfo setRawSchema(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field rawSchema of com.linkedin.glossary.GlossaryTermInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "rawSchema", value);
        this._rawSchemaField = value;
        return this;
    }

    @Override
    public GlossaryTermInfo clone() throws CloneNotSupportedException {
        GlossaryTermInfo __clone = (GlossaryTermInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public GlossaryTermInfo copy() throws CloneNotSupportedException {
        GlossaryTermInfo __copy = (GlossaryTermInfo)super.copy();
        __copy._sourceUrlField = null;
        __copy._customPropertiesField = null;
        __copy._nameField = null;
        __copy._definitionField = null;
        __copy._idField = null;
        __copy._parentNodeField = null;
        __copy._sourceRefField = null;
        __copy._termSourceField = null;
        __copy._rawSchemaField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Id = SCHEMA.getField("id");
        FIELD_Name = SCHEMA.getField("name");
        FIELD_Definition = SCHEMA.getField("definition");
        FIELD_ParentNode = SCHEMA.getField("parentNode");
        FIELD_TermSource = SCHEMA.getField("termSource");
        FIELD_SourceRef = SCHEMA.getField("sourceRef");
        FIELD_SourceUrl = SCHEMA.getField("sourceUrl");
        FIELD_RawSchema = SCHEMA.getField("rawSchema");
        Custom.initializeCustomClass(GlossaryNodeUrn.class);
        Custom.initializeCustomClass(Url.class);
        Custom.initializeCoercerClass(UrlCoercer.class);
        DEFAULT_CustomProperties = FIELD_CustomProperties.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_CustomProperties.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final GlossaryTermInfo __objectRef;

        private ChangeListener(GlossaryTermInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "sourceUrl": {
                    this.__objectRef._sourceUrlField = null;
                    break;
                }
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "definition": {
                    this.__objectRef._definitionField = null;
                    break;
                }
                case "id": {
                    this.__objectRef._idField = null;
                    break;
                }
                case "parentNode": {
                    this.__objectRef._parentNodeField = null;
                    break;
                }
                case "sourceRef": {
                    this.__objectRef._sourceRefField = null;
                    break;
                }
                case "termSource": {
                    this.__objectRef._termSourceField = null;
                    break;
                }
                case "rawSchema": {
                    this.__objectRef._rawSchemaField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public PathSpec id() {
            return new PathSpec(this.getPathComponents(), "id");
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec definition() {
            return new PathSpec(this.getPathComponents(), "definition");
        }

        public PathSpec parentNode() {
            return new PathSpec(this.getPathComponents(), "parentNode");
        }

        public PathSpec termSource() {
            return new PathSpec(this.getPathComponents(), "termSource");
        }

        public PathSpec sourceRef() {
            return new PathSpec(this.getPathComponents(), "sourceRef");
        }

        public PathSpec sourceUrl() {
            return new PathSpec(this.getPathComponents(), "sourceUrl");
        }

        @Deprecated
        public PathSpec rawSchema() {
            return new PathSpec(this.getPathComponents(), "rawSchema");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(12);
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withId() {
            this.getDataMap().put("id", 1);
            return this;
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withDefinition() {
            this.getDataMap().put("definition", 1);
            return this;
        }

        public ProjectionMask withParentNode() {
            this.getDataMap().put("parentNode", 1);
            return this;
        }

        public ProjectionMask withTermSource() {
            this.getDataMap().put("termSource", 1);
            return this;
        }

        public ProjectionMask withSourceRef() {
            this.getDataMap().put("sourceRef", 1);
            return this;
        }

        public ProjectionMask withSourceUrl() {
            this.getDataMap().put("sourceUrl", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withRawSchema() {
            this.getDataMap().put("rawSchema", 1);
            return this;
        }
    }
}

