/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.form;

import com.linkedin.common.UrnArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FormActorAssignment
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.form,record FormActorAssignment{/**Whether the form should be assigned to the owners of assets that it is applied to.\nThis is the default.*/@Searchable={\"fieldName\":\"isOwnershipForm\",\"fieldType\":\"BOOLEAN\"}owners:boolean=true/**Optional: Specific set of groups that are targeted by this form assignment.*/@Searchable.`/*`={\"fieldName\":\"assignedGroups\",\"fieldType\":\"URN\"}groups:optional array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**Optional: Specific set of users that are targeted by this form assignment.*/@Searchable.`/*`={\"fieldName\":\"assignedUsers\",\"fieldType\":\"URN\"}users:optional array[com.linkedin.common.Urn]}", SchemaFormatType.PDL);
    private Boolean _ownersField = null;
    private UrnArray _groupsField = null;
    private UrnArray _usersField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Owners = SCHEMA.getField("owners");
    private static final Boolean DEFAULT_Owners;
    private static final RecordDataSchema.Field FIELD_Groups;
    private static final RecordDataSchema.Field FIELD_Users;

    public FormActorAssignment() {
        super(new DataMap(4, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public FormActorAssignment(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasOwners() {
        if (this._ownersField != null) {
            return true;
        }
        return this._map.containsKey("owners");
    }

    public void removeOwners() {
        this._map.remove("owners");
    }

    @Nullable
    public Boolean isOwners(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isOwners();
            }
            case NULL: {
                if (this._ownersField != null) {
                    return this._ownersField;
                }
                Object __rawValue = this._map.get("owners");
                this._ownersField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._ownersField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isOwners() {
        if (this._ownersField != null) {
            return this._ownersField;
        }
        Object __rawValue = this._map.get("owners");
        if (__rawValue == null) {
            return DEFAULT_Owners;
        }
        this._ownersField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._ownersField;
    }

    public FormActorAssignment setOwners(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOwners(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field owners of com.linkedin.form.FormActorAssignment");
                }
                CheckedUtil.putWithoutChecking(this._map, "owners", value);
                this._ownersField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOwners();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "owners", value);
                this._ownersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "owners", value);
                this._ownersField = value;
            }
        }
        return this;
    }

    public FormActorAssignment setOwners(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field owners of com.linkedin.form.FormActorAssignment to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "owners", value);
        this._ownersField = value;
        return this;
    }

    public FormActorAssignment setOwners(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "owners", value);
        this._ownersField = value;
        return this;
    }

    public boolean hasGroups() {
        if (this._groupsField != null) {
            return true;
        }
        return this._map.containsKey("groups");
    }

    public void removeGroups() {
        this._map.remove("groups");
    }

    @Nullable
    public UrnArray getGroups(GetMode mode) {
        return this.getGroups();
    }

    @Nullable
    public UrnArray getGroups() {
        if (this._groupsField != null) {
            return this._groupsField;
        }
        Object __rawValue = this._map.get("groups");
        this._groupsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._groupsField;
    }

    public FormActorAssignment setGroups(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGroups(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGroups();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
            }
        }
        return this;
    }

    public FormActorAssignment setGroups(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field groups of com.linkedin.form.FormActorAssignment to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
        this._groupsField = value;
        return this;
    }

    public boolean hasUsers() {
        if (this._usersField != null) {
            return true;
        }
        return this._map.containsKey("users");
    }

    public void removeUsers() {
        this._map.remove("users");
    }

    @Nullable
    public UrnArray getUsers(GetMode mode) {
        return this.getUsers();
    }

    @Nullable
    public UrnArray getUsers() {
        if (this._usersField != null) {
            return this._usersField;
        }
        Object __rawValue = this._map.get("users");
        this._usersField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._usersField;
    }

    public FormActorAssignment setUsers(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUsers(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUsers();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "users", value.data());
                this._usersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "users", value.data());
                this._usersField = value;
            }
        }
        return this;
    }

    public FormActorAssignment setUsers(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field users of com.linkedin.form.FormActorAssignment to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "users", value.data());
        this._usersField = value;
        return this;
    }

    @Override
    public FormActorAssignment clone() throws CloneNotSupportedException {
        FormActorAssignment __clone = (FormActorAssignment)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public FormActorAssignment copy() throws CloneNotSupportedException {
        FormActorAssignment __copy = (FormActorAssignment)super.copy();
        __copy._groupsField = null;
        __copy._ownersField = null;
        __copy._usersField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Groups = SCHEMA.getField("groups");
        FIELD_Users = SCHEMA.getField("users");
        DEFAULT_Owners = DataTemplateUtil.coerceBooleanOutput(FIELD_Owners.getDefault());
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final FormActorAssignment __objectRef;

        private ChangeListener(FormActorAssignment reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "groups": {
                    this.__objectRef._groupsField = null;
                    break;
                }
                case "owners": {
                    this.__objectRef._ownersField = null;
                    break;
                }
                case "users": {
                    this.__objectRef._usersField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec owners() {
            return new PathSpec(this.getPathComponents(), "owners");
        }

        public PathSpec groups() {
            return new PathSpec(this.getPathComponents(), "groups");
        }

        public PathSpec groups(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "groups");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec users() {
            return new PathSpec(this.getPathComponents(), "users");
        }

        public PathSpec users(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "users");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withOwners() {
            this.getDataMap().put("owners", 1);
            return this;
        }

        public ProjectionMask withGroups() {
            this.getDataMap().put("groups", 1);
            return this;
        }

        public ProjectionMask withGroups(Integer start, Integer count) {
            this.getDataMap().put("groups", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("groups").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("groups").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withUsers() {
            this.getDataMap().put("users", 1);
            return this;
        }

        public ProjectionMask withUsers(Integer start, Integer count) {
            this.getDataMap().put("users", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("users").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("users").put("$count", count);
            }
            return this;
        }
    }
}

