/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.execution;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StructuredExecutionReport
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.execution/**A flexible carrier for structured results of an execution request.\nThe goal is to allow for free flow of structured responses from execution tasks to the orchestrator or observer.\nThe full spectrum of different execution report types is not intended to be modeled by this object.*/record StructuredExecutionReport{/**The type of the structured report. (e.g. INGESTION_REPORT, TEST_CONNECTION_REPORT, etc.)*/type:string/**The serialized value of the structured report\n*/serializedValue:string/**The content-type of the serialized value (e.g. application/json, application/json;gzip etc.)\n*/contentType:string}", SchemaFormatType.PDL);
    private String _typeField = null;
    private String _serializedValueField = null;
    private String _contentTypeField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_SerializedValue = SCHEMA.getField("serializedValue");
    private static final RecordDataSchema.Field FIELD_ContentType = SCHEMA.getField("contentType");

    public StructuredExecutionReport() {
        super(new DataMap(4, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public StructuredExecutionReport(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public String getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._typeField;
    }

    public StructuredExecutionReport setType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.execution.StructuredExecutionReport");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
            }
        }
        return this;
    }

    public StructuredExecutionReport setType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.execution.StructuredExecutionReport to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value);
        this._typeField = value;
        return this;
    }

    public boolean hasSerializedValue() {
        if (this._serializedValueField != null) {
            return true;
        }
        return this._map.containsKey("serializedValue");
    }

    public void removeSerializedValue() {
        this._map.remove("serializedValue");
    }

    @Nullable
    public String getSerializedValue(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSerializedValue();
            }
            case DEFAULT: 
            case NULL: {
                if (this._serializedValueField != null) {
                    return this._serializedValueField;
                }
                Object __rawValue = this._map.get("serializedValue");
                this._serializedValueField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._serializedValueField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getSerializedValue() {
        if (this._serializedValueField != null) {
            return this._serializedValueField;
        }
        Object __rawValue = this._map.get("serializedValue");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("serializedValue");
        }
        this._serializedValueField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._serializedValueField;
    }

    public StructuredExecutionReport setSerializedValue(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSerializedValue(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field serializedValue of com.linkedin.execution.StructuredExecutionReport");
                }
                CheckedUtil.putWithoutChecking(this._map, "serializedValue", value);
                this._serializedValueField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSerializedValue();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "serializedValue", value);
                this._serializedValueField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "serializedValue", value);
                this._serializedValueField = value;
            }
        }
        return this;
    }

    public StructuredExecutionReport setSerializedValue(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field serializedValue of com.linkedin.execution.StructuredExecutionReport to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "serializedValue", value);
        this._serializedValueField = value;
        return this;
    }

    public boolean hasContentType() {
        if (this._contentTypeField != null) {
            return true;
        }
        return this._map.containsKey("contentType");
    }

    public void removeContentType() {
        this._map.remove("contentType");
    }

    @Nullable
    public String getContentType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getContentType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._contentTypeField != null) {
                    return this._contentTypeField;
                }
                Object __rawValue = this._map.get("contentType");
                this._contentTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._contentTypeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getContentType() {
        if (this._contentTypeField != null) {
            return this._contentTypeField;
        }
        Object __rawValue = this._map.get("contentType");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("contentType");
        }
        this._contentTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._contentTypeField;
    }

    public StructuredExecutionReport setContentType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setContentType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field contentType of com.linkedin.execution.StructuredExecutionReport");
                }
                CheckedUtil.putWithoutChecking(this._map, "contentType", value);
                this._contentTypeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeContentType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "contentType", value);
                this._contentTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "contentType", value);
                this._contentTypeField = value;
            }
        }
        return this;
    }

    public StructuredExecutionReport setContentType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field contentType of com.linkedin.execution.StructuredExecutionReport to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "contentType", value);
        this._contentTypeField = value;
        return this;
    }

    @Override
    public StructuredExecutionReport clone() throws CloneNotSupportedException {
        StructuredExecutionReport __clone = (StructuredExecutionReport)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public StructuredExecutionReport copy() throws CloneNotSupportedException {
        StructuredExecutionReport __copy = (StructuredExecutionReport)super.copy();
        __copy._serializedValueField = null;
        __copy._typeField = null;
        __copy._contentTypeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final StructuredExecutionReport __objectRef;

        private ChangeListener(StructuredExecutionReport reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "serializedValue": {
                    this.__objectRef._serializedValueField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "contentType": {
                    this.__objectRef._contentTypeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec serializedValue() {
            return new PathSpec(this.getPathComponents(), "serializedValue");
        }

        public PathSpec contentType() {
            return new PathSpec(this.getPathComponents(), "contentType");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withSerializedValue() {
            this.getDataMap().put("serializedValue", 1);
            return this;
        }

        public ProjectionMask withContentType() {
            this.getDataMap().put("contentType", 1);
            return this;
        }
    }
}

