/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.dataset.ValueFrequency;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class ValueFrequencyArray
extends WrappingArrayTemplate<ValueFrequency> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.dataset,record ValueFrequency{value:string,frequency:long}}]", SchemaFormatType.PDL);

    public ValueFrequencyArray() {
        this(new DataList());
    }

    public ValueFrequencyArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public ValueFrequencyArray(Collection<ValueFrequency> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public ValueFrequencyArray(DataList data) {
        super(data, SCHEMA, ValueFrequency.class);
    }

    public ValueFrequencyArray(ValueFrequency first, ValueFrequency ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public ValueFrequencyArray clone() throws CloneNotSupportedException {
        ValueFrequencyArray __clone = (ValueFrequencyArray)super.clone();
        return __clone;
    }

    @Override
    public ValueFrequencyArray copy() throws CloneNotSupportedException {
        ValueFrequencyArray __copy = (ValueFrequencyArray)super.copy();
        return __copy;
    }

    @Override
    protected ValueFrequency coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new ValueFrequency(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private ValueFrequency.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<ValueFrequency.ProjectionMask, ValueFrequency.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? ValueFrequency.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public ValueFrequency.Fields items() {
            return new ValueFrequency.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

