/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.datahub;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DoubleMap;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.datahub.SearchFieldType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataHubSearchConfig
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.datahub/**Configuration for how any given field should be indexed and matched in the DataHub search index.\n*/record DataHubSearchConfig{/**Name of the field in the search index. Defaults to the field name otherwise\n*/fieldName:optional string/**Type of the field. Defines how the field is indexed and matched\n*/fieldType:optional enum SearchFieldType{KEYWORD,TEXT,TEXT_PARTIAL,BROWSE_PATH,URN,URN_PARTIAL,BOOLEAN,COUNT,DATETIME,OBJECT,BROWSE_PATH_V2,WORD_GRAM}/**Whether we should match the field for the default search query\n*/queryByDefault:boolean=false/**Whether we should use the field for default autocomplete\n*/enableAutocomplete:boolean=false/**Whether or not to add field to filters.\n*/addToFilters:boolean=false/**Whether or not to add the \"has values\" to filters.\ncheck if this is conditional on addToFilters being true\n*/addHasValuesToFilters:boolean=true/**Display name of the filter\n*/filterNameOverride:optional string/**Display name of the has values filter\n*/hasValuesFilterNameOverride:optional string/**Boost multiplier to the match score. Matches on fields with higher boost score ranks higher\n*/boostScore:double=1.0/**If set, add a index field of the given name that checks whether the field exists\n*/hasValuesFieldName:optional string/**If set, add a index field of the given name that checks the number of elements\n*/numValuesFieldName:optional string/**(Optional) Weights to apply to score for a given value\n*/weightsPerFieldValue:optional map[string,double]/**(Optional) Aliases for this given field that can be used for sorting etc.\n*/fieldNameAliases:optional array[string]}", SchemaFormatType.PDL);
    private String _fieldNameField = null;
    private SearchFieldType _fieldTypeField = null;
    private Boolean _queryByDefaultField = null;
    private Boolean _enableAutocompleteField = null;
    private Boolean _addToFiltersField = null;
    private Boolean _addHasValuesToFiltersField = null;
    private String _filterNameOverrideField = null;
    private String _hasValuesFilterNameOverrideField = null;
    private Double _boostScoreField = null;
    private String _hasValuesFieldNameField = null;
    private String _numValuesFieldNameField = null;
    private DoubleMap _weightsPerFieldValueField = null;
    private StringArray _fieldNameAliasesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_FieldName = SCHEMA.getField("fieldName");
    private static final RecordDataSchema.Field FIELD_FieldType = SCHEMA.getField("fieldType");
    private static final RecordDataSchema.Field FIELD_QueryByDefault = SCHEMA.getField("queryByDefault");
    private static final Boolean DEFAULT_QueryByDefault;
    private static final RecordDataSchema.Field FIELD_EnableAutocomplete;
    private static final Boolean DEFAULT_EnableAutocomplete;
    private static final RecordDataSchema.Field FIELD_AddToFilters;
    private static final Boolean DEFAULT_AddToFilters;
    private static final RecordDataSchema.Field FIELD_AddHasValuesToFilters;
    private static final Boolean DEFAULT_AddHasValuesToFilters;
    private static final RecordDataSchema.Field FIELD_FilterNameOverride;
    private static final RecordDataSchema.Field FIELD_HasValuesFilterNameOverride;
    private static final RecordDataSchema.Field FIELD_BoostScore;
    private static final Double DEFAULT_BoostScore;
    private static final RecordDataSchema.Field FIELD_HasValuesFieldName;
    private static final RecordDataSchema.Field FIELD_NumValuesFieldName;
    private static final RecordDataSchema.Field FIELD_WeightsPerFieldValue;
    private static final RecordDataSchema.Field FIELD_FieldNameAliases;

    public DataHubSearchConfig() {
        super(new DataMap(), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public DataHubSearchConfig(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasFieldName() {
        if (this._fieldNameField != null) {
            return true;
        }
        return this._map.containsKey("fieldName");
    }

    public void removeFieldName() {
        this._map.remove("fieldName");
    }

    @Nullable
    public String getFieldName(GetMode mode) {
        return this.getFieldName();
    }

    @Nullable
    public String getFieldName() {
        if (this._fieldNameField != null) {
            return this._fieldNameField;
        }
        Object __rawValue = this._map.get("fieldName");
        this._fieldNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._fieldNameField;
    }

    public DataHubSearchConfig setFieldName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFieldName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFieldName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fieldName", value);
                this._fieldNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fieldName", value);
                this._fieldNameField = value;
            }
        }
        return this;
    }

    public DataHubSearchConfig setFieldName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fieldName of com.linkedin.datahub.DataHubSearchConfig to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fieldName", value);
        this._fieldNameField = value;
        return this;
    }

    public boolean hasFieldType() {
        if (this._fieldTypeField != null) {
            return true;
        }
        return this._map.containsKey("fieldType");
    }

    public void removeFieldType() {
        this._map.remove("fieldType");
    }

    @Nullable
    public SearchFieldType getFieldType(GetMode mode) {
        return this.getFieldType();
    }

    @Nullable
    public SearchFieldType getFieldType() {
        if (this._fieldTypeField != null) {
            return this._fieldTypeField;
        }
        Object __rawValue = this._map.get("fieldType");
        this._fieldTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, SearchFieldType.class, SearchFieldType.$UNKNOWN);
        return this._fieldTypeField;
    }

    public DataHubSearchConfig setFieldType(@Nullable SearchFieldType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFieldType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFieldType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fieldType", value.name());
                this._fieldTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fieldType", value.name());
                this._fieldTypeField = value;
            }
        }
        return this;
    }

    public DataHubSearchConfig setFieldType(@Nonnull SearchFieldType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fieldType of com.linkedin.datahub.DataHubSearchConfig to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fieldType", value.name());
        this._fieldTypeField = value;
        return this;
    }

    public boolean hasQueryByDefault() {
        if (this._queryByDefaultField != null) {
            return true;
        }
        return this._map.containsKey("queryByDefault");
    }

    public void removeQueryByDefault() {
        this._map.remove("queryByDefault");
    }

    @Nullable
    public Boolean isQueryByDefault(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isQueryByDefault();
            }
            case NULL: {
                if (this._queryByDefaultField != null) {
                    return this._queryByDefaultField;
                }
                Object __rawValue = this._map.get("queryByDefault");
                this._queryByDefaultField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._queryByDefaultField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isQueryByDefault() {
        if (this._queryByDefaultField != null) {
            return this._queryByDefaultField;
        }
        Object __rawValue = this._map.get("queryByDefault");
        if (__rawValue == null) {
            return DEFAULT_QueryByDefault;
        }
        this._queryByDefaultField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._queryByDefaultField;
    }

    public DataHubSearchConfig setQueryByDefault(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setQueryByDefault(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field queryByDefault of com.linkedin.datahub.DataHubSearchConfig");
                }
                CheckedUtil.putWithoutChecking(this._map, "queryByDefault", value);
                this._queryByDefaultField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeQueryByDefault();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "queryByDefault", value);
                this._queryByDefaultField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "queryByDefault", value);
                this._queryByDefaultField = value;
            }
        }
        return this;
    }

    public DataHubSearchConfig setQueryByDefault(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field queryByDefault of com.linkedin.datahub.DataHubSearchConfig to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "queryByDefault", value);
        this._queryByDefaultField = value;
        return this;
    }

    public DataHubSearchConfig setQueryByDefault(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "queryByDefault", value);
        this._queryByDefaultField = value;
        return this;
    }

    public boolean hasEnableAutocomplete() {
        if (this._enableAutocompleteField != null) {
            return true;
        }
        return this._map.containsKey("enableAutocomplete");
    }

    public void removeEnableAutocomplete() {
        this._map.remove("enableAutocomplete");
    }

    @Nullable
    public Boolean isEnableAutocomplete(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isEnableAutocomplete();
            }
            case NULL: {
                if (this._enableAutocompleteField != null) {
                    return this._enableAutocompleteField;
                }
                Object __rawValue = this._map.get("enableAutocomplete");
                this._enableAutocompleteField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._enableAutocompleteField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isEnableAutocomplete() {
        if (this._enableAutocompleteField != null) {
            return this._enableAutocompleteField;
        }
        Object __rawValue = this._map.get("enableAutocomplete");
        if (__rawValue == null) {
            return DEFAULT_EnableAutocomplete;
        }
        this._enableAutocompleteField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._enableAutocompleteField;
    }

    public DataHubSearchConfig setEnableAutocomplete(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEnableAutocomplete(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field enableAutocomplete of com.linkedin.datahub.DataHubSearchConfig");
                }
                CheckedUtil.putWithoutChecking(this._map, "enableAutocomplete", value);
                this._enableAutocompleteField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEnableAutocomplete();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "enableAutocomplete", value);
                this._enableAutocompleteField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "enableAutocomplete", value);
                this._enableAutocompleteField = value;
            }
        }
        return this;
    }

    public DataHubSearchConfig setEnableAutocomplete(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field enableAutocomplete of com.linkedin.datahub.DataHubSearchConfig to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "enableAutocomplete", value);
        this._enableAutocompleteField = value;
        return this;
    }

    public DataHubSearchConfig setEnableAutocomplete(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "enableAutocomplete", value);
        this._enableAutocompleteField = value;
        return this;
    }

    public boolean hasAddToFilters() {
        if (this._addToFiltersField != null) {
            return true;
        }
        return this._map.containsKey("addToFilters");
    }

    public void removeAddToFilters() {
        this._map.remove("addToFilters");
    }

    @Nullable
    public Boolean isAddToFilters(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isAddToFilters();
            }
            case NULL: {
                if (this._addToFiltersField != null) {
                    return this._addToFiltersField;
                }
                Object __rawValue = this._map.get("addToFilters");
                this._addToFiltersField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._addToFiltersField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isAddToFilters() {
        if (this._addToFiltersField != null) {
            return this._addToFiltersField;
        }
        Object __rawValue = this._map.get("addToFilters");
        if (__rawValue == null) {
            return DEFAULT_AddToFilters;
        }
        this._addToFiltersField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._addToFiltersField;
    }

    public DataHubSearchConfig setAddToFilters(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAddToFilters(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field addToFilters of com.linkedin.datahub.DataHubSearchConfig");
                }
                CheckedUtil.putWithoutChecking(this._map, "addToFilters", value);
                this._addToFiltersField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAddToFilters();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "addToFilters", value);
                this._addToFiltersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "addToFilters", value);
                this._addToFiltersField = value;
            }
        }
        return this;
    }

    public DataHubSearchConfig setAddToFilters(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field addToFilters of com.linkedin.datahub.DataHubSearchConfig to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "addToFilters", value);
        this._addToFiltersField = value;
        return this;
    }

    public DataHubSearchConfig setAddToFilters(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "addToFilters", value);
        this._addToFiltersField = value;
        return this;
    }

    public boolean hasAddHasValuesToFilters() {
        if (this._addHasValuesToFiltersField != null) {
            return true;
        }
        return this._map.containsKey("addHasValuesToFilters");
    }

    public void removeAddHasValuesToFilters() {
        this._map.remove("addHasValuesToFilters");
    }

    @Nullable
    public Boolean isAddHasValuesToFilters(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isAddHasValuesToFilters();
            }
            case NULL: {
                if (this._addHasValuesToFiltersField != null) {
                    return this._addHasValuesToFiltersField;
                }
                Object __rawValue = this._map.get("addHasValuesToFilters");
                this._addHasValuesToFiltersField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._addHasValuesToFiltersField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isAddHasValuesToFilters() {
        if (this._addHasValuesToFiltersField != null) {
            return this._addHasValuesToFiltersField;
        }
        Object __rawValue = this._map.get("addHasValuesToFilters");
        if (__rawValue == null) {
            return DEFAULT_AddHasValuesToFilters;
        }
        this._addHasValuesToFiltersField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._addHasValuesToFiltersField;
    }

    public DataHubSearchConfig setAddHasValuesToFilters(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAddHasValuesToFilters(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field addHasValuesToFilters of com.linkedin.datahub.DataHubSearchConfig");
                }
                CheckedUtil.putWithoutChecking(this._map, "addHasValuesToFilters", value);
                this._addHasValuesToFiltersField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAddHasValuesToFilters();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "addHasValuesToFilters", value);
                this._addHasValuesToFiltersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "addHasValuesToFilters", value);
                this._addHasValuesToFiltersField = value;
            }
        }
        return this;
    }

    public DataHubSearchConfig setAddHasValuesToFilters(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field addHasValuesToFilters of com.linkedin.datahub.DataHubSearchConfig to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "addHasValuesToFilters", value);
        this._addHasValuesToFiltersField = value;
        return this;
    }

    public DataHubSearchConfig setAddHasValuesToFilters(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "addHasValuesToFilters", value);
        this._addHasValuesToFiltersField = value;
        return this;
    }

    public boolean hasFilterNameOverride() {
        if (this._filterNameOverrideField != null) {
            return true;
        }
        return this._map.containsKey("filterNameOverride");
    }

    public void removeFilterNameOverride() {
        this._map.remove("filterNameOverride");
    }

    @Nullable
    public String getFilterNameOverride(GetMode mode) {
        return this.getFilterNameOverride();
    }

    @Nullable
    public String getFilterNameOverride() {
        if (this._filterNameOverrideField != null) {
            return this._filterNameOverrideField;
        }
        Object __rawValue = this._map.get("filterNameOverride");
        this._filterNameOverrideField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._filterNameOverrideField;
    }

    public DataHubSearchConfig setFilterNameOverride(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFilterNameOverride(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFilterNameOverride();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "filterNameOverride", value);
                this._filterNameOverrideField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "filterNameOverride", value);
                this._filterNameOverrideField = value;
            }
        }
        return this;
    }

    public DataHubSearchConfig setFilterNameOverride(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field filterNameOverride of com.linkedin.datahub.DataHubSearchConfig to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "filterNameOverride", value);
        this._filterNameOverrideField = value;
        return this;
    }

    public boolean hasHasValuesFilterNameOverride() {
        if (this._hasValuesFilterNameOverrideField != null) {
            return true;
        }
        return this._map.containsKey("hasValuesFilterNameOverride");
    }

    public void removeHasValuesFilterNameOverride() {
        this._map.remove("hasValuesFilterNameOverride");
    }

    @Nullable
    public String getHasValuesFilterNameOverride(GetMode mode) {
        return this.getHasValuesFilterNameOverride();
    }

    @Nullable
    public String getHasValuesFilterNameOverride() {
        if (this._hasValuesFilterNameOverrideField != null) {
            return this._hasValuesFilterNameOverrideField;
        }
        Object __rawValue = this._map.get("hasValuesFilterNameOverride");
        this._hasValuesFilterNameOverrideField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._hasValuesFilterNameOverrideField;
    }

    public DataHubSearchConfig setHasValuesFilterNameOverride(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setHasValuesFilterNameOverride(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeHasValuesFilterNameOverride();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "hasValuesFilterNameOverride", value);
                this._hasValuesFilterNameOverrideField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "hasValuesFilterNameOverride", value);
                this._hasValuesFilterNameOverrideField = value;
            }
        }
        return this;
    }

    public DataHubSearchConfig setHasValuesFilterNameOverride(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field hasValuesFilterNameOverride of com.linkedin.datahub.DataHubSearchConfig to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "hasValuesFilterNameOverride", value);
        this._hasValuesFilterNameOverrideField = value;
        return this;
    }

    public boolean hasBoostScore() {
        if (this._boostScoreField != null) {
            return true;
        }
        return this._map.containsKey("boostScore");
    }

    public void removeBoostScore() {
        this._map.remove("boostScore");
    }

    @Nullable
    public Double getBoostScore(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getBoostScore();
            }
            case NULL: {
                if (this._boostScoreField != null) {
                    return this._boostScoreField;
                }
                Object __rawValue = this._map.get("boostScore");
                this._boostScoreField = DataTemplateUtil.coerceDoubleOutput(__rawValue);
                return this._boostScoreField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Double getBoostScore() {
        if (this._boostScoreField != null) {
            return this._boostScoreField;
        }
        Object __rawValue = this._map.get("boostScore");
        if (__rawValue == null) {
            return DEFAULT_BoostScore;
        }
        this._boostScoreField = DataTemplateUtil.coerceDoubleOutput(__rawValue);
        return this._boostScoreField;
    }

    public DataHubSearchConfig setBoostScore(@Nullable Double value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setBoostScore(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field boostScore of com.linkedin.datahub.DataHubSearchConfig");
                }
                CheckedUtil.putWithoutChecking(this._map, "boostScore", DataTemplateUtil.coerceDoubleInput(value));
                this._boostScoreField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeBoostScore();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "boostScore", DataTemplateUtil.coerceDoubleInput(value));
                this._boostScoreField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "boostScore", DataTemplateUtil.coerceDoubleInput(value));
                this._boostScoreField = value;
            }
        }
        return this;
    }

    public DataHubSearchConfig setBoostScore(@Nonnull Double value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field boostScore of com.linkedin.datahub.DataHubSearchConfig to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "boostScore", DataTemplateUtil.coerceDoubleInput(value));
        this._boostScoreField = value;
        return this;
    }

    public DataHubSearchConfig setBoostScore(double value) {
        CheckedUtil.putWithoutChecking(this._map, "boostScore", DataTemplateUtil.coerceDoubleInput(value));
        this._boostScoreField = value;
        return this;
    }

    public boolean hasHasValuesFieldName() {
        if (this._hasValuesFieldNameField != null) {
            return true;
        }
        return this._map.containsKey("hasValuesFieldName");
    }

    public void removeHasValuesFieldName() {
        this._map.remove("hasValuesFieldName");
    }

    @Nullable
    public String getHasValuesFieldName(GetMode mode) {
        return this.getHasValuesFieldName();
    }

    @Nullable
    public String getHasValuesFieldName() {
        if (this._hasValuesFieldNameField != null) {
            return this._hasValuesFieldNameField;
        }
        Object __rawValue = this._map.get("hasValuesFieldName");
        this._hasValuesFieldNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._hasValuesFieldNameField;
    }

    public DataHubSearchConfig setHasValuesFieldName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setHasValuesFieldName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeHasValuesFieldName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "hasValuesFieldName", value);
                this._hasValuesFieldNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "hasValuesFieldName", value);
                this._hasValuesFieldNameField = value;
            }
        }
        return this;
    }

    public DataHubSearchConfig setHasValuesFieldName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field hasValuesFieldName of com.linkedin.datahub.DataHubSearchConfig to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "hasValuesFieldName", value);
        this._hasValuesFieldNameField = value;
        return this;
    }

    public boolean hasNumValuesFieldName() {
        if (this._numValuesFieldNameField != null) {
            return true;
        }
        return this._map.containsKey("numValuesFieldName");
    }

    public void removeNumValuesFieldName() {
        this._map.remove("numValuesFieldName");
    }

    @Nullable
    public String getNumValuesFieldName(GetMode mode) {
        return this.getNumValuesFieldName();
    }

    @Nullable
    public String getNumValuesFieldName() {
        if (this._numValuesFieldNameField != null) {
            return this._numValuesFieldNameField;
        }
        Object __rawValue = this._map.get("numValuesFieldName");
        this._numValuesFieldNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._numValuesFieldNameField;
    }

    public DataHubSearchConfig setNumValuesFieldName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumValuesFieldName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumValuesFieldName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numValuesFieldName", value);
                this._numValuesFieldNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numValuesFieldName", value);
                this._numValuesFieldNameField = value;
            }
        }
        return this;
    }

    public DataHubSearchConfig setNumValuesFieldName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numValuesFieldName of com.linkedin.datahub.DataHubSearchConfig to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numValuesFieldName", value);
        this._numValuesFieldNameField = value;
        return this;
    }

    public boolean hasWeightsPerFieldValue() {
        if (this._weightsPerFieldValueField != null) {
            return true;
        }
        return this._map.containsKey("weightsPerFieldValue");
    }

    public void removeWeightsPerFieldValue() {
        this._map.remove("weightsPerFieldValue");
    }

    @Nullable
    public DoubleMap getWeightsPerFieldValue(GetMode mode) {
        return this.getWeightsPerFieldValue();
    }

    @Nullable
    public DoubleMap getWeightsPerFieldValue() {
        if (this._weightsPerFieldValueField != null) {
            return this._weightsPerFieldValueField;
        }
        Object __rawValue = this._map.get("weightsPerFieldValue");
        this._weightsPerFieldValueField = __rawValue == null ? null : new DoubleMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._weightsPerFieldValueField;
    }

    public DataHubSearchConfig setWeightsPerFieldValue(@Nullable DoubleMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setWeightsPerFieldValue(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeWeightsPerFieldValue();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "weightsPerFieldValue", value.data());
                this._weightsPerFieldValueField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "weightsPerFieldValue", value.data());
                this._weightsPerFieldValueField = value;
            }
        }
        return this;
    }

    public DataHubSearchConfig setWeightsPerFieldValue(@Nonnull DoubleMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field weightsPerFieldValue of com.linkedin.datahub.DataHubSearchConfig to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "weightsPerFieldValue", value.data());
        this._weightsPerFieldValueField = value;
        return this;
    }

    public boolean hasFieldNameAliases() {
        if (this._fieldNameAliasesField != null) {
            return true;
        }
        return this._map.containsKey("fieldNameAliases");
    }

    public void removeFieldNameAliases() {
        this._map.remove("fieldNameAliases");
    }

    @Nullable
    public StringArray getFieldNameAliases(GetMode mode) {
        return this.getFieldNameAliases();
    }

    @Nullable
    public StringArray getFieldNameAliases() {
        if (this._fieldNameAliasesField != null) {
            return this._fieldNameAliasesField;
        }
        Object __rawValue = this._map.get("fieldNameAliases");
        this._fieldNameAliasesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._fieldNameAliasesField;
    }

    public DataHubSearchConfig setFieldNameAliases(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFieldNameAliases(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFieldNameAliases();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fieldNameAliases", value.data());
                this._fieldNameAliasesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fieldNameAliases", value.data());
                this._fieldNameAliasesField = value;
            }
        }
        return this;
    }

    public DataHubSearchConfig setFieldNameAliases(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fieldNameAliases of com.linkedin.datahub.DataHubSearchConfig to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fieldNameAliases", value.data());
        this._fieldNameAliasesField = value;
        return this;
    }

    @Override
    public DataHubSearchConfig clone() throws CloneNotSupportedException {
        DataHubSearchConfig __clone = (DataHubSearchConfig)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataHubSearchConfig copy() throws CloneNotSupportedException {
        DataHubSearchConfig __copy = (DataHubSearchConfig)super.copy();
        __copy._enableAutocompleteField = null;
        __copy._fieldNameAliasesField = null;
        __copy._fieldNameField = null;
        __copy._weightsPerFieldValueField = null;
        __copy._boostScoreField = null;
        __copy._hasValuesFieldNameField = null;
        __copy._queryByDefaultField = null;
        __copy._numValuesFieldNameField = null;
        __copy._addToFiltersField = null;
        __copy._addHasValuesToFiltersField = null;
        __copy._hasValuesFilterNameOverrideField = null;
        __copy._filterNameOverrideField = null;
        __copy._fieldTypeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_EnableAutocomplete = SCHEMA.getField("enableAutocomplete");
        FIELD_AddToFilters = SCHEMA.getField("addToFilters");
        FIELD_AddHasValuesToFilters = SCHEMA.getField("addHasValuesToFilters");
        FIELD_FilterNameOverride = SCHEMA.getField("filterNameOverride");
        FIELD_HasValuesFilterNameOverride = SCHEMA.getField("hasValuesFilterNameOverride");
        FIELD_BoostScore = SCHEMA.getField("boostScore");
        FIELD_HasValuesFieldName = SCHEMA.getField("hasValuesFieldName");
        FIELD_NumValuesFieldName = SCHEMA.getField("numValuesFieldName");
        FIELD_WeightsPerFieldValue = SCHEMA.getField("weightsPerFieldValue");
        FIELD_FieldNameAliases = SCHEMA.getField("fieldNameAliases");
        DEFAULT_QueryByDefault = DataTemplateUtil.coerceBooleanOutput(FIELD_QueryByDefault.getDefault());
        DEFAULT_EnableAutocomplete = DataTemplateUtil.coerceBooleanOutput(FIELD_EnableAutocomplete.getDefault());
        DEFAULT_AddToFilters = DataTemplateUtil.coerceBooleanOutput(FIELD_AddToFilters.getDefault());
        DEFAULT_AddHasValuesToFilters = DataTemplateUtil.coerceBooleanOutput(FIELD_AddHasValuesToFilters.getDefault());
        DEFAULT_BoostScore = DataTemplateUtil.coerceDoubleOutput(FIELD_BoostScore.getDefault());
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataHubSearchConfig __objectRef;

        private ChangeListener(DataHubSearchConfig reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "enableAutocomplete": {
                    this.__objectRef._enableAutocompleteField = null;
                    break;
                }
                case "fieldNameAliases": {
                    this.__objectRef._fieldNameAliasesField = null;
                    break;
                }
                case "fieldName": {
                    this.__objectRef._fieldNameField = null;
                    break;
                }
                case "weightsPerFieldValue": {
                    this.__objectRef._weightsPerFieldValueField = null;
                    break;
                }
                case "boostScore": {
                    this.__objectRef._boostScoreField = null;
                    break;
                }
                case "hasValuesFieldName": {
                    this.__objectRef._hasValuesFieldNameField = null;
                    break;
                }
                case "queryByDefault": {
                    this.__objectRef._queryByDefaultField = null;
                    break;
                }
                case "numValuesFieldName": {
                    this.__objectRef._numValuesFieldNameField = null;
                    break;
                }
                case "addToFilters": {
                    this.__objectRef._addToFiltersField = null;
                    break;
                }
                case "addHasValuesToFilters": {
                    this.__objectRef._addHasValuesToFiltersField = null;
                    break;
                }
                case "hasValuesFilterNameOverride": {
                    this.__objectRef._hasValuesFilterNameOverrideField = null;
                    break;
                }
                case "filterNameOverride": {
                    this.__objectRef._filterNameOverrideField = null;
                    break;
                }
                case "fieldType": {
                    this.__objectRef._fieldTypeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec fieldName() {
            return new PathSpec(this.getPathComponents(), "fieldName");
        }

        public PathSpec fieldType() {
            return new PathSpec(this.getPathComponents(), "fieldType");
        }

        public PathSpec queryByDefault() {
            return new PathSpec(this.getPathComponents(), "queryByDefault");
        }

        public PathSpec enableAutocomplete() {
            return new PathSpec(this.getPathComponents(), "enableAutocomplete");
        }

        public PathSpec addToFilters() {
            return new PathSpec(this.getPathComponents(), "addToFilters");
        }

        public PathSpec addHasValuesToFilters() {
            return new PathSpec(this.getPathComponents(), "addHasValuesToFilters");
        }

        public PathSpec filterNameOverride() {
            return new PathSpec(this.getPathComponents(), "filterNameOverride");
        }

        public PathSpec hasValuesFilterNameOverride() {
            return new PathSpec(this.getPathComponents(), "hasValuesFilterNameOverride");
        }

        public PathSpec boostScore() {
            return new PathSpec(this.getPathComponents(), "boostScore");
        }

        public PathSpec hasValuesFieldName() {
            return new PathSpec(this.getPathComponents(), "hasValuesFieldName");
        }

        public PathSpec numValuesFieldName() {
            return new PathSpec(this.getPathComponents(), "numValuesFieldName");
        }

        public PathSpec weightsPerFieldValue() {
            return new PathSpec(this.getPathComponents(), "weightsPerFieldValue");
        }

        public PathSpec fieldNameAliases() {
            return new PathSpec(this.getPathComponents(), "fieldNameAliases");
        }

        public PathSpec fieldNameAliases(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "fieldNameAliases");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
        }

        public ProjectionMask withFieldName() {
            this.getDataMap().put("fieldName", 1);
            return this;
        }

        public ProjectionMask withFieldType() {
            this.getDataMap().put("fieldType", 1);
            return this;
        }

        public ProjectionMask withQueryByDefault() {
            this.getDataMap().put("queryByDefault", 1);
            return this;
        }

        public ProjectionMask withEnableAutocomplete() {
            this.getDataMap().put("enableAutocomplete", 1);
            return this;
        }

        public ProjectionMask withAddToFilters() {
            this.getDataMap().put("addToFilters", 1);
            return this;
        }

        public ProjectionMask withAddHasValuesToFilters() {
            this.getDataMap().put("addHasValuesToFilters", 1);
            return this;
        }

        public ProjectionMask withFilterNameOverride() {
            this.getDataMap().put("filterNameOverride", 1);
            return this;
        }

        public ProjectionMask withHasValuesFilterNameOverride() {
            this.getDataMap().put("hasValuesFilterNameOverride", 1);
            return this;
        }

        public ProjectionMask withBoostScore() {
            this.getDataMap().put("boostScore", 1);
            return this;
        }

        public ProjectionMask withHasValuesFieldName() {
            this.getDataMap().put("hasValuesFieldName", 1);
            return this;
        }

        public ProjectionMask withNumValuesFieldName() {
            this.getDataMap().put("numValuesFieldName", 1);
            return this;
        }

        public ProjectionMask withWeightsPerFieldValue() {
            this.getDataMap().put("weightsPerFieldValue", 1);
            return this;
        }

        public ProjectionMask withFieldNameAliases() {
            this.getDataMap().put("fieldNameAliases", 1);
            return this;
        }

        public ProjectionMask withFieldNameAliases(Integer start, Integer count) {
            this.getDataMap().put("fieldNameAliases", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("fieldNameAliases").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("fieldNameAliases").put("$count", count);
            }
            return this;
        }
    }
}

