/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.DataList;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DirectArrayTemplate;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.util.ArgumentUtil;
import java.util.Arrays;
import java.util.Collection;

public final class StringArray
extends DirectArrayTemplate<String> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("{ \"type\" : \"array\", \"items\" : \"string\" }");

    public StringArray() {
        this(new DataList());
    }

    public StringArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public StringArray(Collection<String> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public StringArray(DataList list) {
        super(list, SCHEMA, String.class, String.class);
    }

    public StringArray(String first, String ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    @Override
    public StringArray clone() throws CloneNotSupportedException {
        return (StringArray)super.clone();
    }

    @Override
    public StringArray copy() throws CloneNotSupportedException {
        return (StringArray)super.copy();
    }

    @Override
    protected Object coerceInput(String object) throws ClassCastException {
        ArgumentUtil.notNull(object, "object");
        return object;
    }

    @Override
    protected String coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return DataTemplateUtil.coerceStringOutput(object);
    }
}

