/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.annotation;

import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaTraverse;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.schema.annotation.CurrentSchemaEntryMode;
import com.linkedin.data.schema.annotation.SchemaVisitor;
import com.linkedin.data.schema.annotation.TraverserContextImpl;
import java.util.IdentityHashMap;

public class DataSchemaRichContextTraverser {
    private final IdentityHashMap<DataSchema, Boolean> _seenAncestorsDataSchema = new IdentityHashMap();
    private SchemaVisitor _schemaVisitor;
    private DataSchema _originalTopLevelSchemaUnderTraversal;

    public DataSchemaRichContextTraverser(SchemaVisitor schemaVisitor) {
        this._schemaVisitor = schemaVisitor;
    }

    public void traverse(DataSchema schema) {
        this._originalTopLevelSchemaUnderTraversal = schema;
        TraverserContextImpl traverserContext = new TraverserContextImpl(this._originalTopLevelSchemaUnderTraversal, schema, this._schemaVisitor.getInitialVisitorContext());
        this.doRecursiveTraversal(traverserContext);
    }

    private void doRecursiveTraversal(TraverserContextImpl context) {
        DataSchema schema = context.getCurrentSchema();
        this._schemaVisitor.callbackOnContext(context, DataSchemaTraverse.Order.PRE_ORDER);
        if (context.shouldContinue() == Boolean.TRUE || context.shouldContinue() != Boolean.FALSE && !this._seenAncestorsDataSchema.containsKey(schema)) {
            this._seenAncestorsDataSchema.put(schema, Boolean.TRUE);
            switch (schema.getType()) {
                case TYPEREF: {
                    TyperefDataSchema typerefDataSchema = (TyperefDataSchema)schema;
                    String nextSchemaPathComponent = this._schemaVisitor.shouldIncludeTyperefsInPathSpec() ? "$typeref" : null;
                    TraverserContextImpl nextContext = context.getNextContext("ref", nextSchemaPathComponent, typerefDataSchema.getRef(), CurrentSchemaEntryMode.TYPEREF_REF);
                    this.doRecursiveTraversal(nextContext);
                    break;
                }
                case MAP: {
                    MapDataSchema mapDataSchema = (MapDataSchema)schema;
                    TraverserContextImpl nextContext = context.getNextContext("$key", "$key", mapDataSchema.getKey(), CurrentSchemaEntryMode.MAP_KEY);
                    this.doRecursiveTraversal(nextContext);
                    nextContext = context.getNextContext(PathSpec.WILDCARD, PathSpec.WILDCARD, mapDataSchema.getValues(), CurrentSchemaEntryMode.MAP_VALUE);
                    this.doRecursiveTraversal(nextContext);
                    break;
                }
                case ARRAY: {
                    ArrayDataSchema arrayDataSchema = (ArrayDataSchema)schema;
                    TraverserContextImpl nextContext = context.getNextContext(PathSpec.WILDCARD, PathSpec.WILDCARD, arrayDataSchema.getItems(), CurrentSchemaEntryMode.ARRAY_VALUE);
                    this.doRecursiveTraversal(nextContext);
                    break;
                }
                case RECORD: {
                    RecordDataSchema recordDataSchema = (RecordDataSchema)schema;
                    for (RecordDataSchema.Field field : recordDataSchema.getFields()) {
                        TraverserContextImpl nextContext = context.getNextContext(field.getName(), field.getName(), field.getType(), CurrentSchemaEntryMode.FIELD);
                        nextContext.setEnclosingField(field);
                        this.doRecursiveTraversal(nextContext);
                    }
                    break;
                }
                case UNION: {
                    UnionDataSchema unionDataSchema = (UnionDataSchema)schema;
                    for (UnionDataSchema.Member member : unionDataSchema.getMembers()) {
                        TraverserContextImpl nextContext = context.getNextContext(member.getUnionMemberKey(), member.getUnionMemberKey(), member.getType(), CurrentSchemaEntryMode.UNION_MEMBER);
                        nextContext.setEnclosingUnionMember(member);
                        this.doRecursiveTraversal(nextContext);
                    }
                    break;
                }
                default: {
                    assert (DataSchemaRichContextTraverser.isLeafSchema(schema));
                    break;
                }
            }
            this._seenAncestorsDataSchema.remove(schema);
        }
        this._schemaVisitor.callbackOnContext(context, DataSchemaTraverse.Order.POST_ORDER);
    }

    public static boolean isLeafSchema(DataSchema dataSchema) {
        return dataSchema instanceof PrimitiveDataSchema || dataSchema.getType() == DataSchema.Type.FIXED || dataSchema.getType() == DataSchema.Type.ENUM;
    }
}

