/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class PathSpec {
    public static final String WILDCARD = new String("*");
    public static final String ATTR_ARRAY_START = "start";
    public static final String ATTR_ARRAY_COUNT = "count";
    private final List<String> _path;
    private final Map<String, Object> _attributes = new HashMap<String, Object>();
    private static final PathSpec EMPTY_PATH_SPEC = new PathSpec();
    public static final char SEPARATOR = '/';
    private static final char ATTR_SEPARATOR = '&';
    private static final char PATH_ATTR_SEPARATOR = '?';
    private static final char ATTR_KEY_VALUE_SEPARATOR = '=';
    private static final Pattern PATHSPEC_PATTERN = Pattern.compile(String.format("^(%s[^%<s\\s]+)+", Character.valueOf('/')));

    public PathSpec(List<String> parentPath, String segment) {
        this._path = new ArrayList<String>(parentPath.size() + 1);
        this._path.addAll(parentPath);
        this._path.add(segment);
    }

    public PathSpec(String segment) {
        this._path = new ArrayList<String>(1);
        this._path.add(segment);
    }

    public PathSpec(String ... segments) {
        this._path = new ArrayList<String>(Arrays.asList(segments));
    }

    public PathSpec(Collection<String> pathSpecCollection) {
        this._path = new ArrayList<String>(pathSpecCollection.size());
        this._path.addAll(pathSpecCollection);
    }

    public PathSpec() {
        this._path = Collections.emptyList();
    }

    public void setAttribute(String name, Object value) {
        this._attributes.put(name, value);
    }

    public static PathSpec emptyPath() {
        return EMPTY_PATH_SPEC;
    }

    public List<String> getPathComponents() {
        return Collections.unmodifiableList(this._path);
    }

    public boolean isEmptyPath() {
        return this._path.isEmpty();
    }

    public Map<String, Object> getPathAttributes() {
        return Collections.unmodifiableMap(this._attributes);
    }

    public PathSpec getParent() {
        if (this._path.size() <= 1) {
            return PathSpec.emptyPath();
        }
        return new PathSpec(this._path.subList(0, this._path.size() - 1));
    }

    public String toString() {
        StringBuilder rep = new StringBuilder();
        for (String s2 : this.getPathComponents()) {
            rep.append('/');
            rep.append(s2);
        }
        boolean beforeAttributes = true;
        if (!this._attributes.isEmpty()) {
            for (Map.Entry<String, Object> attribute : this._attributes.entrySet()) {
                rep.append(beforeAttributes ? (char)'?' : '&');
                rep.append(attribute.getKey());
                rep.append('=');
                rep.append(attribute.getValue());
                beforeAttributes = false;
            }
        }
        return rep.toString();
    }

    public static boolean validatePathSpecString(String pathSpecStr) {
        return PATHSPEC_PATTERN.matcher(pathSpecStr).matches();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PathSpec) {
            PathSpec other = (PathSpec)obj;
            if (other._path.size() != this._path.size()) {
                return false;
            }
            for (int ii = 0; ii < this._path.size(); ++ii) {
                if (this._path.get(ii) == WILDCARD != (other._path.get(ii) == WILDCARD)) {
                    return false;
                }
                if (this._path.get(ii).equals(other._path.get(ii))) continue;
                return false;
            }
            return Objects.equals(this._attributes, other._attributes);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this._path, this._attributes);
    }
}

