/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.it;

import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.element.DataElement;
import com.linkedin.data.element.MutableDataElement;
import com.linkedin.data.element.SimpleDataElement;
import com.linkedin.data.it.DataIterator;
import com.linkedin.data.it.IterationOrder;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;

public class ObjectIterator
implements DataIterator {
    private final DataElement _startElement;
    private final Deque<State> _stack = new ArrayDeque<State>();
    private boolean _first = true;
    private DataElement _current = null;
    private boolean _preOrder = true;

    public ObjectIterator(Object data, DataSchema schema, IterationOrder order) {
        this(new SimpleDataElement(data, schema), order);
    }

    public ObjectIterator(DataElement element, IterationOrder order) {
        this._startElement = element;
        this._current = null;
        this._first = true;
        this._preOrder = order == IterationOrder.PRE_ORDER;
    }

    private ObjectIterator(Object data, DataSchema schema) {
        this(data, schema, IterationOrder.PRE_ORDER);
    }

    @Override
    public DataElement next() {
        return this._preOrder ? this.preOrderNext() : this.postOrderNext();
    }

    private DataElement postOrderNext() {
        if (this._first) {
            this._first = false;
            this._current = this._startElement;
            while (this._current != null && this._current.getValue() instanceof DataComplex) {
                this.push();
                this._current = this._stack.getLast().next();
            }
            if (this._current == null) {
                this._current = this._stack.removeLast()._element;
            }
            return this._current;
        }
        this._current = null;
        while (!this._stack.isEmpty()) {
            this._current = this._stack.getLast().next();
            if (this._current == null) {
                this._current = this._stack.removeLast()._element;
                break;
            }
            if (!(this._current.getValue() instanceof DataComplex)) break;
            this.push();
        }
        return this._current;
    }

    private DataElement preOrderNext() {
        if (this._first) {
            this._first = false;
            this._current = this._startElement;
            return this._current;
        }
        if (this._current != null && this._current.getValue() instanceof DataComplex) {
            this.push();
        }
        this._current = null;
        while (!this._stack.isEmpty()) {
            this._current = this._stack.getLast().next();
            if (this._current != null) break;
            this._stack.removeLast();
        }
        return this._current;
    }

    @Override
    public void skipToSibling() {
        if (this._preOrder) {
            this._current = null;
        }
    }

    private void push() {
        Class<?> clazz = this._current.getValue().getClass();
        if (clazz == DataMap.class) {
            this._stack.addLast(new MapState(this._current));
        } else if (clazz == DataList.class) {
            this._stack.addLast(new ListState(this._current));
        }
    }

    private class ListState
    extends State {
        private final DataList _list;
        private final ListIterator<Object> _it;
        private final MutableDataElement _childElement;
        private int _currentIndex;

        private ListState(DataElement element) {
            super(element);
            this._list = (DataList)element.getValue();
            this._it = this._list.listIterator();
            this._currentIndex = -1;
            this._childElement = new MutableDataElement(element);
        }

        @Override
        protected DataElement next() {
            MutableDataElement element;
            if (this._it.hasNext()) {
                this._currentIndex = this._it.nextIndex();
                Object value = this._it.next();
                this._childElement.setValueNameSchema(value, this._currentIndex, this.currentSchema());
                element = this._childElement;
            } else {
                element = null;
            }
            return element;
        }

        private DataSchema currentSchema() {
            DataSchema dereferencedListSchema;
            DataSchema schema = null;
            DataSchema listSchema = this._element.getSchema();
            if (listSchema != null && (dereferencedListSchema = listSchema.getDereferencedDataSchema()).getType() == DataSchema.Type.ARRAY) {
                schema = ((ArrayDataSchema)dereferencedListSchema).getItems();
            }
            return schema;
        }
    }

    private class MapState
    extends State {
        private final DataMap _map;
        private final Iterator<Map.Entry<String, Object>> _it;
        private final MutableDataElement _childElement;
        private Map.Entry<String, Object> _currentEntry;

        private MapState(DataElement element) {
            super(element);
            this._map = (DataMap)element.getValue();
            this._it = this._map.entrySet().iterator();
            this._currentEntry = null;
            this._childElement = new MutableDataElement(element);
        }

        @Override
        protected DataElement next() {
            MutableDataElement element;
            if (this._it.hasNext()) {
                this._currentEntry = this._it.next();
                this._childElement.setValueNameSchema(this._currentEntry.getValue(), this._currentEntry.getKey(), this.currentSchema());
                element = this._childElement;
            } else {
                element = null;
            }
            return element;
        }

        private DataSchema currentSchema() {
            DataSchema schema;
            DataSchema mapSchema = this._element.getSchema();
            if (mapSchema == null) {
                schema = null;
            } else {
                DataSchema dereferencedSchema = mapSchema.getDereferencedDataSchema();
                DataSchema.Type deferencedType = dereferencedSchema.getType();
                switch (deferencedType) {
                    case RECORD: {
                        RecordDataSchema.Field field = ((RecordDataSchema)dereferencedSchema).getField(this._currentEntry.getKey());
                        schema = field == null ? null : field.getType();
                        break;
                    }
                    case UNION: {
                        schema = ((UnionDataSchema)dereferencedSchema).getTypeByMemberKey(this._currentEntry.getKey());
                        break;
                    }
                    case MAP: {
                        schema = ((MapDataSchema)dereferencedSchema).getValues();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown dereferenced type " + (Object)((Object)deferencedType) + " for DataMap's schema " + mapSchema);
                    }
                }
            }
            return schema;
        }
    }

    private abstract class State {
        protected final DataElement _element;

        protected State(DataElement element) {
            this._element = element;
        }

        protected abstract DataElement next();
    }
}

