/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec.entitystream;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.entitystream.AbstractDataDecoder;
import com.linkedin.data.codec.entitystream.JacksonSmileDataDecoder;
import com.linkedin.data.codec.entitystream.JacksonSmileDataEncoder;
import com.linkedin.data.codec.entitystream.StreamDataCodec;
import com.linkedin.entitystream.EntityStream;
import com.linkedin.entitystream.EntityStreams;
import datahub.shaded.jackson.core.JsonFactory;
import datahub.shaded.jackson.dataformat.smile.SmileFactory;
import datahub.shaded.jackson.dataformat.smile.SmileGenerator;
import java.util.concurrent.CompletionStage;

public class JacksonSmileStreamDataCodec
implements StreamDataCodec {
    private final int _bufferSize;
    protected final SmileFactory _smileFactory;

    public JacksonSmileStreamDataCodec(int bufferSize) {
        this(new SmileFactory(), bufferSize);
        this._smileFactory.enable(SmileGenerator.Feature.CHECK_SHARED_NAMES);
        this._smileFactory.enable(SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES);
    }

    public JacksonSmileStreamDataCodec(SmileFactory smileFactory, int bufferSize) {
        this._smileFactory = smileFactory;
        this._bufferSize = bufferSize;
        this._smileFactory.disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
    }

    @Override
    public CompletionStage<DataMap> decodeMap(EntityStream<ByteString> entityStream) {
        JacksonSmileDataDecoder decoder = new JacksonSmileDataDecoder(this._smileFactory, AbstractDataDecoder.START_OBJECT_TOKEN);
        entityStream.setReader(decoder);
        return decoder.getResult();
    }

    @Override
    public CompletionStage<DataList> decodeList(EntityStream<ByteString> entityStream) {
        JacksonSmileDataDecoder decoder = new JacksonSmileDataDecoder(this._smileFactory, AbstractDataDecoder.START_ARRAY_TOKEN);
        entityStream.setReader(decoder);
        return decoder.getResult();
    }

    @Override
    public EntityStream<ByteString> encodeMap(DataMap map) {
        return EntityStreams.newEntityStream(new JacksonSmileDataEncoder(this._smileFactory, map, this._bufferSize));
    }

    @Override
    public EntityStream<ByteString> encodeList(DataList list) {
        return EntityStreams.newEntityStream(new JacksonSmileDataEncoder(this._smileFactory, list, this._bufferSize));
    }
}

