/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec.entitystream;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.DataMapBuilder;
import com.linkedin.data.codec.entitystream.AbstractDataDecoder;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.parser.NonBlockingDataParser;
import datahub.shaded.jackson.core.JsonFactory;
import datahub.shaded.jackson.core.JsonParser;
import datahub.shaded.jackson.core.JsonToken;
import datahub.shaded.jackson.core.async.ByteArrayFeeder;
import java.io.IOException;
import java.util.EnumSet;

class AbstractJacksonDataDecoder<T extends DataComplex>
extends AbstractDataDecoder<T> {
    protected final JsonFactory _jsonFactory;
    private DataMapBuilder _currDataMapBuilder;

    @Deprecated
    protected AbstractJacksonDataDecoder(JsonFactory jsonFactory, byte expectedFirstToken) {
        this._jsonFactory = jsonFactory;
        EnumSet expectedDataToken = NONE;
        if ((expectedFirstToken & Token.START_OBJECT.bitPattern) != 0) {
            expectedDataToken.add(NonBlockingDataParser.Token.START_OBJECT);
        }
        if ((expectedFirstToken & Token.START_ARRAY.bitPattern) != 0) {
            expectedDataToken.add(NonBlockingDataParser.Token.START_ARRAY);
        }
        this._expectedTokens = expectedDataToken;
    }

    protected AbstractJacksonDataDecoder(JsonFactory jsonFactory) {
        this(jsonFactory, START_TOKENS);
    }

    protected AbstractJacksonDataDecoder(JsonFactory jsonFactory, EnumSet<NonBlockingDataParser.Token> expectedFirstTokens) {
        super(expectedFirstTokens);
        this._jsonFactory = jsonFactory;
    }

    @Override
    protected NonBlockingDataParser createDataParser() throws IOException {
        return new JacksonStreamDataParser(this._jsonFactory);
    }

    @Override
    protected DataComplex createDataObject(NonBlockingDataParser parser) {
        if (this._currDataMapBuilder == null || this._currDataMapBuilder.inUse()) {
            this._currDataMapBuilder = new DataMapBuilder();
        }
        this._currDataMapBuilder.setInUse(true);
        return this._currDataMapBuilder;
    }

    @Override
    protected DataComplex createDataList(NonBlockingDataParser parser) {
        return new DataList();
    }

    @Override
    protected DataComplex postProcessDataComplex(DataComplex dataComplex) {
        if (dataComplex instanceof DataMapBuilder) {
            dataComplex = ((DataMapBuilder)dataComplex).convertToDataMap();
        }
        return dataComplex;
    }

    @Override
    protected void addEntryToDataObject(DataComplex dataComplex, String currField, Object currValue) {
        if (dataComplex instanceof DataMapBuilder) {
            DataMapBuilder dataMapBuilder = (DataMapBuilder)dataComplex;
            if (dataMapBuilder.smallHashMapThresholdReached()) {
                DataMap dataMap = dataMapBuilder.convertToDataMap();
                this.replaceObjectStackTop(dataMap);
                CheckedUtil.putWithoutChecking(dataMap, currField, currValue);
            } else {
                dataMapBuilder.addKVPair(currField, currValue);
            }
        } else {
            CheckedUtil.putWithoutChecking((DataMap)dataComplex, currField, currValue);
        }
    }

    class JacksonStreamDataParser
    implements NonBlockingDataParser {
        private final JsonParser _jsonParser;
        private final ByteArrayFeeder _byteArrayFeeder;
        private JsonToken _previousTokenReturned;

        public JacksonStreamDataParser(JsonFactory jsonFactory) throws IOException {
            this._jsonParser = jsonFactory.createNonBlockingByteArrayParser();
            this._byteArrayFeeder = (ByteArrayFeeder)((Object)this._jsonParser);
        }

        @Override
        public void feedInput(byte[] data, int offset, int len) throws IOException {
            if (!this._byteArrayFeeder.needMoreInput()) {
                throw new IOException("Invalid state: Parser cannot accept more data");
            }
            this._byteArrayFeeder.feedInput(data, offset, offset + len);
        }

        @Override
        public void endOfInput() {
            this._byteArrayFeeder.endOfInput();
        }

        @Override
        public NonBlockingDataParser.Token nextToken() throws IOException {
            this._previousTokenReturned = this._jsonParser.nextToken();
            if (this._previousTokenReturned == null) {
                return NonBlockingDataParser.Token.EOF_INPUT;
            }
            switch (this._previousTokenReturned) {
                case START_OBJECT: {
                    return NonBlockingDataParser.Token.START_OBJECT;
                }
                case END_OBJECT: {
                    return NonBlockingDataParser.Token.END_OBJECT;
                }
                case START_ARRAY: {
                    return NonBlockingDataParser.Token.START_ARRAY;
                }
                case END_ARRAY: {
                    return NonBlockingDataParser.Token.END_ARRAY;
                }
                case FIELD_NAME: 
                case VALUE_STRING: {
                    return NonBlockingDataParser.Token.STRING;
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    JsonParser.NumberType numberType = this._jsonParser.getNumberType();
                    switch (numberType) {
                        case INT: {
                            return NonBlockingDataParser.Token.INTEGER;
                        }
                        case LONG: {
                            return NonBlockingDataParser.Token.LONG;
                        }
                        case FLOAT: {
                            return NonBlockingDataParser.Token.FLOAT;
                        }
                        case DOUBLE: {
                            return NonBlockingDataParser.Token.DOUBLE;
                        }
                    }
                    throw new IOException("Unexpected number value type " + (Object)((Object)numberType) + " at " + this._jsonParser.getTokenLocation());
                }
                case VALUE_TRUE: {
                    return NonBlockingDataParser.Token.BOOL_TRUE;
                }
                case VALUE_FALSE: {
                    return NonBlockingDataParser.Token.BOOL_FALSE;
                }
                case VALUE_NULL: {
                    return NonBlockingDataParser.Token.NULL;
                }
                case NOT_AVAILABLE: {
                    return NonBlockingDataParser.Token.NOT_AVAILABLE;
                }
            }
            throw new IOException("Unexpected token " + (Object)((Object)this._previousTokenReturned) + " at " + this._jsonParser.getTokenLocation());
        }

        @Override
        public String getString() throws IOException {
            return this._previousTokenReturned == JsonToken.FIELD_NAME ? this._jsonParser.getCurrentName() : this._jsonParser.getText();
        }

        @Override
        public ByteString getRawBytes() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getIntValue() throws IOException {
            return this._jsonParser.getIntValue();
        }

        @Override
        public long getLongValue() throws IOException {
            return this._jsonParser.getLongValue();
        }

        @Override
        public float getFloatValue() throws IOException {
            return this._jsonParser.getFloatValue();
        }

        @Override
        public double getDoubleValue() throws IOException {
            return this._jsonParser.getDoubleValue();
        }
    }

    @Deprecated
    static enum Token {
        START_OBJECT(1),
        END_OBJECT(2),
        START_ARRAY(4),
        END_ARRAY(8),
        FIELD_NAME(16),
        SIMPLE_VALUE(32);

        final byte bitPattern;

        private Token(int bp) {
            this.bitPattern = (byte)bp;
        }
    }
}

