/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec.entitystream;

import com.linkedin.data.ByteString;
import com.linkedin.data.Data;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.entitystream.DataEncoder;
import com.linkedin.data.codec.entitystream.QueueBufferedOutputStream;
import com.linkedin.entitystream.WriteHandle;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataEncoder
implements DataEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataEncoder.class);
    private static final Object MAP = new Object();
    private static final Object LIST = new Object();
    private Data.TraverseCallback _traverseCallback;
    private QueueBufferedOutputStream _out;
    private Deque<DataComplex> _stack;
    private Deque<Iterator<?>> _iteratorStack;
    private Deque<Object> _typeStack;
    private WriteHandle<? super ByteString> _writeHandle;
    private boolean _done;

    private AbstractDataEncoder(int bufferSize) {
        this._out = new QueueBufferedOutputStream(bufferSize);
        this._stack = new ArrayDeque<DataComplex>();
        this._iteratorStack = new ArrayDeque();
        this._typeStack = new ArrayDeque<Object>();
        this._done = false;
    }

    protected AbstractDataEncoder(DataMap dataMap, int bufferSize) {
        this(bufferSize);
        this._stack.push(dataMap);
        this._typeStack.push(MAP);
    }

    protected AbstractDataEncoder(DataList dataList, int bufferSize) {
        this(bufferSize);
        this._stack.push(dataList);
        this._typeStack.push(LIST);
    }

    @Override
    public void onInit(WriteHandle<? super ByteString> wh) {
        this._writeHandle = wh;
        try {
            this._traverseCallback = this.createTraverseCallback(this._out);
        }
        catch (IOException e) {
            this._writeHandle.error(e);
        }
    }

    protected abstract Data.TraverseCallback createTraverseCallback(OutputStream var1) throws IOException;

    protected DataMap preProcessMap(DataMap dataMap) throws IOException {
        return dataMap;
    }

    protected DataList preProcessList(DataList dataList) throws IOException {
        return dataList;
    }

    protected Iterator<Map.Entry<String, Object>> createIterator(DataMap dataMap) throws IOException {
        return dataMap.entrySet().iterator();
    }

    protected Iterator<Object> createIterator(DataList dataList) throws IOException {
        return dataList.iterator();
    }

    @Override
    public void onWritePossible() {
        while (this._writeHandle.remaining() > 0) {
            if (this._done) {
                if (this._out.isEmpty()) {
                    this._writeHandle.done();
                    break;
                }
                this._writeHandle.write(this._out.getBytes());
                continue;
            }
            if (this._out.isFull()) {
                this._writeHandle.write(this._out.getBytes());
                continue;
            }
            try {
                this.generate();
            }
            catch (Exception e) {
                this._writeHandle.error(e);
                break;
            }
        }
    }

    private void generate() throws Exception {
        while (!this._out.isFull()) {
            DataComplex current = this._stack.peek();
            if (this._iteratorStack.size() != this._stack.size()) {
                if (this._typeStack.peek() == MAP) {
                    DataMap dataMap = this.preProcessMap((DataMap)current);
                    if (dataMap != null) {
                        this._iteratorStack.push(this.createIterator(dataMap));
                        this._traverseCallback.startMap(dataMap);
                        continue;
                    }
                    this.removeProcessedEntity();
                    if (!this._done) continue;
                    this._traverseCallback.close();
                    break;
                }
                DataList dataList = this.preProcessList((DataList)current);
                if (dataList != null) {
                    this._iteratorStack.push(this.createIterator(dataList));
                    this._traverseCallback.startList(dataList);
                    continue;
                }
                this.removeProcessedEntity();
                if (!this._done) continue;
                this._traverseCallback.close();
                break;
            }
            Iterator<?> curr = this._iteratorStack.peek();
            if (curr.hasNext()) {
                Object currItem = curr.next();
                if (this._typeStack.peek() == MAP) {
                    Map.Entry entry = (Map.Entry)currItem;
                    this._traverseCallback.key((String)entry.getKey());
                    this.writeValue(entry.getValue());
                    this._traverseCallback.endKey((String)entry.getKey());
                    continue;
                }
                this.writeValue(currItem);
                continue;
            }
            this._iteratorStack.pop();
            Object type = this.removeProcessedEntity();
            if (type == MAP) {
                this._traverseCallback.endMap();
            } else {
                this._traverseCallback.endList();
            }
            if (!this._done) continue;
            this._traverseCallback.close();
            break;
        }
    }

    private void writeValue(Object value) throws Exception {
        if (value == null || value == Data.NULL) {
            this._traverseCallback.nullValue();
            return;
        }
        switch (value.getClass().getName()) {
            case "java.lang.String": {
                this._traverseCallback.stringValue((String)value);
                break;
            }
            case "java.lang.Integer": {
                this._traverseCallback.integerValue((Integer)value);
                break;
            }
            case "com.linkedin.data.DataMap": {
                this._stack.push((DataMap)value);
                this._typeStack.push(MAP);
                break;
            }
            case "com.linkedin.data.DataList": {
                this._stack.push((DataList)value);
                this._typeStack.push(LIST);
                break;
            }
            case "java.lang.Boolean": {
                this._traverseCallback.booleanValue((Boolean)value);
                break;
            }
            case "java.lang.Long": {
                this._traverseCallback.longValue((Long)value);
                break;
            }
            case "java.lang.Float": {
                this._traverseCallback.floatValue(((Float)value).floatValue());
                break;
            }
            case "java.lang.Double": {
                this._traverseCallback.doubleValue((Double)value);
                break;
            }
            case "com.linkedin.data.ByteString": {
                this._traverseCallback.byteStringValue((ByteString)value);
                break;
            }
            default: {
                this._traverseCallback.illegalValue(value);
            }
        }
    }

    private Object removeProcessedEntity() {
        this._stack.pop();
        this._done = this._stack.isEmpty();
        return this._typeStack.pop();
    }

    @Override
    public void onAbort(Throwable e) {
        try {
            this._traverseCallback.close();
        }
        catch (IOException ioe) {
            LOGGER.warn("Error closing output stream on abort due to " + e.getMessage(), ioe);
        }
    }
}

