/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.urn;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.lang3.StringUtils;

public class VersionedUrnUtils {
    private VersionedUrnUtils() {
    }

    public static Map<String, Long> convertVersionStamp(String versionStamp) {
        String[] aspectNameVersionPairs;
        HashMap<String, Long> aspectVersionMap = new HashMap<String, Long>();
        if (StringUtils.isBlank(versionStamp)) {
            return aspectVersionMap;
        }
        for (String pair : aspectNameVersionPairs = versionStamp.split(";")) {
            String[] tokens = pair.split(":");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Invalid version stamp cannot be parsed: " + versionStamp);
            }
            try {
                aspectVersionMap.put(tokens[0], Long.valueOf(tokens[1]));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid value for aspect version: " + tokens[1]);
            }
        }
        return aspectVersionMap;
    }

    public static String constructVersionStamp(SortedMap<String, Long> versionStampMap) {
        StringBuilder versionStamp = versionStampMap.entrySet().stream().collect(StringBuilder::new, (builder, entry) -> builder.append((String)entry.getKey()).append(":").append(entry.getValue()).append(";"), StringBuilder::append);
        return versionStamp.substring(0, versionStamp.length() - 1);
    }
}

