/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.MetadataAttribution;
import com.linkedin.common.urn.TagUrn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TagAssociation
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Properties of an applied tag. For now, just an Urn. In the future we can extend this with other properties, e.g.\npropagation parameters.*/record TagAssociation{/**Urn of the applied tag*/tag:/**Globally defined tag*/@java.class=\"com.linkedin.common.urn.TagUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Globally defined tags\",\"entityType\":\"tag\",\"fields\":[{\"doc\":\"tag name\",\"maxLength\":200,\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":220,\"name\":\"Tag\",\"namespace\":\"li\",\"owners\":[],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref TagUrn=string/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"tagAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"tagAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"tagAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}", SchemaFormatType.PDL);
    private TagUrn _tagField = null;
    private String _contextField = null;
    private MetadataAttribution _attributionField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Tag = SCHEMA.getField("tag");
    private static final RecordDataSchema.Field FIELD_Context = SCHEMA.getField("context");
    private static final RecordDataSchema.Field FIELD_Attribution = SCHEMA.getField("attribution");

    public TagAssociation() {
        super(new DataMap(4, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public TagAssociation(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTag() {
        if (this._tagField != null) {
            return true;
        }
        return this._map.containsKey("tag");
    }

    public void removeTag() {
        this._map.remove("tag");
    }

    @Nullable
    public TagUrn getTag(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTag();
            }
            case DEFAULT: 
            case NULL: {
                if (this._tagField != null) {
                    return this._tagField;
                }
                Object __rawValue = this._map.get("tag");
                this._tagField = DataTemplateUtil.coerceCustomOutput(__rawValue, TagUrn.class);
                return this._tagField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public TagUrn getTag() {
        if (this._tagField != null) {
            return this._tagField;
        }
        Object __rawValue = this._map.get("tag");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("tag");
        }
        this._tagField = DataTemplateUtil.coerceCustomOutput(__rawValue, TagUrn.class);
        return this._tagField;
    }

    public TagAssociation setTag(@Nullable TagUrn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTag(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field tag of com.linkedin.common.TagAssociation");
                }
                CheckedUtil.putWithoutChecking(this._map, "tag", DataTemplateUtil.coerceCustomInput(value, TagUrn.class));
                this._tagField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTag();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "tag", DataTemplateUtil.coerceCustomInput(value, TagUrn.class));
                this._tagField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "tag", DataTemplateUtil.coerceCustomInput(value, TagUrn.class));
                this._tagField = value;
            }
        }
        return this;
    }

    public TagAssociation setTag(@Nonnull TagUrn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field tag of com.linkedin.common.TagAssociation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "tag", DataTemplateUtil.coerceCustomInput(value, TagUrn.class));
        this._tagField = value;
        return this;
    }

    public boolean hasContext() {
        if (this._contextField != null) {
            return true;
        }
        return this._map.containsKey("context");
    }

    public void removeContext() {
        this._map.remove("context");
    }

    @Nullable
    public String getContext(GetMode mode) {
        return this.getContext();
    }

    @Nullable
    public String getContext() {
        if (this._contextField != null) {
            return this._contextField;
        }
        Object __rawValue = this._map.get("context");
        this._contextField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._contextField;
    }

    public TagAssociation setContext(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setContext(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeContext();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "context", value);
                this._contextField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "context", value);
                this._contextField = value;
            }
        }
        return this;
    }

    public TagAssociation setContext(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field context of com.linkedin.common.TagAssociation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "context", value);
        this._contextField = value;
        return this;
    }

    public boolean hasAttribution() {
        if (this._attributionField != null) {
            return true;
        }
        return this._map.containsKey("attribution");
    }

    public void removeAttribution() {
        this._map.remove("attribution");
    }

    @Nullable
    public MetadataAttribution getAttribution(GetMode mode) {
        return this.getAttribution();
    }

    @Nullable
    public MetadataAttribution getAttribution() {
        if (this._attributionField != null) {
            return this._attributionField;
        }
        Object __rawValue = this._map.get("attribution");
        this._attributionField = __rawValue == null ? null : new MetadataAttribution(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._attributionField;
    }

    public TagAssociation setAttribution(@Nullable MetadataAttribution value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAttribution(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAttribution();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "attribution", value.data());
                this._attributionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "attribution", value.data());
                this._attributionField = value;
            }
        }
        return this;
    }

    public TagAssociation setAttribution(@Nonnull MetadataAttribution value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field attribution of com.linkedin.common.TagAssociation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "attribution", value.data());
        this._attributionField = value;
        return this;
    }

    @Override
    public TagAssociation clone() throws CloneNotSupportedException {
        TagAssociation __clone = (TagAssociation)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public TagAssociation copy() throws CloneNotSupportedException {
        TagAssociation __copy = (TagAssociation)super.copy();
        __copy._contextField = null;
        __copy._attributionField = null;
        __copy._tagField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(TagUrn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final TagAssociation __objectRef;

        private ChangeListener(TagAssociation reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "context": {
                    this.__objectRef._contextField = null;
                    break;
                }
                case "attribution": {
                    this.__objectRef._attributionField = null;
                    break;
                }
                case "tag": {
                    this.__objectRef._tagField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec tag() {
            return new PathSpec(this.getPathComponents(), "tag");
        }

        public PathSpec context() {
            return new PathSpec(this.getPathComponents(), "context");
        }

        public MetadataAttribution.Fields attribution() {
            return new MetadataAttribution.Fields(this.getPathComponents(), "attribution");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private MetadataAttribution.ProjectionMask _attributionMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withTag() {
            this.getDataMap().put("tag", 1);
            return this;
        }

        public ProjectionMask withContext() {
            this.getDataMap().put("context", 1);
            return this;
        }

        public ProjectionMask withAttribution(Function<MetadataAttribution.ProjectionMask, MetadataAttribution.ProjectionMask> nestedMask) {
            this._attributionMask = nestedMask.apply(this._attributionMask == null ? MetadataAttribution.createMask() : this._attributionMask);
            this.getDataMap().put("attribution", this._attributionMask.getDataMap());
            return this;
        }

        public ProjectionMask withAttribution() {
            this._attributionMask = null;
            this.getDataMap().put("attribution", 1);
            return this;
        }
    }
}

