/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.MetadataAttribution;
import com.linkedin.common.urn.GlossaryTermUrn;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GlossaryTermAssociation
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Properties of an applied glossary term.*/record GlossaryTermAssociation{/**Urn of the applied glossary term*/@Relationship={\"entityTypes\":[\"glossaryTerm\"],\"name\":\"TermedWith\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"glossaryTerms\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Glossary Term\",\"hasValuesFieldName\":\"hasGlossaryTerms\",\"includeSystemModifiedAt\":true,\"systemModifiedAtFieldName\":\"termsModifiedAt\"}urn:/**Business Term*/@java.class=\"com.linkedin.common.urn.GlossaryTermUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"business term\",\"entityType\":\"glossaryTerm\",\"fields\":[{\"doc\":\"The name of business term with hierarchy.\",\"name\":\"name\",\"type\":\"string\"}],\"maxLength\":56,\"name\":\"GlossaryTerm\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref GlossaryTermUrn=string/**The user URN which will be credited for adding associating this term to the entity*/actor:optional@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**Additional context about the association*/context:optional string/**Information about who, why, and how this metadata was applied*/@Searchable={\"/actor\":{\"fieldName\":\"termAttributionActors\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/source\":{\"fieldName\":\"termAttributionSources\",\"fieldType\":\"URN\",\"queryByDefault\":false},\"/time\":{\"fieldName\":\"termAttributionDates\",\"fieldType\":\"DATETIME\",\"queryByDefault\":false}}attribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}", SchemaFormatType.PDL);
    private GlossaryTermUrn _urnField = null;
    private Urn _actorField = null;
    private String _contextField = null;
    private MetadataAttribution _attributionField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Urn = SCHEMA.getField("urn");
    private static final RecordDataSchema.Field FIELD_Actor = SCHEMA.getField("actor");
    private static final RecordDataSchema.Field FIELD_Context = SCHEMA.getField("context");
    private static final RecordDataSchema.Field FIELD_Attribution = SCHEMA.getField("attribution");

    public GlossaryTermAssociation() {
        super(new DataMap(6, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public GlossaryTermAssociation(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUrn() {
        if (this._urnField != null) {
            return true;
        }
        return this._map.containsKey("urn");
    }

    public void removeUrn() {
        this._map.remove("urn");
    }

    @Nullable
    public GlossaryTermUrn getUrn(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getUrn();
            }
            case DEFAULT: 
            case NULL: {
                if (this._urnField != null) {
                    return this._urnField;
                }
                Object __rawValue = this._map.get("urn");
                this._urnField = DataTemplateUtil.coerceCustomOutput(__rawValue, GlossaryTermUrn.class);
                return this._urnField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public GlossaryTermUrn getUrn() {
        if (this._urnField != null) {
            return this._urnField;
        }
        Object __rawValue = this._map.get("urn");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("urn");
        }
        this._urnField = DataTemplateUtil.coerceCustomOutput(__rawValue, GlossaryTermUrn.class);
        return this._urnField;
    }

    public GlossaryTermAssociation setUrn(@Nullable GlossaryTermUrn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field urn of com.linkedin.common.GlossaryTermAssociation");
                }
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, GlossaryTermUrn.class));
                this._urnField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, GlossaryTermUrn.class));
                this._urnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, GlossaryTermUrn.class));
                this._urnField = value;
            }
        }
        return this;
    }

    public GlossaryTermAssociation setUrn(@Nonnull GlossaryTermUrn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field urn of com.linkedin.common.GlossaryTermAssociation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "urn", DataTemplateUtil.coerceCustomInput(value, GlossaryTermUrn.class));
        this._urnField = value;
        return this;
    }

    public boolean hasActor() {
        if (this._actorField != null) {
            return true;
        }
        return this._map.containsKey("actor");
    }

    public void removeActor() {
        this._map.remove("actor");
    }

    @Nullable
    public Urn getActor(GetMode mode) {
        return this.getActor();
    }

    @Nullable
    public Urn getActor() {
        if (this._actorField != null) {
            return this._actorField;
        }
        Object __rawValue = this._map.get("actor");
        this._actorField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._actorField;
    }

    public GlossaryTermAssociation setActor(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setActor(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeActor();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._actorField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._actorField = value;
            }
        }
        return this;
    }

    public GlossaryTermAssociation setActor(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field actor of com.linkedin.common.GlossaryTermAssociation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._actorField = value;
        return this;
    }

    public boolean hasContext() {
        if (this._contextField != null) {
            return true;
        }
        return this._map.containsKey("context");
    }

    public void removeContext() {
        this._map.remove("context");
    }

    @Nullable
    public String getContext(GetMode mode) {
        return this.getContext();
    }

    @Nullable
    public String getContext() {
        if (this._contextField != null) {
            return this._contextField;
        }
        Object __rawValue = this._map.get("context");
        this._contextField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._contextField;
    }

    public GlossaryTermAssociation setContext(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setContext(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeContext();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "context", value);
                this._contextField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "context", value);
                this._contextField = value;
            }
        }
        return this;
    }

    public GlossaryTermAssociation setContext(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field context of com.linkedin.common.GlossaryTermAssociation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "context", value);
        this._contextField = value;
        return this;
    }

    public boolean hasAttribution() {
        if (this._attributionField != null) {
            return true;
        }
        return this._map.containsKey("attribution");
    }

    public void removeAttribution() {
        this._map.remove("attribution");
    }

    @Nullable
    public MetadataAttribution getAttribution(GetMode mode) {
        return this.getAttribution();
    }

    @Nullable
    public MetadataAttribution getAttribution() {
        if (this._attributionField != null) {
            return this._attributionField;
        }
        Object __rawValue = this._map.get("attribution");
        this._attributionField = __rawValue == null ? null : new MetadataAttribution(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._attributionField;
    }

    public GlossaryTermAssociation setAttribution(@Nullable MetadataAttribution value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAttribution(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAttribution();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "attribution", value.data());
                this._attributionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "attribution", value.data());
                this._attributionField = value;
            }
        }
        return this;
    }

    public GlossaryTermAssociation setAttribution(@Nonnull MetadataAttribution value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field attribution of com.linkedin.common.GlossaryTermAssociation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "attribution", value.data());
        this._attributionField = value;
        return this;
    }

    @Override
    public GlossaryTermAssociation clone() throws CloneNotSupportedException {
        GlossaryTermAssociation __clone = (GlossaryTermAssociation)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public GlossaryTermAssociation copy() throws CloneNotSupportedException {
        GlossaryTermAssociation __copy = (GlossaryTermAssociation)super.copy();
        __copy._urnField = null;
        __copy._actorField = null;
        __copy._contextField = null;
        __copy._attributionField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(GlossaryTermUrn.class);
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final GlossaryTermAssociation __objectRef;

        private ChangeListener(GlossaryTermAssociation reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "urn": {
                    this.__objectRef._urnField = null;
                    break;
                }
                case "actor": {
                    this.__objectRef._actorField = null;
                    break;
                }
                case "context": {
                    this.__objectRef._contextField = null;
                    break;
                }
                case "attribution": {
                    this.__objectRef._attributionField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec urn() {
            return new PathSpec(this.getPathComponents(), "urn");
        }

        public PathSpec actor() {
            return new PathSpec(this.getPathComponents(), "actor");
        }

        public PathSpec context() {
            return new PathSpec(this.getPathComponents(), "context");
        }

        public MetadataAttribution.Fields attribution() {
            return new MetadataAttribution.Fields(this.getPathComponents(), "attribution");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private MetadataAttribution.ProjectionMask _attributionMask;

        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withUrn() {
            this.getDataMap().put("urn", 1);
            return this;
        }

        public ProjectionMask withActor() {
            this.getDataMap().put("actor", 1);
            return this;
        }

        public ProjectionMask withContext() {
            this.getDataMap().put("context", 1);
            return this;
        }

        public ProjectionMask withAttribution(Function<MetadataAttribution.ProjectionMask, MetadataAttribution.ProjectionMask> nestedMask) {
            this._attributionMask = nestedMask.apply(this._attributionMask == null ? MetadataAttribution.createMask() : this._attributionMask);
            this.getDataMap().put("attribution", this._attributionMask.getDataMap());
            return this;
        }

        public ProjectionMask withAttribution() {
            this._attributionMask = null;
            this.getDataMap().put("attribution", 1);
            return this;
        }
    }
}

