/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.EntityRelationshipArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityRelationships
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Downstream lineage of a dataset*/record EntityRelationships{/**List of related entities*/relationships:array[/**Downstream lineage information about a dataset including the source reporting the lineage*/record EntityRelationship{/**Audit stamp containing who reported the lineage and when*/created:optional/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}/**The downstream dataset the lineage points to*/entity:Urn/**The type of the relationship*/type:string}]/**The start of the result set*/start:int/**The start of the result set*/count:int/**Total number of edges found.*/total:int}", SchemaFormatType.PDL);
    private EntityRelationshipArray _relationshipsField = null;
    private Integer _startField = null;
    private Integer _countField = null;
    private Integer _totalField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Relationships = SCHEMA.getField("relationships");
    private static final RecordDataSchema.Field FIELD_Start = SCHEMA.getField("start");
    private static final RecordDataSchema.Field FIELD_Count = SCHEMA.getField("count");
    private static final RecordDataSchema.Field FIELD_Total = SCHEMA.getField("total");

    public EntityRelationships() {
        super(new DataMap(6, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public EntityRelationships(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasRelationships() {
        if (this._relationshipsField != null) {
            return true;
        }
        return this._map.containsKey("relationships");
    }

    public void removeRelationships() {
        this._map.remove("relationships");
    }

    @Nullable
    public EntityRelationshipArray getRelationships(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getRelationships();
            }
            case DEFAULT: 
            case NULL: {
                if (this._relationshipsField != null) {
                    return this._relationshipsField;
                }
                Object __rawValue = this._map.get("relationships");
                this._relationshipsField = __rawValue == null ? null : new EntityRelationshipArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._relationshipsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public EntityRelationshipArray getRelationships() {
        if (this._relationshipsField != null) {
            return this._relationshipsField;
        }
        Object __rawValue = this._map.get("relationships");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("relationships");
        }
        this._relationshipsField = __rawValue == null ? null : new EntityRelationshipArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._relationshipsField;
    }

    public EntityRelationships setRelationships(@Nullable EntityRelationshipArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRelationships(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field relationships of com.linkedin.common.EntityRelationships");
                }
                CheckedUtil.putWithoutChecking(this._map, "relationships", value.data());
                this._relationshipsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRelationships();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "relationships", value.data());
                this._relationshipsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "relationships", value.data());
                this._relationshipsField = value;
            }
        }
        return this;
    }

    public EntityRelationships setRelationships(@Nonnull EntityRelationshipArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field relationships of com.linkedin.common.EntityRelationships to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "relationships", value.data());
        this._relationshipsField = value;
        return this;
    }

    public boolean hasStart() {
        if (this._startField != null) {
            return true;
        }
        return this._map.containsKey("start");
    }

    public void removeStart() {
        this._map.remove("start");
    }

    @Nullable
    public Integer getStart(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getStart();
            }
            case DEFAULT: 
            case NULL: {
                if (this._startField != null) {
                    return this._startField;
                }
                Object __rawValue = this._map.get("start");
                this._startField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._startField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getStart() {
        if (this._startField != null) {
            return this._startField;
        }
        Object __rawValue = this._map.get("start");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("start");
        }
        this._startField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._startField;
    }

    public EntityRelationships setStart(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStart(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field start of com.linkedin.common.EntityRelationships");
                }
                CheckedUtil.putWithoutChecking(this._map, "start", DataTemplateUtil.coerceIntInput(value));
                this._startField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStart();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "start", DataTemplateUtil.coerceIntInput(value));
                this._startField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "start", DataTemplateUtil.coerceIntInput(value));
                this._startField = value;
            }
        }
        return this;
    }

    public EntityRelationships setStart(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field start of com.linkedin.common.EntityRelationships to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "start", DataTemplateUtil.coerceIntInput(value));
        this._startField = value;
        return this;
    }

    public EntityRelationships setStart(int value) {
        CheckedUtil.putWithoutChecking(this._map, "start", DataTemplateUtil.coerceIntInput(value));
        this._startField = value;
        return this;
    }

    public boolean hasCount() {
        if (this._countField != null) {
            return true;
        }
        return this._map.containsKey("count");
    }

    public void removeCount() {
        this._map.remove("count");
    }

    @Nullable
    public Integer getCount(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCount();
            }
            case DEFAULT: 
            case NULL: {
                if (this._countField != null) {
                    return this._countField;
                }
                Object __rawValue = this._map.get("count");
                this._countField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._countField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getCount() {
        if (this._countField != null) {
            return this._countField;
        }
        Object __rawValue = this._map.get("count");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("count");
        }
        this._countField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._countField;
    }

    public EntityRelationships setCount(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field count of com.linkedin.common.EntityRelationships");
                }
                CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
                this._countField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
                this._countField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
                this._countField = value;
            }
        }
        return this;
    }

    public EntityRelationships setCount(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field count of com.linkedin.common.EntityRelationships to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
        this._countField = value;
        return this;
    }

    public EntityRelationships setCount(int value) {
        CheckedUtil.putWithoutChecking(this._map, "count", DataTemplateUtil.coerceIntInput(value));
        this._countField = value;
        return this;
    }

    public boolean hasTotal() {
        if (this._totalField != null) {
            return true;
        }
        return this._map.containsKey("total");
    }

    public void removeTotal() {
        this._map.remove("total");
    }

    @Nullable
    public Integer getTotal(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTotal();
            }
            case DEFAULT: 
            case NULL: {
                if (this._totalField != null) {
                    return this._totalField;
                }
                Object __rawValue = this._map.get("total");
                this._totalField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._totalField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getTotal() {
        if (this._totalField != null) {
            return this._totalField;
        }
        Object __rawValue = this._map.get("total");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("total");
        }
        this._totalField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._totalField;
    }

    public EntityRelationships setTotal(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTotal(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field total of com.linkedin.common.EntityRelationships");
                }
                CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
                this._totalField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTotal();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
                this._totalField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
                this._totalField = value;
            }
        }
        return this;
    }

    public EntityRelationships setTotal(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field total of com.linkedin.common.EntityRelationships to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
        this._totalField = value;
        return this;
    }

    public EntityRelationships setTotal(int value) {
        CheckedUtil.putWithoutChecking(this._map, "total", DataTemplateUtil.coerceIntInput(value));
        this._totalField = value;
        return this;
    }

    @Override
    public EntityRelationships clone() throws CloneNotSupportedException {
        EntityRelationships __clone = (EntityRelationships)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public EntityRelationships copy() throws CloneNotSupportedException {
        EntityRelationships __copy = (EntityRelationships)super.copy();
        __copy._relationshipsField = null;
        __copy._totalField = null;
        __copy._startField = null;
        __copy._countField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final EntityRelationships __objectRef;

        private ChangeListener(EntityRelationships reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "relationships": {
                    this.__objectRef._relationshipsField = null;
                    break;
                }
                case "total": {
                    this.__objectRef._totalField = null;
                    break;
                }
                case "start": {
                    this.__objectRef._startField = null;
                    break;
                }
                case "count": {
                    this.__objectRef._countField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public EntityRelationshipArray.Fields relationships() {
            return new EntityRelationshipArray.Fields(this.getPathComponents(), "relationships");
        }

        public PathSpec relationships(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "relationships");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec start() {
            return new PathSpec(this.getPathComponents(), "start");
        }

        public PathSpec count() {
            return new PathSpec(this.getPathComponents(), "count");
        }

        public PathSpec total() {
            return new PathSpec(this.getPathComponents(), "total");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private EntityRelationshipArray.ProjectionMask _relationshipsMask;

        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withRelationships(Function<EntityRelationshipArray.ProjectionMask, EntityRelationshipArray.ProjectionMask> nestedMask) {
            this._relationshipsMask = nestedMask.apply(this._relationshipsMask == null ? EntityRelationshipArray.createMask() : this._relationshipsMask);
            this.getDataMap().put("relationships", this._relationshipsMask.getDataMap());
            return this;
        }

        public ProjectionMask withRelationships() {
            this._relationshipsMask = null;
            this.getDataMap().put("relationships", 1);
            return this;
        }

        public ProjectionMask withRelationships(Function<EntityRelationshipArray.ProjectionMask, EntityRelationshipArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._relationshipsMask = nestedMask.apply(this._relationshipsMask == null ? EntityRelationshipArray.createMask() : this._relationshipsMask);
            this.getDataMap().put("relationships", this._relationshipsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("relationships").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("relationships").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withRelationships(Integer start, Integer count) {
            this._relationshipsMask = null;
            this.getDataMap().put("relationships", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("relationships").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("relationships").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withStart() {
            this.getDataMap().put("start", 1);
            return this;
        }

        public ProjectionMask withCount() {
            this.getDataMap().put("count", 1);
            return this;
        }

        public ProjectionMask withTotal() {
            this.getDataMap().put("total", 1);
            return this;
        }
    }
}

