/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.assertion.AssertionStdOperator;
import com.linkedin.assertion.AssertionStdParameters;
import com.linkedin.assertion.FieldMetricType;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.schema.SchemaFieldSpec;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FieldMetricAssertion
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**Attributes defining a field metric assertion, which asserts an expectation against\na common metric derived from the set of field / column values, for example:\nmax, min, median, null count, null percentage, unique count, unique percentage, and more.*/record FieldMetricAssertion{/**The field under evaluation*/@Searchable.`/path`.fieldName=\"fieldPath\"field:{namespace com.linkedin.schema/**Lightweight spec used for referencing a particular schema field.\n*/record SchemaFieldSpec{/**The field path*/path:string/**The DataHub standard schema field type.*/type:string/**The native field type*/nativeType:string}}/**The specific metric to assert against. This is the value that\nwill be obtained by applying a standard operation, such as an aggregation,\nto the selected field.*/metric:/**A standard metric that can be derived from the set of values\nfor a specific field / column of a dataset / table.*/enum FieldMetricType{/**The number of unique values found in the column value set*/UNIQUE_COUNT/**The percentage of unique values to total rows for the dataset*/UNIQUE_PERCENTAGE/**The number of null values found in the column value set*/NULL_COUNT/**The percentage of null values to total rows for the dataset*/NULL_PERCENTAGE/**The minimum value in the column set (applies to numeric columns)*/MIN/**The maximum value in the column set (applies to numeric columns)*/MAX/**The mean length found in the column set (applies to numeric columns)*/MEAN/**The median length found in the column set (applies to numeric columns)*/MEDIAN/**The stddev length found in the column set (applies to numeric columns)*/STDDEV/**The number of negative values found in the value set (applies to numeric columns)*/NEGATIVE_COUNT/**The percentage of negative values to total rows for the dataset (applies to numeric columns)*/NEGATIVE_PERCENTAGE/**The number of zero values found in the value set (applies to numeric columns)*/ZERO_COUNT/**The percentage of zero values to total rows for the dataset (applies to numeric columns)*/ZERO_PERCENTAGE/**The minimum length found in the column set (applies to string columns)*/MIN_LENGTH/**The maximum length found in the column set (applies to string columns)*/MAX_LENGTH/**The number of empty string values found in the value set (applies to string columns).\nNote: This is a completely different metric different from NULL_COUNT!*/EMPTY_COUNT/**The percentage of empty string values to total rows for the dataset (applies to string columns)\nNote: This is a completely different metric different from NULL_PERCENTAGE!*/EMPTY_PERCENTAGE}/**The predicate to evaluate against the metric for the field / column.\nDepending on the operator, parameters may be required in order to successfully\nevaluate the assertion against the metric value.*/operator:/**A boolean operator that is applied on the input to an assertion, after an aggregation function has been applied.*/enum AssertionStdOperator{/**Value being asserted is between min_value and max_value.  Requires 'minValue' & 'maxValue' parameters.*/BETWEEN/**Value being asserted is less than a max value. Requires 'value' parameter.*/LESS_THAN/**Value being asserted is less than or equal to some value. Requires 'value' parameter.*/LESS_THAN_OR_EQUAL_TO/**Value being asserted is greater than some value. Requires 'value' parameter.*/GREATER_THAN/**Value being asserted is greater than or equal to some value. Requires 'value' parameter.*/GREATER_THAN_OR_EQUAL_TO/**Value being asserted is equal to value. Requires 'value' parameter.*/EQUAL_TO/**Value being asserted is not equal to value. Requires 'value' parameter.*/NOT_EQUAL_TO/**Value being asserted is null. Requires no parameters.*/NULL/**Value being asserted is not null. Requires no parameters.*/NOT_NULL/**Value being asserted contains value. Requires 'value' parameter.*/CONTAIN/**Value being asserted ends with value. Requires 'value' parameter.*/END_WITH/**Value being asserted starts with value. Requires 'value' parameter.*/START_WITH/**Value being asserted matches the regex value. Requires 'value' parameter.*/REGEX_MATCH/**Value being asserted is one of the array values. Requires 'value' parameter.*/IN/**Value being asserted is not in one of the array values. Requires 'value' parameter.*/NOT_IN/**Value being asserted is true. Requires no parameters.*/IS_TRUE/**Value being asserted is false. Requires no parameters.*/IS_FALSE/**Other*/_NATIVE_}/**Standard parameters required for the assertion. e.g. min_value, max_value, value, columns*/parameters:optional/**Parameters for AssertionStdOperators.*/record AssertionStdParameters{/**The value parameter of an assertion*/value:optional/**Single parameter for AssertionStdOperators.*/record AssertionStdParameter{/**The parameter value*/value:string/**The type of the parameter*/type:enum AssertionStdParameterType{/**A string value*/STRING/**A numeric value*/NUMBER/**A list of values. When used, value should be formatted as a serialized JSON array.*/LIST/**A set of values. When used, value should be formatted as a serialized JSON array.*/SET/**A value of unknown type*/UNKNOWN}}/**The maxValue parameter of an assertion*/maxValue:optional AssertionStdParameter/**The minValue parameter of an assertion*/minValue:optional AssertionStdParameter}}", SchemaFormatType.PDL);
    private SchemaFieldSpec _fieldField = null;
    private FieldMetricType _metricField = null;
    private AssertionStdOperator _operatorField = null;
    private AssertionStdParameters _parametersField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Field = SCHEMA.getField("field");
    private static final RecordDataSchema.Field FIELD_Metric = SCHEMA.getField("metric");
    private static final RecordDataSchema.Field FIELD_Operator = SCHEMA.getField("operator");
    private static final RecordDataSchema.Field FIELD_Parameters = SCHEMA.getField("parameters");

    public FieldMetricAssertion() {
        super(new DataMap(6, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public FieldMetricAssertion(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasField() {
        if (this._fieldField != null) {
            return true;
        }
        return this._map.containsKey("field");
    }

    public void removeField() {
        this._map.remove("field");
    }

    @Nullable
    public SchemaFieldSpec getField(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getField();
            }
            case DEFAULT: 
            case NULL: {
                if (this._fieldField != null) {
                    return this._fieldField;
                }
                Object __rawValue = this._map.get("field");
                this._fieldField = __rawValue == null ? null : new SchemaFieldSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._fieldField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public SchemaFieldSpec getField() {
        if (this._fieldField != null) {
            return this._fieldField;
        }
        Object __rawValue = this._map.get("field");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("field");
        }
        this._fieldField = __rawValue == null ? null : new SchemaFieldSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._fieldField;
    }

    public FieldMetricAssertion setField(@Nullable SchemaFieldSpec value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setField(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field field of com.linkedin.assertion.FieldMetricAssertion");
                }
                CheckedUtil.putWithoutChecking(this._map, "field", value.data());
                this._fieldField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeField();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "field", value.data());
                this._fieldField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "field", value.data());
                this._fieldField = value;
            }
        }
        return this;
    }

    public FieldMetricAssertion setField(@Nonnull SchemaFieldSpec value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field field of com.linkedin.assertion.FieldMetricAssertion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "field", value.data());
        this._fieldField = value;
        return this;
    }

    public boolean hasMetric() {
        if (this._metricField != null) {
            return true;
        }
        return this._map.containsKey("metric");
    }

    public void removeMetric() {
        this._map.remove("metric");
    }

    @Nullable
    public FieldMetricType getMetric(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getMetric();
            }
            case DEFAULT: 
            case NULL: {
                if (this._metricField != null) {
                    return this._metricField;
                }
                Object __rawValue = this._map.get("metric");
                this._metricField = DataTemplateUtil.coerceEnumOutput(__rawValue, FieldMetricType.class, FieldMetricType.$UNKNOWN);
                return this._metricField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FieldMetricType getMetric() {
        if (this._metricField != null) {
            return this._metricField;
        }
        Object __rawValue = this._map.get("metric");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("metric");
        }
        this._metricField = DataTemplateUtil.coerceEnumOutput(__rawValue, FieldMetricType.class, FieldMetricType.$UNKNOWN);
        return this._metricField;
    }

    public FieldMetricAssertion setMetric(@Nullable FieldMetricType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMetric(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field metric of com.linkedin.assertion.FieldMetricAssertion");
                }
                CheckedUtil.putWithoutChecking(this._map, "metric", value.name());
                this._metricField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMetric();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "metric", value.name());
                this._metricField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "metric", value.name());
                this._metricField = value;
            }
        }
        return this;
    }

    public FieldMetricAssertion setMetric(@Nonnull FieldMetricType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field metric of com.linkedin.assertion.FieldMetricAssertion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "metric", value.name());
        this._metricField = value;
        return this;
    }

    public boolean hasOperator() {
        if (this._operatorField != null) {
            return true;
        }
        return this._map.containsKey("operator");
    }

    public void removeOperator() {
        this._map.remove("operator");
    }

    @Nullable
    public AssertionStdOperator getOperator(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getOperator();
            }
            case DEFAULT: 
            case NULL: {
                if (this._operatorField != null) {
                    return this._operatorField;
                }
                Object __rawValue = this._map.get("operator");
                this._operatorField = DataTemplateUtil.coerceEnumOutput(__rawValue, AssertionStdOperator.class, AssertionStdOperator.$UNKNOWN);
                return this._operatorField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AssertionStdOperator getOperator() {
        if (this._operatorField != null) {
            return this._operatorField;
        }
        Object __rawValue = this._map.get("operator");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("operator");
        }
        this._operatorField = DataTemplateUtil.coerceEnumOutput(__rawValue, AssertionStdOperator.class, AssertionStdOperator.$UNKNOWN);
        return this._operatorField;
    }

    public FieldMetricAssertion setOperator(@Nullable AssertionStdOperator value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOperator(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field operator of com.linkedin.assertion.FieldMetricAssertion");
                }
                CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
                this._operatorField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOperator();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
                this._operatorField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
                this._operatorField = value;
            }
        }
        return this;
    }

    public FieldMetricAssertion setOperator(@Nonnull AssertionStdOperator value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field operator of com.linkedin.assertion.FieldMetricAssertion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "operator", value.name());
        this._operatorField = value;
        return this;
    }

    public boolean hasParameters() {
        if (this._parametersField != null) {
            return true;
        }
        return this._map.containsKey("parameters");
    }

    public void removeParameters() {
        this._map.remove("parameters");
    }

    @Nullable
    public AssertionStdParameters getParameters(GetMode mode) {
        return this.getParameters();
    }

    @Nullable
    public AssertionStdParameters getParameters() {
        if (this._parametersField != null) {
            return this._parametersField;
        }
        Object __rawValue = this._map.get("parameters");
        this._parametersField = __rawValue == null ? null : new AssertionStdParameters(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._parametersField;
    }

    public FieldMetricAssertion setParameters(@Nullable AssertionStdParameters value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setParameters(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeParameters();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
                this._parametersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
                this._parametersField = value;
            }
        }
        return this;
    }

    public FieldMetricAssertion setParameters(@Nonnull AssertionStdParameters value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field parameters of com.linkedin.assertion.FieldMetricAssertion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
        this._parametersField = value;
        return this;
    }

    @Override
    public FieldMetricAssertion clone() throws CloneNotSupportedException {
        FieldMetricAssertion __clone = (FieldMetricAssertion)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public FieldMetricAssertion copy() throws CloneNotSupportedException {
        FieldMetricAssertion __copy = (FieldMetricAssertion)super.copy();
        __copy._fieldField = null;
        __copy._metricField = null;
        __copy._parametersField = null;
        __copy._operatorField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final FieldMetricAssertion __objectRef;

        private ChangeListener(FieldMetricAssertion reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "field": {
                    this.__objectRef._fieldField = null;
                    break;
                }
                case "metric": {
                    this.__objectRef._metricField = null;
                    break;
                }
                case "parameters": {
                    this.__objectRef._parametersField = null;
                    break;
                }
                case "operator": {
                    this.__objectRef._operatorField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public SchemaFieldSpec.Fields field() {
            return new SchemaFieldSpec.Fields(this.getPathComponents(), "field");
        }

        public PathSpec metric() {
            return new PathSpec(this.getPathComponents(), "metric");
        }

        public PathSpec operator() {
            return new PathSpec(this.getPathComponents(), "operator");
        }

        public AssertionStdParameters.Fields parameters() {
            return new AssertionStdParameters.Fields(this.getPathComponents(), "parameters");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private SchemaFieldSpec.ProjectionMask _fieldMask;
        private AssertionStdParameters.ProjectionMask _parametersMask;

        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withField(Function<SchemaFieldSpec.ProjectionMask, SchemaFieldSpec.ProjectionMask> nestedMask) {
            this._fieldMask = nestedMask.apply(this._fieldMask == null ? SchemaFieldSpec.createMask() : this._fieldMask);
            this.getDataMap().put("field", this._fieldMask.getDataMap());
            return this;
        }

        public ProjectionMask withField() {
            this._fieldMask = null;
            this.getDataMap().put("field", 1);
            return this;
        }

        public ProjectionMask withMetric() {
            this.getDataMap().put("metric", 1);
            return this;
        }

        public ProjectionMask withOperator() {
            this.getDataMap().put("operator", 1);
            return this;
        }

        public ProjectionMask withParameters(Function<AssertionStdParameters.ProjectionMask, AssertionStdParameters.ProjectionMask> nestedMask) {
            this._parametersMask = nestedMask.apply(this._parametersMask == null ? AssertionStdParameters.createMask() : this._parametersMask);
            this.getDataMap().put("parameters", this._parametersMask.getDataMap());
            return this;
        }

        public ProjectionMask withParameters() {
            this._parametersMask = null;
            this.getDataMap().put("parameters", 1);
            return this;
        }
    }
}

