/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.LocalAsyncCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class LocalAsyncLoadingCache<K, V>
implements LocalAsyncCache<K, V>,
AsyncLoadingCache<K, V> {
    static final Logger logger = Logger.getLogger(LocalAsyncLoadingCache.class.getName());
    final boolean canBulkLoad;
    final AsyncCacheLoader<K, V> loader;
    @Nullable LoadingCacheView<K, V> cacheView;

    LocalAsyncLoadingCache(AsyncCacheLoader<? super K, V> loader) {
        this.loader = loader;
        this.canBulkLoad = LocalAsyncLoadingCache.canBulkLoad(loader);
    }

    private static boolean canBulkLoad(AsyncCacheLoader<?, ?> loader) {
        try {
            Class<AsyncCacheLoader> defaultLoaderClass = AsyncCacheLoader.class;
            if (loader instanceof CacheLoader) {
                Method defaultLoadAll;
                defaultLoaderClass = CacheLoader.class;
                Method classLoadAll = loader.getClass().getMethod("loadAll", Iterable.class);
                if (!classLoadAll.equals(defaultLoadAll = CacheLoader.class.getMethod("loadAll", Iterable.class))) {
                    return true;
                }
            }
            Method classAsyncLoadAll = loader.getClass().getMethod("asyncLoadAll", Iterable.class, Executor.class);
            Method defaultAsyncLoadAll = defaultLoaderClass.getMethod("asyncLoadAll", Iterable.class, Executor.class);
            return !classAsyncLoadAll.equals(defaultAsyncLoadAll);
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.log(Level.WARNING, "Cannot determine if CacheLoader can bulk load", e);
            return false;
        }
    }

    @Override
    public CompletableFuture<V> get(K key) {
        return this.get(key, this.loader::asyncLoad);
    }

    @Override
    public CompletableFuture<Map<K, V>> getAll(Iterable<? extends K> keys) {
        if (this.canBulkLoad) {
            return this.getAllBulk(keys);
        }
        LinkedHashMap<Object, CompletableFuture> result = new LinkedHashMap<Object, CompletableFuture>();
        Function<Object, CompletableFuture> mappingFunction = this::get;
        for (K key : keys) {
            CompletableFuture future = result.computeIfAbsent(key, mappingFunction);
            Objects.requireNonNull(future);
        }
        return this.composeResult(result);
    }

    private CompletableFuture<Map<K, V>> getAllBulk(Iterable<? extends K> keys) {
        LinkedHashMap futures = new LinkedHashMap();
        HashMap proxies = new HashMap();
        for (K key : keys) {
            if (futures.containsKey(key)) continue;
            CompletableFuture<Object> future = this.cache().getIfPresent(key, false);
            if (future == null) {
                CompletableFuture proxy = new CompletableFuture();
                future = this.cache().putIfAbsent(key, proxy);
                if (future == null) {
                    future = proxy;
                    proxies.put(key, proxy);
                }
            }
            futures.put(key, future);
        }
        this.cache().statsCounter().recordMisses(proxies.size());
        this.cache().statsCounter().recordHits(futures.size() - proxies.size());
        if (proxies.isEmpty()) {
            return this.composeResult(futures);
        }
        AsyncBulkCompleter completer = new AsyncBulkCompleter(proxies);
        try {
            this.loader.asyncLoadAll(proxies.keySet(), this.cache().executor()).whenComplete((BiConsumer)completer);
            return this.composeResult(futures);
        }
        catch (Throwable t2) {
            completer.accept(null, t2);
            throw t2;
        }
    }

    private CompletableFuture<Map<K, V>> composeResult(Map<K, CompletableFuture<V>> futures) {
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        CompletableFuture[] array = futures.values().toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(array).thenApply(ignored -> {
            LinkedHashMap result = new LinkedHashMap(futures.size());
            futures.forEach((key, future) -> {
                Object value = future.getNow(null);
                if (value != null) {
                    result.put(key, value);
                }
            });
            return Collections.unmodifiableMap(result);
        });
    }

    @Override
    public LoadingCache<K, V> synchronous() {
        return this.cacheView == null ? (this.cacheView = new LoadingCacheView(this)) : this.cacheView;
    }

    static final class LoadingCacheView<K, V>
    extends LocalAsyncCache.AbstractCacheView<K, V>
    implements LoadingCache<K, V> {
        private static final long serialVersionUID = 1L;
        final LocalAsyncLoadingCache<K, V> asyncCache;

        LoadingCacheView(LocalAsyncLoadingCache<K, V> asyncCache) {
            this.asyncCache = Objects.requireNonNull(asyncCache);
        }

        @Override
        LocalAsyncLoadingCache<K, V> asyncCache() {
            return this.asyncCache;
        }

        @Override
        public V get(K key) {
            try {
                return this.asyncCache.get(key).get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw new CompletionException(e.getCause());
            }
            catch (InterruptedException e) {
                throw new CompletionException(e);
            }
        }

        @Override
        public Map<K, V> getAll(Iterable<? extends K> keys) {
            try {
                return this.asyncCache.getAll(keys).get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw new CompletionException(e.getCause());
            }
            catch (InterruptedException e) {
                throw new CompletionException(e);
            }
        }

        @Override
        public void refresh(K key) {
            CompletableFuture oldValueFuture;
            long[] writeTime;
            block5: {
                block4: {
                    Objects.requireNonNull(key);
                    writeTime = new long[1];
                    oldValueFuture = this.asyncCache.cache().getIfPresentQuietly(key, writeTime);
                    if (oldValueFuture == null) break block4;
                    if (!oldValueFuture.isDone() || !oldValueFuture.isCompletedExceptionally()) break block5;
                }
                this.asyncCache.get(key, this.asyncCache.loader::asyncLoad, false);
                return;
            }
            if (!oldValueFuture.isDone()) {
                return;
            }
            oldValueFuture.thenAccept(oldValue -> {
                long now = this.asyncCache.cache().statsTicker().read();
                CompletableFuture<Object> refreshFuture = oldValue == null ? this.asyncCache.loader.asyncLoad(key, this.asyncCache.cache().executor()) : this.asyncCache.loader.asyncReload(key, oldValue, this.asyncCache.cache().executor());
                refreshFuture.whenComplete((newValue, error) -> {
                    long loadTime = this.asyncCache.cache().statsTicker().read() - now;
                    if (error != null) {
                        this.asyncCache.cache().statsCounter().recordLoadFailure(loadTime);
                        logger.log(Level.WARNING, "Exception thrown during refresh", (Throwable)error);
                        return;
                    }
                    boolean[] discard = new boolean[1];
                    this.asyncCache.cache().compute(key, (k, currentValue) -> {
                        if (currentValue == null) {
                            return newValue == null ? null : refreshFuture;
                        }
                        if (currentValue == oldValueFuture) {
                            long expectedWriteTime = writeTime[0];
                            if (this.asyncCache.cache().hasWriteTime()) {
                                this.asyncCache.cache().getIfPresentQuietly(key, writeTime);
                            }
                            if (writeTime[0] == expectedWriteTime) {
                                return newValue == null ? null : refreshFuture;
                            }
                        }
                        discard[0] = true;
                        return currentValue;
                    }, false, false, true);
                    if (discard[0] && this.asyncCache.cache().hasRemovalListener()) {
                        this.asyncCache.cache().notifyRemoval(key, refreshFuture, RemovalCause.REPLACED);
                    }
                    if (newValue == null) {
                        this.asyncCache.cache().statsCounter().recordLoadFailure(loadTime);
                    } else {
                        this.asyncCache.cache().statsCounter().recordLoadSuccess(loadTime);
                    }
                });
            });
        }
    }

    private final class AsyncBulkCompleter
    implements BiConsumer<Map<K, V>, Throwable> {
        private final Map<K, CompletableFuture<V>> proxies;
        private final long startTime;

        AsyncBulkCompleter(Map<K, CompletableFuture<V>> proxies) {
            this.startTime = LocalAsyncLoadingCache.this.cache().statsTicker().read();
            this.proxies = proxies;
        }

        @Override
        public void accept(@Nullable Map<K, V> result, @Nullable Throwable error) {
            long loadTime = LocalAsyncLoadingCache.this.cache().statsTicker().read() - this.startTime;
            if (result == null) {
                if (error == null) {
                    error = new CompletionException("null map", null);
                }
                for (Map.Entry entry : this.proxies.entrySet()) {
                    LocalAsyncLoadingCache.this.cache().remove(entry.getKey(), entry.getValue());
                    entry.getValue().obtrudeException(error);
                }
                LocalAsyncLoadingCache.this.cache().statsCounter().recordLoadFailure(loadTime);
                logger.log(Level.WARNING, "Exception thrown during asynchronous load", error);
            } else {
                this.fillProxies(result);
                this.addNewEntries(result);
                LocalAsyncLoadingCache.this.cache().statsCounter().recordLoadSuccess(loadTime);
            }
        }

        private void fillProxies(Map<K, V> result) {
            this.proxies.forEach((key, future) -> {
                Object value = result.get(key);
                future.obtrudeValue(value);
                if (value == null) {
                    LocalAsyncLoadingCache.this.cache().remove(key, future);
                } else {
                    LocalAsyncLoadingCache.this.cache().replace(key, (CompletableFuture<CompletableFuture>)future, (CompletableFuture<CompletableFuture>)future);
                }
            });
        }

        private void addNewEntries(Map<K, V> result) {
            if (this.proxies.size() == result.size()) {
                return;
            }
            result.forEach((key, value) -> {
                if (!this.proxies.containsKey(key)) {
                    LocalAsyncLoadingCache.this.cache().put(key, CompletableFuture.completedFuture(value));
                }
            });
        }
    }
}

