/*
 * Decompiled with CFR 0.152.
 */
package datahub.shaded.jackson.databind.ser.std;

import datahub.shaded.jackson.core.JsonGenerator;
import datahub.shaded.jackson.databind.JavaType;
import datahub.shaded.jackson.databind.JsonMappingException;
import datahub.shaded.jackson.databind.SerializerProvider;
import datahub.shaded.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import datahub.shaded.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import datahub.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import datahub.shaded.jackson.databind.ser.std.StdScalarSerializer;
import datahub.shaded.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            int pos = bbuf.position();
            gen.writeBinary(bbuf.array(), bbuf.arrayOffset() + pos, bbuf.limit() - pos);
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

