/*
 * Decompiled with CFR 0.152.
 */
package datahub.shaded.jackson.databind.deser.std;

import datahub.shaded.jackson.core.JsonParser;
import datahub.shaded.jackson.databind.DeserializationContext;
import datahub.shaded.jackson.databind.JsonMappingException;
import datahub.shaded.jackson.databind.deser.std.StdScalarDeserializer;
import datahub.shaded.jackson.databind.type.LogicalType;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class AtomicIntegerDeserializer
extends StdScalarDeserializer<AtomicInteger> {
    private static final long serialVersionUID = 1L;

    public AtomicIntegerDeserializer() {
        super(AtomicInteger.class);
    }

    @Override
    public AtomicInteger deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.isExpectedNumberIntToken()) {
            return new AtomicInteger(p.getIntValue());
        }
        Integer I = this._parseInteger(p, ctxt, AtomicInteger.class);
        return I == null ? null : new AtomicInteger(I);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Integer;
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) throws JsonMappingException {
        return new AtomicInteger();
    }
}

