/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.usage;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.usage.UsageAggregation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class UsageAggregationArray
extends WrappingArrayTemplate<UsageAggregation> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.usage/**Usage data for a given resource, rolled up into a bucket.*/@deprecated=\"Use DatasetUsageStatistics, or other UsageStatistics records, instead\"record UsageAggregation{/** Bucket start time in milliseconds */bucket:long/** Bucket duration */duration:{namespace com.linkedin.common/**Enum to define the length of a bucket when doing aggregations*/enum WindowDuration{YEAR,MONTH,WEEK,DAY,HOUR}}/** Resource associated with these usage stats */resource:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/** Metrics associated with this bucket */metrics:/**Metrics for usage data for a given resource and bucket. Not all fields\nmake sense for all buckets, so every field is optional.*/record UsageAggregationMetrics{/** Unique user count */uniqueUserCount:optional int/** Users within this bucket, with frequency counts */users:optional array[/** Records a single user's usage counts for a given resource */record UserUsageCounts{user:optional com.linkedin.common.Urn,count:int/** If user_email is set, we attempt to resolve the user's urn upon ingest */userEmail:optional string}]/** Total SQL query count */totalSqlQueries:optional int/** Frequent SQL queries; mostly makes sense for datasets in SQL databases */topSqlQueries:optional array[string]/** Field-level usage stats */fields:optional array[/** Records field-level usage counts for a given resource */record FieldUsageCounts{fieldName:string,count:int}]}}}]", SchemaFormatType.PDL);

    public UsageAggregationArray() {
        this(new DataList());
    }

    public UsageAggregationArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public UsageAggregationArray(Collection<UsageAggregation> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public UsageAggregationArray(DataList data) {
        super(data, SCHEMA, UsageAggregation.class);
    }

    public UsageAggregationArray(UsageAggregation first, UsageAggregation ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public UsageAggregationArray clone() throws CloneNotSupportedException {
        UsageAggregationArray __clone = (UsageAggregationArray)super.clone();
        return __clone;
    }

    @Override
    public UsageAggregationArray copy() throws CloneNotSupportedException {
        UsageAggregationArray __copy = (UsageAggregationArray)super.copy();
        return __copy;
    }

    @Override
    protected UsageAggregation coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new UsageAggregation(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private UsageAggregation.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<UsageAggregation.ProjectionMask, UsageAggregation.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? UsageAggregation.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public UsageAggregation.Fields items() {
            return new UsageAggregation.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

