/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.upgrade;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import com.linkedin.upgrade.DataHubUpgradeState;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataHubUpgradeResult
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.upgrade/**Information collected when a DataHubUpgrade successfully finishes*/@Aspect.name=\"dataHubUpgradeResult\"record DataHubUpgradeResult{/**Upgrade state  UpgradeResult.Result*/state:optional enum DataHubUpgradeState{/**Upgrade in progress.*/IN_PROGRESS/**Upgrade was successful.*/SUCCEEDED/**Upgrade with an error state, however the upgrade should be re-run.*/FAILED/**Upgrade with an error state and should not be re-run.*/ABORTED}=\"SUCCEEDED\"/**Timestamp when we started this DataHubUpgrade*/timestampMs:long/**Result map to place helpful information about this upgrade job*/result:optional map[string,string]}", SchemaFormatType.PDL);
    private DataHubUpgradeState _stateField = null;
    private Long _timestampMsField = null;
    private StringMap _resultField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_State = SCHEMA.getField("state");
    private static final DataHubUpgradeState DEFAULT_State;
    private static final RecordDataSchema.Field FIELD_TimestampMs;
    private static final RecordDataSchema.Field FIELD_Result;

    public DataHubUpgradeResult() {
        super(new DataMap(4, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public DataHubUpgradeResult(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasState() {
        if (this._stateField != null) {
            return true;
        }
        return this._map.containsKey("state");
    }

    public void removeState() {
        this._map.remove("state");
    }

    @Nullable
    public DataHubUpgradeState getState(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getState();
            }
            case NULL: {
                if (this._stateField != null) {
                    return this._stateField;
                }
                Object __rawValue = this._map.get("state");
                this._stateField = DataTemplateUtil.coerceEnumOutput(__rawValue, DataHubUpgradeState.class, DataHubUpgradeState.$UNKNOWN);
                return this._stateField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public DataHubUpgradeState getState() {
        if (this._stateField != null) {
            return this._stateField;
        }
        Object __rawValue = this._map.get("state");
        if (__rawValue == null) {
            return DEFAULT_State;
        }
        this._stateField = DataTemplateUtil.coerceEnumOutput(__rawValue, DataHubUpgradeState.class, DataHubUpgradeState.$UNKNOWN);
        return this._stateField;
    }

    public DataHubUpgradeResult setState(@Nullable DataHubUpgradeState value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setState(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeState();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "state", value.name());
                this._stateField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "state", value.name());
                this._stateField = value;
            }
        }
        return this;
    }

    public DataHubUpgradeResult setState(@Nonnull DataHubUpgradeState value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field state of com.linkedin.upgrade.DataHubUpgradeResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "state", value.name());
        this._stateField = value;
        return this;
    }

    public boolean hasTimestampMs() {
        if (this._timestampMsField != null) {
            return true;
        }
        return this._map.containsKey("timestampMs");
    }

    public void removeTimestampMs() {
        this._map.remove("timestampMs");
    }

    @Nullable
    public Long getTimestampMs(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTimestampMs();
            }
            case DEFAULT: 
            case NULL: {
                if (this._timestampMsField != null) {
                    return this._timestampMsField;
                }
                Object __rawValue = this._map.get("timestampMs");
                this._timestampMsField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._timestampMsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getTimestampMs() {
        if (this._timestampMsField != null) {
            return this._timestampMsField;
        }
        Object __rawValue = this._map.get("timestampMs");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("timestampMs");
        }
        this._timestampMsField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._timestampMsField;
    }

    public DataHubUpgradeResult setTimestampMs(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTimestampMs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field timestampMs of com.linkedin.upgrade.DataHubUpgradeResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMs", DataTemplateUtil.coerceLongInput(value));
                this._timestampMsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTimestampMs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMs", DataTemplateUtil.coerceLongInput(value));
                this._timestampMsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "timestampMs", DataTemplateUtil.coerceLongInput(value));
                this._timestampMsField = value;
            }
        }
        return this;
    }

    public DataHubUpgradeResult setTimestampMs(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field timestampMs of com.linkedin.upgrade.DataHubUpgradeResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "timestampMs", DataTemplateUtil.coerceLongInput(value));
        this._timestampMsField = value;
        return this;
    }

    public DataHubUpgradeResult setTimestampMs(long value) {
        CheckedUtil.putWithoutChecking(this._map, "timestampMs", DataTemplateUtil.coerceLongInput(value));
        this._timestampMsField = value;
        return this;
    }

    public boolean hasResult() {
        if (this._resultField != null) {
            return true;
        }
        return this._map.containsKey("result");
    }

    public void removeResult() {
        this._map.remove("result");
    }

    @Nullable
    public StringMap getResult(GetMode mode) {
        return this.getResult();
    }

    @Nullable
    public StringMap getResult() {
        if (this._resultField != null) {
            return this._resultField;
        }
        Object __rawValue = this._map.get("result");
        this._resultField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._resultField;
    }

    public DataHubUpgradeResult setResult(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setResult(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeResult();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "result", value.data());
                this._resultField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "result", value.data());
                this._resultField = value;
            }
        }
        return this;
    }

    public DataHubUpgradeResult setResult(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field result of com.linkedin.upgrade.DataHubUpgradeResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "result", value.data());
        this._resultField = value;
        return this;
    }

    @Override
    public DataHubUpgradeResult clone() throws CloneNotSupportedException {
        DataHubUpgradeResult __clone = (DataHubUpgradeResult)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataHubUpgradeResult copy() throws CloneNotSupportedException {
        DataHubUpgradeResult __copy = (DataHubUpgradeResult)super.copy();
        __copy._resultField = null;
        __copy._stateField = null;
        __copy._timestampMsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_TimestampMs = SCHEMA.getField("timestampMs");
        FIELD_Result = SCHEMA.getField("result");
        DEFAULT_State = DataTemplateUtil.coerceEnumOutput(FIELD_State.getDefault(), DataHubUpgradeState.class, DataHubUpgradeState.$UNKNOWN);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataHubUpgradeResult __objectRef;

        private ChangeListener(DataHubUpgradeResult reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "result": {
                    this.__objectRef._resultField = null;
                    break;
                }
                case "state": {
                    this.__objectRef._stateField = null;
                    break;
                }
                case "timestampMs": {
                    this.__objectRef._timestampMsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec state() {
            return new PathSpec(this.getPathComponents(), "state");
        }

        public PathSpec timestampMs() {
            return new PathSpec(this.getPathComponents(), "timestampMs");
        }

        public PathSpec result() {
            return new PathSpec(this.getPathComponents(), "result");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withState() {
            this.getDataMap().put("state", 1);
            return this;
        }

        public ProjectionMask withTimestampMs() {
            this.getDataMap().put("timestampMs", 1);
            return this;
        }

        public ProjectionMask withResult() {
            this.getDataMap().put("result", 1);
            return this;
        }
    }
}

