/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.upgrade;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataHubUpgradeRequest
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.upgrade/**Information collected when kicking off a DataHubUpgrade*/@Aspect.name=\"dataHubUpgradeRequest\"record DataHubUpgradeRequest{/**Timestamp when we started this DataHubUpgrade*/timestampMs:long/**Version of this upgrade*/version:string}", SchemaFormatType.PDL);
    private Long _timestampMsField = null;
    private String _versionField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_TimestampMs = SCHEMA.getField("timestampMs");
    private static final RecordDataSchema.Field FIELD_Version = SCHEMA.getField("version");

    public DataHubUpgradeRequest() {
        super(new DataMap(3, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public DataHubUpgradeRequest(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTimestampMs() {
        if (this._timestampMsField != null) {
            return true;
        }
        return this._map.containsKey("timestampMs");
    }

    public void removeTimestampMs() {
        this._map.remove("timestampMs");
    }

    @Nullable
    public Long getTimestampMs(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTimestampMs();
            }
            case DEFAULT: 
            case NULL: {
                if (this._timestampMsField != null) {
                    return this._timestampMsField;
                }
                Object __rawValue = this._map.get("timestampMs");
                this._timestampMsField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._timestampMsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getTimestampMs() {
        if (this._timestampMsField != null) {
            return this._timestampMsField;
        }
        Object __rawValue = this._map.get("timestampMs");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("timestampMs");
        }
        this._timestampMsField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._timestampMsField;
    }

    public DataHubUpgradeRequest setTimestampMs(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTimestampMs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field timestampMs of com.linkedin.upgrade.DataHubUpgradeRequest");
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMs", DataTemplateUtil.coerceLongInput(value));
                this._timestampMsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTimestampMs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMs", DataTemplateUtil.coerceLongInput(value));
                this._timestampMsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "timestampMs", DataTemplateUtil.coerceLongInput(value));
                this._timestampMsField = value;
            }
        }
        return this;
    }

    public DataHubUpgradeRequest setTimestampMs(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field timestampMs of com.linkedin.upgrade.DataHubUpgradeRequest to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "timestampMs", DataTemplateUtil.coerceLongInput(value));
        this._timestampMsField = value;
        return this;
    }

    public DataHubUpgradeRequest setTimestampMs(long value) {
        CheckedUtil.putWithoutChecking(this._map, "timestampMs", DataTemplateUtil.coerceLongInput(value));
        this._timestampMsField = value;
        return this;
    }

    public boolean hasVersion() {
        if (this._versionField != null) {
            return true;
        }
        return this._map.containsKey("version");
    }

    public void removeVersion() {
        this._map.remove("version");
    }

    @Nullable
    public String getVersion(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getVersion();
            }
            case DEFAULT: 
            case NULL: {
                if (this._versionField != null) {
                    return this._versionField;
                }
                Object __rawValue = this._map.get("version");
                this._versionField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._versionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getVersion() {
        if (this._versionField != null) {
            return this._versionField;
        }
        Object __rawValue = this._map.get("version");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("version");
        }
        this._versionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._versionField;
    }

    public DataHubUpgradeRequest setVersion(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field version of com.linkedin.upgrade.DataHubUpgradeRequest");
                }
                CheckedUtil.putWithoutChecking(this._map, "version", value);
                this._versionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "version", value);
                this._versionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "version", value);
                this._versionField = value;
            }
        }
        return this;
    }

    public DataHubUpgradeRequest setVersion(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field version of com.linkedin.upgrade.DataHubUpgradeRequest to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "version", value);
        this._versionField = value;
        return this;
    }

    @Override
    public DataHubUpgradeRequest clone() throws CloneNotSupportedException {
        DataHubUpgradeRequest __clone = (DataHubUpgradeRequest)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataHubUpgradeRequest copy() throws CloneNotSupportedException {
        DataHubUpgradeRequest __copy = (DataHubUpgradeRequest)super.copy();
        __copy._versionField = null;
        __copy._timestampMsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataHubUpgradeRequest __objectRef;

        private ChangeListener(DataHubUpgradeRequest reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "version": {
                    this.__objectRef._versionField = null;
                    break;
                }
                case "timestampMs": {
                    this.__objectRef._timestampMsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec timestampMs() {
            return new PathSpec(this.getPathComponents(), "timestampMs");
        }

        public PathSpec version() {
            return new PathSpec(this.getPathComponents(), "version");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withTimestampMs() {
            this.getDataMap().put("timestampMs", 1);
            return this;
        }

        public ProjectionMask withVersion() {
            this.getDataMap().put("version", 1);
            return this;
        }
    }
}

