/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.timeseries;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.timeseries.AggregationType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AggregationSpec
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.timeseries/**Provides the aggregation specification on a member/field.*/record AggregationSpec{/**Name of the member/field.*/fieldPath:string/**Aggregation type for the metric.*/aggregationType:enum AggregationType{LATEST,SUM,CARDINALITY}}", SchemaFormatType.PDL);
    private String _fieldPathField = null;
    private AggregationType _aggregationTypeField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_FieldPath = SCHEMA.getField("fieldPath");
    private static final RecordDataSchema.Field FIELD_AggregationType = SCHEMA.getField("aggregationType");

    public AggregationSpec() {
        super(new DataMap(3, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public AggregationSpec(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasFieldPath() {
        if (this._fieldPathField != null) {
            return true;
        }
        return this._map.containsKey("fieldPath");
    }

    public void removeFieldPath() {
        this._map.remove("fieldPath");
    }

    @Nullable
    public String getFieldPath(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getFieldPath();
            }
            case DEFAULT: 
            case NULL: {
                if (this._fieldPathField != null) {
                    return this._fieldPathField;
                }
                Object __rawValue = this._map.get("fieldPath");
                this._fieldPathField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._fieldPathField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getFieldPath() {
        if (this._fieldPathField != null) {
            return this._fieldPathField;
        }
        Object __rawValue = this._map.get("fieldPath");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("fieldPath");
        }
        this._fieldPathField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._fieldPathField;
    }

    public AggregationSpec setFieldPath(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFieldPath(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field fieldPath of com.linkedin.timeseries.AggregationSpec");
                }
                CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
                this._fieldPathField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFieldPath();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
                this._fieldPathField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
                this._fieldPathField = value;
            }
        }
        return this;
    }

    public AggregationSpec setFieldPath(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fieldPath of com.linkedin.timeseries.AggregationSpec to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fieldPath", value);
        this._fieldPathField = value;
        return this;
    }

    public boolean hasAggregationType() {
        if (this._aggregationTypeField != null) {
            return true;
        }
        return this._map.containsKey("aggregationType");
    }

    public void removeAggregationType() {
        this._map.remove("aggregationType");
    }

    @Nullable
    public AggregationType getAggregationType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAggregationType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._aggregationTypeField != null) {
                    return this._aggregationTypeField;
                }
                Object __rawValue = this._map.get("aggregationType");
                this._aggregationTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, AggregationType.class, AggregationType.$UNKNOWN);
                return this._aggregationTypeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AggregationType getAggregationType() {
        if (this._aggregationTypeField != null) {
            return this._aggregationTypeField;
        }
        Object __rawValue = this._map.get("aggregationType");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("aggregationType");
        }
        this._aggregationTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, AggregationType.class, AggregationType.$UNKNOWN);
        return this._aggregationTypeField;
    }

    public AggregationSpec setAggregationType(@Nullable AggregationType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAggregationType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field aggregationType of com.linkedin.timeseries.AggregationSpec");
                }
                CheckedUtil.putWithoutChecking(this._map, "aggregationType", value.name());
                this._aggregationTypeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAggregationType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aggregationType", value.name());
                this._aggregationTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aggregationType", value.name());
                this._aggregationTypeField = value;
            }
        }
        return this;
    }

    public AggregationSpec setAggregationType(@Nonnull AggregationType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aggregationType of com.linkedin.timeseries.AggregationSpec to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aggregationType", value.name());
        this._aggregationTypeField = value;
        return this;
    }

    @Override
    public AggregationSpec clone() throws CloneNotSupportedException {
        AggregationSpec __clone = (AggregationSpec)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public AggregationSpec copy() throws CloneNotSupportedException {
        AggregationSpec __copy = (AggregationSpec)super.copy();
        __copy._aggregationTypeField = null;
        __copy._fieldPathField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final AggregationSpec __objectRef;

        private ChangeListener(AggregationSpec reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "aggregationType": {
                    this.__objectRef._aggregationTypeField = null;
                    break;
                }
                case "fieldPath": {
                    this.__objectRef._fieldPathField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec fieldPath() {
            return new PathSpec(this.getPathComponents(), "fieldPath");
        }

        public PathSpec aggregationType() {
            return new PathSpec(this.getPathComponents(), "aggregationType");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withFieldPath() {
            this.getDataMap().put("fieldPath", 1);
            return this;
        }

        public ProjectionMask withAggregationType() {
            this.getDataMap().put("aggregationType", 1);
            return this;
        }
    }
}

