/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.template;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.template.SummaryElementType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SummaryElement
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.template/**Info for a given asset summary element*/record SummaryElement{/**The type of element/property*/elementType:enum SummaryElementType{CREATED,TAGS,GLOSSARY_TERMS,OWNERS,DOMAIN,STRUCTURED_PROPERTY}/**The urn of the structured property shown. Required if propertyType is STRUCTURED_PROPERTY*/@Relationship={\"entityTypes\":[\"structuredProperty\"],\"name\":\"ContainsStructuredProperty\"}structuredPropertyUrn:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}", SchemaFormatType.PDL);
    private SummaryElementType _elementTypeField = null;
    private Urn _structuredPropertyUrnField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_ElementType = SCHEMA.getField("elementType");
    private static final RecordDataSchema.Field FIELD_StructuredPropertyUrn = SCHEMA.getField("structuredPropertyUrn");

    public SummaryElement() {
        super(new DataMap(3, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public SummaryElement(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasElementType() {
        if (this._elementTypeField != null) {
            return true;
        }
        return this._map.containsKey("elementType");
    }

    public void removeElementType() {
        this._map.remove("elementType");
    }

    @Nullable
    public SummaryElementType getElementType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getElementType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._elementTypeField != null) {
                    return this._elementTypeField;
                }
                Object __rawValue = this._map.get("elementType");
                this._elementTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, SummaryElementType.class, SummaryElementType.$UNKNOWN);
                return this._elementTypeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public SummaryElementType getElementType() {
        if (this._elementTypeField != null) {
            return this._elementTypeField;
        }
        Object __rawValue = this._map.get("elementType");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("elementType");
        }
        this._elementTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, SummaryElementType.class, SummaryElementType.$UNKNOWN);
        return this._elementTypeField;
    }

    public SummaryElement setElementType(@Nullable SummaryElementType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setElementType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field elementType of com.linkedin.template.SummaryElement");
                }
                CheckedUtil.putWithoutChecking(this._map, "elementType", value.name());
                this._elementTypeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeElementType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "elementType", value.name());
                this._elementTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "elementType", value.name());
                this._elementTypeField = value;
            }
        }
        return this;
    }

    public SummaryElement setElementType(@Nonnull SummaryElementType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field elementType of com.linkedin.template.SummaryElement to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "elementType", value.name());
        this._elementTypeField = value;
        return this;
    }

    public boolean hasStructuredPropertyUrn() {
        if (this._structuredPropertyUrnField != null) {
            return true;
        }
        return this._map.containsKey("structuredPropertyUrn");
    }

    public void removeStructuredPropertyUrn() {
        this._map.remove("structuredPropertyUrn");
    }

    @Nullable
    public Urn getStructuredPropertyUrn(GetMode mode) {
        return this.getStructuredPropertyUrn();
    }

    @Nullable
    public Urn getStructuredPropertyUrn() {
        if (this._structuredPropertyUrnField != null) {
            return this._structuredPropertyUrnField;
        }
        Object __rawValue = this._map.get("structuredPropertyUrn");
        this._structuredPropertyUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._structuredPropertyUrnField;
    }

    public SummaryElement setStructuredPropertyUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStructuredPropertyUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStructuredPropertyUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "structuredPropertyUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._structuredPropertyUrnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "structuredPropertyUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._structuredPropertyUrnField = value;
            }
        }
        return this;
    }

    public SummaryElement setStructuredPropertyUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field structuredPropertyUrn of com.linkedin.template.SummaryElement to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "structuredPropertyUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._structuredPropertyUrnField = value;
        return this;
    }

    @Override
    public SummaryElement clone() throws CloneNotSupportedException {
        SummaryElement __clone = (SummaryElement)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public SummaryElement copy() throws CloneNotSupportedException {
        SummaryElement __copy = (SummaryElement)super.copy();
        __copy._elementTypeField = null;
        __copy._structuredPropertyUrnField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final SummaryElement __objectRef;

        private ChangeListener(SummaryElement reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "elementType": {
                    this.__objectRef._elementTypeField = null;
                    break;
                }
                case "structuredPropertyUrn": {
                    this.__objectRef._structuredPropertyUrnField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec elementType() {
            return new PathSpec(this.getPathComponents(), "elementType");
        }

        public PathSpec structuredPropertyUrn() {
            return new PathSpec(this.getPathComponents(), "structuredPropertyUrn");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withElementType() {
            this.getDataMap().put("elementType", 1);
            return this;
        }

        public ProjectionMask withStructuredPropertyUrn() {
            this.getDataMap().put("structuredPropertyUrn", 1);
            return this;
        }
    }
}

