/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.schema;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.UnionTemplate;
import com.linkedin.schema.DatasetFieldForeignKey;
import com.linkedin.schema.UrnForeignKey;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ForeignKeySpec
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.schema/**Description of a foreign key in a schema.*/record ForeignKeySpec{/**Foreign key definition in metadata schema.*/foreignKey:union[/**For non-urn based foregin keys.*/record DatasetFieldForeignKey{/**dataset that stores the resource.*/parentDataset:{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}/**List of fields in hosting(current) SchemaMetadata that conform a foreign key. List can contain a single entry or multiple entries if several entries in hosting schema conform a foreign key in a single parent dataset.*/currentFieldPaths:array[{namespace com.linkedin.dataset/**Schema field path. TODO: Add formal documentation on normalization rules.*/typeref SchemaFieldPath=string}]/**SchemaField@fieldPath that uniquely identify field in parent dataset that this field references.*/parentField:com.linkedin.dataset.SchemaFieldPath}/**If SchemaMetadata fields make any external references and references are of type com.linkedin.common.Urn or any children, this models can be used to mark it.*/record UrnForeignKey{/**Field in hosting(current) SchemaMetadata.*/currentFieldPath:com.linkedin.dataset.SchemaFieldPath}]}", SchemaFormatType.PDL);
    private ForeignKey _foreignKeyField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_ForeignKey = SCHEMA.getField("foreignKey");

    public ForeignKeySpec() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public ForeignKeySpec(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasForeignKey() {
        if (this._foreignKeyField != null) {
            return true;
        }
        return this._map.containsKey("foreignKey");
    }

    public void removeForeignKey() {
        this._map.remove("foreignKey");
    }

    @Nullable
    public ForeignKey getForeignKey(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getForeignKey();
            }
            case DEFAULT: 
            case NULL: {
                if (this._foreignKeyField != null) {
                    return this._foreignKeyField;
                }
                Object __rawValue = this._map.get("foreignKey");
                this._foreignKeyField = __rawValue == null ? null : new ForeignKey(__rawValue);
                return this._foreignKeyField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public ForeignKey getForeignKey() {
        if (this._foreignKeyField != null) {
            return this._foreignKeyField;
        }
        Object __rawValue = this._map.get("foreignKey");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("foreignKey");
        }
        this._foreignKeyField = __rawValue == null ? null : new ForeignKey(__rawValue);
        return this._foreignKeyField;
    }

    public ForeignKeySpec setForeignKey(@Nullable ForeignKey value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setForeignKey(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field foreignKey of com.linkedin.schema.ForeignKeySpec");
                }
                CheckedUtil.putWithoutChecking(this._map, "foreignKey", value.data());
                this._foreignKeyField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeForeignKey();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "foreignKey", value.data());
                this._foreignKeyField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "foreignKey", value.data());
                this._foreignKeyField = value;
            }
        }
        return this;
    }

    public ForeignKeySpec setForeignKey(@Nonnull ForeignKey value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field foreignKey of com.linkedin.schema.ForeignKeySpec to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "foreignKey", value.data());
        this._foreignKeyField = value;
        return this;
    }

    @Override
    public ForeignKeySpec clone() throws CloneNotSupportedException {
        ForeignKeySpec __clone = (ForeignKeySpec)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public ForeignKeySpec copy() throws CloneNotSupportedException {
        ForeignKeySpec __copy = (ForeignKeySpec)super.copy();
        __copy._foreignKeyField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    public static class ForeignKey
    extends UnionTemplate {
        private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema("union[{namespace com.linkedin.schema/**For non-urn based foregin keys.*/record DatasetFieldForeignKey{/**dataset that stores the resource.*/parentDataset:{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}/**List of fields in hosting(current) SchemaMetadata that conform a foreign key. List can contain a single entry or multiple entries if several entries in hosting schema conform a foreign key in a single parent dataset.*/currentFieldPaths:array[{namespace com.linkedin.dataset/**Schema field path. TODO: Add formal documentation on normalization rules.*/typeref SchemaFieldPath=string}]/**SchemaField@fieldPath that uniquely identify field in parent dataset that this field references.*/parentField:com.linkedin.dataset.SchemaFieldPath}}{namespace com.linkedin.schema/**If SchemaMetadata fields make any external references and references are of type com.linkedin.common.Urn or any children, this models can be used to mark it.*/record UrnForeignKey{/**Field in hosting(current) SchemaMetadata.*/currentFieldPath:com.linkedin.dataset.SchemaFieldPath}}]", SchemaFormatType.PDL);
        private DatasetFieldForeignKey _datasetFieldForeignKeyMember = null;
        private UrnForeignKey _urnForeignKeyMember = null;
        private ChangeListener __changeListener = new ChangeListener(this);
        private static final DataSchema MEMBER_DatasetFieldForeignKey = SCHEMA.getTypeByMemberKey("com.linkedin.schema.DatasetFieldForeignKey");
        public static final String MEMBERKEY_DatasetFieldForeignKey = "com.linkedin.schema.DatasetFieldForeignKey";
        private static final DataSchema MEMBER_UrnForeignKey = SCHEMA.getTypeByMemberKey("com.linkedin.schema.UrnForeignKey");
        public static final String MEMBERKEY_UrnForeignKey = "com.linkedin.schema.UrnForeignKey";

        public ForeignKey() {
            super(new DataMap(2, 0.75f), SCHEMA);
            this.addChangeListener(this.__changeListener);
        }

        public ForeignKey(Object data) {
            super(data, SCHEMA);
            this.addChangeListener(this.__changeListener);
        }

        public static UnionDataSchema dataSchema() {
            return SCHEMA;
        }

        public static ForeignKey create(DatasetFieldForeignKey value) {
            ForeignKey newUnion = new ForeignKey();
            newUnion.setDatasetFieldForeignKey(value);
            return newUnion;
        }

        public boolean isDatasetFieldForeignKey() {
            return this.memberIs(MEMBERKEY_DatasetFieldForeignKey);
        }

        public DatasetFieldForeignKey getDatasetFieldForeignKey() {
            this.checkNotNull();
            if (this._datasetFieldForeignKeyMember != null) {
                return this._datasetFieldForeignKeyMember;
            }
            Object __rawValue = this._map.get(MEMBERKEY_DatasetFieldForeignKey);
            this._datasetFieldForeignKeyMember = __rawValue == null ? null : new DatasetFieldForeignKey(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
            return this._datasetFieldForeignKeyMember;
        }

        public void setDatasetFieldForeignKey(DatasetFieldForeignKey value) {
            this.checkNotNull();
            this._map.clear();
            this._datasetFieldForeignKeyMember = value;
            CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_DatasetFieldForeignKey, value.data());
        }

        public static ForeignKey create(UrnForeignKey value) {
            ForeignKey newUnion = new ForeignKey();
            newUnion.setUrnForeignKey(value);
            return newUnion;
        }

        public boolean isUrnForeignKey() {
            return this.memberIs(MEMBERKEY_UrnForeignKey);
        }

        public UrnForeignKey getUrnForeignKey() {
            this.checkNotNull();
            if (this._urnForeignKeyMember != null) {
                return this._urnForeignKeyMember;
            }
            Object __rawValue = this._map.get(MEMBERKEY_UrnForeignKey);
            this._urnForeignKeyMember = __rawValue == null ? null : new UrnForeignKey(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
            return this._urnForeignKeyMember;
        }

        public void setUrnForeignKey(UrnForeignKey value) {
            this.checkNotNull();
            this._map.clear();
            this._urnForeignKeyMember = value;
            CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_UrnForeignKey, value.data());
        }

        public static ProjectionMask createMask() {
            return new ProjectionMask();
        }

        @Override
        public ForeignKey clone() throws CloneNotSupportedException {
            ForeignKey __clone = (ForeignKey)super.clone();
            __clone.__changeListener = new ChangeListener(__clone);
            __clone.addChangeListener(__clone.__changeListener);
            return __clone;
        }

        @Override
        public ForeignKey copy() throws CloneNotSupportedException {
            ForeignKey __copy = (ForeignKey)super.copy();
            __copy._datasetFieldForeignKeyMember = null;
            __copy._urnForeignKeyMember = null;
            __copy.__changeListener = new ChangeListener(__copy);
            __copy.addChangeListener(__copy.__changeListener);
            return __copy;
        }

        private static class ChangeListener
        implements CheckedMap.ChangeListener<String, Object> {
            private final ForeignKey __objectRef;

            private ChangeListener(ForeignKey reference) {
                this.__objectRef = reference;
            }

            @Override
            public void onUnderlyingMapChanged(String key, Object value) {
                switch (key) {
                    case "com.linkedin.schema.DatasetFieldForeignKey": {
                        this.__objectRef._datasetFieldForeignKeyMember = null;
                        break;
                    }
                    case "com.linkedin.schema.UrnForeignKey": {
                        this.__objectRef._urnForeignKeyMember = null;
                    }
                }
            }
        }

        public static class ProjectionMask
        extends MaskMap {
            private DatasetFieldForeignKey.ProjectionMask _DatasetFieldForeignKeyMask;
            private UrnForeignKey.ProjectionMask _UrnForeignKeyMask;

            ProjectionMask() {
                super(3);
            }

            public ProjectionMask withDatasetFieldForeignKey(Function<DatasetFieldForeignKey.ProjectionMask, DatasetFieldForeignKey.ProjectionMask> nestedMask) {
                this._DatasetFieldForeignKeyMask = nestedMask.apply(this._DatasetFieldForeignKeyMask == null ? DatasetFieldForeignKey.createMask() : this._DatasetFieldForeignKeyMask);
                this.getDataMap().put(ForeignKey.MEMBERKEY_DatasetFieldForeignKey, this._DatasetFieldForeignKeyMask.getDataMap());
                return this;
            }

            public ProjectionMask withUrnForeignKey(Function<UrnForeignKey.ProjectionMask, UrnForeignKey.ProjectionMask> nestedMask) {
                this._UrnForeignKeyMask = nestedMask.apply(this._UrnForeignKeyMask == null ? UrnForeignKey.createMask() : this._UrnForeignKeyMask);
                this.getDataMap().put(ForeignKey.MEMBERKEY_UrnForeignKey, this._UrnForeignKeyMask.getDataMap());
                return this;
            }
        }

        public static class Fields
        extends PathSpec {
            public Fields(List<String> path, String name) {
                super(path, name);
            }

            public Fields() {
            }

            public DatasetFieldForeignKey.Fields DatasetFieldForeignKey() {
                return new DatasetFieldForeignKey.Fields(this.getPathComponents(), ForeignKey.MEMBERKEY_DatasetFieldForeignKey);
            }

            public UrnForeignKey.Fields UrnForeignKey() {
                return new UrnForeignKey.Fields(this.getPathComponents(), ForeignKey.MEMBERKEY_UrnForeignKey);
            }
        }
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final ForeignKeySpec __objectRef;

        private ChangeListener(ForeignKeySpec reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "foreignKey": {
                    this.__objectRef._foreignKeyField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public ForeignKey.Fields foreignKey() {
            return new ForeignKey.Fields(this.getPathComponents(), "foreignKey");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private ForeignKey.ProjectionMask _foreignKeyMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withForeignKey(Function<ForeignKey.ProjectionMask, ForeignKey.ProjectionMask> nestedMask) {
            this._foreignKeyMask = nestedMask.apply(this._foreignKeyMask == null ? ForeignKey.createMask() : this._foreignKeyMask);
            this.getDataMap().put("foreignKey", this._foreignKeyMask.getDataMap());
            return this;
        }

        public ProjectionMask withForeignKey() {
            this._foreignKeyMask = null;
            this.getDataMap().put("foreignKey", 1);
            return this;
        }
    }
}

