/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.schema;

import com.linkedin.common.urn.DatasetUrn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DatasetFieldForeignKey
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.schema/**For non-urn based foregin keys.*/record DatasetFieldForeignKey{/**dataset that stores the resource.*/parentDataset:{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}/**List of fields in hosting(current) SchemaMetadata that conform a foreign key. List can contain a single entry or multiple entries if several entries in hosting schema conform a foreign key in a single parent dataset.*/currentFieldPaths:array[{namespace com.linkedin.dataset/**Schema field path. TODO: Add formal documentation on normalization rules.*/typeref SchemaFieldPath=string}]/**SchemaField@fieldPath that uniquely identify field in parent dataset that this field references.*/parentField:com.linkedin.dataset.SchemaFieldPath}", SchemaFormatType.PDL);
    private DatasetUrn _parentDatasetField = null;
    private StringArray _currentFieldPathsField = null;
    private String _parentFieldField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_ParentDataset = SCHEMA.getField("parentDataset");
    private static final RecordDataSchema.Field FIELD_CurrentFieldPaths = SCHEMA.getField("currentFieldPaths");
    private static final RecordDataSchema.Field FIELD_ParentField = SCHEMA.getField("parentField");

    public DatasetFieldForeignKey() {
        super(new DataMap(4, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public DatasetFieldForeignKey(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasParentDataset() {
        if (this._parentDatasetField != null) {
            return true;
        }
        return this._map.containsKey("parentDataset");
    }

    public void removeParentDataset() {
        this._map.remove("parentDataset");
    }

    @Nullable
    public DatasetUrn getParentDataset(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getParentDataset();
            }
            case DEFAULT: 
            case NULL: {
                if (this._parentDatasetField != null) {
                    return this._parentDatasetField;
                }
                Object __rawValue = this._map.get("parentDataset");
                this._parentDatasetField = DataTemplateUtil.coerceCustomOutput(__rawValue, DatasetUrn.class);
                return this._parentDatasetField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DatasetUrn getParentDataset() {
        if (this._parentDatasetField != null) {
            return this._parentDatasetField;
        }
        Object __rawValue = this._map.get("parentDataset");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("parentDataset");
        }
        this._parentDatasetField = DataTemplateUtil.coerceCustomOutput(__rawValue, DatasetUrn.class);
        return this._parentDatasetField;
    }

    public DatasetFieldForeignKey setParentDataset(@Nullable DatasetUrn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setParentDataset(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field parentDataset of com.linkedin.schema.DatasetFieldForeignKey");
                }
                CheckedUtil.putWithoutChecking(this._map, "parentDataset", DataTemplateUtil.coerceCustomInput(value, DatasetUrn.class));
                this._parentDatasetField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeParentDataset();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "parentDataset", DataTemplateUtil.coerceCustomInput(value, DatasetUrn.class));
                this._parentDatasetField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "parentDataset", DataTemplateUtil.coerceCustomInput(value, DatasetUrn.class));
                this._parentDatasetField = value;
            }
        }
        return this;
    }

    public DatasetFieldForeignKey setParentDataset(@Nonnull DatasetUrn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field parentDataset of com.linkedin.schema.DatasetFieldForeignKey to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "parentDataset", DataTemplateUtil.coerceCustomInput(value, DatasetUrn.class));
        this._parentDatasetField = value;
        return this;
    }

    public boolean hasCurrentFieldPaths() {
        if (this._currentFieldPathsField != null) {
            return true;
        }
        return this._map.containsKey("currentFieldPaths");
    }

    public void removeCurrentFieldPaths() {
        this._map.remove("currentFieldPaths");
    }

    @Nullable
    public StringArray getCurrentFieldPaths(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCurrentFieldPaths();
            }
            case DEFAULT: 
            case NULL: {
                if (this._currentFieldPathsField != null) {
                    return this._currentFieldPathsField;
                }
                Object __rawValue = this._map.get("currentFieldPaths");
                this._currentFieldPathsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._currentFieldPathsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringArray getCurrentFieldPaths() {
        if (this._currentFieldPathsField != null) {
            return this._currentFieldPathsField;
        }
        Object __rawValue = this._map.get("currentFieldPaths");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("currentFieldPaths");
        }
        this._currentFieldPathsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._currentFieldPathsField;
    }

    public DatasetFieldForeignKey setCurrentFieldPaths(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCurrentFieldPaths(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field currentFieldPaths of com.linkedin.schema.DatasetFieldForeignKey");
                }
                CheckedUtil.putWithoutChecking(this._map, "currentFieldPaths", value.data());
                this._currentFieldPathsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCurrentFieldPaths();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "currentFieldPaths", value.data());
                this._currentFieldPathsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "currentFieldPaths", value.data());
                this._currentFieldPathsField = value;
            }
        }
        return this;
    }

    public DatasetFieldForeignKey setCurrentFieldPaths(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field currentFieldPaths of com.linkedin.schema.DatasetFieldForeignKey to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "currentFieldPaths", value.data());
        this._currentFieldPathsField = value;
        return this;
    }

    public boolean hasParentField() {
        if (this._parentFieldField != null) {
            return true;
        }
        return this._map.containsKey("parentField");
    }

    public void removeParentField() {
        this._map.remove("parentField");
    }

    @Nullable
    public String getParentField(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getParentField();
            }
            case DEFAULT: 
            case NULL: {
                if (this._parentFieldField != null) {
                    return this._parentFieldField;
                }
                Object __rawValue = this._map.get("parentField");
                this._parentFieldField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._parentFieldField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getParentField() {
        if (this._parentFieldField != null) {
            return this._parentFieldField;
        }
        Object __rawValue = this._map.get("parentField");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("parentField");
        }
        this._parentFieldField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._parentFieldField;
    }

    public DatasetFieldForeignKey setParentField(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setParentField(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field parentField of com.linkedin.schema.DatasetFieldForeignKey");
                }
                CheckedUtil.putWithoutChecking(this._map, "parentField", value);
                this._parentFieldField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeParentField();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "parentField", value);
                this._parentFieldField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "parentField", value);
                this._parentFieldField = value;
            }
        }
        return this;
    }

    public DatasetFieldForeignKey setParentField(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field parentField of com.linkedin.schema.DatasetFieldForeignKey to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "parentField", value);
        this._parentFieldField = value;
        return this;
    }

    @Override
    public DatasetFieldForeignKey clone() throws CloneNotSupportedException {
        DatasetFieldForeignKey __clone = (DatasetFieldForeignKey)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DatasetFieldForeignKey copy() throws CloneNotSupportedException {
        DatasetFieldForeignKey __copy = (DatasetFieldForeignKey)super.copy();
        __copy._parentDatasetField = null;
        __copy._parentFieldField = null;
        __copy._currentFieldPathsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(DatasetUrn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DatasetFieldForeignKey __objectRef;

        private ChangeListener(DatasetFieldForeignKey reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "parentDataset": {
                    this.__objectRef._parentDatasetField = null;
                    break;
                }
                case "parentField": {
                    this.__objectRef._parentFieldField = null;
                    break;
                }
                case "currentFieldPaths": {
                    this.__objectRef._currentFieldPathsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec parentDataset() {
            return new PathSpec(this.getPathComponents(), "parentDataset");
        }

        public PathSpec currentFieldPaths() {
            return new PathSpec(this.getPathComponents(), "currentFieldPaths");
        }

        public PathSpec currentFieldPaths(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "currentFieldPaths");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec parentField() {
            return new PathSpec(this.getPathComponents(), "parentField");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withParentDataset() {
            this.getDataMap().put("parentDataset", 1);
            return this;
        }

        public ProjectionMask withCurrentFieldPaths() {
            this.getDataMap().put("currentFieldPaths", 1);
            return this;
        }

        public ProjectionMask withCurrentFieldPaths(Integer start, Integer count) {
            this.getDataMap().put("currentFieldPaths", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("currentFieldPaths").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("currentFieldPaths").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withParentField() {
            this.getDataMap().put("parentField", 1);
            return this;
        }
    }
}

