/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.query;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.dataset.DatasetUserUsageCountsArray;
import com.linkedin.timeseries.PartitionSpec;
import com.linkedin.timeseries.TimeWindowSize;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class QueryUsageStatistics
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.query/**Stats corresponding to dataset's usage.*/@Aspect={\"name\":\"queryUsageStatistics\",\"type\":\"timeseries\"}record QueryUsageStatistics includes{namespace com.linkedin.timeseries,record TimeseriesAspectBase{/**The event timestamp field as epoch at UTC in milli seconds.*/timestampMillis:long/**Granularity of the event if applicable*/eventGranularity:optional/**Defines the size of a time window.*/record TimeWindowSize{/**Interval unit such as minute/hour/day etc.*/unit:enum CalendarInterval{SECOND,MINUTE,HOUR,DAY,WEEK,MONTH,QUARTER,YEAR}/**How many units. Defaults to 1.*/multiple:int=1}/**The optional partition specification.*/partitionSpec:optional/**A reference to a specific partition in a dataset.*/record PartitionSpec{/**A unique id / value for the partition for which statistics were collected,\ngenerated by applying the key definition to a given row.*/@TimeseriesField={}partition:string/**Time window of the partition, if we are able to extract it from the partition key.*/timePartition:optional record TimeWindow{/**Start time as epoch at UTC.*/startTimeMillis:long/**The length of the window.*/length:TimeWindowSize}/**Unused!*/@deprecated,type:enum PartitionType{FULL_TABLE,QUERY,PARTITION}=\"PARTITION\"}={\"partition\":\"FULL_TABLE_SNAPSHOT\",\"type\":\"FULL_TABLE\"}/**The optional messageId, if provided serves as a custom user-defined unique identifier for an aspect value.*/messageId:optional string}}{/**Total query count in this bucket*/@TimeseriesField={}queryCount:optional int/**Query cost for this query and bucket*/@TimeseriesField={}queryCost:optional double/**Last executed timestamp*/@TimeseriesField={}lastExecutedAt:optional long/**Unique user count*/@TimeseriesField={}uniqueUserCount:optional int/**Users within this bucket, with frequency counts*/@TimeseriesFieldCollection.key=\"user\"userCounts:optional array[{namespace com.linkedin.dataset/**Records a single user's usage counts for a given resource*/record DatasetUserUsageCounts{/**The unique id of the user.*/user:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Number of times the dataset has been used by the user.*/@TimeseriesField={}count:int/**If user_email is set, we attempt to resolve the user's urn upon ingest*/@TimeseriesField={}userEmail:optional string}}]}", SchemaFormatType.PDL);
    private Long _timestampMillisField = null;
    private TimeWindowSize _eventGranularityField = null;
    private PartitionSpec _partitionSpecField = null;
    private String _messageIdField = null;
    private Integer _queryCountField = null;
    private Double _queryCostField = null;
    private Long _lastExecutedAtField = null;
    private Integer _uniqueUserCountField = null;
    private DatasetUserUsageCountsArray _userCountsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_TimestampMillis = SCHEMA.getField("timestampMillis");
    private static final RecordDataSchema.Field FIELD_EventGranularity = SCHEMA.getField("eventGranularity");
    private static final RecordDataSchema.Field FIELD_PartitionSpec = SCHEMA.getField("partitionSpec");
    private static final PartitionSpec DEFAULT_PartitionSpec;
    private static final RecordDataSchema.Field FIELD_MessageId;
    private static final RecordDataSchema.Field FIELD_QueryCount;
    private static final RecordDataSchema.Field FIELD_QueryCost;
    private static final RecordDataSchema.Field FIELD_LastExecutedAt;
    private static final RecordDataSchema.Field FIELD_UniqueUserCount;
    private static final RecordDataSchema.Field FIELD_UserCounts;

    public QueryUsageStatistics() {
        super(new DataMap(12, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public QueryUsageStatistics(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTimestampMillis() {
        if (this._timestampMillisField != null) {
            return true;
        }
        return this._map.containsKey("timestampMillis");
    }

    public void removeTimestampMillis() {
        this._map.remove("timestampMillis");
    }

    @Nullable
    public Long getTimestampMillis(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTimestampMillis();
            }
            case DEFAULT: 
            case NULL: {
                if (this._timestampMillisField != null) {
                    return this._timestampMillisField;
                }
                Object __rawValue = this._map.get("timestampMillis");
                this._timestampMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._timestampMillisField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getTimestampMillis() {
        if (this._timestampMillisField != null) {
            return this._timestampMillisField;
        }
        Object __rawValue = this._map.get("timestampMillis");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("timestampMillis");
        }
        this._timestampMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._timestampMillisField;
    }

    public QueryUsageStatistics setTimestampMillis(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTimestampMillis(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field timestampMillis of com.linkedin.query.QueryUsageStatistics");
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTimestampMillis();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
            }
        }
        return this;
    }

    public QueryUsageStatistics setTimestampMillis(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field timestampMillis of com.linkedin.query.QueryUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
        this._timestampMillisField = value;
        return this;
    }

    public QueryUsageStatistics setTimestampMillis(long value) {
        CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
        this._timestampMillisField = value;
        return this;
    }

    public boolean hasEventGranularity() {
        if (this._eventGranularityField != null) {
            return true;
        }
        return this._map.containsKey("eventGranularity");
    }

    public void removeEventGranularity() {
        this._map.remove("eventGranularity");
    }

    @Nullable
    public TimeWindowSize getEventGranularity(GetMode mode) {
        return this.getEventGranularity();
    }

    @Nullable
    public TimeWindowSize getEventGranularity() {
        if (this._eventGranularityField != null) {
            return this._eventGranularityField;
        }
        Object __rawValue = this._map.get("eventGranularity");
        this._eventGranularityField = __rawValue == null ? null : new TimeWindowSize(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._eventGranularityField;
    }

    public QueryUsageStatistics setEventGranularity(@Nullable TimeWindowSize value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEventGranularity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEventGranularity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
                this._eventGranularityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
                this._eventGranularityField = value;
            }
        }
        return this;
    }

    public QueryUsageStatistics setEventGranularity(@Nonnull TimeWindowSize value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field eventGranularity of com.linkedin.query.QueryUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
        this._eventGranularityField = value;
        return this;
    }

    public boolean hasPartitionSpec() {
        if (this._partitionSpecField != null) {
            return true;
        }
        return this._map.containsKey("partitionSpec");
    }

    public void removePartitionSpec() {
        this._map.remove("partitionSpec");
    }

    @Nullable
    public PartitionSpec getPartitionSpec(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getPartitionSpec();
            }
            case NULL: {
                if (this._partitionSpecField != null) {
                    return this._partitionSpecField;
                }
                Object __rawValue = this._map.get("partitionSpec");
                this._partitionSpecField = __rawValue == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._partitionSpecField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public PartitionSpec getPartitionSpec() {
        if (this._partitionSpecField != null) {
            return this._partitionSpecField;
        }
        Object __rawValue = this._map.get("partitionSpec");
        if (__rawValue == null) {
            return DEFAULT_PartitionSpec;
        }
        this._partitionSpecField = __rawValue == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._partitionSpecField;
    }

    public QueryUsageStatistics setPartitionSpec(@Nullable PartitionSpec value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPartitionSpec(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePartitionSpec();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
                this._partitionSpecField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
                this._partitionSpecField = value;
            }
        }
        return this;
    }

    public QueryUsageStatistics setPartitionSpec(@Nonnull PartitionSpec value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field partitionSpec of com.linkedin.query.QueryUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
        this._partitionSpecField = value;
        return this;
    }

    public boolean hasMessageId() {
        if (this._messageIdField != null) {
            return true;
        }
        return this._map.containsKey("messageId");
    }

    public void removeMessageId() {
        this._map.remove("messageId");
    }

    @Nullable
    public String getMessageId(GetMode mode) {
        return this.getMessageId();
    }

    @Nullable
    public String getMessageId() {
        if (this._messageIdField != null) {
            return this._messageIdField;
        }
        Object __rawValue = this._map.get("messageId");
        this._messageIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._messageIdField;
    }

    public QueryUsageStatistics setMessageId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMessageId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMessageId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "messageId", value);
                this._messageIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "messageId", value);
                this._messageIdField = value;
            }
        }
        return this;
    }

    public QueryUsageStatistics setMessageId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field messageId of com.linkedin.query.QueryUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "messageId", value);
        this._messageIdField = value;
        return this;
    }

    public boolean hasQueryCount() {
        if (this._queryCountField != null) {
            return true;
        }
        return this._map.containsKey("queryCount");
    }

    public void removeQueryCount() {
        this._map.remove("queryCount");
    }

    @Nullable
    public Integer getQueryCount(GetMode mode) {
        return this.getQueryCount();
    }

    @Nullable
    public Integer getQueryCount() {
        if (this._queryCountField != null) {
            return this._queryCountField;
        }
        Object __rawValue = this._map.get("queryCount");
        this._queryCountField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._queryCountField;
    }

    public QueryUsageStatistics setQueryCount(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setQueryCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeQueryCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "queryCount", DataTemplateUtil.coerceIntInput(value));
                this._queryCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "queryCount", DataTemplateUtil.coerceIntInput(value));
                this._queryCountField = value;
            }
        }
        return this;
    }

    public QueryUsageStatistics setQueryCount(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field queryCount of com.linkedin.query.QueryUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "queryCount", DataTemplateUtil.coerceIntInput(value));
        this._queryCountField = value;
        return this;
    }

    public QueryUsageStatistics setQueryCount(int value) {
        CheckedUtil.putWithoutChecking(this._map, "queryCount", DataTemplateUtil.coerceIntInput(value));
        this._queryCountField = value;
        return this;
    }

    public boolean hasQueryCost() {
        if (this._queryCostField != null) {
            return true;
        }
        return this._map.containsKey("queryCost");
    }

    public void removeQueryCost() {
        this._map.remove("queryCost");
    }

    @Nullable
    public Double getQueryCost(GetMode mode) {
        return this.getQueryCost();
    }

    @Nullable
    public Double getQueryCost() {
        if (this._queryCostField != null) {
            return this._queryCostField;
        }
        Object __rawValue = this._map.get("queryCost");
        this._queryCostField = DataTemplateUtil.coerceDoubleOutput(__rawValue);
        return this._queryCostField;
    }

    public QueryUsageStatistics setQueryCost(@Nullable Double value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setQueryCost(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeQueryCost();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "queryCost", DataTemplateUtil.coerceDoubleInput(value));
                this._queryCostField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "queryCost", DataTemplateUtil.coerceDoubleInput(value));
                this._queryCostField = value;
            }
        }
        return this;
    }

    public QueryUsageStatistics setQueryCost(@Nonnull Double value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field queryCost of com.linkedin.query.QueryUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "queryCost", DataTemplateUtil.coerceDoubleInput(value));
        this._queryCostField = value;
        return this;
    }

    public QueryUsageStatistics setQueryCost(double value) {
        CheckedUtil.putWithoutChecking(this._map, "queryCost", DataTemplateUtil.coerceDoubleInput(value));
        this._queryCostField = value;
        return this;
    }

    public boolean hasLastExecutedAt() {
        if (this._lastExecutedAtField != null) {
            return true;
        }
        return this._map.containsKey("lastExecutedAt");
    }

    public void removeLastExecutedAt() {
        this._map.remove("lastExecutedAt");
    }

    @Nullable
    public Long getLastExecutedAt(GetMode mode) {
        return this.getLastExecutedAt();
    }

    @Nullable
    public Long getLastExecutedAt() {
        if (this._lastExecutedAtField != null) {
            return this._lastExecutedAtField;
        }
        Object __rawValue = this._map.get("lastExecutedAt");
        this._lastExecutedAtField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._lastExecutedAtField;
    }

    public QueryUsageStatistics setLastExecutedAt(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastExecutedAt(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastExecutedAt();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastExecutedAt", DataTemplateUtil.coerceLongInput(value));
                this._lastExecutedAtField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastExecutedAt", DataTemplateUtil.coerceLongInput(value));
                this._lastExecutedAtField = value;
            }
        }
        return this;
    }

    public QueryUsageStatistics setLastExecutedAt(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastExecutedAt of com.linkedin.query.QueryUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastExecutedAt", DataTemplateUtil.coerceLongInput(value));
        this._lastExecutedAtField = value;
        return this;
    }

    public QueryUsageStatistics setLastExecutedAt(long value) {
        CheckedUtil.putWithoutChecking(this._map, "lastExecutedAt", DataTemplateUtil.coerceLongInput(value));
        this._lastExecutedAtField = value;
        return this;
    }

    public boolean hasUniqueUserCount() {
        if (this._uniqueUserCountField != null) {
            return true;
        }
        return this._map.containsKey("uniqueUserCount");
    }

    public void removeUniqueUserCount() {
        this._map.remove("uniqueUserCount");
    }

    @Nullable
    public Integer getUniqueUserCount(GetMode mode) {
        return this.getUniqueUserCount();
    }

    @Nullable
    public Integer getUniqueUserCount() {
        if (this._uniqueUserCountField != null) {
            return this._uniqueUserCountField;
        }
        Object __rawValue = this._map.get("uniqueUserCount");
        this._uniqueUserCountField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._uniqueUserCountField;
    }

    public QueryUsageStatistics setUniqueUserCount(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUniqueUserCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUniqueUserCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "uniqueUserCount", DataTemplateUtil.coerceIntInput(value));
                this._uniqueUserCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "uniqueUserCount", DataTemplateUtil.coerceIntInput(value));
                this._uniqueUserCountField = value;
            }
        }
        return this;
    }

    public QueryUsageStatistics setUniqueUserCount(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field uniqueUserCount of com.linkedin.query.QueryUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "uniqueUserCount", DataTemplateUtil.coerceIntInput(value));
        this._uniqueUserCountField = value;
        return this;
    }

    public QueryUsageStatistics setUniqueUserCount(int value) {
        CheckedUtil.putWithoutChecking(this._map, "uniqueUserCount", DataTemplateUtil.coerceIntInput(value));
        this._uniqueUserCountField = value;
        return this;
    }

    public boolean hasUserCounts() {
        if (this._userCountsField != null) {
            return true;
        }
        return this._map.containsKey("userCounts");
    }

    public void removeUserCounts() {
        this._map.remove("userCounts");
    }

    @Nullable
    public DatasetUserUsageCountsArray getUserCounts(GetMode mode) {
        return this.getUserCounts();
    }

    @Nullable
    public DatasetUserUsageCountsArray getUserCounts() {
        if (this._userCountsField != null) {
            return this._userCountsField;
        }
        Object __rawValue = this._map.get("userCounts");
        this._userCountsField = __rawValue == null ? null : new DatasetUserUsageCountsArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._userCountsField;
    }

    public QueryUsageStatistics setUserCounts(@Nullable DatasetUserUsageCountsArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUserCounts(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUserCounts();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "userCounts", value.data());
                this._userCountsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "userCounts", value.data());
                this._userCountsField = value;
            }
        }
        return this;
    }

    public QueryUsageStatistics setUserCounts(@Nonnull DatasetUserUsageCountsArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field userCounts of com.linkedin.query.QueryUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "userCounts", value.data());
        this._userCountsField = value;
        return this;
    }

    @Override
    public QueryUsageStatistics clone() throws CloneNotSupportedException {
        QueryUsageStatistics __clone = (QueryUsageStatistics)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public QueryUsageStatistics copy() throws CloneNotSupportedException {
        QueryUsageStatistics __copy = (QueryUsageStatistics)super.copy();
        __copy._queryCostField = null;
        __copy._timestampMillisField = null;
        __copy._lastExecutedAtField = null;
        __copy._eventGranularityField = null;
        __copy._messageIdField = null;
        __copy._queryCountField = null;
        __copy._userCountsField = null;
        __copy._partitionSpecField = null;
        __copy._uniqueUserCountField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_MessageId = SCHEMA.getField("messageId");
        FIELD_QueryCount = SCHEMA.getField("queryCount");
        FIELD_QueryCost = SCHEMA.getField("queryCost");
        FIELD_LastExecutedAt = SCHEMA.getField("lastExecutedAt");
        FIELD_UniqueUserCount = SCHEMA.getField("uniqueUserCount");
        FIELD_UserCounts = SCHEMA.getField("userCounts");
        DEFAULT_PartitionSpec = FIELD_PartitionSpec.getDefault() == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(FIELD_PartitionSpec.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final QueryUsageStatistics __objectRef;

        private ChangeListener(QueryUsageStatistics reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "queryCost": {
                    this.__objectRef._queryCostField = null;
                    break;
                }
                case "timestampMillis": {
                    this.__objectRef._timestampMillisField = null;
                    break;
                }
                case "lastExecutedAt": {
                    this.__objectRef._lastExecutedAtField = null;
                    break;
                }
                case "eventGranularity": {
                    this.__objectRef._eventGranularityField = null;
                    break;
                }
                case "messageId": {
                    this.__objectRef._messageIdField = null;
                    break;
                }
                case "queryCount": {
                    this.__objectRef._queryCountField = null;
                    break;
                }
                case "userCounts": {
                    this.__objectRef._userCountsField = null;
                    break;
                }
                case "partitionSpec": {
                    this.__objectRef._partitionSpecField = null;
                    break;
                }
                case "uniqueUserCount": {
                    this.__objectRef._uniqueUserCountField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec timestampMillis() {
            return new PathSpec(this.getPathComponents(), "timestampMillis");
        }

        public TimeWindowSize.Fields eventGranularity() {
            return new TimeWindowSize.Fields(this.getPathComponents(), "eventGranularity");
        }

        public PartitionSpec.Fields partitionSpec() {
            return new PartitionSpec.Fields(this.getPathComponents(), "partitionSpec");
        }

        public PathSpec messageId() {
            return new PathSpec(this.getPathComponents(), "messageId");
        }

        public PathSpec queryCount() {
            return new PathSpec(this.getPathComponents(), "queryCount");
        }

        public PathSpec queryCost() {
            return new PathSpec(this.getPathComponents(), "queryCost");
        }

        public PathSpec lastExecutedAt() {
            return new PathSpec(this.getPathComponents(), "lastExecutedAt");
        }

        public PathSpec uniqueUserCount() {
            return new PathSpec(this.getPathComponents(), "uniqueUserCount");
        }

        public DatasetUserUsageCountsArray.Fields userCounts() {
            return new DatasetUserUsageCountsArray.Fields(this.getPathComponents(), "userCounts");
        }

        public PathSpec userCounts(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "userCounts");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TimeWindowSize.ProjectionMask _eventGranularityMask;
        private PartitionSpec.ProjectionMask _partitionSpecMask;
        private DatasetUserUsageCountsArray.ProjectionMask _userCountsMask;

        ProjectionMask() {
            super(12);
        }

        public ProjectionMask withTimestampMillis() {
            this.getDataMap().put("timestampMillis", 1);
            return this;
        }

        public ProjectionMask withEventGranularity(Function<TimeWindowSize.ProjectionMask, TimeWindowSize.ProjectionMask> nestedMask) {
            this._eventGranularityMask = nestedMask.apply(this._eventGranularityMask == null ? TimeWindowSize.createMask() : this._eventGranularityMask);
            this.getDataMap().put("eventGranularity", this._eventGranularityMask.getDataMap());
            return this;
        }

        public ProjectionMask withEventGranularity() {
            this._eventGranularityMask = null;
            this.getDataMap().put("eventGranularity", 1);
            return this;
        }

        public ProjectionMask withPartitionSpec(Function<PartitionSpec.ProjectionMask, PartitionSpec.ProjectionMask> nestedMask) {
            this._partitionSpecMask = nestedMask.apply(this._partitionSpecMask == null ? PartitionSpec.createMask() : this._partitionSpecMask);
            this.getDataMap().put("partitionSpec", this._partitionSpecMask.getDataMap());
            return this;
        }

        public ProjectionMask withPartitionSpec() {
            this._partitionSpecMask = null;
            this.getDataMap().put("partitionSpec", 1);
            return this;
        }

        public ProjectionMask withMessageId() {
            this.getDataMap().put("messageId", 1);
            return this;
        }

        public ProjectionMask withQueryCount() {
            this.getDataMap().put("queryCount", 1);
            return this;
        }

        public ProjectionMask withQueryCost() {
            this.getDataMap().put("queryCost", 1);
            return this;
        }

        public ProjectionMask withLastExecutedAt() {
            this.getDataMap().put("lastExecutedAt", 1);
            return this;
        }

        public ProjectionMask withUniqueUserCount() {
            this.getDataMap().put("uniqueUserCount", 1);
            return this;
        }

        public ProjectionMask withUserCounts(Function<DatasetUserUsageCountsArray.ProjectionMask, DatasetUserUsageCountsArray.ProjectionMask> nestedMask) {
            this._userCountsMask = nestedMask.apply(this._userCountsMask == null ? DatasetUserUsageCountsArray.createMask() : this._userCountsMask);
            this.getDataMap().put("userCounts", this._userCountsMask.getDataMap());
            return this;
        }

        public ProjectionMask withUserCounts() {
            this._userCountsMask = null;
            this.getDataMap().put("userCounts", 1);
            return this;
        }

        public ProjectionMask withUserCounts(Function<DatasetUserUsageCountsArray.ProjectionMask, DatasetUserUsageCountsArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._userCountsMask = nestedMask.apply(this._userCountsMask == null ? DatasetUserUsageCountsArray.createMask() : this._userCountsMask);
            this.getDataMap().put("userCounts", this._userCountsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("userCounts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("userCounts").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withUserCounts(Integer start, Integer count) {
            this._userCountsMask = null;
            this.getDataMap().put("userCounts", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("userCounts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("userCounts").put("$count", count);
            }
            return this;
        }
    }
}

