/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.module;

import com.linkedin.common.UrnArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssetCollectionModuleParams
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.module/**The params required if the module is type ASSET_COLLECTION*/record AssetCollectionModuleParams{assetUrns:array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**Optional dynamic filters\n\nThe stringified json representing the logical predicate built in the UI to select assets.\nThis predicate is turned into orFilters to send through graphql since graphql doesn't support\narbitrary nesting. This string is used to restore the UI for this logical predicate.*/dynamicFilterJson:optional string}", SchemaFormatType.PDL);
    private UrnArray _assetUrnsField = null;
    private String _dynamicFilterJsonField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_AssetUrns = SCHEMA.getField("assetUrns");
    private static final RecordDataSchema.Field FIELD_DynamicFilterJson = SCHEMA.getField("dynamicFilterJson");

    public AssetCollectionModuleParams() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public AssetCollectionModuleParams(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasAssetUrns() {
        if (this._assetUrnsField != null) {
            return true;
        }
        return this._map.containsKey("assetUrns");
    }

    public void removeAssetUrns() {
        this._map.remove("assetUrns");
    }

    @Nullable
    public UrnArray getAssetUrns(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAssetUrns();
            }
            case DEFAULT: 
            case NULL: {
                if (this._assetUrnsField != null) {
                    return this._assetUrnsField;
                }
                Object __rawValue = this._map.get("assetUrns");
                this._assetUrnsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._assetUrnsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UrnArray getAssetUrns() {
        if (this._assetUrnsField != null) {
            return this._assetUrnsField;
        }
        Object __rawValue = this._map.get("assetUrns");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("assetUrns");
        }
        this._assetUrnsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._assetUrnsField;
    }

    public AssetCollectionModuleParams setAssetUrns(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAssetUrns(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field assetUrns of com.linkedin.module.AssetCollectionModuleParams");
                }
                CheckedUtil.putWithoutChecking(this._map, "assetUrns", value.data());
                this._assetUrnsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAssetUrns();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "assetUrns", value.data());
                this._assetUrnsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "assetUrns", value.data());
                this._assetUrnsField = value;
            }
        }
        return this;
    }

    public AssetCollectionModuleParams setAssetUrns(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field assetUrns of com.linkedin.module.AssetCollectionModuleParams to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "assetUrns", value.data());
        this._assetUrnsField = value;
        return this;
    }

    public boolean hasDynamicFilterJson() {
        if (this._dynamicFilterJsonField != null) {
            return true;
        }
        return this._map.containsKey("dynamicFilterJson");
    }

    public void removeDynamicFilterJson() {
        this._map.remove("dynamicFilterJson");
    }

    @Nullable
    public String getDynamicFilterJson(GetMode mode) {
        return this.getDynamicFilterJson();
    }

    @Nullable
    public String getDynamicFilterJson() {
        if (this._dynamicFilterJsonField != null) {
            return this._dynamicFilterJsonField;
        }
        Object __rawValue = this._map.get("dynamicFilterJson");
        this._dynamicFilterJsonField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._dynamicFilterJsonField;
    }

    public AssetCollectionModuleParams setDynamicFilterJson(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDynamicFilterJson(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDynamicFilterJson();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "dynamicFilterJson", value);
                this._dynamicFilterJsonField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "dynamicFilterJson", value);
                this._dynamicFilterJsonField = value;
            }
        }
        return this;
    }

    public AssetCollectionModuleParams setDynamicFilterJson(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field dynamicFilterJson of com.linkedin.module.AssetCollectionModuleParams to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "dynamicFilterJson", value);
        this._dynamicFilterJsonField = value;
        return this;
    }

    @Override
    public AssetCollectionModuleParams clone() throws CloneNotSupportedException {
        AssetCollectionModuleParams __clone = (AssetCollectionModuleParams)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public AssetCollectionModuleParams copy() throws CloneNotSupportedException {
        AssetCollectionModuleParams __copy = (AssetCollectionModuleParams)super.copy();
        __copy._assetUrnsField = null;
        __copy._dynamicFilterJsonField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final AssetCollectionModuleParams __objectRef;

        private ChangeListener(AssetCollectionModuleParams reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "assetUrns": {
                    this.__objectRef._assetUrnsField = null;
                    break;
                }
                case "dynamicFilterJson": {
                    this.__objectRef._dynamicFilterJsonField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec assetUrns() {
            return new PathSpec(this.getPathComponents(), "assetUrns");
        }

        public PathSpec assetUrns(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "assetUrns");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec dynamicFilterJson() {
            return new PathSpec(this.getPathComponents(), "dynamicFilterJson");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withAssetUrns() {
            this.getDataMap().put("assetUrns", 1);
            return this;
        }

        public ProjectionMask withAssetUrns(Integer start, Integer count) {
            this.getDataMap().put("assetUrns", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("assetUrns").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("assetUrns").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDynamicFilterJson() {
            this.getDataMap().put("dynamicFilterJson", 1);
            return this;
        }
    }
}

