/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.common.url.Url;
import com.linkedin.common.url.UrlCoercer;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.data.template.StringMap;
import com.linkedin.ml.metadata.MLHyperParamArray;
import com.linkedin.ml.metadata.MLMetricArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MLTrainingRunProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**The inputs and outputs of this training run*/@Aspect.name=\"mlTrainingRunProperties\"record MLTrainingRunProperties includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{namespace com.linkedin.common/**A reference to an external platform.*/record ExternalReference{/**URL where the reference exist*/@Searchable.fieldType=\"KEYWORD\"externalUrl:optional@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}{/**Run Id of the ML Training Run*/id:optional string/**List of URLs for the Outputs of the ML Training Run*/outputUrls:optional array[string]/**Hyperparameters of the ML Training Run*/hyperParams:optional array[/**Properties associated with an ML Hyper Param*/@Aspect.name=\"mlHyperParam\"record MLHyperParam{/**Name of the MLHyperParam*/name:string/**Documentation of the MLHyperParam*/description:optional string/**The value of the MLHyperParam*/value:optional string/**Date when the MLHyperParam was developed*/createdAt:optional{namespace com.linkedin.common/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long}}]/**Metrics of the ML Training Run*/trainingMetrics:optional array[/**Properties associated with an ML Metric*/@Aspect.name=\"mlMetric\"record MLMetric{/**Name of the mlMetric*/name:string/**Documentation of the mlMetric*/description:optional string/**The value of the mlMetric*/value:optional string/**Date when the mlMetric was developed*/createdAt:optional com.linkedin.common.Time}]}", SchemaFormatType.PDL);
    private StringMap _customPropertiesField = null;
    private Url _externalUrlField = null;
    private String _idField = null;
    private StringArray _outputUrlsField = null;
    private MLHyperParamArray _hyperParamsField = null;
    private MLMetricArray _trainingMetricsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CustomProperties = SCHEMA.getField("customProperties");
    private static final StringMap DEFAULT_CustomProperties;
    private static final RecordDataSchema.Field FIELD_ExternalUrl;
    private static final RecordDataSchema.Field FIELD_Id;
    private static final RecordDataSchema.Field FIELD_OutputUrls;
    private static final RecordDataSchema.Field FIELD_HyperParams;
    private static final RecordDataSchema.Field FIELD_TrainingMetrics;

    public MLTrainingRunProperties() {
        super(new DataMap(8, 0.75f), SCHEMA, 6);
        this.addChangeListener(this.__changeListener);
    }

    public MLTrainingRunProperties(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCustomProperties();
            }
            case NULL: {
                if (this._customPropertiesField != null) {
                    return this._customPropertiesField;
                }
                Object __rawValue = this._map.get("customProperties");
                this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._customPropertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        if (__rawValue == null) {
            return DEFAULT_CustomProperties;
        }
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public MLTrainingRunProperties setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field customProperties of com.linkedin.ml.metadata.MLTrainingRunProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public MLTrainingRunProperties setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.ml.metadata.MLTrainingRunProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasExternalUrl() {
        if (this._externalUrlField != null) {
            return true;
        }
        return this._map.containsKey("externalUrl");
    }

    public void removeExternalUrl() {
        this._map.remove("externalUrl");
    }

    @Nullable
    public Url getExternalUrl(GetMode mode) {
        return this.getExternalUrl();
    }

    @Nullable
    public Url getExternalUrl() {
        if (this._externalUrlField != null) {
            return this._externalUrlField;
        }
        Object __rawValue = this._map.get("externalUrl");
        this._externalUrlField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
        return this._externalUrlField;
    }

    public MLTrainingRunProperties setExternalUrl(@Nullable Url value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExternalUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExternalUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
            }
        }
        return this;
    }

    public MLTrainingRunProperties setExternalUrl(@Nonnull Url value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field externalUrl of com.linkedin.ml.metadata.MLTrainingRunProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
        this._externalUrlField = value;
        return this;
    }

    public boolean hasId() {
        if (this._idField != null) {
            return true;
        }
        return this._map.containsKey("id");
    }

    public void removeId() {
        this._map.remove("id");
    }

    @Nullable
    public String getId(GetMode mode) {
        return this.getId();
    }

    @Nullable
    public String getId() {
        if (this._idField != null) {
            return this._idField;
        }
        Object __rawValue = this._map.get("id");
        this._idField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._idField;
    }

    public MLTrainingRunProperties setId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "id", value);
                this._idField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "id", value);
                this._idField = value;
            }
        }
        return this;
    }

    public MLTrainingRunProperties setId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field id of com.linkedin.ml.metadata.MLTrainingRunProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "id", value);
        this._idField = value;
        return this;
    }

    public boolean hasOutputUrls() {
        if (this._outputUrlsField != null) {
            return true;
        }
        return this._map.containsKey("outputUrls");
    }

    public void removeOutputUrls() {
        this._map.remove("outputUrls");
    }

    @Nullable
    public StringArray getOutputUrls(GetMode mode) {
        return this.getOutputUrls();
    }

    @Nullable
    public StringArray getOutputUrls() {
        if (this._outputUrlsField != null) {
            return this._outputUrlsField;
        }
        Object __rawValue = this._map.get("outputUrls");
        this._outputUrlsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._outputUrlsField;
    }

    public MLTrainingRunProperties setOutputUrls(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOutputUrls(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOutputUrls();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "outputUrls", value.data());
                this._outputUrlsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "outputUrls", value.data());
                this._outputUrlsField = value;
            }
        }
        return this;
    }

    public MLTrainingRunProperties setOutputUrls(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field outputUrls of com.linkedin.ml.metadata.MLTrainingRunProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "outputUrls", value.data());
        this._outputUrlsField = value;
        return this;
    }

    public boolean hasHyperParams() {
        if (this._hyperParamsField != null) {
            return true;
        }
        return this._map.containsKey("hyperParams");
    }

    public void removeHyperParams() {
        this._map.remove("hyperParams");
    }

    @Nullable
    public MLHyperParamArray getHyperParams(GetMode mode) {
        return this.getHyperParams();
    }

    @Nullable
    public MLHyperParamArray getHyperParams() {
        if (this._hyperParamsField != null) {
            return this._hyperParamsField;
        }
        Object __rawValue = this._map.get("hyperParams");
        this._hyperParamsField = __rawValue == null ? null : new MLHyperParamArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._hyperParamsField;
    }

    public MLTrainingRunProperties setHyperParams(@Nullable MLHyperParamArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setHyperParams(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeHyperParams();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "hyperParams", value.data());
                this._hyperParamsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "hyperParams", value.data());
                this._hyperParamsField = value;
            }
        }
        return this;
    }

    public MLTrainingRunProperties setHyperParams(@Nonnull MLHyperParamArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field hyperParams of com.linkedin.ml.metadata.MLTrainingRunProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "hyperParams", value.data());
        this._hyperParamsField = value;
        return this;
    }

    public boolean hasTrainingMetrics() {
        if (this._trainingMetricsField != null) {
            return true;
        }
        return this._map.containsKey("trainingMetrics");
    }

    public void removeTrainingMetrics() {
        this._map.remove("trainingMetrics");
    }

    @Nullable
    public MLMetricArray getTrainingMetrics(GetMode mode) {
        return this.getTrainingMetrics();
    }

    @Nullable
    public MLMetricArray getTrainingMetrics() {
        if (this._trainingMetricsField != null) {
            return this._trainingMetricsField;
        }
        Object __rawValue = this._map.get("trainingMetrics");
        this._trainingMetricsField = __rawValue == null ? null : new MLMetricArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._trainingMetricsField;
    }

    public MLTrainingRunProperties setTrainingMetrics(@Nullable MLMetricArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTrainingMetrics(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTrainingMetrics();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "trainingMetrics", value.data());
                this._trainingMetricsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "trainingMetrics", value.data());
                this._trainingMetricsField = value;
            }
        }
        return this;
    }

    public MLTrainingRunProperties setTrainingMetrics(@Nonnull MLMetricArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field trainingMetrics of com.linkedin.ml.metadata.MLTrainingRunProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "trainingMetrics", value.data());
        this._trainingMetricsField = value;
        return this;
    }

    @Override
    public MLTrainingRunProperties clone() throws CloneNotSupportedException {
        MLTrainingRunProperties __clone = (MLTrainingRunProperties)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public MLTrainingRunProperties copy() throws CloneNotSupportedException {
        MLTrainingRunProperties __copy = (MLTrainingRunProperties)super.copy();
        __copy._externalUrlField = null;
        __copy._trainingMetricsField = null;
        __copy._customPropertiesField = null;
        __copy._outputUrlsField = null;
        __copy._idField = null;
        __copy._hyperParamsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_ExternalUrl = SCHEMA.getField("externalUrl");
        FIELD_Id = SCHEMA.getField("id");
        FIELD_OutputUrls = SCHEMA.getField("outputUrls");
        FIELD_HyperParams = SCHEMA.getField("hyperParams");
        FIELD_TrainingMetrics = SCHEMA.getField("trainingMetrics");
        Custom.initializeCustomClass(Url.class);
        Custom.initializeCoercerClass(UrlCoercer.class);
        DEFAULT_CustomProperties = FIELD_CustomProperties.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_CustomProperties.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final MLTrainingRunProperties __objectRef;

        private ChangeListener(MLTrainingRunProperties reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "externalUrl": {
                    this.__objectRef._externalUrlField = null;
                    break;
                }
                case "trainingMetrics": {
                    this.__objectRef._trainingMetricsField = null;
                    break;
                }
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "outputUrls": {
                    this.__objectRef._outputUrlsField = null;
                    break;
                }
                case "id": {
                    this.__objectRef._idField = null;
                    break;
                }
                case "hyperParams": {
                    this.__objectRef._hyperParamsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public PathSpec externalUrl() {
            return new PathSpec(this.getPathComponents(), "externalUrl");
        }

        public PathSpec id() {
            return new PathSpec(this.getPathComponents(), "id");
        }

        public PathSpec outputUrls() {
            return new PathSpec(this.getPathComponents(), "outputUrls");
        }

        public PathSpec outputUrls(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "outputUrls");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public MLHyperParamArray.Fields hyperParams() {
            return new MLHyperParamArray.Fields(this.getPathComponents(), "hyperParams");
        }

        public PathSpec hyperParams(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "hyperParams");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public MLMetricArray.Fields trainingMetrics() {
            return new MLMetricArray.Fields(this.getPathComponents(), "trainingMetrics");
        }

        public PathSpec trainingMetrics(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "trainingMetrics");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private MLHyperParamArray.ProjectionMask _hyperParamsMask;
        private MLMetricArray.ProjectionMask _trainingMetricsMask;

        ProjectionMask() {
            super(8);
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withExternalUrl() {
            this.getDataMap().put("externalUrl", 1);
            return this;
        }

        public ProjectionMask withId() {
            this.getDataMap().put("id", 1);
            return this;
        }

        public ProjectionMask withOutputUrls() {
            this.getDataMap().put("outputUrls", 1);
            return this;
        }

        public ProjectionMask withOutputUrls(Integer start, Integer count) {
            this.getDataMap().put("outputUrls", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("outputUrls").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("outputUrls").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withHyperParams(Function<MLHyperParamArray.ProjectionMask, MLHyperParamArray.ProjectionMask> nestedMask) {
            this._hyperParamsMask = nestedMask.apply(this._hyperParamsMask == null ? MLHyperParamArray.createMask() : this._hyperParamsMask);
            this.getDataMap().put("hyperParams", this._hyperParamsMask.getDataMap());
            return this;
        }

        public ProjectionMask withHyperParams() {
            this._hyperParamsMask = null;
            this.getDataMap().put("hyperParams", 1);
            return this;
        }

        public ProjectionMask withHyperParams(Function<MLHyperParamArray.ProjectionMask, MLHyperParamArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._hyperParamsMask = nestedMask.apply(this._hyperParamsMask == null ? MLHyperParamArray.createMask() : this._hyperParamsMask);
            this.getDataMap().put("hyperParams", this._hyperParamsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("hyperParams").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("hyperParams").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withHyperParams(Integer start, Integer count) {
            this._hyperParamsMask = null;
            this.getDataMap().put("hyperParams", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("hyperParams").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("hyperParams").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withTrainingMetrics(Function<MLMetricArray.ProjectionMask, MLMetricArray.ProjectionMask> nestedMask) {
            this._trainingMetricsMask = nestedMask.apply(this._trainingMetricsMask == null ? MLMetricArray.createMask() : this._trainingMetricsMask);
            this.getDataMap().put("trainingMetrics", this._trainingMetricsMask.getDataMap());
            return this;
        }

        public ProjectionMask withTrainingMetrics() {
            this._trainingMetricsMask = null;
            this.getDataMap().put("trainingMetrics", 1);
            return this;
        }

        public ProjectionMask withTrainingMetrics(Function<MLMetricArray.ProjectionMask, MLMetricArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._trainingMetricsMask = nestedMask.apply(this._trainingMetricsMask == null ? MLMetricArray.createMask() : this._trainingMetricsMask);
            this.getDataMap().put("trainingMetrics", this._trainingMetricsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("trainingMetrics").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("trainingMetrics").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withTrainingMetrics(Integer start, Integer count) {
            this._trainingMetricsMask = null;
            this.getDataMap().put("trainingMetrics", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("trainingMetrics").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("trainingMetrics").put("$count", count);
            }
            return this;
        }
    }
}

