/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.common.MLFeatureUrnArray;
import com.linkedin.common.TimeStamp;
import com.linkedin.common.UrnArray;
import com.linkedin.common.VersionTag;
import com.linkedin.common.url.Url;
import com.linkedin.common.url.UrlCoercer;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.data.template.StringMap;
import com.linkedin.ml.metadata.HyperParameterValueTypeMap;
import com.linkedin.ml.metadata.MLHyperParamArray;
import com.linkedin.ml.metadata.MLMetricArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MLModelProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**Properties associated with a ML Model*/@Aspect.name=\"mlModelProperties\"record MLModelProperties includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{namespace com.linkedin.common/**A reference to an external platform.*/record ExternalReference{/**URL where the reference exist*/@Searchable.fieldType=\"KEYWORD\"externalUrl:optional@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}/**A set of re-usable fields used to capture lineage information for ML Models and ML Model Groups*/record MLModelLineageInfo{/**List of jobs or process instances (if any) used to train the model or group. Visible in Lineage. Note that ML Models can also be specified as the output of a specific Data Process Instances (runs) via the DataProcessInstanceOutputs aspect.*/@Relationship.`/*`={\"entityTypes\":[\"dataJob\",\"dataProcessInstance\"],\"isLineage\":true,\"name\":\"TrainedBy\"}trainingJobs:optional array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**List of jobs or process instances (if any) that use the model or group.*/@Relationship.`/*`={\"entityTypes\":[\"dataJob\",\"dataProcessInstance\"],\"isLineage\":true,\"isUpstream\":false,\"name\":\"UsedBy\"}downstreamJobs:optional array[com.linkedin.common.Urn]}{/**Display name of the MLModel*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\",\"queryByDefault\":true,\"searchTier\":1}name:optional string/**Documentation of the MLModel*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\",\"searchTier\":2}description:optional string/**Date when the MLModel was developed*/@deprecated,date:optional{namespace com.linkedin.common/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long}/**Audit stamp containing who created this and when*/created:optional{namespace com.linkedin.common/**A standard event timestamp*/record TimeStamp{/**When did the event occur*/time:Time/**Optional: The actor urn involved in the event.*/actor:optional Urn}}/**Date when the MLModel was last modified*/lastModified:optional com.linkedin.common.TimeStamp/**Version of the MLModel*/version:optional{namespace com.linkedin.common/**A resource-defined string representing the resource state for the purpose of concurrency control*/record VersionTag{versionTag:optional string,metadataAttribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:Time/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:Urn/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}}/**Type of Algorithm or MLModel such as whether it is a Naive Bayes classifier, Convolutional Neural Network, etc*/@Searchable.fieldType=\"TEXT_PARTIAL\"type:optional string/**Hyper Parameters of the MLModel\n\nNOTE: these are deprecated in favor of hyperParams*/hyperParameters:optional map[string/**A union of all supported metadata aspects for HyperParameter Value*/typeref HyperParameterValueType=union[string,int,float,double,boolean]]/**Hyperparameters of the MLModel*/hyperParams:optional array[/**Properties associated with an ML Hyper Param*/@Aspect.name=\"mlHyperParam\"record MLHyperParam{/**Name of the MLHyperParam*/name:string/**Documentation of the MLHyperParam*/description:optional string/**The value of the MLHyperParam*/value:optional string/**Date when the MLHyperParam was developed*/createdAt:optional com.linkedin.common.Time}]/**Metrics of the MLModel used in training*/trainingMetrics:optional array[/**Properties associated with an ML Metric*/@Aspect.name=\"mlMetric\"record MLMetric{/**Name of the mlMetric*/name:string/**Documentation of the mlMetric*/description:optional string/**The value of the mlMetric*/value:optional string/**Date when the mlMetric was developed*/createdAt:optional com.linkedin.common.Time}]/**Metrics of the MLModel used in production*/onlineMetrics:optional array[MLMetric]/**List of features used for MLModel training*/@Relationship.`/*`={\"entityTypes\":[\"mlFeature\"],\"isLineage\":true,\"name\":\"Consumes\"}mlFeatures:optional array[{namespace com.linkedin.common/**Standardized MLFeature identifier.*/@java.class=\"com.linkedin.common.urn.MLFeatureUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized MLFeature identifier.\",\"entityType\":\"mlFeature\",\"fields\":[{\"doc\":\"Namespace for the MLFeature\",\"name\":\"mlFeatureNamespace\",\"type\":\"string\"},{\"doc\":\"Name of the MLFeature\",\"maxLength\":210,\"name\":\"mlFeatureName\",\"type\":\"string\"}],\"maxLength\":284,\"name\":\"MLFeature\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref MLFeatureUrn=string}]/**Tags for the MLModel*/tags:array[string]=[]/**Deployments for the MLModel*/@Relationship.`/*`={\"entityTypes\":[\"mlModelDeployment\"],\"name\":\"DeployedTo\"}deployments:optional array[com.linkedin.common.Urn]/**Groups the model belongs to*/@Relationship.`/*`={\"entityTypes\":[\"mlModelGroup\"],\"isLineage\":true,\"isUpstream\":false,\"name\":\"MemberOf\"}groups:optional array[com.linkedin.common.Urn]}", SchemaFormatType.PDL);
    private StringMap _customPropertiesField = null;
    private Url _externalUrlField = null;
    private UrnArray _trainingJobsField = null;
    private UrnArray _downstreamJobsField = null;
    private String _nameField = null;
    private String _descriptionField = null;
    private Long _dateField = null;
    private TimeStamp _createdField = null;
    private TimeStamp _lastModifiedField = null;
    private VersionTag _versionField = null;
    private String _typeField = null;
    private HyperParameterValueTypeMap _hyperParametersField = null;
    private MLHyperParamArray _hyperParamsField = null;
    private MLMetricArray _trainingMetricsField = null;
    private MLMetricArray _onlineMetricsField = null;
    private MLFeatureUrnArray _mlFeaturesField = null;
    private StringArray _tagsField = null;
    private UrnArray _deploymentsField = null;
    private UrnArray _groupsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CustomProperties = SCHEMA.getField("customProperties");
    private static final StringMap DEFAULT_CustomProperties;
    private static final RecordDataSchema.Field FIELD_ExternalUrl;
    private static final RecordDataSchema.Field FIELD_TrainingJobs;
    private static final RecordDataSchema.Field FIELD_DownstreamJobs;
    private static final RecordDataSchema.Field FIELD_Name;
    private static final RecordDataSchema.Field FIELD_Description;
    private static final RecordDataSchema.Field FIELD_Date;
    private static final RecordDataSchema.Field FIELD_Created;
    private static final RecordDataSchema.Field FIELD_LastModified;
    private static final RecordDataSchema.Field FIELD_Version;
    private static final RecordDataSchema.Field FIELD_Type;
    private static final RecordDataSchema.Field FIELD_HyperParameters;
    private static final RecordDataSchema.Field FIELD_HyperParams;
    private static final RecordDataSchema.Field FIELD_TrainingMetrics;
    private static final RecordDataSchema.Field FIELD_OnlineMetrics;
    private static final RecordDataSchema.Field FIELD_MlFeatures;
    private static final RecordDataSchema.Field FIELD_Tags;
    private static final StringArray DEFAULT_Tags;
    private static final RecordDataSchema.Field FIELD_Deployments;
    private static final RecordDataSchema.Field FIELD_Groups;

    public MLModelProperties() {
        super(new DataMap(), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public MLModelProperties(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCustomProperties();
            }
            case NULL: {
                if (this._customPropertiesField != null) {
                    return this._customPropertiesField;
                }
                Object __rawValue = this._map.get("customProperties");
                this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._customPropertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        if (__rawValue == null) {
            return DEFAULT_CustomProperties;
        }
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public MLModelProperties setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field customProperties of com.linkedin.ml.metadata.MLModelProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public MLModelProperties setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasExternalUrl() {
        if (this._externalUrlField != null) {
            return true;
        }
        return this._map.containsKey("externalUrl");
    }

    public void removeExternalUrl() {
        this._map.remove("externalUrl");
    }

    @Nullable
    public Url getExternalUrl(GetMode mode) {
        return this.getExternalUrl();
    }

    @Nullable
    public Url getExternalUrl() {
        if (this._externalUrlField != null) {
            return this._externalUrlField;
        }
        Object __rawValue = this._map.get("externalUrl");
        this._externalUrlField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
        return this._externalUrlField;
    }

    public MLModelProperties setExternalUrl(@Nullable Url value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExternalUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExternalUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
            }
        }
        return this;
    }

    public MLModelProperties setExternalUrl(@Nonnull Url value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field externalUrl of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
        this._externalUrlField = value;
        return this;
    }

    public boolean hasTrainingJobs() {
        if (this._trainingJobsField != null) {
            return true;
        }
        return this._map.containsKey("trainingJobs");
    }

    public void removeTrainingJobs() {
        this._map.remove("trainingJobs");
    }

    @Nullable
    public UrnArray getTrainingJobs(GetMode mode) {
        return this.getTrainingJobs();
    }

    @Nullable
    public UrnArray getTrainingJobs() {
        if (this._trainingJobsField != null) {
            return this._trainingJobsField;
        }
        Object __rawValue = this._map.get("trainingJobs");
        this._trainingJobsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._trainingJobsField;
    }

    public MLModelProperties setTrainingJobs(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTrainingJobs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTrainingJobs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "trainingJobs", value.data());
                this._trainingJobsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "trainingJobs", value.data());
                this._trainingJobsField = value;
            }
        }
        return this;
    }

    public MLModelProperties setTrainingJobs(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field trainingJobs of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "trainingJobs", value.data());
        this._trainingJobsField = value;
        return this;
    }

    public boolean hasDownstreamJobs() {
        if (this._downstreamJobsField != null) {
            return true;
        }
        return this._map.containsKey("downstreamJobs");
    }

    public void removeDownstreamJobs() {
        this._map.remove("downstreamJobs");
    }

    @Nullable
    public UrnArray getDownstreamJobs(GetMode mode) {
        return this.getDownstreamJobs();
    }

    @Nullable
    public UrnArray getDownstreamJobs() {
        if (this._downstreamJobsField != null) {
            return this._downstreamJobsField;
        }
        Object __rawValue = this._map.get("downstreamJobs");
        this._downstreamJobsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._downstreamJobsField;
    }

    public MLModelProperties setDownstreamJobs(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDownstreamJobs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDownstreamJobs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "downstreamJobs", value.data());
                this._downstreamJobsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "downstreamJobs", value.data());
                this._downstreamJobsField = value;
            }
        }
        return this;
    }

    public MLModelProperties setDownstreamJobs(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field downstreamJobs of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "downstreamJobs", value.data());
        this._downstreamJobsField = value;
        return this;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        return this.getName();
    }

    @Nullable
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public MLModelProperties setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public MLModelProperties setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public MLModelProperties setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public MLModelProperties setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    @Deprecated
    public boolean hasDate() {
        if (this._dateField != null) {
            return true;
        }
        return this._map.containsKey("date");
    }

    @Deprecated
    public void removeDate() {
        this._map.remove("date");
    }

    @Deprecated
    @Nullable
    public Long getDate(GetMode mode) {
        return this.getDate();
    }

    @Deprecated
    @Nullable
    public Long getDate() {
        if (this._dateField != null) {
            return this._dateField;
        }
        Object __rawValue = this._map.get("date");
        this._dateField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._dateField;
    }

    @Deprecated
    public MLModelProperties setDate(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDate(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDate();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "date", DataTemplateUtil.coerceLongInput(value));
                this._dateField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "date", DataTemplateUtil.coerceLongInput(value));
                this._dateField = value;
            }
        }
        return this;
    }

    @Deprecated
    public MLModelProperties setDate(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field date of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "date", DataTemplateUtil.coerceLongInput(value));
        this._dateField = value;
        return this;
    }

    @Deprecated
    public MLModelProperties setDate(long value) {
        CheckedUtil.putWithoutChecking(this._map, "date", DataTemplateUtil.coerceLongInput(value));
        this._dateField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public TimeStamp getCreated(GetMode mode) {
        return this.getCreated();
    }

    @Nullable
    public TimeStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        this._createdField = __rawValue == null ? null : new TimeStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public MLModelProperties setCreated(@Nullable TimeStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public MLModelProperties setCreated(@Nonnull TimeStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public TimeStamp getLastModified(GetMode mode) {
        return this.getLastModified();
    }

    @Nullable
    public TimeStamp getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        this._lastModifiedField = __rawValue == null ? null : new TimeStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public MLModelProperties setLastModified(@Nullable TimeStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public MLModelProperties setLastModified(@Nonnull TimeStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    public boolean hasVersion() {
        if (this._versionField != null) {
            return true;
        }
        return this._map.containsKey("version");
    }

    public void removeVersion() {
        this._map.remove("version");
    }

    @Nullable
    public VersionTag getVersion(GetMode mode) {
        return this.getVersion();
    }

    @Nullable
    public VersionTag getVersion() {
        if (this._versionField != null) {
            return this._versionField;
        }
        Object __rawValue = this._map.get("version");
        this._versionField = __rawValue == null ? null : new VersionTag(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._versionField;
    }

    public MLModelProperties setVersion(@Nullable VersionTag value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "version", value.data());
                this._versionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "version", value.data());
                this._versionField = value;
            }
        }
        return this;
    }

    public MLModelProperties setVersion(@Nonnull VersionTag value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field version of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "version", value.data());
        this._versionField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public String getType(GetMode mode) {
        return this.getType();
    }

    @Nullable
    public String getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        this._typeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._typeField;
    }

    public MLModelProperties setType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
            }
        }
        return this;
    }

    public MLModelProperties setType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value);
        this._typeField = value;
        return this;
    }

    public boolean hasHyperParameters() {
        if (this._hyperParametersField != null) {
            return true;
        }
        return this._map.containsKey("hyperParameters");
    }

    public void removeHyperParameters() {
        this._map.remove("hyperParameters");
    }

    @Nullable
    public HyperParameterValueTypeMap getHyperParameters(GetMode mode) {
        return this.getHyperParameters();
    }

    @Nullable
    public HyperParameterValueTypeMap getHyperParameters() {
        if (this._hyperParametersField != null) {
            return this._hyperParametersField;
        }
        Object __rawValue = this._map.get("hyperParameters");
        this._hyperParametersField = __rawValue == null ? null : new HyperParameterValueTypeMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._hyperParametersField;
    }

    public MLModelProperties setHyperParameters(@Nullable HyperParameterValueTypeMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setHyperParameters(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeHyperParameters();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "hyperParameters", value.data());
                this._hyperParametersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "hyperParameters", value.data());
                this._hyperParametersField = value;
            }
        }
        return this;
    }

    public MLModelProperties setHyperParameters(@Nonnull HyperParameterValueTypeMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field hyperParameters of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "hyperParameters", value.data());
        this._hyperParametersField = value;
        return this;
    }

    public boolean hasHyperParams() {
        if (this._hyperParamsField != null) {
            return true;
        }
        return this._map.containsKey("hyperParams");
    }

    public void removeHyperParams() {
        this._map.remove("hyperParams");
    }

    @Nullable
    public MLHyperParamArray getHyperParams(GetMode mode) {
        return this.getHyperParams();
    }

    @Nullable
    public MLHyperParamArray getHyperParams() {
        if (this._hyperParamsField != null) {
            return this._hyperParamsField;
        }
        Object __rawValue = this._map.get("hyperParams");
        this._hyperParamsField = __rawValue == null ? null : new MLHyperParamArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._hyperParamsField;
    }

    public MLModelProperties setHyperParams(@Nullable MLHyperParamArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setHyperParams(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeHyperParams();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "hyperParams", value.data());
                this._hyperParamsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "hyperParams", value.data());
                this._hyperParamsField = value;
            }
        }
        return this;
    }

    public MLModelProperties setHyperParams(@Nonnull MLHyperParamArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field hyperParams of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "hyperParams", value.data());
        this._hyperParamsField = value;
        return this;
    }

    public boolean hasTrainingMetrics() {
        if (this._trainingMetricsField != null) {
            return true;
        }
        return this._map.containsKey("trainingMetrics");
    }

    public void removeTrainingMetrics() {
        this._map.remove("trainingMetrics");
    }

    @Nullable
    public MLMetricArray getTrainingMetrics(GetMode mode) {
        return this.getTrainingMetrics();
    }

    @Nullable
    public MLMetricArray getTrainingMetrics() {
        if (this._trainingMetricsField != null) {
            return this._trainingMetricsField;
        }
        Object __rawValue = this._map.get("trainingMetrics");
        this._trainingMetricsField = __rawValue == null ? null : new MLMetricArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._trainingMetricsField;
    }

    public MLModelProperties setTrainingMetrics(@Nullable MLMetricArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTrainingMetrics(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTrainingMetrics();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "trainingMetrics", value.data());
                this._trainingMetricsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "trainingMetrics", value.data());
                this._trainingMetricsField = value;
            }
        }
        return this;
    }

    public MLModelProperties setTrainingMetrics(@Nonnull MLMetricArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field trainingMetrics of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "trainingMetrics", value.data());
        this._trainingMetricsField = value;
        return this;
    }

    public boolean hasOnlineMetrics() {
        if (this._onlineMetricsField != null) {
            return true;
        }
        return this._map.containsKey("onlineMetrics");
    }

    public void removeOnlineMetrics() {
        this._map.remove("onlineMetrics");
    }

    @Nullable
    public MLMetricArray getOnlineMetrics(GetMode mode) {
        return this.getOnlineMetrics();
    }

    @Nullable
    public MLMetricArray getOnlineMetrics() {
        if (this._onlineMetricsField != null) {
            return this._onlineMetricsField;
        }
        Object __rawValue = this._map.get("onlineMetrics");
        this._onlineMetricsField = __rawValue == null ? null : new MLMetricArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._onlineMetricsField;
    }

    public MLModelProperties setOnlineMetrics(@Nullable MLMetricArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOnlineMetrics(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOnlineMetrics();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "onlineMetrics", value.data());
                this._onlineMetricsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "onlineMetrics", value.data());
                this._onlineMetricsField = value;
            }
        }
        return this;
    }

    public MLModelProperties setOnlineMetrics(@Nonnull MLMetricArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field onlineMetrics of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "onlineMetrics", value.data());
        this._onlineMetricsField = value;
        return this;
    }

    public boolean hasMlFeatures() {
        if (this._mlFeaturesField != null) {
            return true;
        }
        return this._map.containsKey("mlFeatures");
    }

    public void removeMlFeatures() {
        this._map.remove("mlFeatures");
    }

    @Nullable
    public MLFeatureUrnArray getMlFeatures(GetMode mode) {
        return this.getMlFeatures();
    }

    @Nullable
    public MLFeatureUrnArray getMlFeatures() {
        if (this._mlFeaturesField != null) {
            return this._mlFeaturesField;
        }
        Object __rawValue = this._map.get("mlFeatures");
        this._mlFeaturesField = __rawValue == null ? null : new MLFeatureUrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._mlFeaturesField;
    }

    public MLModelProperties setMlFeatures(@Nullable MLFeatureUrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMlFeatures(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMlFeatures();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "mlFeatures", value.data());
                this._mlFeaturesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "mlFeatures", value.data());
                this._mlFeaturesField = value;
            }
        }
        return this;
    }

    public MLModelProperties setMlFeatures(@Nonnull MLFeatureUrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field mlFeatures of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "mlFeatures", value.data());
        this._mlFeaturesField = value;
        return this;
    }

    public boolean hasTags() {
        if (this._tagsField != null) {
            return true;
        }
        return this._map.containsKey("tags");
    }

    public void removeTags() {
        this._map.remove("tags");
    }

    @Nullable
    public StringArray getTags(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getTags();
            }
            case NULL: {
                if (this._tagsField != null) {
                    return this._tagsField;
                }
                Object __rawValue = this._map.get("tags");
                this._tagsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._tagsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringArray getTags() {
        if (this._tagsField != null) {
            return this._tagsField;
        }
        Object __rawValue = this._map.get("tags");
        if (__rawValue == null) {
            return DEFAULT_Tags;
        }
        this._tagsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._tagsField;
    }

    public MLModelProperties setTags(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTags(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field tags of com.linkedin.ml.metadata.MLModelProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "tags", value.data());
                this._tagsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTags();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "tags", value.data());
                this._tagsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "tags", value.data());
                this._tagsField = value;
            }
        }
        return this;
    }

    public MLModelProperties setTags(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field tags of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "tags", value.data());
        this._tagsField = value;
        return this;
    }

    public boolean hasDeployments() {
        if (this._deploymentsField != null) {
            return true;
        }
        return this._map.containsKey("deployments");
    }

    public void removeDeployments() {
        this._map.remove("deployments");
    }

    @Nullable
    public UrnArray getDeployments(GetMode mode) {
        return this.getDeployments();
    }

    @Nullable
    public UrnArray getDeployments() {
        if (this._deploymentsField != null) {
            return this._deploymentsField;
        }
        Object __rawValue = this._map.get("deployments");
        this._deploymentsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._deploymentsField;
    }

    public MLModelProperties setDeployments(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDeployments(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDeployments();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "deployments", value.data());
                this._deploymentsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "deployments", value.data());
                this._deploymentsField = value;
            }
        }
        return this;
    }

    public MLModelProperties setDeployments(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field deployments of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "deployments", value.data());
        this._deploymentsField = value;
        return this;
    }

    public boolean hasGroups() {
        if (this._groupsField != null) {
            return true;
        }
        return this._map.containsKey("groups");
    }

    public void removeGroups() {
        this._map.remove("groups");
    }

    @Nullable
    public UrnArray getGroups(GetMode mode) {
        return this.getGroups();
    }

    @Nullable
    public UrnArray getGroups() {
        if (this._groupsField != null) {
            return this._groupsField;
        }
        Object __rawValue = this._map.get("groups");
        this._groupsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._groupsField;
    }

    public MLModelProperties setGroups(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGroups(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGroups();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
            }
        }
        return this;
    }

    public MLModelProperties setGroups(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field groups of com.linkedin.ml.metadata.MLModelProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
        this._groupsField = value;
        return this;
    }

    @Override
    public MLModelProperties clone() throws CloneNotSupportedException {
        MLModelProperties __clone = (MLModelProperties)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public MLModelProperties copy() throws CloneNotSupportedException {
        MLModelProperties __copy = (MLModelProperties)super.copy();
        __copy._dateField = null;
        __copy._externalUrlField = null;
        __copy._trainingMetricsField = null;
        __copy._createdField = null;
        __copy._downstreamJobsField = null;
        __copy._descriptionField = null;
        __copy._groupsField = null;
        __copy._typeField = null;
        __copy._versionField = null;
        __copy._hyperParamsField = null;
        __copy._tagsField = null;
        __copy._deploymentsField = null;
        __copy._customPropertiesField = null;
        __copy._hyperParametersField = null;
        __copy._mlFeaturesField = null;
        __copy._nameField = null;
        __copy._lastModifiedField = null;
        __copy._trainingJobsField = null;
        __copy._onlineMetricsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_ExternalUrl = SCHEMA.getField("externalUrl");
        FIELD_TrainingJobs = SCHEMA.getField("trainingJobs");
        FIELD_DownstreamJobs = SCHEMA.getField("downstreamJobs");
        FIELD_Name = SCHEMA.getField("name");
        FIELD_Description = SCHEMA.getField("description");
        FIELD_Date = SCHEMA.getField("date");
        FIELD_Created = SCHEMA.getField("created");
        FIELD_LastModified = SCHEMA.getField("lastModified");
        FIELD_Version = SCHEMA.getField("version");
        FIELD_Type = SCHEMA.getField("type");
        FIELD_HyperParameters = SCHEMA.getField("hyperParameters");
        FIELD_HyperParams = SCHEMA.getField("hyperParams");
        FIELD_TrainingMetrics = SCHEMA.getField("trainingMetrics");
        FIELD_OnlineMetrics = SCHEMA.getField("onlineMetrics");
        FIELD_MlFeatures = SCHEMA.getField("mlFeatures");
        FIELD_Tags = SCHEMA.getField("tags");
        FIELD_Deployments = SCHEMA.getField("deployments");
        FIELD_Groups = SCHEMA.getField("groups");
        Custom.initializeCustomClass(Url.class);
        Custom.initializeCoercerClass(UrlCoercer.class);
        DEFAULT_CustomProperties = FIELD_CustomProperties.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_CustomProperties.getDefault(), DataMap.class));
        DEFAULT_Tags = FIELD_Tags.getDefault() == null ? null : new StringArray(DataTemplateUtil.castOrThrow(FIELD_Tags.getDefault(), DataList.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final MLModelProperties __objectRef;

        private ChangeListener(MLModelProperties reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "date": {
                    this.__objectRef._dateField = null;
                    break;
                }
                case "externalUrl": {
                    this.__objectRef._externalUrlField = null;
                    break;
                }
                case "trainingMetrics": {
                    this.__objectRef._trainingMetricsField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "downstreamJobs": {
                    this.__objectRef._downstreamJobsField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "groups": {
                    this.__objectRef._groupsField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "version": {
                    this.__objectRef._versionField = null;
                    break;
                }
                case "hyperParams": {
                    this.__objectRef._hyperParamsField = null;
                    break;
                }
                case "tags": {
                    this.__objectRef._tagsField = null;
                    break;
                }
                case "deployments": {
                    this.__objectRef._deploymentsField = null;
                    break;
                }
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "hyperParameters": {
                    this.__objectRef._hyperParametersField = null;
                    break;
                }
                case "mlFeatures": {
                    this.__objectRef._mlFeaturesField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                    break;
                }
                case "trainingJobs": {
                    this.__objectRef._trainingJobsField = null;
                    break;
                }
                case "onlineMetrics": {
                    this.__objectRef._onlineMetricsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public PathSpec externalUrl() {
            return new PathSpec(this.getPathComponents(), "externalUrl");
        }

        public PathSpec trainingJobs() {
            return new PathSpec(this.getPathComponents(), "trainingJobs");
        }

        public PathSpec trainingJobs(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "trainingJobs");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec downstreamJobs() {
            return new PathSpec(this.getPathComponents(), "downstreamJobs");
        }

        public PathSpec downstreamJobs(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "downstreamJobs");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        @Deprecated
        public PathSpec date() {
            return new PathSpec(this.getPathComponents(), "date");
        }

        public TimeStamp.Fields created() {
            return new TimeStamp.Fields(this.getPathComponents(), "created");
        }

        public TimeStamp.Fields lastModified() {
            return new TimeStamp.Fields(this.getPathComponents(), "lastModified");
        }

        public VersionTag.Fields version() {
            return new VersionTag.Fields(this.getPathComponents(), "version");
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public HyperParameterValueTypeMap.Fields hyperParameters() {
            return new HyperParameterValueTypeMap.Fields(this.getPathComponents(), "hyperParameters");
        }

        public MLHyperParamArray.Fields hyperParams() {
            return new MLHyperParamArray.Fields(this.getPathComponents(), "hyperParams");
        }

        public PathSpec hyperParams(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "hyperParams");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public MLMetricArray.Fields trainingMetrics() {
            return new MLMetricArray.Fields(this.getPathComponents(), "trainingMetrics");
        }

        public PathSpec trainingMetrics(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "trainingMetrics");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public MLMetricArray.Fields onlineMetrics() {
            return new MLMetricArray.Fields(this.getPathComponents(), "onlineMetrics");
        }

        public PathSpec onlineMetrics(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "onlineMetrics");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec mlFeatures() {
            return new PathSpec(this.getPathComponents(), "mlFeatures");
        }

        public PathSpec mlFeatures(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "mlFeatures");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec tags() {
            return new PathSpec(this.getPathComponents(), "tags");
        }

        public PathSpec tags(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "tags");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec deployments() {
            return new PathSpec(this.getPathComponents(), "deployments");
        }

        public PathSpec deployments(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "deployments");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec groups() {
            return new PathSpec(this.getPathComponents(), "groups");
        }

        public PathSpec groups(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "groups");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TimeStamp.ProjectionMask _createdMask;
        private TimeStamp.ProjectionMask _lastModifiedMask;
        private VersionTag.ProjectionMask _versionMask;
        private HyperParameterValueTypeMap.ProjectionMask _hyperParametersMask;
        private MLHyperParamArray.ProjectionMask _hyperParamsMask;
        private MLMetricArray.ProjectionMask _trainingMetricsMask;
        private MLMetricArray.ProjectionMask _onlineMetricsMask;

        ProjectionMask() {
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withExternalUrl() {
            this.getDataMap().put("externalUrl", 1);
            return this;
        }

        public ProjectionMask withTrainingJobs() {
            this.getDataMap().put("trainingJobs", 1);
            return this;
        }

        public ProjectionMask withTrainingJobs(Integer start, Integer count) {
            this.getDataMap().put("trainingJobs", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("trainingJobs").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("trainingJobs").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDownstreamJobs() {
            this.getDataMap().put("downstreamJobs", 1);
            return this;
        }

        public ProjectionMask withDownstreamJobs(Integer start, Integer count) {
            this.getDataMap().put("downstreamJobs", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("downstreamJobs").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("downstreamJobs").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withDate() {
            this.getDataMap().put("date", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<TimeStamp.ProjectionMask, TimeStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? TimeStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<TimeStamp.ProjectionMask, TimeStamp.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? TimeStamp.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }

        public ProjectionMask withVersion(Function<VersionTag.ProjectionMask, VersionTag.ProjectionMask> nestedMask) {
            this._versionMask = nestedMask.apply(this._versionMask == null ? VersionTag.createMask() : this._versionMask);
            this.getDataMap().put("version", this._versionMask.getDataMap());
            return this;
        }

        public ProjectionMask withVersion() {
            this._versionMask = null;
            this.getDataMap().put("version", 1);
            return this;
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withHyperParameters(Function<HyperParameterValueTypeMap.ProjectionMask, HyperParameterValueTypeMap.ProjectionMask> nestedMask) {
            this._hyperParametersMask = nestedMask.apply(this._hyperParametersMask == null ? HyperParameterValueTypeMap.createMask() : this._hyperParametersMask);
            this.getDataMap().put("hyperParameters", this._hyperParametersMask.getDataMap());
            return this;
        }

        public ProjectionMask withHyperParameters() {
            this._hyperParametersMask = null;
            this.getDataMap().put("hyperParameters", 1);
            return this;
        }

        public ProjectionMask withHyperParams(Function<MLHyperParamArray.ProjectionMask, MLHyperParamArray.ProjectionMask> nestedMask) {
            this._hyperParamsMask = nestedMask.apply(this._hyperParamsMask == null ? MLHyperParamArray.createMask() : this._hyperParamsMask);
            this.getDataMap().put("hyperParams", this._hyperParamsMask.getDataMap());
            return this;
        }

        public ProjectionMask withHyperParams() {
            this._hyperParamsMask = null;
            this.getDataMap().put("hyperParams", 1);
            return this;
        }

        public ProjectionMask withHyperParams(Function<MLHyperParamArray.ProjectionMask, MLHyperParamArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._hyperParamsMask = nestedMask.apply(this._hyperParamsMask == null ? MLHyperParamArray.createMask() : this._hyperParamsMask);
            this.getDataMap().put("hyperParams", this._hyperParamsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("hyperParams").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("hyperParams").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withHyperParams(Integer start, Integer count) {
            this._hyperParamsMask = null;
            this.getDataMap().put("hyperParams", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("hyperParams").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("hyperParams").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withTrainingMetrics(Function<MLMetricArray.ProjectionMask, MLMetricArray.ProjectionMask> nestedMask) {
            this._trainingMetricsMask = nestedMask.apply(this._trainingMetricsMask == null ? MLMetricArray.createMask() : this._trainingMetricsMask);
            this.getDataMap().put("trainingMetrics", this._trainingMetricsMask.getDataMap());
            return this;
        }

        public ProjectionMask withTrainingMetrics() {
            this._trainingMetricsMask = null;
            this.getDataMap().put("trainingMetrics", 1);
            return this;
        }

        public ProjectionMask withTrainingMetrics(Function<MLMetricArray.ProjectionMask, MLMetricArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._trainingMetricsMask = nestedMask.apply(this._trainingMetricsMask == null ? MLMetricArray.createMask() : this._trainingMetricsMask);
            this.getDataMap().put("trainingMetrics", this._trainingMetricsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("trainingMetrics").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("trainingMetrics").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withTrainingMetrics(Integer start, Integer count) {
            this._trainingMetricsMask = null;
            this.getDataMap().put("trainingMetrics", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("trainingMetrics").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("trainingMetrics").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withOnlineMetrics(Function<MLMetricArray.ProjectionMask, MLMetricArray.ProjectionMask> nestedMask) {
            this._onlineMetricsMask = nestedMask.apply(this._onlineMetricsMask == null ? MLMetricArray.createMask() : this._onlineMetricsMask);
            this.getDataMap().put("onlineMetrics", this._onlineMetricsMask.getDataMap());
            return this;
        }

        public ProjectionMask withOnlineMetrics() {
            this._onlineMetricsMask = null;
            this.getDataMap().put("onlineMetrics", 1);
            return this;
        }

        public ProjectionMask withOnlineMetrics(Function<MLMetricArray.ProjectionMask, MLMetricArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._onlineMetricsMask = nestedMask.apply(this._onlineMetricsMask == null ? MLMetricArray.createMask() : this._onlineMetricsMask);
            this.getDataMap().put("onlineMetrics", this._onlineMetricsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("onlineMetrics").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("onlineMetrics").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withOnlineMetrics(Integer start, Integer count) {
            this._onlineMetricsMask = null;
            this.getDataMap().put("onlineMetrics", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("onlineMetrics").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("onlineMetrics").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withMlFeatures() {
            this.getDataMap().put("mlFeatures", 1);
            return this;
        }

        public ProjectionMask withMlFeatures(Integer start, Integer count) {
            this.getDataMap().put("mlFeatures", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("mlFeatures").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("mlFeatures").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withTags() {
            this.getDataMap().put("tags", 1);
            return this;
        }

        public ProjectionMask withTags(Integer start, Integer count) {
            this.getDataMap().put("tags", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("tags").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("tags").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDeployments() {
            this.getDataMap().put("deployments", 1);
            return this;
        }

        public ProjectionMask withDeployments(Integer start, Integer count) {
            this.getDataMap().put("deployments", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("deployments").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("deployments").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withGroups() {
            this.getDataMap().put("groups", 1);
            return this;
        }

        public ProjectionMask withGroups(Integer start, Integer count) {
            this.getDataMap().put("groups", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("groups").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("groups").put("$count", count);
            }
            return this;
        }
    }
}

