/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.common.UrnArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MLModelLineageInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**A set of re-usable fields used to capture lineage information for ML Models and ML Model Groups*/record MLModelLineageInfo{/**List of jobs or process instances (if any) used to train the model or group. Visible in Lineage. Note that ML Models can also be specified as the output of a specific Data Process Instances (runs) via the DataProcessInstanceOutputs aspect.*/@Relationship.`/*`={\"entityTypes\":[\"dataJob\",\"dataProcessInstance\"],\"isLineage\":true,\"name\":\"TrainedBy\"}trainingJobs:optional array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**List of jobs or process instances (if any) that use the model or group.*/@Relationship.`/*`={\"entityTypes\":[\"dataJob\",\"dataProcessInstance\"],\"isLineage\":true,\"isUpstream\":false,\"name\":\"UsedBy\"}downstreamJobs:optional array[com.linkedin.common.Urn]}", SchemaFormatType.PDL);
    private UrnArray _trainingJobsField = null;
    private UrnArray _downstreamJobsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_TrainingJobs = SCHEMA.getField("trainingJobs");
    private static final RecordDataSchema.Field FIELD_DownstreamJobs = SCHEMA.getField("downstreamJobs");

    public MLModelLineageInfo() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public MLModelLineageInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTrainingJobs() {
        if (this._trainingJobsField != null) {
            return true;
        }
        return this._map.containsKey("trainingJobs");
    }

    public void removeTrainingJobs() {
        this._map.remove("trainingJobs");
    }

    @Nullable
    public UrnArray getTrainingJobs(GetMode mode) {
        return this.getTrainingJobs();
    }

    @Nullable
    public UrnArray getTrainingJobs() {
        if (this._trainingJobsField != null) {
            return this._trainingJobsField;
        }
        Object __rawValue = this._map.get("trainingJobs");
        this._trainingJobsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._trainingJobsField;
    }

    public MLModelLineageInfo setTrainingJobs(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTrainingJobs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTrainingJobs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "trainingJobs", value.data());
                this._trainingJobsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "trainingJobs", value.data());
                this._trainingJobsField = value;
            }
        }
        return this;
    }

    public MLModelLineageInfo setTrainingJobs(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field trainingJobs of com.linkedin.ml.metadata.MLModelLineageInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "trainingJobs", value.data());
        this._trainingJobsField = value;
        return this;
    }

    public boolean hasDownstreamJobs() {
        if (this._downstreamJobsField != null) {
            return true;
        }
        return this._map.containsKey("downstreamJobs");
    }

    public void removeDownstreamJobs() {
        this._map.remove("downstreamJobs");
    }

    @Nullable
    public UrnArray getDownstreamJobs(GetMode mode) {
        return this.getDownstreamJobs();
    }

    @Nullable
    public UrnArray getDownstreamJobs() {
        if (this._downstreamJobsField != null) {
            return this._downstreamJobsField;
        }
        Object __rawValue = this._map.get("downstreamJobs");
        this._downstreamJobsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._downstreamJobsField;
    }

    public MLModelLineageInfo setDownstreamJobs(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDownstreamJobs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDownstreamJobs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "downstreamJobs", value.data());
                this._downstreamJobsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "downstreamJobs", value.data());
                this._downstreamJobsField = value;
            }
        }
        return this;
    }

    public MLModelLineageInfo setDownstreamJobs(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field downstreamJobs of com.linkedin.ml.metadata.MLModelLineageInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "downstreamJobs", value.data());
        this._downstreamJobsField = value;
        return this;
    }

    @Override
    public MLModelLineageInfo clone() throws CloneNotSupportedException {
        MLModelLineageInfo __clone = (MLModelLineageInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public MLModelLineageInfo copy() throws CloneNotSupportedException {
        MLModelLineageInfo __copy = (MLModelLineageInfo)super.copy();
        __copy._downstreamJobsField = null;
        __copy._trainingJobsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final MLModelLineageInfo __objectRef;

        private ChangeListener(MLModelLineageInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "downstreamJobs": {
                    this.__objectRef._downstreamJobsField = null;
                    break;
                }
                case "trainingJobs": {
                    this.__objectRef._trainingJobsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec trainingJobs() {
            return new PathSpec(this.getPathComponents(), "trainingJobs");
        }

        public PathSpec trainingJobs(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "trainingJobs");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec downstreamJobs() {
            return new PathSpec(this.getPathComponents(), "downstreamJobs");
        }

        public PathSpec downstreamJobs(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "downstreamJobs");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withTrainingJobs() {
            this.getDataMap().put("trainingJobs", 1);
            return this;
        }

        public ProjectionMask withTrainingJobs(Integer start, Integer count) {
            this.getDataMap().put("trainingJobs", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("trainingJobs").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("trainingJobs").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDownstreamJobs() {
            this.getDataMap().put("downstreamJobs", 1);
            return this;
        }

        public ProjectionMask withDownstreamJobs(Integer start, Integer count) {
            this.getDataMap().put("downstreamJobs", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("downstreamJobs").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("downstreamJobs").put("$count", count);
            }
            return this;
        }
    }
}

