/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingMapTemplate;
import com.linkedin.ml.metadata.HyperParameterValueType;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class HyperParameterValueTypeMap
extends WrappingMapTemplate<HyperParameterValueType> {
    private static final MapDataSchema SCHEMA = (MapDataSchema)DataTemplateUtil.parseSchema("map[string,union[string,int,float,double,boolean]]", SchemaFormatType.PDL);

    public HyperParameterValueTypeMap() {
        this(new DataMap());
    }

    public HyperParameterValueTypeMap(int initialCapacity) {
        this(new DataMap(initialCapacity));
    }

    public HyperParameterValueTypeMap(int initialCapacity, float loadFactor) {
        this(new DataMap(initialCapacity, loadFactor));
    }

    public HyperParameterValueTypeMap(Map<String, HyperParameterValueType> m4) {
        this(HyperParameterValueTypeMap.newDataMapOfSize(m4.size()));
        this.putAll(m4);
    }

    public HyperParameterValueTypeMap(DataMap data) {
        super(data, SCHEMA, HyperParameterValueType.class);
    }

    public static MapDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public HyperParameterValueTypeMap clone() throws CloneNotSupportedException {
        HyperParameterValueTypeMap __clone = (HyperParameterValueTypeMap)super.clone();
        return __clone;
    }

    @Override
    public HyperParameterValueTypeMap copy() throws CloneNotSupportedException {
        HyperParameterValueTypeMap __copy = (HyperParameterValueTypeMap)super.copy();
        return __copy;
    }

    @Override
    protected HyperParameterValueType coerceOutput(Object object) throws TemplateOutputCastException {
        if (object == null) {
            return null;
        }
        return object == null ? null : new HyperParameterValueType(object);
    }

    public static class ProjectionMask
    extends MaskMap {
        private HyperParameterValueType.ProjectionMask _valuesMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withValues(Function<HyperParameterValueType.ProjectionMask, HyperParameterValueType.ProjectionMask> nestedMask) {
            this._valuesMask = nestedMask.apply(this._valuesMask == null ? HyperParameterValueType.createMask() : this._valuesMask);
            this.getDataMap().put("$*", this._valuesMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public HyperParameterValueType.Fields values() {
            return new HyperParameterValueType.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

