/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.ml.metadata.BaseDataArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EvaluationData
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**All referenced datasets would ideally point to any set of documents that provide visibility into the source and composition of the dataset.*/@Aspect.name=\"mlModelEvaluationData\"record EvaluationData{/**Details on the dataset(s) used for the quantitative analyses in the MLModel*/evaluationData:array[/**BaseData record*/record BaseData{/**What dataset were used in the MLModel?*/dataset:{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}/**Why was this dataset chosen?*/motivation:optional string/**How was the data preprocessed (e.g., tokenization of sentences, cropping of images, any filtering such as dropping images without faces)?*/preProcessing:optional array[string]}]}", SchemaFormatType.PDL);
    private BaseDataArray _evaluationDataField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_EvaluationData = SCHEMA.getField("evaluationData");

    public EvaluationData() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public EvaluationData(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasEvaluationData() {
        if (this._evaluationDataField != null) {
            return true;
        }
        return this._map.containsKey("evaluationData");
    }

    public void removeEvaluationData() {
        this._map.remove("evaluationData");
    }

    @Nullable
    public BaseDataArray getEvaluationData(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEvaluationData();
            }
            case DEFAULT: 
            case NULL: {
                if (this._evaluationDataField != null) {
                    return this._evaluationDataField;
                }
                Object __rawValue = this._map.get("evaluationData");
                this._evaluationDataField = __rawValue == null ? null : new BaseDataArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._evaluationDataField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public BaseDataArray getEvaluationData() {
        if (this._evaluationDataField != null) {
            return this._evaluationDataField;
        }
        Object __rawValue = this._map.get("evaluationData");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("evaluationData");
        }
        this._evaluationDataField = __rawValue == null ? null : new BaseDataArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._evaluationDataField;
    }

    public EvaluationData setEvaluationData(@Nullable BaseDataArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEvaluationData(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field evaluationData of com.linkedin.ml.metadata.EvaluationData");
                }
                CheckedUtil.putWithoutChecking(this._map, "evaluationData", value.data());
                this._evaluationDataField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEvaluationData();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "evaluationData", value.data());
                this._evaluationDataField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "evaluationData", value.data());
                this._evaluationDataField = value;
            }
        }
        return this;
    }

    public EvaluationData setEvaluationData(@Nonnull BaseDataArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field evaluationData of com.linkedin.ml.metadata.EvaluationData to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "evaluationData", value.data());
        this._evaluationDataField = value;
        return this;
    }

    @Override
    public EvaluationData clone() throws CloneNotSupportedException {
        EvaluationData __clone = (EvaluationData)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public EvaluationData copy() throws CloneNotSupportedException {
        EvaluationData __copy = (EvaluationData)super.copy();
        __copy._evaluationDataField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final EvaluationData __objectRef;

        private ChangeListener(EvaluationData reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "evaluationData": {
                    this.__objectRef._evaluationDataField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public BaseDataArray.Fields evaluationData() {
            return new BaseDataArray.Fields(this.getPathComponents(), "evaluationData");
        }

        public PathSpec evaluationData(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "evaluationData");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private BaseDataArray.ProjectionMask _evaluationDataMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withEvaluationData(Function<BaseDataArray.ProjectionMask, BaseDataArray.ProjectionMask> nestedMask) {
            this._evaluationDataMask = nestedMask.apply(this._evaluationDataMask == null ? BaseDataArray.createMask() : this._evaluationDataMask);
            this.getDataMap().put("evaluationData", this._evaluationDataMask.getDataMap());
            return this;
        }

        public ProjectionMask withEvaluationData() {
            this._evaluationDataMask = null;
            this.getDataMap().put("evaluationData", 1);
            return this;
        }

        public ProjectionMask withEvaluationData(Function<BaseDataArray.ProjectionMask, BaseDataArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._evaluationDataMask = nestedMask.apply(this._evaluationDataMask == null ? BaseDataArray.createMask() : this._evaluationDataMask);
            this.getDataMap().put("evaluationData", this._evaluationDataMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("evaluationData").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("evaluationData").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withEvaluationData(Integer start, Integer count) {
            this._evaluationDataMask = null;
            this.getDataMap().put("evaluationData", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("evaluationData").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("evaluationData").put("$count", count);
            }
            return this;
        }
    }
}

