/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils;

import com.google.common.annotations.VisibleForTesting;
import com.linkedin.common.urn.Urn;
import com.linkedin.common.urn.UrnUtils;
import com.linkedin.schema.SchemaField;
import com.linkedin.schema.SchemaMetadata;
import com.linkedin.util.Pair;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.codec.digest.DigestUtils;

public class SchemaFieldUtils {
    private static final String FIELD_PATH_V2 = "[version=2.0]";

    private SchemaFieldUtils() {
    }

    public static Urn generateSchemaFieldUrn(Urn parentUrn, SchemaField field) {
        return SchemaFieldUtils.generateSchemaFieldUrn(parentUrn, field.getFieldPath());
    }

    public static String generateDocumentId(Urn schemaFieldUrn) {
        if (!"schemaField".equals(schemaFieldUrn.getEntityType())) {
            throw new IllegalArgumentException(String.format("Invalid URN, expected entity %s, found %s", "schemaField", schemaFieldUrn.getEntityType()));
        }
        return String.format("urn:li:%s:(%s,%s)", "schemaField", DigestUtils.sha256Hex((String)schemaFieldUrn.getEntityKey().get(0)), DigestUtils.sha256Hex((String)schemaFieldUrn.getEntityKey().get(1)));
    }

    public static Urn generateSchemaFieldUrn(@Nonnull Urn parentUrn, @Nonnull String fieldPath) {
        String encodedFieldPath = fieldPath.replaceAll("\\(", "%28").replaceAll("\\)", "%29").replaceAll(",", "%2C");
        return Urn.createFromTuple("schemaField", parentUrn.toString(), encodedFieldPath);
    }

    public static Set<Urn> getSchemaFieldAliases(@Nonnull Urn datasetUrn, @Nonnull SchemaMetadata schemaMetadata, @Nonnull SchemaField schemaField) {
        Urn downgradedUrn = SchemaFieldUtils.downgradeSchemaFieldUrn(SchemaFieldUtils.generateSchemaFieldUrn(datasetUrn, SchemaFieldUtils.downgradeFieldPath(schemaField.getFieldPath())));
        HashSet aliases = schemaMetadata.getFields().stream().map(field -> Pair.of(SchemaFieldUtils.generateSchemaFieldUrn(datasetUrn, SchemaFieldUtils.downgradeFieldPath(field.getFieldPath())), SchemaFieldUtils.generateSchemaFieldUrn(datasetUrn, field.getFieldPath()))).filter(pair -> ((Urn)pair.getFirst()).equals(downgradedUrn)).map(Pair::getSecond).collect(Collectors.toCollection(HashSet::new));
        if (!aliases.isEmpty()) {
            aliases.add(downgradedUrn);
        }
        return aliases;
    }

    @Nonnull
    @VisibleForTesting
    static Urn downgradeSchemaFieldUrn(@Nonnull Urn schemaFieldUrn) {
        return SchemaFieldUtils.generateSchemaFieldUrn(UrnUtils.getUrn(schemaFieldUrn.getId()), SchemaFieldUtils.downgradeFieldPath(schemaFieldUrn.getEntityKey().get(1)));
    }

    @Nonnull
    public static String downgradeFieldPath(@Nonnull SchemaField field) {
        return SchemaFieldUtils.downgradeFieldPath(field.getFieldPath());
    }

    @Nonnull
    private static String downgradeFieldPath(@Nonnull String fieldPath) {
        if (fieldPath.startsWith(FIELD_PATH_V2)) {
            return Arrays.stream(fieldPath.substring(FIELD_PATH_V2.length()).split("[.]")).filter(component -> !component.isEmpty() && (!component.startsWith("[") || !component.endsWith("]"))).collect(Collectors.joining("."));
        }
        return fieldPath;
    }
}

