/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.models.registry.EntityRegistry;
import com.linkedin.metadata.utils.GenericRecordUtils;
import com.linkedin.mxe.MetadataChangeLog;
import com.linkedin.mxe.MetadataChangeProposal;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityKeyUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityKeyUtils.class);
    private static final Logger logger = LoggerFactory.getLogger(EntityKeyUtils.class);

    private EntityKeyUtils() {
    }

    @Nonnull
    public static Urn getUrnFromProposal(MetadataChangeProposal metadataChangeProposal, AspectSpec keyAspectSpec) {
        if (metadataChangeProposal.hasEntityUrn()) {
            Urn urn = metadataChangeProposal.getEntityUrn();
            try {
                EntityKeyUtils.convertUrnToEntityKey(urn, keyAspectSpec);
            }
            catch (RuntimeException re) {
                throw new RuntimeException(String.format("Failed to validate entity URN %s", urn), re);
            }
            return urn;
        }
        if (metadataChangeProposal.hasEntityKeyAspect()) {
            RecordTemplate keyAspectRecord = GenericRecordUtils.deserializeAspect(metadataChangeProposal.getEntityKeyAspect().getValue(), metadataChangeProposal.getEntityKeyAspect().getContentType(), keyAspectSpec);
            return EntityKeyUtils.convertEntityKeyToUrn(keyAspectRecord, metadataChangeProposal.getEntityType());
        }
        throw new IllegalArgumentException("One of urn and keyAspect must be set");
    }

    @Nonnull
    public static Urn getUrnFromLog(MetadataChangeLog metadataChangeLog, AspectSpec keyAspectSpec) {
        if (metadataChangeLog.hasEntityUrn()) {
            Urn urn = metadataChangeLog.getEntityUrn();
            try {
                EntityKeyUtils.convertUrnToEntityKey(urn, keyAspectSpec);
            }
            catch (RuntimeException re) {
                throw new RuntimeException(String.format("Failed to validate entity URN %s", urn), re);
            }
            return urn;
        }
        if (metadataChangeLog.hasEntityKeyAspect()) {
            RecordTemplate keyAspectRecord = GenericRecordUtils.deserializeAspect(metadataChangeLog.getEntityKeyAspect().getValue(), metadataChangeLog.getEntityKeyAspect().getContentType(), keyAspectSpec);
            return EntityKeyUtils.convertEntityKeyToUrn(keyAspectRecord, metadataChangeLog.getEntityType());
        }
        throw new IllegalArgumentException("One of urn and keyAspect must be set");
    }

    public static Urn getUrnFromEvent(@Nonnull MetadataChangeLog event, @Nonnull EntityRegistry entityRegistry) {
        EntitySpec entitySpec;
        try {
            entitySpec = entityRegistry.getEntitySpec(event.getEntityType());
        }
        catch (IllegalArgumentException e) {
            log.error("Error while processing entity type {}: {}", (Object)event.getEntityType(), (Object)e.toString());
            throw new RuntimeException("Failed to get urn from MetadataChangeLog event. Skipping processing.", e);
        }
        return EntityKeyUtils.getUrnFromLog(event, entitySpec.getKeyAspectSpec());
    }

    @Nonnull
    public static RecordTemplate convertUrnToEntityKey(@Nonnull Urn urn, @Nonnull AspectSpec keyAspectSpec) {
        RecordDataSchema keySchema = keyAspectSpec.getPegasusSchema();
        Class<RecordTemplate> clazz = keyAspectSpec.getDataTemplateClass().asSubclass(RecordTemplate.class);
        if (urn.getEntityKey().getParts().size() != keySchema.getFields().size()) {
            throw new IllegalArgumentException("Failed to convert urn to entity key: urns parts and key fields do not have same length for " + String.valueOf(urn));
        }
        DataMap dataMap = new DataMap();
        for (int i = 0; i < urn.getEntityKey().getParts().size(); ++i) {
            String urnPart = urn.getEntityKey().get(i);
            RecordDataSchema.Field field = keySchema.getFields().get(i);
            dataMap.put(field.getName(), urnPart);
        }
        try {
            Constructor<RecordTemplate> constructor = clazz.getConstructor(DataMap.class);
            return constructor.newInstance(dataMap);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Failed to instantiate RecordTemplate with name %s. Missing constructor taking DataMap as arg.", clazz.getName()));
        }
    }

    @Nonnull
    public static RecordTemplate convertUrnToEntityKeyInternal(@Nonnull Urn urn, @Nonnull RecordDataSchema keySchema) {
        Class<RecordTemplate> clazz;
        try {
            clazz = Class.forName(keySchema.getFullName()).asSubclass(RecordTemplate.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Failed to find RecordTemplate class associated with provided RecordDataSchema named %s", keySchema.getFullName()), e);
        }
        if (urn.getEntityKey().getParts().size() != keySchema.getFields().size()) {
            throw new IllegalArgumentException("Failed to convert urn to entity key: urns parts and key fields do not have same length");
        }
        DataMap dataMap = new DataMap();
        for (int i = 0; i < urn.getEntityKey().getParts().size(); ++i) {
            String urnPart = urn.getEntityKey().get(i);
            RecordDataSchema.Field field = keySchema.getFields().get(i);
            dataMap.put(field.getName(), urnPart);
        }
        try {
            Constructor<RecordTemplate> constructor = clazz.getConstructor(DataMap.class);
            return constructor.newInstance(dataMap);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Failed to instantiate RecordTemplate with name %s. Missing constructor taking DataMap as arg.", clazz.getName()));
        }
    }

    @Nonnull
    public static Urn convertEntityKeyToUrn(@Nonnull RecordTemplate keyAspect, @Nonnull String entityName) {
        ArrayList<String> urnParts = new ArrayList<String>();
        for (RecordDataSchema.Field field : keyAspect.schema().getFields()) {
            Object value = keyAspect.data().get(field.getName());
            String valueString = value == null ? "" : value.toString();
            urnParts.add(valueString);
        }
        return Urn.createFromTuple(entityName, urnParts);
    }
}

