/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.common.urn.UrnUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.joda.time.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditStampUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditStampUtils.class);

    private AuditStampUtils() {
    }

    public static AuditStamp createDefaultAuditStamp() {
        return AuditStampUtils.getAuditStamp(UrnUtils.getUrn("urn:li:corpuser:__datahub_system"));
    }

    public static AuditStamp createAuditStamp(@Nonnull String actorUrn) {
        return AuditStampUtils.getAuditStamp(UrnUtils.getUrn(actorUrn));
    }

    public static AuditStamp getAuditStamp(Urn actor) {
        return AuditStampUtils.getAuditStamp(actor, null);
    }

    public static AuditStamp getAuditStamp(@Nonnull Urn actor, @Nullable Long currentTimeMs) {
        AuditStamp auditStamp = new AuditStamp();
        auditStamp.setTime(currentTimeMs != null ? currentTimeMs : DateTimeUtils.currentTimeMillis());
        auditStamp.setActor(actor);
        return auditStamp;
    }
}

