/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.search;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.query.FreshnessStats;
import com.linkedin.metadata.search.LineageSearchEntityArray;
import com.linkedin.metadata.search.LineageSearchPath;
import com.linkedin.metadata.search.SearchResultMetadata;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LineageSearchResult
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.search/**The model for the result of a lineage search query*/record LineageSearchResult includes{namespace com.linkedin.metadata.query/**A common model for the result of any query. \nExpected to be included into other top level query results.*/record AnyResult{/**Freshness Stats to help a caller understand the freshness of the results\nUseful when the results are being retrieved from a cache, index or other eventually consistent storage*/freshness:optional/**Stats that describe the freshness of a dataset or query result.\nUseful to describe consistency and staleness of results when served\nout of a cache or other eventually consistent system.*/record FreshnessStats{cached:optional boolean,systemFreshness:optional map[string,long]}}}{/**A list of entities returned from the search results*/entities:array[/**The model for each entity returned by the lineage search query*/record LineageSearchEntity includes/**The model for each entity returned by the search query*/record SearchEntity{/**Urn of the entity being returned*/entity:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Matched field name and values*/matchedFields:array[record MatchedField{/**Matched field name*/name:string/**Matched field value*/value:string}]=[]features:optional map[string,double]score:optional double/**A list of the the restricted aspects on the entity.\nIf the key aspect is present, assume ALL aspects should be restricted including the entity's Urn.*/restrictedAspects:optional array[string]/**Extra fields from the search document based on what is requested in the search request*/extraFields:optional map[string,string]}{/**Optional list of entities between the source and destination node.\nThere can be multiple paths from the source to the destination.*/paths:array[array[com.linkedin.common.Urn]]=[]/**Optional list of entities between the source and destination node*/@deprecated,path:array[com.linkedin.common.Urn]=[]/**Degree of relationship (number of hops to get to entity)*/@deprecated,degree:int=1/**The degrees of separation (number of hops) between the source and this entity */degrees:array[int]=[]/**Marks an entity as having been explored for as a part of the graph walk*/explored:optional boolean/**Indicates this destination node has additional unexplored child relationships*/truncatedChildren:optional boolean/**Whether this relationship was ignored as a hop while performing the graph walk*/ignoredAsHop:optional boolean}]/**Metadata specific to the browse result of the queried path*/metadata:/**The model for the search result*/record SearchResultMetadata{/**A list of search result metadata such as aggregations*/aggregations:array[record AggregationMetadata{/**The name of the aggregation, e.g, platform, origin*/name:string/**Name of the filter to be displayed in the UI*/displayName:optional string/**Entity associated with this facet*/entity:optional com.linkedin.common.Urn/**List of aggregations showing the number of documents falling into each bucket. e.g, for platform aggregation, the bucket can be hive, kafka, etc*/aggregations:map[string,long]filterValues:array[record FilterValue{value:string,entity:optional com.linkedin.common.Urn,facetCount:long,filtered:optional boolean}]}]=[]/**A list of search query suggestions based on the given query*/suggestions:array[/**The model for the search result*/record SearchSuggestion{/**The suggestion text for this search query*/text:string/**The score for how close this suggestion is to the original search query.\nThe closer to 1 means it is closer to the original query and 0 is further away.*/score:float/**How many matches there are with the suggested text for the given field*/frequency:long}]=[]}/**Offset of the first entity in the result*/from:int/**Size of each page in the result*/pageSize:int/**The total number of entities directly under searched path*/numEntities:int/**The path taken when doing search across lineage*/lineageSearchPath:optional/**The path taken when doing search across lineage*/enum LineageSearchPath{/**Designates the tortoise lineage code path*/TORTOISE/**Designates the lightning lineage code path*/LIGHTNING}}", SchemaFormatType.PDL);
    private FreshnessStats _freshnessField = null;
    private LineageSearchEntityArray _entitiesField = null;
    private SearchResultMetadata _metadataField = null;
    private Integer _fromField = null;
    private Integer _pageSizeField = null;
    private Integer _numEntitiesField = null;
    private LineageSearchPath _lineageSearchPathField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Freshness = SCHEMA.getField("freshness");
    private static final RecordDataSchema.Field FIELD_Entities = SCHEMA.getField("entities");
    private static final RecordDataSchema.Field FIELD_Metadata = SCHEMA.getField("metadata");
    private static final RecordDataSchema.Field FIELD_From = SCHEMA.getField("from");
    private static final RecordDataSchema.Field FIELD_PageSize = SCHEMA.getField("pageSize");
    private static final RecordDataSchema.Field FIELD_NumEntities = SCHEMA.getField("numEntities");
    private static final RecordDataSchema.Field FIELD_LineageSearchPath = SCHEMA.getField("lineageSearchPath");

    public LineageSearchResult() {
        super(new DataMap(10, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public LineageSearchResult(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasFreshness() {
        if (this._freshnessField != null) {
            return true;
        }
        return this._map.containsKey("freshness");
    }

    public void removeFreshness() {
        this._map.remove("freshness");
    }

    @Nullable
    public FreshnessStats getFreshness(GetMode mode) {
        return this.getFreshness();
    }

    @Nullable
    public FreshnessStats getFreshness() {
        if (this._freshnessField != null) {
            return this._freshnessField;
        }
        Object __rawValue = this._map.get("freshness");
        this._freshnessField = __rawValue == null ? null : new FreshnessStats(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._freshnessField;
    }

    public LineageSearchResult setFreshness(@Nullable FreshnessStats value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFreshness(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFreshness();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "freshness", value.data());
                this._freshnessField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "freshness", value.data());
                this._freshnessField = value;
            }
        }
        return this;
    }

    public LineageSearchResult setFreshness(@Nonnull FreshnessStats value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field freshness of com.linkedin.metadata.search.LineageSearchResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "freshness", value.data());
        this._freshnessField = value;
        return this;
    }

    public boolean hasEntities() {
        if (this._entitiesField != null) {
            return true;
        }
        return this._map.containsKey("entities");
    }

    public void removeEntities() {
        this._map.remove("entities");
    }

    @Nullable
    public LineageSearchEntityArray getEntities(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntities();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entitiesField != null) {
                    return this._entitiesField;
                }
                Object __rawValue = this._map.get("entities");
                this._entitiesField = __rawValue == null ? null : new LineageSearchEntityArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._entitiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public LineageSearchEntityArray getEntities() {
        if (this._entitiesField != null) {
            return this._entitiesField;
        }
        Object __rawValue = this._map.get("entities");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entities");
        }
        this._entitiesField = __rawValue == null ? null : new LineageSearchEntityArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._entitiesField;
    }

    public LineageSearchResult setEntities(@Nullable LineageSearchEntityArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntities(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entities of com.linkedin.metadata.search.LineageSearchResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
                this._entitiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntities();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
                this._entitiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
                this._entitiesField = value;
            }
        }
        return this;
    }

    public LineageSearchResult setEntities(@Nonnull LineageSearchEntityArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entities of com.linkedin.metadata.search.LineageSearchResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
        this._entitiesField = value;
        return this;
    }

    public boolean hasMetadata() {
        if (this._metadataField != null) {
            return true;
        }
        return this._map.containsKey("metadata");
    }

    public void removeMetadata() {
        this._map.remove("metadata");
    }

    @Nullable
    public SearchResultMetadata getMetadata(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getMetadata();
            }
            case DEFAULT: 
            case NULL: {
                if (this._metadataField != null) {
                    return this._metadataField;
                }
                Object __rawValue = this._map.get("metadata");
                this._metadataField = __rawValue == null ? null : new SearchResultMetadata(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._metadataField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public SearchResultMetadata getMetadata() {
        if (this._metadataField != null) {
            return this._metadataField;
        }
        Object __rawValue = this._map.get("metadata");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("metadata");
        }
        this._metadataField = __rawValue == null ? null : new SearchResultMetadata(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._metadataField;
    }

    public LineageSearchResult setMetadata(@Nullable SearchResultMetadata value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMetadata(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field metadata of com.linkedin.metadata.search.LineageSearchResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "metadata", value.data());
                this._metadataField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMetadata();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "metadata", value.data());
                this._metadataField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "metadata", value.data());
                this._metadataField = value;
            }
        }
        return this;
    }

    public LineageSearchResult setMetadata(@Nonnull SearchResultMetadata value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field metadata of com.linkedin.metadata.search.LineageSearchResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "metadata", value.data());
        this._metadataField = value;
        return this;
    }

    public boolean hasFrom() {
        if (this._fromField != null) {
            return true;
        }
        return this._map.containsKey("from");
    }

    public void removeFrom() {
        this._map.remove("from");
    }

    @Nullable
    public Integer getFrom(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getFrom();
            }
            case DEFAULT: 
            case NULL: {
                if (this._fromField != null) {
                    return this._fromField;
                }
                Object __rawValue = this._map.get("from");
                this._fromField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._fromField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getFrom() {
        if (this._fromField != null) {
            return this._fromField;
        }
        Object __rawValue = this._map.get("from");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("from");
        }
        this._fromField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._fromField;
    }

    public LineageSearchResult setFrom(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFrom(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field from of com.linkedin.metadata.search.LineageSearchResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "from", DataTemplateUtil.coerceIntInput(value));
                this._fromField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFrom();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "from", DataTemplateUtil.coerceIntInput(value));
                this._fromField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "from", DataTemplateUtil.coerceIntInput(value));
                this._fromField = value;
            }
        }
        return this;
    }

    public LineageSearchResult setFrom(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field from of com.linkedin.metadata.search.LineageSearchResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "from", DataTemplateUtil.coerceIntInput(value));
        this._fromField = value;
        return this;
    }

    public LineageSearchResult setFrom(int value) {
        CheckedUtil.putWithoutChecking(this._map, "from", DataTemplateUtil.coerceIntInput(value));
        this._fromField = value;
        return this;
    }

    public boolean hasPageSize() {
        if (this._pageSizeField != null) {
            return true;
        }
        return this._map.containsKey("pageSize");
    }

    public void removePageSize() {
        this._map.remove("pageSize");
    }

    @Nullable
    public Integer getPageSize(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPageSize();
            }
            case DEFAULT: 
            case NULL: {
                if (this._pageSizeField != null) {
                    return this._pageSizeField;
                }
                Object __rawValue = this._map.get("pageSize");
                this._pageSizeField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._pageSizeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getPageSize() {
        if (this._pageSizeField != null) {
            return this._pageSizeField;
        }
        Object __rawValue = this._map.get("pageSize");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("pageSize");
        }
        this._pageSizeField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._pageSizeField;
    }

    public LineageSearchResult setPageSize(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPageSize(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field pageSize of com.linkedin.metadata.search.LineageSearchResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
                this._pageSizeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePageSize();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
                this._pageSizeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
                this._pageSizeField = value;
            }
        }
        return this;
    }

    public LineageSearchResult setPageSize(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field pageSize of com.linkedin.metadata.search.LineageSearchResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
        this._pageSizeField = value;
        return this;
    }

    public LineageSearchResult setPageSize(int value) {
        CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
        this._pageSizeField = value;
        return this;
    }

    public boolean hasNumEntities() {
        if (this._numEntitiesField != null) {
            return true;
        }
        return this._map.containsKey("numEntities");
    }

    public void removeNumEntities() {
        this._map.remove("numEntities");
    }

    @Nullable
    public Integer getNumEntities(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getNumEntities();
            }
            case DEFAULT: 
            case NULL: {
                if (this._numEntitiesField != null) {
                    return this._numEntitiesField;
                }
                Object __rawValue = this._map.get("numEntities");
                this._numEntitiesField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._numEntitiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getNumEntities() {
        if (this._numEntitiesField != null) {
            return this._numEntitiesField;
        }
        Object __rawValue = this._map.get("numEntities");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("numEntities");
        }
        this._numEntitiesField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._numEntitiesField;
    }

    public LineageSearchResult setNumEntities(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumEntities(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field numEntities of com.linkedin.metadata.search.LineageSearchResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceIntInput(value));
                this._numEntitiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumEntities();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceIntInput(value));
                this._numEntitiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceIntInput(value));
                this._numEntitiesField = value;
            }
        }
        return this;
    }

    public LineageSearchResult setNumEntities(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numEntities of com.linkedin.metadata.search.LineageSearchResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceIntInput(value));
        this._numEntitiesField = value;
        return this;
    }

    public LineageSearchResult setNumEntities(int value) {
        CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceIntInput(value));
        this._numEntitiesField = value;
        return this;
    }

    public boolean hasLineageSearchPath() {
        if (this._lineageSearchPathField != null) {
            return true;
        }
        return this._map.containsKey("lineageSearchPath");
    }

    public void removeLineageSearchPath() {
        this._map.remove("lineageSearchPath");
    }

    @Nullable
    public LineageSearchPath getLineageSearchPath(GetMode mode) {
        return this.getLineageSearchPath();
    }

    @Nullable
    public LineageSearchPath getLineageSearchPath() {
        if (this._lineageSearchPathField != null) {
            return this._lineageSearchPathField;
        }
        Object __rawValue = this._map.get("lineageSearchPath");
        this._lineageSearchPathField = DataTemplateUtil.coerceEnumOutput(__rawValue, LineageSearchPath.class, LineageSearchPath.$UNKNOWN);
        return this._lineageSearchPathField;
    }

    public LineageSearchResult setLineageSearchPath(@Nullable LineageSearchPath value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLineageSearchPath(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLineageSearchPath();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lineageSearchPath", value.name());
                this._lineageSearchPathField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lineageSearchPath", value.name());
                this._lineageSearchPathField = value;
            }
        }
        return this;
    }

    public LineageSearchResult setLineageSearchPath(@Nonnull LineageSearchPath value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lineageSearchPath of com.linkedin.metadata.search.LineageSearchResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lineageSearchPath", value.name());
        this._lineageSearchPathField = value;
        return this;
    }

    @Override
    public LineageSearchResult clone() throws CloneNotSupportedException {
        LineageSearchResult __clone = (LineageSearchResult)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public LineageSearchResult copy() throws CloneNotSupportedException {
        LineageSearchResult __copy = (LineageSearchResult)super.copy();
        __copy._numEntitiesField = null;
        __copy._metadataField = null;
        __copy._entitiesField = null;
        __copy._pageSizeField = null;
        __copy._fromField = null;
        __copy._freshnessField = null;
        __copy._lineageSearchPathField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final LineageSearchResult __objectRef;

        private ChangeListener(LineageSearchResult reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "numEntities": {
                    this.__objectRef._numEntitiesField = null;
                    break;
                }
                case "metadata": {
                    this.__objectRef._metadataField = null;
                    break;
                }
                case "entities": {
                    this.__objectRef._entitiesField = null;
                    break;
                }
                case "pageSize": {
                    this.__objectRef._pageSizeField = null;
                    break;
                }
                case "from": {
                    this.__objectRef._fromField = null;
                    break;
                }
                case "freshness": {
                    this.__objectRef._freshnessField = null;
                    break;
                }
                case "lineageSearchPath": {
                    this.__objectRef._lineageSearchPathField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public FreshnessStats.Fields freshness() {
            return new FreshnessStats.Fields(this.getPathComponents(), "freshness");
        }

        public LineageSearchEntityArray.Fields entities() {
            return new LineageSearchEntityArray.Fields(this.getPathComponents(), "entities");
        }

        public PathSpec entities(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "entities");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public SearchResultMetadata.Fields metadata() {
            return new SearchResultMetadata.Fields(this.getPathComponents(), "metadata");
        }

        public PathSpec from() {
            return new PathSpec(this.getPathComponents(), "from");
        }

        public PathSpec pageSize() {
            return new PathSpec(this.getPathComponents(), "pageSize");
        }

        public PathSpec numEntities() {
            return new PathSpec(this.getPathComponents(), "numEntities");
        }

        public PathSpec lineageSearchPath() {
            return new PathSpec(this.getPathComponents(), "lineageSearchPath");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private FreshnessStats.ProjectionMask _freshnessMask;
        private LineageSearchEntityArray.ProjectionMask _entitiesMask;
        private SearchResultMetadata.ProjectionMask _metadataMask;

        ProjectionMask() {
            super(10);
        }

        public ProjectionMask withFreshness(Function<FreshnessStats.ProjectionMask, FreshnessStats.ProjectionMask> nestedMask) {
            this._freshnessMask = nestedMask.apply(this._freshnessMask == null ? FreshnessStats.createMask() : this._freshnessMask);
            this.getDataMap().put("freshness", this._freshnessMask.getDataMap());
            return this;
        }

        public ProjectionMask withFreshness() {
            this._freshnessMask = null;
            this.getDataMap().put("freshness", 1);
            return this;
        }

        public ProjectionMask withEntities(Function<LineageSearchEntityArray.ProjectionMask, LineageSearchEntityArray.ProjectionMask> nestedMask) {
            this._entitiesMask = nestedMask.apply(this._entitiesMask == null ? LineageSearchEntityArray.createMask() : this._entitiesMask);
            this.getDataMap().put("entities", this._entitiesMask.getDataMap());
            return this;
        }

        public ProjectionMask withEntities() {
            this._entitiesMask = null;
            this.getDataMap().put("entities", 1);
            return this;
        }

        public ProjectionMask withEntities(Function<LineageSearchEntityArray.ProjectionMask, LineageSearchEntityArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._entitiesMask = nestedMask.apply(this._entitiesMask == null ? LineageSearchEntityArray.createMask() : this._entitiesMask);
            this.getDataMap().put("entities", this._entitiesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("entities").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("entities").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withEntities(Integer start, Integer count) {
            this._entitiesMask = null;
            this.getDataMap().put("entities", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("entities").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("entities").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withMetadata(Function<SearchResultMetadata.ProjectionMask, SearchResultMetadata.ProjectionMask> nestedMask) {
            this._metadataMask = nestedMask.apply(this._metadataMask == null ? SearchResultMetadata.createMask() : this._metadataMask);
            this.getDataMap().put("metadata", this._metadataMask.getDataMap());
            return this;
        }

        public ProjectionMask withMetadata() {
            this._metadataMask = null;
            this.getDataMap().put("metadata", 1);
            return this;
        }

        public ProjectionMask withFrom() {
            this.getDataMap().put("from", 1);
            return this;
        }

        public ProjectionMask withPageSize() {
            this.getDataMap().put("pageSize", 1);
            return this;
        }

        public ProjectionMask withNumEntities() {
            this.getDataMap().put("numEntities", 1);
            return this;
        }

        public ProjectionMask withLineageSearchPath() {
            this.getDataMap().put("lineageSearchPath", 1);
            return this;
        }
    }
}

