/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.query.filter;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.metadata.query.filter.Condition;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Criterion
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.query.filter/**A criterion for matching a field with given value*/record Criterion{/**The name of the field that the criterion refers to*/field:string/**The value of the intended field*/value:string/**Values. one of which the intended field should match\nNote, if values is set, the above \"value\" field will be ignored*/values:array[string]=[]/**The condition for the criterion, e.g. EQUAL, START_WITH*/condition:/**The matching condition in a filter criterion*/enum Condition{/**Represent the relation: String field contains value, e.g. name contains Profile*/CONTAIN/**Represent the relation: String field ends with value, e.g. name ends with Event*/END_WITH/**Represent the relation: field = value, e.g. platform = hdfs*/EQUAL/**Represent the relation: field = value and support case insensitive values, e.g. platform = hdfs*/IEQUAL/**Represent the relation: field is null, e.g. platform is null*/IS_NULL/**Represents the relation: field exists and is non-empty, e.g. owners is not null and != [] (empty)*/EXISTS/**Represent the relation greater than, e.g. ownerCount > 5*/GREATER_THAN/**Represent the relation greater than or equal to, e.g. ownerCount >= 5*/GREATER_THAN_OR_EQUAL_TO/**Represent the relation: String field is one of the array values to, e.g. name in [\"Profile\", \"Event\"]*/IN/**Represent the relation less than, e.g. ownerCount < 3*/LESS_THAN/**Represent the relation less than or equal to, e.g. ownerCount <= 3*/LESS_THAN_OR_EQUAL_TO/**Represent the relation: String field starts with value, e.g. name starts with PageView*/START_WITH/**Represent the relation: URN field any nested children in addition to the given URN*/DESCENDANTS_INCL/**Represent the relation: URN field matches any nested parent in addition to the given URN*/ANCESTORS_INCL/**Represent the relation: URN field matches any nested child or parent in addition to the given URN*/RELATED_INCL}=\"EQUAL\"/**Whether the condition should be negated*/negated:boolean=false}", SchemaFormatType.PDL);
    private String _fieldField = null;
    private String _valueField = null;
    private StringArray _valuesField = null;
    private Condition _conditionField = null;
    private Boolean _negatedField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Field = SCHEMA.getField("field");
    private static final RecordDataSchema.Field FIELD_Value = SCHEMA.getField("value");
    private static final RecordDataSchema.Field FIELD_Values = SCHEMA.getField("values");
    private static final StringArray DEFAULT_Values;
    private static final RecordDataSchema.Field FIELD_Condition;
    private static final Condition DEFAULT_Condition;
    private static final RecordDataSchema.Field FIELD_Negated;
    private static final Boolean DEFAULT_Negated;

    public Criterion() {
        super(new DataMap(7, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public Criterion(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasField() {
        if (this._fieldField != null) {
            return true;
        }
        return this._map.containsKey("field");
    }

    public void removeField() {
        this._map.remove("field");
    }

    @Nullable
    public String getField(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getField();
            }
            case DEFAULT: 
            case NULL: {
                if (this._fieldField != null) {
                    return this._fieldField;
                }
                Object __rawValue = this._map.get("field");
                this._fieldField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._fieldField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getField() {
        if (this._fieldField != null) {
            return this._fieldField;
        }
        Object __rawValue = this._map.get("field");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("field");
        }
        this._fieldField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._fieldField;
    }

    public Criterion setField(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setField(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field field of com.linkedin.metadata.query.filter.Criterion");
                }
                CheckedUtil.putWithoutChecking(this._map, "field", value);
                this._fieldField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeField();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "field", value);
                this._fieldField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "field", value);
                this._fieldField = value;
            }
        }
        return this;
    }

    public Criterion setField(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field field of com.linkedin.metadata.query.filter.Criterion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "field", value);
        this._fieldField = value;
        return this;
    }

    public boolean hasValue() {
        if (this._valueField != null) {
            return true;
        }
        return this._map.containsKey("value");
    }

    public void removeValue() {
        this._map.remove("value");
    }

    @Nullable
    public String getValue(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getValue();
            }
            case DEFAULT: 
            case NULL: {
                if (this._valueField != null) {
                    return this._valueField;
                }
                Object __rawValue = this._map.get("value");
                this._valueField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._valueField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getValue() {
        if (this._valueField != null) {
            return this._valueField;
        }
        Object __rawValue = this._map.get("value");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("value");
        }
        this._valueField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._valueField;
    }

    public Criterion setValue(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setValue(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field value of com.linkedin.metadata.query.filter.Criterion");
                }
                CheckedUtil.putWithoutChecking(this._map, "value", value);
                this._valueField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeValue();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "value", value);
                this._valueField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "value", value);
                this._valueField = value;
            }
        }
        return this;
    }

    public Criterion setValue(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field value of com.linkedin.metadata.query.filter.Criterion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "value", value);
        this._valueField = value;
        return this;
    }

    public boolean hasValues() {
        if (this._valuesField != null) {
            return true;
        }
        return this._map.containsKey("values");
    }

    public void removeValues() {
        this._map.remove("values");
    }

    @Nullable
    public StringArray getValues(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getValues();
            }
            case NULL: {
                if (this._valuesField != null) {
                    return this._valuesField;
                }
                Object __rawValue = this._map.get("values");
                this._valuesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._valuesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringArray getValues() {
        if (this._valuesField != null) {
            return this._valuesField;
        }
        Object __rawValue = this._map.get("values");
        if (__rawValue == null) {
            return DEFAULT_Values;
        }
        this._valuesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._valuesField;
    }

    public Criterion setValues(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setValues(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field values of com.linkedin.metadata.query.filter.Criterion");
                }
                CheckedUtil.putWithoutChecking(this._map, "values", value.data());
                this._valuesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeValues();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "values", value.data());
                this._valuesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "values", value.data());
                this._valuesField = value;
            }
        }
        return this;
    }

    public Criterion setValues(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field values of com.linkedin.metadata.query.filter.Criterion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "values", value.data());
        this._valuesField = value;
        return this;
    }

    public boolean hasCondition() {
        if (this._conditionField != null) {
            return true;
        }
        return this._map.containsKey("condition");
    }

    public void removeCondition() {
        this._map.remove("condition");
    }

    @Nullable
    public Condition getCondition(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCondition();
            }
            case NULL: {
                if (this._conditionField != null) {
                    return this._conditionField;
                }
                Object __rawValue = this._map.get("condition");
                this._conditionField = DataTemplateUtil.coerceEnumOutput(__rawValue, Condition.class, Condition.$UNKNOWN);
                return this._conditionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Condition getCondition() {
        if (this._conditionField != null) {
            return this._conditionField;
        }
        Object __rawValue = this._map.get("condition");
        if (__rawValue == null) {
            return DEFAULT_Condition;
        }
        this._conditionField = DataTemplateUtil.coerceEnumOutput(__rawValue, Condition.class, Condition.$UNKNOWN);
        return this._conditionField;
    }

    public Criterion setCondition(@Nullable Condition value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCondition(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field condition of com.linkedin.metadata.query.filter.Criterion");
                }
                CheckedUtil.putWithoutChecking(this._map, "condition", value.name());
                this._conditionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCondition();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "condition", value.name());
                this._conditionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "condition", value.name());
                this._conditionField = value;
            }
        }
        return this;
    }

    public Criterion setCondition(@Nonnull Condition value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field condition of com.linkedin.metadata.query.filter.Criterion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "condition", value.name());
        this._conditionField = value;
        return this;
    }

    public boolean hasNegated() {
        if (this._negatedField != null) {
            return true;
        }
        return this._map.containsKey("negated");
    }

    public void removeNegated() {
        this._map.remove("negated");
    }

    @Nullable
    public Boolean isNegated(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isNegated();
            }
            case NULL: {
                if (this._negatedField != null) {
                    return this._negatedField;
                }
                Object __rawValue = this._map.get("negated");
                this._negatedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._negatedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isNegated() {
        if (this._negatedField != null) {
            return this._negatedField;
        }
        Object __rawValue = this._map.get("negated");
        if (__rawValue == null) {
            return DEFAULT_Negated;
        }
        this._negatedField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._negatedField;
    }

    public Criterion setNegated(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNegated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field negated of com.linkedin.metadata.query.filter.Criterion");
                }
                CheckedUtil.putWithoutChecking(this._map, "negated", value);
                this._negatedField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNegated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "negated", value);
                this._negatedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "negated", value);
                this._negatedField = value;
            }
        }
        return this;
    }

    public Criterion setNegated(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field negated of com.linkedin.metadata.query.filter.Criterion to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "negated", value);
        this._negatedField = value;
        return this;
    }

    public Criterion setNegated(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "negated", value);
        this._negatedField = value;
        return this;
    }

    @Override
    public Criterion clone() throws CloneNotSupportedException {
        Criterion __clone = (Criterion)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public Criterion copy() throws CloneNotSupportedException {
        Criterion __copy = (Criterion)super.copy();
        __copy._conditionField = null;
        __copy._negatedField = null;
        __copy._fieldField = null;
        __copy._valuesField = null;
        __copy._valueField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Condition = SCHEMA.getField("condition");
        FIELD_Negated = SCHEMA.getField("negated");
        DEFAULT_Values = FIELD_Values.getDefault() == null ? null : new StringArray(DataTemplateUtil.castOrThrow(FIELD_Values.getDefault(), DataList.class));
        DEFAULT_Condition = DataTemplateUtil.coerceEnumOutput(FIELD_Condition.getDefault(), Condition.class, Condition.$UNKNOWN);
        DEFAULT_Negated = DataTemplateUtil.coerceBooleanOutput(FIELD_Negated.getDefault());
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final Criterion __objectRef;

        private ChangeListener(Criterion reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "condition": {
                    this.__objectRef._conditionField = null;
                    break;
                }
                case "negated": {
                    this.__objectRef._negatedField = null;
                    break;
                }
                case "field": {
                    this.__objectRef._fieldField = null;
                    break;
                }
                case "values": {
                    this.__objectRef._valuesField = null;
                    break;
                }
                case "value": {
                    this.__objectRef._valueField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec field() {
            return new PathSpec(this.getPathComponents(), "field");
        }

        public PathSpec value() {
            return new PathSpec(this.getPathComponents(), "value");
        }

        public PathSpec values() {
            return new PathSpec(this.getPathComponents(), "values");
        }

        public PathSpec values(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "values");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec condition() {
            return new PathSpec(this.getPathComponents(), "condition");
        }

        public PathSpec negated() {
            return new PathSpec(this.getPathComponents(), "negated");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withField() {
            this.getDataMap().put("field", 1);
            return this;
        }

        public ProjectionMask withValue() {
            this.getDataMap().put("value", 1);
            return this;
        }

        public ProjectionMask withValues() {
            this.getDataMap().put("values", 1);
            return this;
        }

        public ProjectionMask withValues(Integer start, Integer count) {
            this.getDataMap().put("values", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("values").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("values").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withCondition() {
            this.getDataMap().put("condition", 1);
            return this;
        }

        public ProjectionMask withNegated() {
            this.getDataMap().put("negated", 1);
            return this;
        }
    }
}

