/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.registry;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.metadata.aspect.patch.template.AspectTemplateEngine;
import com.linkedin.metadata.aspect.plugins.PluginFactory;
import com.linkedin.metadata.aspect.plugins.config.PluginConfiguration;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.DataSchemaFactory;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.models.EntitySpecBuilder;
import com.linkedin.metadata.models.EventSpec;
import com.linkedin.metadata.models.EventSpecBuilder;
import com.linkedin.metadata.models.registry.EntityRegistry;
import com.linkedin.metadata.models.registry.EntityRegistryException;
import com.linkedin.metadata.models.registry.EntityRegistryUtils;
import com.linkedin.metadata.models.registry.config.Entities;
import com.linkedin.metadata.models.registry.config.Entity;
import com.linkedin.metadata.models.registry.config.Event;
import com.linkedin.util.Pair;
import datahub.shaded.jackson.core.StreamReadConstraints;
import datahub.shaded.jackson.databind.ObjectMapper;
import datahub.shaded.jackson.dataformat.yaml.YAMLFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchEntityRegistry
implements EntityRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PatchEntityRegistry.class);
    private final DataSchemaFactory dataSchemaFactory;
    private final PluginFactory pluginFactory;
    @Nullable
    private BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> pluginFactoryProvider;
    private final Map<String, EntitySpec> entityNameToSpec;
    private final Map<String, EventSpec> eventNameToSpec;
    private final Map<String, AspectSpec> _aspectNameToSpec;
    private final String registryName;
    private final ComparableVersion registryVersion;
    private final String identifier;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper(new YAMLFactory());

    public String toString() {
        StringBuilder sb = new StringBuilder("PatchEntityRegistry[identifier=" + this.identifier + ";");
        this.entityNameToSpec.forEach((key1, value1) -> sb.append("[entityName=").append((String)key1).append(";aspects=[").append(value1.getAspectSpecs().stream().map(AspectSpec::getName).collect(Collectors.joining(","))).append("]]"));
        this.eventNameToSpec.forEach((key, value) -> sb.append("[eventName=").append((String)key).append("]"));
        return sb.toString();
    }

    public PatchEntityRegistry(Pair<Path, Path> configFileClassPathPair, String registryName, ComparableVersion registryVersion, @Nullable BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> pluginFactoryProvider) throws IOException, EntityRegistryException {
        this(DataSchemaFactory.withCustomClasspath(configFileClassPathPair.getSecond()), DataSchemaFactory.getClassLoader(configFileClassPathPair.getSecond()).map(Stream::of).orElse(Stream.empty()).collect(Collectors.toList()), configFileClassPathPair.getFirst(), registryName, registryVersion, pluginFactoryProvider);
    }

    public PatchEntityRegistry(String entityRegistryRoot, String registryName, ComparableVersion registryVersion, @Nullable BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> pluginFactoryProvider) throws EntityRegistryException, IOException {
        this(PatchEntityRegistry.getFileAndClassPath(entityRegistryRoot), registryName, registryVersion, pluginFactoryProvider);
    }

    private static Pair<Path, Path> getFileAndClassPath(String entityRegistryRoot) throws IOException, EntityRegistryException {
        Path entityRegistryRootLoc = Paths.get(entityRegistryRoot, new String[0]);
        if (Files.isDirectory(entityRegistryRootLoc, new LinkOption[0])) {
            List yamlFiles = Files.walk(entityRegistryRootLoc, 1, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> f.endsWith("entity-registry.yml") || f.endsWith("entity-registry.yaml")).collect(Collectors.toList());
            if (yamlFiles.isEmpty()) {
                throw new EntityRegistryException(String.format("Did not find an entity registry (entity-registry.yaml/yml) under %s", entityRegistryRootLoc));
            }
            if (yamlFiles.size() > 1) {
                log.warn("Found more than one yaml file in the directory {}. Will pick the first {}", (Object)entityRegistryRootLoc, yamlFiles.get(0));
            }
            Path entityRegistryFile = (Path)yamlFiles.get(0);
            log.info("Loading custom config entity file: {}, dir: {}", (Object)entityRegistryFile, (Object)entityRegistryRootLoc);
            return new Pair<Path, Path>(entityRegistryFile, entityRegistryRootLoc);
        }
        log.info("Loading bare entity registry file at {}", (Object)entityRegistryRootLoc);
        return new Pair<Path, Object>(entityRegistryRootLoc, null);
    }

    public PatchEntityRegistry(DataSchemaFactory dataSchemaFactory, List<ClassLoader> classLoaders, Path configFilePath, String registryName, ComparableVersion registryVersion, @Nullable BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> pluginFactoryProvider) throws FileNotFoundException, EntityRegistryException {
        this(dataSchemaFactory, classLoaders, new FileInputStream(configFilePath.toString()), registryName, registryVersion, pluginFactoryProvider);
    }

    private PatchEntityRegistry(DataSchemaFactory dataSchemaFactory, List<ClassLoader> classLoaders, InputStream configFileStream, String registryName, ComparableVersion registryVersion, @Nullable BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> pluginFactoryProvider) throws EntityRegistryException {
        Entities entities;
        this.dataSchemaFactory = dataSchemaFactory;
        this.registryName = registryName;
        this.registryVersion = registryVersion;
        this.entityNameToSpec = new HashMap<String, EntitySpec>();
        try {
            entities = OBJECT_MAPPER.readValue(configFileStream, Entities.class);
            this.pluginFactory = pluginFactoryProvider != null ? pluginFactoryProvider.apply(entities.getPlugins(), classLoaders) : PluginFactory.withCustomClasspath(entities.getPlugins(), classLoaders);
            this.pluginFactoryProvider = pluginFactoryProvider;
        }
        catch (IOException e) {
            log.error("Unable to read Patch configuration.", e);
            throw new IllegalArgumentException(String.format("Error while reading config file in path %s: %s", configFileStream, e.getMessage()));
        }
        this.identifier = entities.getId() != null ? entities.getId() : "Unknown";
        EntitySpecBuilder entitySpecBuilder = new EntitySpecBuilder();
        for (Entity entity : entities.getEntities()) {
            log.info("Discovered entity {} with aspects {}", (Object)entity.getName(), (Object)entity.getAspects().stream().collect(Collectors.joining()));
            ArrayList<AspectSpec> aspectSpecs = new ArrayList<AspectSpec>();
            if (entity.getKeyAspect() != null) {
                AspectSpec keyAspectSpec = this.buildAspectSpec(entity.getKeyAspect(), entitySpecBuilder);
                log.info("Adding key aspect {} with spec {}", (Object)entity.getKeyAspect(), (Object)keyAspectSpec);
                aspectSpecs.add(keyAspectSpec);
            }
            entity.getAspects().forEach(aspect -> {
                if (!aspect.equals(entity.getKeyAspect())) {
                    AspectSpec aspectSpec = this.buildAspectSpec((String)aspect, entitySpecBuilder);
                    log.info("Adding aspect {} with spec {}", aspect, (Object)aspectSpec);
                    aspectSpecs.add(aspectSpec);
                }
            });
            EntitySpec entitySpec = entitySpecBuilder.buildPartialEntitySpec(entity.getName(), entity.getKeyAspect(), aspectSpecs);
            this.entityNameToSpec.put(entity.getName().toLowerCase(), entitySpec);
        }
        this.eventNameToSpec = new HashMap<String, EventSpec>();
        if (entities.getEvents() != null) {
            for (Event event : entities.getEvents()) {
                EventSpec eventSpec = this.buildEventSpec(event.getName());
                this.eventNameToSpec.put(event.getName().toLowerCase(), eventSpec);
            }
        }
        this._aspectNameToSpec = EntityRegistryUtils.populateAspectMap(new ArrayList<EntitySpec>(this.entityNameToSpec.values()));
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @Nonnull
    public EntitySpec getEntitySpec(@Nonnull String entityName) {
        String lowercaseEntityName = entityName.toLowerCase();
        if (!this.entityNameToSpec.containsKey(lowercaseEntityName)) {
            throw new IllegalArgumentException(String.format("Failed to find entity with name %s in EntityRegistry", entityName));
        }
        return this.entityNameToSpec.get(lowercaseEntityName);
    }

    @Override
    @Nonnull
    public EventSpec getEventSpec(@Nonnull String eventName) {
        String lowercaseEventName = eventName.toLowerCase();
        if (!this.eventNameToSpec.containsKey(lowercaseEventName)) {
            throw new IllegalArgumentException(String.format("Failed to find event with name %s in EntityRegistry", eventName));
        }
        return this.eventNameToSpec.get(lowercaseEventName);
    }

    @Override
    @Nonnull
    public Map<String, EntitySpec> getEntitySpecs() {
        return this.entityNameToSpec;
    }

    @Override
    @Nonnull
    public Map<String, AspectSpec> getAspectSpecs() {
        return this._aspectNameToSpec;
    }

    @Override
    @Nonnull
    public Map<String, EventSpec> getEventSpecs() {
        return this.eventNameToSpec;
    }

    @Override
    @Nonnull
    public AspectTemplateEngine getAspectTemplateEngine() {
        return new AspectTemplateEngine();
    }

    private AspectSpec buildAspectSpec(String aspectName, EntitySpecBuilder entitySpecBuilder) {
        Optional<DataSchema> aspectSchema = this.dataSchemaFactory.getAspectSchema(aspectName);
        Optional<Class> aspectClass = this.dataSchemaFactory.getAspectClass(aspectName);
        if (!aspectSchema.isPresent()) {
            throw new IllegalArgumentException(String.format("Aspect %s does not exist", aspectName));
        }
        AspectSpec aspectSpec = entitySpecBuilder.buildAspectSpec(aspectSchema.get(), aspectClass.get());
        aspectSpec.setRegistryName(this.registryName);
        aspectSpec.setRegistryVersion(this.registryVersion);
        return aspectSpec;
    }

    private EventSpec buildEventSpec(String eventName) {
        Optional<DataSchema> eventSchema = this.dataSchemaFactory.getEventSchema(eventName);
        if (!eventSchema.isPresent()) {
            throw new IllegalArgumentException(String.format("Event %s does not exist", eventName));
        }
        return new EventSpecBuilder().buildEventSpec(eventName, eventSchema.get());
    }

    @Override
    @Generated
    public PluginFactory getPluginFactory() {
        return this.pluginFactory;
    }

    @Override
    @Nullable
    @Generated
    public BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> getPluginFactoryProvider() {
        return this.pluginFactoryProvider;
    }

    static {
        int maxSize = Integer.parseInt(System.getenv().getOrDefault("INGESTION_MAX_SERIALIZED_STRING_LENGTH", "16000000"));
        OBJECT_MAPPER.getFactory().setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(maxSize).build());
    }
}

