/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models;

import com.google.common.collect.ImmutableSet;
import com.linkedin.common.Status;
import com.linkedin.common.urn.Urn;
import com.linkedin.common.urn.UrnUtils;
import com.linkedin.data.template.GetMode;
import com.linkedin.entity.Aspect;
import com.linkedin.metadata.aspect.AspectRetriever;
import com.linkedin.metadata.models.LogicalValueType;
import com.linkedin.metadata.query.filter.ConjunctiveCriterion;
import com.linkedin.metadata.query.filter.Criterion;
import com.linkedin.metadata.query.filter.Filter;
import com.linkedin.structured.PrimitivePropertyValue;
import com.linkedin.structured.StructuredProperties;
import com.linkedin.structured.StructuredPropertyDefinition;
import com.linkedin.structured.StructuredPropertySettings;
import com.linkedin.structured.StructuredPropertyValueAssignment;
import com.linkedin.structured.StructuredPropertyValueAssignmentArray;
import com.linkedin.util.Pair;
import java.sql.Date;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructuredPropertyUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StructuredPropertyUtils.class);
    static final Date MIN_DATE = Date.valueOf("1000-01-01");
    static final Date MAX_DATE = Date.valueOf("9999-12-31");
    public static final String INVALID_SETTINGS_MESSAGE = "Cannot have property isHidden = true while other display location settings are also true.";
    public static final String ONLY_ONE_BADGE = "Cannot have more than one property set with show as badge. Property urns currently set: ";

    private StructuredPropertyUtils() {
    }

    public static LogicalValueType getLogicalValueType(StructuredPropertyDefinition structuredPropertyDefinition) {
        return StructuredPropertyUtils.getLogicalValueType(structuredPropertyDefinition.getValueType());
    }

    public static LogicalValueType getLogicalValueType(@Nullable Urn valueType) {
        String valueTypeId = StructuredPropertyUtils.getValueTypeId(valueType);
        if ("string".equals(valueTypeId)) {
            return LogicalValueType.STRING;
        }
        if ("date".equals(valueTypeId)) {
            return LogicalValueType.DATE;
        }
        if ("number".equals(valueTypeId)) {
            return LogicalValueType.NUMBER;
        }
        if ("urn".equals(valueTypeId)) {
            return LogicalValueType.URN;
        }
        if ("rich_text".equals(valueTypeId)) {
            return LogicalValueType.RICH_TEXT;
        }
        return LogicalValueType.UNKNOWN;
    }

    @Nullable
    public static String getValueTypeId(@Nullable Urn valueType) {
        if (valueType != null) {
            String valueTypeId = valueType.getId();
            if (valueTypeId.startsWith("datahub.")) {
                valueTypeId = valueTypeId.split("\\.")[1];
            }
            return valueTypeId.toLowerCase();
        }
        return null;
    }

    public static Optional<String> toStructuredPropertyFacetName(@Nonnull String fieldOrFacetName, @Nullable AspectRetriever aspectRetriever) {
        return StructuredPropertyUtils.lookupDefinitionFromFilterOrFacetName(fieldOrFacetName, aspectRetriever).map(urnDefinition -> {
            switch (StructuredPropertyUtils.getLogicalValueType((StructuredPropertyDefinition)urnDefinition.getSecond())) {
                case NUMBER: 
                case DATE: {
                    return "structuredProperties." + StructuredPropertyUtils.toElasticsearchFieldName((Urn)urnDefinition.getFirst(), (StructuredPropertyDefinition)urnDefinition.getSecond());
                }
            }
            return "structuredProperties." + StructuredPropertyUtils.toElasticsearchFieldName((Urn)urnDefinition.getFirst(), (StructuredPropertyDefinition)urnDefinition.getSecond()) + ".keyword";
        });
    }

    public static Optional<Pair<Urn, StructuredPropertyDefinition>> lookupDefinitionFromFilterOrFacetName(@Nonnull String fieldOrFacetName, @Nullable AspectRetriever aspectRetriever) {
        if (fieldOrFacetName.startsWith("structuredProperties.")) {
            String fqn = StructuredPropertyUtils.fieldOrFacetToFQN(fieldOrFacetName);
            Urn urn = StructuredPropertyUtils.toURNFromFQN(fqn);
            Map<Urn, Map<String, Aspect>> result = Objects.requireNonNull(aspectRetriever).getLatestAspectObjects(Collections.singleton(urn), Collections.singleton("propertyDefinition"));
            Optional<Aspect> definition = Optional.ofNullable(result.getOrDefault(urn, Collections.emptyMap()).getOrDefault("propertyDefinition", null));
            return definition.map(definitonAspect -> Pair.of(urn, new StructuredPropertyDefinition(definitonAspect.data())));
        }
        return Optional.empty();
    }

    public static String toElasticsearchFieldName(@Nonnull Urn propertyUrn, @Nullable StructuredPropertyDefinition definition) {
        String qualifiedName;
        String string = qualifiedName = definition != null ? definition.getQualifiedName() : propertyUrn.getId();
        if (qualifiedName.contains(" ")) {
            throw new IllegalArgumentException("Fully qualified structured property name cannot contain spaces");
        }
        if (definition != null && definition.getVersion(GetMode.NULL) != null) {
            return String.join((CharSequence)".", "_versioned", definition.getQualifiedName().replace('.', '_'), definition.getVersion(), StructuredPropertyUtils.getLogicalValueType(definition).name().toLowerCase());
        }
        return qualifiedName.replace('.', '_');
    }

    public static Set<String> toElasticsearchFieldType(@Nonnull String fieldName, @Nullable AspectRetriever aspectRetriever) {
        LogicalValueType logicalValueType = StructuredPropertyUtils.lookupDefinitionFromFilterOrFacetName(fieldName, aspectRetriever).map(definition -> StructuredPropertyUtils.getLogicalValueType((StructuredPropertyDefinition)definition.getValue())).orElse(LogicalValueType.STRING);
        switch (logicalValueType) {
            case NUMBER: {
                return Collections.singleton("double");
            }
            case DATE: {
                return Collections.singleton("long");
            }
            case RICH_TEXT: {
                return Collections.singleton("text");
            }
        }
        return Collections.singleton("keyword");
    }

    public static void validateStructuredPropertyFQN(@Nonnull Collection<String> fullyQualifiedNames, @Nonnull AspectRetriever aspectRetriever) {
        Set<Urn> structuredPropertyUrns = fullyQualifiedNames.stream().map(StructuredPropertyUtils::toURNFromFQN).collect(Collectors.toSet());
        Set<Urn> removedUrns = StructuredPropertyUtils.getRemovedUrns(structuredPropertyUrns, aspectRetriever);
        if (!removedUrns.isEmpty()) {
            throw new IllegalArgumentException(String.format("Cannot filter on deleted Structured Property %s", removedUrns));
        }
    }

    public static Urn toURNFromFQN(@Nonnull String fqn) {
        return UrnUtils.getUrn(String.join((CharSequence)":", "urn:li", "structuredProperty", fqn));
    }

    public static void validateFilter(@Nullable Filter filter, @Nullable AspectRetriever aspectRetriever) {
        if (filter == null) {
            return;
        }
        HashSet<String> fqns = new HashSet<String>();
        if (filter.getCriteria() != null) {
            for (Criterion c : filter.getCriteria()) {
                if (!c.getField().startsWith("structuredProperties.")) continue;
                String fqn = StructuredPropertyUtils.fieldOrFacetToFQN(c.getField());
                fqns.add(fqn);
            }
        }
        if (filter.getOr() != null) {
            for (ConjunctiveCriterion cc : filter.getOr()) {
                for (Criterion c : cc.getAnd()) {
                    if (!c.getField().startsWith("structuredProperties.")) continue;
                    String fqn = StructuredPropertyUtils.fieldOrFacetToFQN(c.getField());
                    fqns.add(fqn);
                }
            }
        }
        if (!fqns.isEmpty()) {
            StructuredPropertyUtils.validateStructuredPropertyFQN(fqns, Objects.requireNonNull(aspectRetriever));
        }
    }

    private static String fieldOrFacetToFQN(String fieldOrFacet) {
        return fieldOrFacet.substring("structuredProperties".length() + 1).replace(".keyword", "").replace(".delimited", "");
    }

    public static Date toDate(PrimitivePropertyValue value) throws DateTimeParseException {
        return Date.valueOf(value.getString());
    }

    public static boolean isValidDate(PrimitivePropertyValue value) {
        Date date;
        if (value.getString() == null) {
            return false;
        }
        if (value.getString().length() != 10) {
            return false;
        }
        try {
            date = StructuredPropertyUtils.toDate(value);
        }
        catch (DateTimeParseException e) {
            return false;
        }
        return date.compareTo(MIN_DATE) >= 0 && date.compareTo(MAX_DATE) <= 0;
    }

    private static Set<Urn> getRemovedUrns(Set<Urn> urns, @Nonnull AspectRetriever aspectRetriever) {
        return aspectRetriever.getLatestAspectObjects(urns, ImmutableSet.of("status")).entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsKey("status") && new Status(((Aspect)((Map)entry.getValue()).get("status")).data()).isRemoved() != false).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public static Map<Urn, Boolean> filterSoftDelete(Map<Urn, StructuredProperties> properties, AspectRetriever aspectRetriever) {
        Set<Urn> structuredPropertiesUrns = properties.values().stream().flatMap(structuredProperties -> structuredProperties.getProperties().stream()).map(StructuredPropertyValueAssignment::getPropertyUrn).collect(Collectors.toSet());
        Set<Urn> removedUrns = StructuredPropertyUtils.getRemovedUrns(structuredPropertiesUrns, aspectRetriever);
        return properties.entrySet().stream().map(entry -> Pair.of((Urn)entry.getKey(), StructuredPropertyUtils.filterSoftDelete((StructuredProperties)entry.getValue(), removedUrns).getSecond())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    private static Pair<StructuredProperties, Boolean> filterSoftDelete(StructuredProperties structuredProperties, Set<Urn> softDeletedPropertyUrns) {
        Pair<StructuredPropertyValueAssignmentArray, Boolean> filtered = StructuredPropertyUtils.filterValueAssignment(structuredProperties.getProperties(), softDeletedPropertyUrns);
        if (filtered.getSecond().booleanValue()) {
            return Pair.of(structuredProperties.setProperties(filtered.getFirst()), true);
        }
        return Pair.of(structuredProperties, false);
    }

    private static Pair<StructuredPropertyValueAssignmentArray, Boolean> filterValueAssignment(StructuredPropertyValueAssignmentArray in, Set<Urn> softDeletedPropertyUrns) {
        if (in.stream().noneMatch(p -> softDeletedPropertyUrns.contains(p.getPropertyUrn()))) {
            return Pair.of(in, false);
        }
        return Pair.of(new StructuredPropertyValueAssignmentArray(in.stream().filter(assignment -> !softDeletedPropertyUrns.contains(assignment.getPropertyUrn())).collect(Collectors.toSet())), true);
    }

    public static String getPropertyId(@Nullable String inputId, @Nullable String inputQualifiedName) {
        if (inputId != null && inputQualifiedName != null && !inputId.equals(inputQualifiedName)) {
            throw new IllegalArgumentException("Qualified name and the ID of a structured property must match");
        }
        String id = UUID.randomUUID().toString();
        if (inputQualifiedName != null) {
            id = inputQualifiedName;
        } else if (inputId != null) {
            id = inputId;
        }
        return id;
    }

    public static boolean validatePropertySettings(StructuredPropertySettings settings, boolean shouldThrow) {
        if (settings.isIsHidden().booleanValue() && (settings.isShowInSearchFilters().booleanValue() || settings.isShowInAssetSummary().booleanValue() || settings.isShowAsAssetBadge().booleanValue() || settings.isShowInColumnsTable().booleanValue())) {
            if (shouldThrow) {
                throw new IllegalArgumentException(INVALID_SETTINGS_MESSAGE);
            }
            return false;
        }
        return true;
    }
}

