/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.RecordTemplate;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSchemaFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSchemaFactory.class);
    private final Map<String, DataSchema> entitySchemas = new HashMap<String, DataSchema>();
    private final Map<String, DataSchema> aspectSchemas = new HashMap<String, DataSchema>();
    private final Map<String, DataSchema> eventSchemas = new HashMap<String, DataSchema>();
    private final Map<String, Class> aspectClasses = new HashMap<String, Class>();
    private static final String NAME_FIELD = "name";
    private static final DataSchemaFactory INSTANCE = new DataSchemaFactory();
    private static final String[] DEFAULT_TOP_LEVEL_NAMESPACES = new String[]{"com", "org", "io", "datahub"};

    public DataSchemaFactory() {
        this(new String[]{"com.linkedin", "com.datahub"});
    }

    public DataSchemaFactory(String classPath) {
        this(new String[]{classPath});
    }

    public DataSchemaFactory(String[] classPaths) {
        this(classPaths, null);
    }

    public static DataSchemaFactory withCustomClasspath(Path pluginLocation) throws IOException {
        if (pluginLocation == null) {
            return INSTANCE;
        }
        return new DataSchemaFactory(DEFAULT_TOP_LEVEL_NAMESPACES, DataSchemaFactory.getClassLoader(pluginLocation).get());
    }

    public static Optional<ClassLoader> getClassLoader(@Nullable Path pluginLocation) throws IOException {
        if (pluginLocation == null) {
            return Optional.empty();
        }
        File pluginDir = pluginLocation.toFile();
        if (!pluginDir.exists()) {
            throw new RuntimeException("Failed to find plugin directory " + pluginDir.getAbsolutePath() + ". Current directory is " + new File(".").getAbsolutePath());
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        if (pluginDir.isDirectory()) {
            List jarFiles = Files.walk(pluginLocation, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".jar")).collect(Collectors.toList());
            for (Path f : jarFiles) {
                URL url = f.toUri().toURL();
                if (url == null) continue;
                urls.add(url);
            }
        } else {
            URL url = pluginLocation.toUri().toURL();
            urls.add(url);
        }
        URL[] urlsArray = new URL[urls.size()];
        urls.toArray(urlsArray);
        URLClassLoader classLoader = new URLClassLoader(urlsArray, Thread.currentThread().getContextClassLoader());
        return Optional.of(classLoader);
    }

    public DataSchemaFactory(String[] classNamespaces, ClassLoader customClassLoader) {
        ClassLoader standardClassLoader = null;
        if (customClassLoader == null) {
            customClassLoader = Thread.currentThread().getContextClassLoader();
        } else {
            standardClassLoader = Thread.currentThread().getContextClassLoader();
        }
        HashSet<Class<RecordTemplate>> classes = new HashSet<Class<RecordTemplate>>();
        if (customClassLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)customClassLoader;
            URL[] uRLArray = urlClassLoader.getURLs();
            log.debug("Using URLClassLoader with {} URLs", (Object)uRLArray.length);
            ConfigurationBuilder configBuilder = new ConfigurationBuilder().setUrls(Arrays.asList(uRLArray)).addClassLoader(urlClassLoader).setScanners(new SubTypesScanner());
            for (String pkg : classNamespaces) {
                configBuilder.forPackages(pkg);
            }
            Reflections reflections = new Reflections(configBuilder);
            classes.addAll(reflections.getSubTypesOf(RecordTemplate.class));
        } else {
            for (String namespace : classNamespaces) {
                log.debug("Reflections scanning {} namespace", (Object)namespace);
                Collection<URL> packageUrls = ClasspathHelper.forPackage(namespace, customClassLoader);
                ConfigurationBuilder configBuilder = new ConfigurationBuilder().setUrls(packageUrls).addClassLoader(customClassLoader).setScanners(new SubTypesScanner());
                Reflections reflections = new Reflections(configBuilder);
                classes.addAll(reflections.getSubTypesOf(RecordTemplate.class));
            }
        }
        log.debug("Found a total of {} RecordTemplate classes", (Object)classes.size());
        if (standardClassLoader != null) {
            HashSet<Class<RecordTemplate>> stdClasses = new HashSet<Class<RecordTemplate>>();
            try {
                for (String namespace : classNamespaces) {
                    Collection<URL> packageUrls = ClasspathHelper.forPackage(namespace, standardClassLoader);
                    if (packageUrls.isEmpty()) continue;
                    ConfigurationBuilder configBuilder = new ConfigurationBuilder().setUrls(packageUrls).addClassLoader(standardClassLoader).setScanners(new SubTypesScanner());
                    Reflections reflections = new Reflections(configBuilder);
                    stdClasses.addAll(reflections.getSubTypesOf(RecordTemplate.class));
                }
                log.debug("Standard ClassLoader found a total of {} RecordTemplate classes", (Object)stdClasses.size());
                classes.removeAll(stdClasses);
                log.debug("Finally found a total of {} RecordTemplate classes to inspect", (Object)classes.size());
            }
            catch (Exception exception) {
                log.warn("Failed to scan with standard classloader, continuing with custom classloader results only", exception);
            }
        }
        for (Class clazz : classes) {
            DataSchema schema = null;
            try {
                schema = DataTemplateUtil.getSchema(clazz);
            }
            catch (Exception namespace) {
                // empty catch block
            }
            if (schema == null) continue;
            DataSchema finalSchema = schema;
            this.getName(schema, "Entity").ifPresent(entityName -> this.entitySchemas.put((String)entityName, finalSchema));
            this.getName(schema, "Aspect").ifPresent(aspectName -> {
                this.aspectSchemas.put((String)aspectName, finalSchema);
                this.aspectClasses.put((String)aspectName, recordClass);
            });
            this.getName(schema, "Event").ifPresent(eventName -> this.eventSchemas.put((String)eventName, finalSchema));
        }
    }

    private Optional<String> getName(DataSchema dataSchema, String annotationName) {
        return Optional.ofNullable(dataSchema.getProperties().get(annotationName)).filter(obj -> Map.class.isAssignableFrom(obj.getClass())).flatMap(obj -> Optional.ofNullable(((Map)obj).get(NAME_FIELD)).map(Object::toString));
    }

    public Optional<DataSchema> getEntitySchema(String entityName) {
        return Optional.ofNullable(this.entitySchemas.get(entityName));
    }

    public Optional<DataSchema> getAspectSchema(String aspectName) {
        return Optional.ofNullable(this.aspectSchemas.get(aspectName));
    }

    public Optional<DataSchema> getEventSchema(String eventName) {
        return Optional.ofNullable(this.eventSchemas.get(eventName));
    }

    public Optional<Class> getAspectClass(String aspectName) {
        return Optional.ofNullable(this.aspectClasses.get(aspectName));
    }

    public static DataSchemaFactory getInstance() {
        return INSTANCE;
    }
}

