/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.entity.ebean.batch;

import com.datahub.util.exception.ModelConversionException;
import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.StringMap;
import com.linkedin.events.metadata.ChangeType;
import com.linkedin.metadata.aspect.AspectRetriever;
import com.linkedin.metadata.aspect.SystemAspect;
import com.linkedin.metadata.aspect.batch.BatchItem;
import com.linkedin.metadata.aspect.batch.ChangeMCP;
import com.linkedin.metadata.aspect.batch.MCPItem;
import com.linkedin.metadata.aspect.patch.template.common.GenericPatchTemplate;
import com.linkedin.metadata.entity.validation.ValidationApiUtils;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.utils.EntityKeyUtils;
import com.linkedin.metadata.utils.GenericRecordUtils;
import com.linkedin.metadata.utils.SystemMetadataUtils;
import com.linkedin.mxe.MetadataChangeProposal;
import com.linkedin.mxe.SystemMetadata;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeItemImpl
implements ChangeMCP {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChangeItemImpl.class);
    @Nonnull
    private final ChangeType changeType;
    @Nonnull
    private final Urn urn;
    @Nonnull
    private final String aspectName;
    @Nonnull
    private final RecordTemplate recordTemplate;
    @Nonnull
    private SystemMetadata systemMetadata;
    @Nonnull
    private final AuditStamp auditStamp;
    @Nullable
    private final MetadataChangeProposal metadataChangeProposal;
    @Nonnull
    private final EntitySpec entitySpec;
    @Nonnull
    private final AspectSpec aspectSpec;
    @Nullable
    private SystemAspect previousSystemAspect;
    private long nextAspectVersion;
    private final Map<String, String> headers;

    public static ChangeItemImpl fromPatch(@Nonnull Urn urn, @Nonnull AspectSpec aspectSpec, @Nullable RecordTemplate recordTemplate, GenericPatchTemplate<? extends RecordTemplate> genericPatchTemplate, @Nonnull AuditStamp auditStamp, AspectRetriever aspectRetriever) {
        ChangeItemImplBuilder builder = ChangeItemImpl.builder().urn(urn).auditStamp(auditStamp).aspectName(aspectSpec.getName());
        RecordTemplate currentValue = recordTemplate != null ? recordTemplate : genericPatchTemplate.getDefault();
        try {
            builder.recordTemplate(genericPatchTemplate.applyPatch(currentValue));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder.build(aspectRetriever);
    }

    @Override
    @Nonnull
    public MetadataChangeProposal getMetadataChangeProposal() {
        if (this.metadataChangeProposal != null) {
            return this.metadataChangeProposal;
        }
        MetadataChangeProposal mcp = new MetadataChangeProposal();
        mcp.setEntityUrn(this.getUrn());
        mcp.setChangeType(this.getChangeType());
        mcp.setEntityType(this.getEntitySpec().getName());
        mcp.setAspectName(this.getAspectName());
        mcp.setAspect(GenericRecordUtils.serializeAspect(this.getRecordTemplate()));
        mcp.setSystemMetadata(this.getSystemMetadata());
        mcp.setEntityKeyAspect(GenericRecordUtils.serializeAspect(EntityKeyUtils.convertUrnToEntityKey(this.getUrn(), this.entitySpec.getKeyAspectSpec())));
        if (!this.headers.isEmpty()) {
            mcp.setHeaders(new StringMap(this.headers));
        }
        return mcp;
    }

    @Override
    public void setSystemMetadata(@Nonnull SystemMetadata systemMetadata) {
        this.systemMetadata = systemMetadata;
        if (this.metadataChangeProposal != null) {
            this.metadataChangeProposal.setSystemMetadata(systemMetadata);
        }
    }

    @Override
    public Map<String, String> getHeaders() {
        return Optional.ofNullable(this.metadataChangeProposal).filter(MetadataChangeProposal::hasHeaders).map(mcp -> mcp.getHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).orElse(this.headers);
    }

    @Override
    public boolean isDatabaseDuplicateOf(BatchItem other) {
        return this.equals(other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeItemImpl that = (ChangeItemImpl)o;
        return this.urn.equals(that.urn) && this.aspectName.equals(that.aspectName) && this.changeType.equals((Object)that.changeType) && Objects.equals(this.systemMetadata, that.systemMetadata) && Objects.equals(this.auditStamp, that.auditStamp) && DataTemplateUtil.areEqual(this.recordTemplate, that.recordTemplate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.urn, this.aspectName, this.changeType, this.systemMetadata, this.auditStamp, this.recordTemplate});
    }

    public String toString() {
        return "ChangeItemImpl{changeType=" + String.valueOf((Object)this.changeType) + ", auditStamp=" + String.valueOf(this.auditStamp) + ", systemMetadata=" + String.valueOf(this.systemMetadata) + ", recordTemplate=" + String.valueOf(this.recordTemplate) + ", aspectName='" + this.aspectName + "', urn=" + String.valueOf(this.urn) + "}";
    }

    @Generated
    ChangeItemImpl(@Nonnull ChangeType changeType, @Nonnull Urn urn, @Nonnull String aspectName, @Nonnull RecordTemplate recordTemplate, @Nonnull SystemMetadata systemMetadata, @Nonnull AuditStamp auditStamp, @Nullable MetadataChangeProposal metadataChangeProposal, @Nonnull EntitySpec entitySpec, @Nonnull AspectSpec aspectSpec, @Nullable SystemAspect previousSystemAspect, long nextAspectVersion, Map<String, String> headers) {
        if (changeType == null) {
            throw new NullPointerException("changeType is marked non-null but is null");
        }
        if (urn == null) {
            throw new NullPointerException("urn is marked non-null but is null");
        }
        if (aspectName == null) {
            throw new NullPointerException("aspectName is marked non-null but is null");
        }
        if (recordTemplate == null) {
            throw new NullPointerException("recordTemplate is marked non-null but is null");
        }
        if (systemMetadata == null) {
            throw new NullPointerException("systemMetadata is marked non-null but is null");
        }
        if (auditStamp == null) {
            throw new NullPointerException("auditStamp is marked non-null but is null");
        }
        if (entitySpec == null) {
            throw new NullPointerException("entitySpec is marked non-null but is null");
        }
        if (aspectSpec == null) {
            throw new NullPointerException("aspectSpec is marked non-null but is null");
        }
        this.changeType = changeType;
        this.urn = urn;
        this.aspectName = aspectName;
        this.recordTemplate = recordTemplate;
        this.systemMetadata = systemMetadata;
        this.auditStamp = auditStamp;
        this.metadataChangeProposal = metadataChangeProposal;
        this.entitySpec = entitySpec;
        this.aspectSpec = aspectSpec;
        this.previousSystemAspect = previousSystemAspect;
        this.nextAspectVersion = nextAspectVersion;
        this.headers = headers;
    }

    @Generated
    public static ChangeItemImplBuilder builder() {
        return new ChangeItemImplBuilder();
    }

    @Generated
    public ChangeItemImplBuilder toBuilder() {
        return new ChangeItemImplBuilder().changeType(this.changeType).urn(this.urn).aspectName(this.aspectName).recordTemplate(this.recordTemplate).systemMetadata(this.systemMetadata).auditStamp(this.auditStamp).metadataChangeProposal(this.metadataChangeProposal).entitySpec(this.entitySpec).aspectSpec(this.aspectSpec).previousSystemAspect(this.previousSystemAspect).nextAspectVersion(this.nextAspectVersion).headers(this.headers);
    }

    @Override
    @Nonnull
    @Generated
    public ChangeType getChangeType() {
        return this.changeType;
    }

    @Override
    @Nonnull
    @Generated
    public Urn getUrn() {
        return this.urn;
    }

    @Override
    @Nonnull
    @Generated
    public String getAspectName() {
        return this.aspectName;
    }

    @Override
    @Nonnull
    @Generated
    public RecordTemplate getRecordTemplate() {
        return this.recordTemplate;
    }

    @Override
    @Nonnull
    @Generated
    public SystemMetadata getSystemMetadata() {
        return this.systemMetadata;
    }

    @Override
    @Nonnull
    @Generated
    public AuditStamp getAuditStamp() {
        return this.auditStamp;
    }

    @Override
    @Nonnull
    @Generated
    public EntitySpec getEntitySpec() {
        return this.entitySpec;
    }

    @Override
    @Nonnull
    @Generated
    public AspectSpec getAspectSpec() {
        return this.aspectSpec;
    }

    @Override
    @Nullable
    @Generated
    public SystemAspect getPreviousSystemAspect() {
        return this.previousSystemAspect;
    }

    @Override
    @Generated
    public long getNextAspectVersion() {
        return this.nextAspectVersion;
    }

    @Override
    @Generated
    public void setPreviousSystemAspect(@Nullable SystemAspect previousSystemAspect) {
        this.previousSystemAspect = previousSystemAspect;
    }

    @Override
    @Generated
    public void setNextAspectVersion(long nextAspectVersion) {
        this.nextAspectVersion = nextAspectVersion;
    }

    public static class ChangeItemImplBuilder {
        @Generated
        private ChangeType changeType;
        @Generated
        private Urn urn;
        @Generated
        private String aspectName;
        @Generated
        private RecordTemplate recordTemplate;
        @Generated
        private SystemMetadata systemMetadata;
        @Generated
        private AuditStamp auditStamp;
        @Generated
        private MetadataChangeProposal metadataChangeProposal;
        @Generated
        private EntitySpec entitySpec;
        @Generated
        private AspectSpec aspectSpec;
        @Generated
        private SystemAspect previousSystemAspect;
        @Generated
        private long nextAspectVersion;
        @Generated
        private Map<String, String> headers;

        private ChangeItemImpl build() {
            return null;
        }

        public ChangeItemImplBuilder systemMetadata(SystemMetadata systemMetadata) {
            this.systemMetadata = SystemMetadataUtils.generateSystemMetadataIfEmpty(systemMetadata);
            return this;
        }

        public ChangeItemImplBuilder changeType(ChangeType changeType) {
            this.changeType = ChangeItemImplBuilder.validateOrDefaultChangeType(changeType);
            return this;
        }

        public ChangeItemImpl build(AspectRetriever aspectRetriever) {
            if (this.changeType == null) {
                this.changeType(null);
            }
            if (this.headers == null) {
                this.headers = Map.of();
            }
            ValidationApiUtils.validateUrn(aspectRetriever.getEntityRegistry(), this.urn);
            log.debug("entity type = {}", (Object)this.urn.getEntityType());
            this.entitySpec(ValidationApiUtils.validateEntity(aspectRetriever.getEntityRegistry(), this.urn.getEntityType()));
            log.debug("entity spec = {}", (Object)this.entitySpec);
            this.aspectSpec(ValidationApiUtils.validateAspect(this.entitySpec, this.aspectName));
            log.debug("aspect spec = {}", (Object)this.aspectSpec);
            if (this.recordTemplate == null && this.metadataChangeProposal != null) {
                this.recordTemplate = ChangeItemImplBuilder.convertToRecordTemplate(this.metadataChangeProposal, this.aspectSpec);
            }
            ValidationApiUtils.validateRecordTemplate(this.entitySpec, this.urn, this.recordTemplate, aspectRetriever);
            if (this.systemMetadata == null) {
                this.systemMetadata(null);
            }
            this.systemMetadata = SystemMetadataUtils.setAspectModified(this.systemMetadata, this.auditStamp);
            return new ChangeItemImpl(this.changeType, this.urn, this.aspectName, this.recordTemplate, this.systemMetadata, this.auditStamp, this.metadataChangeProposal, this.entitySpec, this.aspectSpec, this.previousSystemAspect, this.nextAspectVersion, this.headers);
        }

        public ChangeItemImpl build(MetadataChangeProposal mcp, AuditStamp auditStamp, AspectRetriever aspectRetriever) {
            this.metadataChangeProposal = ValidationApiUtils.validateMCP(aspectRetriever.getEntityRegistry(), mcp);
            this.urn = this.metadataChangeProposal.getEntityUrn();
            this.auditStamp = auditStamp;
            this.aspectName = mcp.getAspectName();
            this.changeType(mcp.getChangeType());
            this.systemMetadata = mcp.getSystemMetadata();
            this.headers = mcp.getHeaders();
            return this.build(aspectRetriever);
        }

        private static ChangeType validateOrDefaultChangeType(@Nullable ChangeType changeType) {
            ChangeType finalChangeType;
            ChangeType changeType2 = finalChangeType = changeType == null ? ChangeType.UPSERT : changeType;
            if (!MCPItem.CHANGE_TYPES.contains((Object)finalChangeType)) {
                throw new IllegalArgumentException(String.format("ChangeType %s not in %s", new Object[]{changeType, MCPItem.CHANGE_TYPES}));
            }
            return finalChangeType;
        }

        private static RecordTemplate convertToRecordTemplate(MetadataChangeProposal mcp, AspectSpec aspectSpec) {
            RecordTemplate aspect;
            if (mcp.getAspect() == null) {
                return null;
            }
            try {
                aspect = GenericRecordUtils.deserializeAspect(mcp.getAspect().getValue(), mcp.getAspect().getContentType(), aspectSpec);
                ValidationApiUtils.validateTrimOrThrow(aspect);
            }
            catch (ModelConversionException e) {
                throw new RuntimeException(String.format("Could not deserialize %s for aspect %s", mcp.getAspect().getValue(), mcp.getAspectName()));
            }
            return aspect;
        }

        @Generated
        ChangeItemImplBuilder() {
        }

        @Generated
        public ChangeItemImplBuilder urn(@Nonnull Urn urn) {
            if (urn == null) {
                throw new NullPointerException("urn is marked non-null but is null");
            }
            this.urn = urn;
            return this;
        }

        @Generated
        public ChangeItemImplBuilder aspectName(@Nonnull String aspectName) {
            if (aspectName == null) {
                throw new NullPointerException("aspectName is marked non-null but is null");
            }
            this.aspectName = aspectName;
            return this;
        }

        @Generated
        public ChangeItemImplBuilder recordTemplate(@Nonnull RecordTemplate recordTemplate) {
            if (recordTemplate == null) {
                throw new NullPointerException("recordTemplate is marked non-null but is null");
            }
            this.recordTemplate = recordTemplate;
            return this;
        }

        @Generated
        public ChangeItemImplBuilder auditStamp(@Nonnull AuditStamp auditStamp) {
            if (auditStamp == null) {
                throw new NullPointerException("auditStamp is marked non-null but is null");
            }
            this.auditStamp = auditStamp;
            return this;
        }

        @Generated
        public ChangeItemImplBuilder metadataChangeProposal(@Nullable MetadataChangeProposal metadataChangeProposal) {
            this.metadataChangeProposal = metadataChangeProposal;
            return this;
        }

        @Generated
        public ChangeItemImplBuilder entitySpec(@Nonnull EntitySpec entitySpec) {
            if (entitySpec == null) {
                throw new NullPointerException("entitySpec is marked non-null but is null");
            }
            this.entitySpec = entitySpec;
            return this;
        }

        @Generated
        public ChangeItemImplBuilder aspectSpec(@Nonnull AspectSpec aspectSpec) {
            if (aspectSpec == null) {
                throw new NullPointerException("aspectSpec is marked non-null but is null");
            }
            this.aspectSpec = aspectSpec;
            return this;
        }

        @Generated
        public ChangeItemImplBuilder previousSystemAspect(@Nullable SystemAspect previousSystemAspect) {
            this.previousSystemAspect = previousSystemAspect;
            return this;
        }

        @Generated
        public ChangeItemImplBuilder nextAspectVersion(long nextAspectVersion) {
            this.nextAspectVersion = nextAspectVersion;
            return this;
        }

        @Generated
        public ChangeItemImplBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public String toString() {
            return "ChangeItemImpl.ChangeItemImplBuilder(changeType=" + String.valueOf((Object)this.changeType) + ", urn=" + String.valueOf(this.urn) + ", aspectName=" + this.aspectName + ", recordTemplate=" + String.valueOf(this.recordTemplate) + ", systemMetadata=" + String.valueOf(this.systemMetadata) + ", auditStamp=" + String.valueOf(this.auditStamp) + ", metadataChangeProposal=" + String.valueOf(this.metadataChangeProposal) + ", entitySpec=" + String.valueOf(this.entitySpec) + ", aspectSpec=" + String.valueOf(this.aspectSpec) + ", previousSystemAspect=" + String.valueOf(this.previousSystemAspect) + ", nextAspectVersion=" + this.nextAspectVersion + ", headers=" + String.valueOf(this.headers) + ")";
        }
    }
}

