/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.plugins.config;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class AspectPluginConfig {
    @Nonnull
    private String className;
    @Nullable
    private List<String> packageScan;
    private boolean enabled;
    @Nullable
    private List<String> supportedOperations;
    @Nonnull
    private List<EntityAspectName> supportedEntityAspectNames;
    @Nullable
    private SpringPluginConfig spring;

    @Nonnull
    public List<String> getSupportedOperations() {
        return this.supportedOperations != null ? this.supportedOperations : Collections.emptyList();
    }

    public boolean isDisabledBy(AspectPluginConfig o) {
        return this.enabled && this.isEqualExcludingEnabled(o) && !o.enabled;
    }

    private boolean isEqualExcludingEnabled(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AspectPluginConfig that = (AspectPluginConfig)o;
        if (!this.className.equals(that.className)) {
            return false;
        }
        if (!Objects.equals(this.packageScan, that.getPackageScan())) {
            return false;
        }
        if (!Objects.equals(this.supportedOperations, that.supportedOperations)) {
            return false;
        }
        if (!Objects.equals(this.spring, that.spring)) {
            return false;
        }
        return this.supportedEntityAspectNames.equals(that.supportedEntityAspectNames);
    }

    @Generated
    public static AspectPluginConfigBuilder builder() {
        return new AspectPluginConfigBuilder();
    }

    @Nonnull
    @Generated
    public String getClassName() {
        return this.className;
    }

    @Nullable
    @Generated
    public List<String> getPackageScan() {
        return this.packageScan;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Nonnull
    @Generated
    public List<EntityAspectName> getSupportedEntityAspectNames() {
        return this.supportedEntityAspectNames;
    }

    @Nullable
    @Generated
    public SpringPluginConfig getSpring() {
        return this.spring;
    }

    @Generated
    public void setClassName(@Nonnull String className) {
        if (className == null) {
            throw new NullPointerException("className is marked non-null but is null");
        }
        this.className = className;
    }

    @Generated
    public void setPackageScan(@Nullable List<String> packageScan) {
        this.packageScan = packageScan;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setSupportedOperations(@Nullable List<String> supportedOperations) {
        this.supportedOperations = supportedOperations;
    }

    @Generated
    public void setSupportedEntityAspectNames(@Nonnull List<EntityAspectName> supportedEntityAspectNames) {
        if (supportedEntityAspectNames == null) {
            throw new NullPointerException("supportedEntityAspectNames is marked non-null but is null");
        }
        this.supportedEntityAspectNames = supportedEntityAspectNames;
    }

    @Generated
    public void setSpring(@Nullable SpringPluginConfig spring) {
        this.spring = spring;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AspectPluginConfig)) {
            return false;
        }
        AspectPluginConfig other = (AspectPluginConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        List<String> this$packageScan = this.getPackageScan();
        List<String> other$packageScan = other.getPackageScan();
        if (this$packageScan == null ? other$packageScan != null : !((Object)this$packageScan).equals(other$packageScan)) {
            return false;
        }
        List<String> this$supportedOperations = this.getSupportedOperations();
        List<String> other$supportedOperations = other.getSupportedOperations();
        if (this$supportedOperations == null ? other$supportedOperations != null : !((Object)this$supportedOperations).equals(other$supportedOperations)) {
            return false;
        }
        List<EntityAspectName> this$supportedEntityAspectNames = this.getSupportedEntityAspectNames();
        List<EntityAspectName> other$supportedEntityAspectNames = other.getSupportedEntityAspectNames();
        if (this$supportedEntityAspectNames == null ? other$supportedEntityAspectNames != null : !((Object)this$supportedEntityAspectNames).equals(other$supportedEntityAspectNames)) {
            return false;
        }
        SpringPluginConfig this$spring = this.getSpring();
        SpringPluginConfig other$spring = other.getSpring();
        return !(this$spring == null ? other$spring != null : !((Object)this$spring).equals(other$spring));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AspectPluginConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        List<String> $packageScan = this.getPackageScan();
        result = result * 59 + ($packageScan == null ? 43 : ((Object)$packageScan).hashCode());
        List<String> $supportedOperations = this.getSupportedOperations();
        result = result * 59 + ($supportedOperations == null ? 43 : ((Object)$supportedOperations).hashCode());
        List<EntityAspectName> $supportedEntityAspectNames = this.getSupportedEntityAspectNames();
        result = result * 59 + ($supportedEntityAspectNames == null ? 43 : ((Object)$supportedEntityAspectNames).hashCode());
        SpringPluginConfig $spring = this.getSpring();
        result = result * 59 + ($spring == null ? 43 : ((Object)$spring).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AspectPluginConfig(className=" + this.getClassName() + ", packageScan=" + String.valueOf(this.getPackageScan()) + ", enabled=" + this.isEnabled() + ", supportedOperations=" + String.valueOf(this.getSupportedOperations()) + ", supportedEntityAspectNames=" + String.valueOf(this.getSupportedEntityAspectNames()) + ", spring=" + String.valueOf(this.getSpring()) + ")";
    }

    @Generated
    public AspectPluginConfig() {
    }

    @Generated
    public AspectPluginConfig(@Nonnull String className, @Nullable List<String> packageScan, boolean enabled, @Nullable List<String> supportedOperations, @Nonnull List<EntityAspectName> supportedEntityAspectNames, @Nullable SpringPluginConfig spring) {
        if (className == null) {
            throw new NullPointerException("className is marked non-null but is null");
        }
        if (supportedEntityAspectNames == null) {
            throw new NullPointerException("supportedEntityAspectNames is marked non-null but is null");
        }
        this.className = className;
        this.packageScan = packageScan;
        this.enabled = enabled;
        this.supportedOperations = supportedOperations;
        this.supportedEntityAspectNames = supportedEntityAspectNames;
        this.spring = spring;
    }

    public static class SpringPluginConfig {
        private boolean enabled;
        @Nullable
        private String name;

        @Generated
        public static SpringPluginConfigBuilder builder() {
            return new SpringPluginConfigBuilder();
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Nullable
        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpringPluginConfig)) {
                return false;
            }
            SpringPluginConfig other = (SpringPluginConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SpringPluginConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AspectPluginConfig.SpringPluginConfig(enabled=" + this.isEnabled() + ", name=" + this.getName() + ")";
        }

        @Generated
        public SpringPluginConfig() {
        }

        @Generated
        public SpringPluginConfig(boolean enabled, @Nullable String name) {
            this.enabled = enabled;
            this.name = name;
        }

        @Generated
        public static class SpringPluginConfigBuilder {
            @Generated
            private boolean enabled;
            @Generated
            private String name;

            @Generated
            SpringPluginConfigBuilder() {
            }

            @Generated
            public SpringPluginConfigBuilder enabled(boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            @Generated
            public SpringPluginConfigBuilder name(@Nullable String name) {
                this.name = name;
                return this;
            }

            @Generated
            public SpringPluginConfig build() {
                return new SpringPluginConfig(this.enabled, this.name);
            }

            @Generated
            public String toString() {
                return "AspectPluginConfig.SpringPluginConfig.SpringPluginConfigBuilder(enabled=" + this.enabled + ", name=" + this.name + ")";
            }
        }
    }

    @Generated
    public static class AspectPluginConfigBuilder {
        @Generated
        private String className;
        @Generated
        private List<String> packageScan;
        @Generated
        private boolean enabled;
        @Generated
        private List<String> supportedOperations;
        @Generated
        private List<EntityAspectName> supportedEntityAspectNames;
        @Generated
        private SpringPluginConfig spring;

        @Generated
        AspectPluginConfigBuilder() {
        }

        @Generated
        public AspectPluginConfigBuilder className(@Nonnull String className) {
            if (className == null) {
                throw new NullPointerException("className is marked non-null but is null");
            }
            this.className = className;
            return this;
        }

        @Generated
        public AspectPluginConfigBuilder packageScan(@Nullable List<String> packageScan) {
            this.packageScan = packageScan;
            return this;
        }

        @Generated
        public AspectPluginConfigBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Generated
        public AspectPluginConfigBuilder supportedOperations(@Nullable List<String> supportedOperations) {
            this.supportedOperations = supportedOperations;
            return this;
        }

        @Generated
        public AspectPluginConfigBuilder supportedEntityAspectNames(@Nonnull List<EntityAspectName> supportedEntityAspectNames) {
            if (supportedEntityAspectNames == null) {
                throw new NullPointerException("supportedEntityAspectNames is marked non-null but is null");
            }
            this.supportedEntityAspectNames = supportedEntityAspectNames;
            return this;
        }

        @Generated
        public AspectPluginConfigBuilder spring(@Nullable SpringPluginConfig spring) {
            this.spring = spring;
            return this;
        }

        @Generated
        public AspectPluginConfig build() {
            return new AspectPluginConfig(this.className, this.packageScan, this.enabled, this.supportedOperations, this.supportedEntityAspectNames, this.spring);
        }

        @Generated
        public String toString() {
            return "AspectPluginConfig.AspectPluginConfigBuilder(className=" + this.className + ", packageScan=" + String.valueOf(this.packageScan) + ", enabled=" + this.enabled + ", supportedOperations=" + String.valueOf(this.supportedOperations) + ", supportedEntityAspectNames=" + String.valueOf(this.supportedEntityAspectNames) + ", spring=" + String.valueOf(this.spring) + ")";
        }
    }

    public static class EntityAspectName {
        public static final EntityAspectName ALL = new EntityAspectName("*", "*");
        @Nonnull
        private String entityName;
        @Nonnull
        private String aspectName;

        @Generated
        public static EntityAspectNameBuilder builder() {
            return new EntityAspectNameBuilder();
        }

        @Nonnull
        @Generated
        public String getEntityName() {
            return this.entityName;
        }

        @Nonnull
        @Generated
        public String getAspectName() {
            return this.aspectName;
        }

        @Generated
        public void setEntityName(@Nonnull String entityName) {
            if (entityName == null) {
                throw new NullPointerException("entityName is marked non-null but is null");
            }
            this.entityName = entityName;
        }

        @Generated
        public void setAspectName(@Nonnull String aspectName) {
            if (aspectName == null) {
                throw new NullPointerException("aspectName is marked non-null but is null");
            }
            this.aspectName = aspectName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntityAspectName)) {
                return false;
            }
            EntityAspectName other = (EntityAspectName)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$entityName = this.getEntityName();
            String other$entityName = other.getEntityName();
            if (this$entityName == null ? other$entityName != null : !this$entityName.equals(other$entityName)) {
                return false;
            }
            String this$aspectName = this.getAspectName();
            String other$aspectName = other.getAspectName();
            return !(this$aspectName == null ? other$aspectName != null : !this$aspectName.equals(other$aspectName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EntityAspectName;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $entityName = this.getEntityName();
            result = result * 59 + ($entityName == null ? 43 : $entityName.hashCode());
            String $aspectName = this.getAspectName();
            result = result * 59 + ($aspectName == null ? 43 : $aspectName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AspectPluginConfig.EntityAspectName(entityName=" + this.getEntityName() + ", aspectName=" + this.getAspectName() + ")";
        }

        @Generated
        public EntityAspectName() {
        }

        @Generated
        public EntityAspectName(@Nonnull String entityName, @Nonnull String aspectName) {
            if (entityName == null) {
                throw new NullPointerException("entityName is marked non-null but is null");
            }
            if (aspectName == null) {
                throw new NullPointerException("aspectName is marked non-null but is null");
            }
            this.entityName = entityName;
            this.aspectName = aspectName;
        }

        @Generated
        public static class EntityAspectNameBuilder {
            @Generated
            private String entityName;
            @Generated
            private String aspectName;

            @Generated
            EntityAspectNameBuilder() {
            }

            @Generated
            public EntityAspectNameBuilder entityName(@Nonnull String entityName) {
                if (entityName == null) {
                    throw new NullPointerException("entityName is marked non-null but is null");
                }
                this.entityName = entityName;
                return this;
            }

            @Generated
            public EntityAspectNameBuilder aspectName(@Nonnull String aspectName) {
                if (aspectName == null) {
                    throw new NullPointerException("aspectName is marked non-null but is null");
                }
                this.aspectName = aspectName;
                return this;
            }

            @Generated
            public EntityAspectName build() {
                return new EntityAspectName(this.entityName, this.aspectName);
            }

            @Generated
            public String toString() {
                return "AspectPluginConfig.EntityAspectName.EntityAspectNameBuilder(entityName=" + this.entityName + ", aspectName=" + this.aspectName + ")";
            }
        }
    }
}

