/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.builder;

import com.linkedin.common.urn.Urn;
import com.linkedin.metadata.aspect.patch.PatchOperationType;
import com.linkedin.metadata.aspect.patch.builder.AbstractMultiFieldPatchBuilder;
import datahub.shaded.jackson.databind.node.JsonNodeFactory;
import datahub.shaded.jackson.databind.node.TextNode;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class SiblingsPatchBuilder
extends AbstractMultiFieldPatchBuilder<SiblingsPatchBuilder> {
    private static final String BASE_PATH = "/siblings/";
    private static final String PRIMARY_PATH = "/primary";

    public SiblingsPatchBuilder addSibling(@Nonnull Urn siblingUrn, boolean primary) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), BASE_PATH + SiblingsPatchBuilder.encodeValueUrn(siblingUrn), new TextNode(siblingUrn.toString())));
        if (primary) {
            this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), PRIMARY_PATH, JsonNodeFactory.instance.booleanNode(true)));
        }
        return this;
    }

    public SiblingsPatchBuilder removeSibling(@Nonnull Urn siblingUrn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), BASE_PATH + SiblingsPatchBuilder.encodeValueUrn(siblingUrn), null));
        return this;
    }

    @Override
    protected String getAspectName() {
        return "siblings";
    }

    @Override
    protected String getEntityType() {
        if (this.targetEntityUrn == null) {
            throw new IllegalStateException("Target Entity Urn must be set to determine entity type before building Patch.");
        }
        return this.targetEntityUrn.getEntityType();
    }
}

