/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.builder;

import com.linkedin.common.urn.GlossaryTermUrn;
import com.linkedin.metadata.aspect.patch.PatchOperationType;
import com.linkedin.metadata.aspect.patch.builder.AbstractMultiFieldPatchBuilder;
import datahub.shaded.jackson.databind.node.JsonNodeFactory;
import datahub.shaded.jackson.databind.node.ObjectNode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class GlossaryTermsPatchBuilder
extends AbstractMultiFieldPatchBuilder<GlossaryTermsPatchBuilder> {
    private static final String BASE_PATH = "/glossaryTerms/";
    private static final String URN_KEY = "urn";
    private static final String CONTEXT_KEY = "context";

    public GlossaryTermsPatchBuilder addTerm(@Nonnull GlossaryTermUrn urn, @Nullable String context) {
        ObjectNode value = JsonNodeFactory.instance.objectNode();
        value.put(URN_KEY, urn.toString());
        if (context != null) {
            value.put(CONTEXT_KEY, context);
        }
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.ADD.getValue(), BASE_PATH + GlossaryTermsPatchBuilder.encodeValueUrn(urn), value));
        return this;
    }

    public GlossaryTermsPatchBuilder removeTerm(@Nonnull GlossaryTermUrn urn) {
        this.pathValues.add(ImmutableTriple.of(PatchOperationType.REMOVE.getValue(), BASE_PATH + GlossaryTermsPatchBuilder.encodeValueUrn(urn), null));
        return this;
    }

    @Override
    protected String getAspectName() {
        return "glossaryTerms";
    }

    @Override
    protected String getEntityType() {
        if (this.targetEntityUrn == null) {
            throw new IllegalStateException("Target Entity Urn must be set to determine entity type before building Patch.");
        }
        return this.targetEntityUrn.getEntityType();
    }
}

