/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch;

import com.linkedin.util.Pair;
import datahub.shaded.jackson.annotation.JsonIgnore;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonPatch;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class GenericJsonPatch {
    public static final String ARRAY_PRIMARY_KEYS_FIELD = "arrayPrimaryKeys";
    public static final String PATCH_FIELD = "patch";
    @Nullable
    private Map<String, List<String>> arrayPrimaryKeys;
    @Nonnull
    private List<PatchOp> patch;
    private boolean forceGenericPatch;

    @Nonnull
    public Map<String, List<String>> getArrayPrimaryKeys() {
        return this.arrayPrimaryKeys == null ? Collections.emptyMap() : this.arrayPrimaryKeys;
    }

    @JsonIgnore
    public JsonPatch getJsonPatch() {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        this.patch.forEach(op -> arrayBuilder.add(Json.createObjectBuilder(op.toMap())));
        return Json.createPatch(arrayBuilder.build());
    }

    @Generated
    public static GenericJsonPatchBuilder builder() {
        return new GenericJsonPatchBuilder();
    }

    @Nonnull
    @Generated
    public List<PatchOp> getPatch() {
        return this.patch;
    }

    @Generated
    public boolean isForceGenericPatch() {
        return this.forceGenericPatch;
    }

    @Generated
    public void setArrayPrimaryKeys(@Nullable Map<String, List<String>> arrayPrimaryKeys) {
        this.arrayPrimaryKeys = arrayPrimaryKeys;
    }

    @Generated
    public void setPatch(@Nonnull List<PatchOp> patch) {
        if (patch == null) {
            throw new NullPointerException("patch is marked non-null but is null");
        }
        this.patch = patch;
    }

    @Generated
    public void setForceGenericPatch(boolean forceGenericPatch) {
        this.forceGenericPatch = forceGenericPatch;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericJsonPatch)) {
            return false;
        }
        GenericJsonPatch other = (GenericJsonPatch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isForceGenericPatch() != other.isForceGenericPatch()) {
            return false;
        }
        Map<String, List<String>> this$arrayPrimaryKeys = this.getArrayPrimaryKeys();
        Map<String, List<String>> other$arrayPrimaryKeys = other.getArrayPrimaryKeys();
        if (this$arrayPrimaryKeys == null ? other$arrayPrimaryKeys != null : !((Object)this$arrayPrimaryKeys).equals(other$arrayPrimaryKeys)) {
            return false;
        }
        List<PatchOp> this$patch = this.getPatch();
        List<PatchOp> other$patch = other.getPatch();
        return !(this$patch == null ? other$patch != null : !((Object)this$patch).equals(other$patch));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GenericJsonPatch;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForceGenericPatch() ? 79 : 97);
        Map<String, List<String>> $arrayPrimaryKeys = this.getArrayPrimaryKeys();
        result = result * 59 + ($arrayPrimaryKeys == null ? 43 : ((Object)$arrayPrimaryKeys).hashCode());
        List<PatchOp> $patch = this.getPatch();
        result = result * 59 + ($patch == null ? 43 : ((Object)$patch).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GenericJsonPatch(arrayPrimaryKeys=" + String.valueOf(this.getArrayPrimaryKeys()) + ", patch=" + String.valueOf(this.getPatch()) + ", forceGenericPatch=" + this.isForceGenericPatch() + ")";
    }

    @Generated
    public GenericJsonPatch() {
    }

    @Generated
    public GenericJsonPatch(@Nullable Map<String, List<String>> arrayPrimaryKeys, @Nonnull List<PatchOp> patch, boolean forceGenericPatch) {
        if (patch == null) {
            throw new NullPointerException("patch is marked non-null but is null");
        }
        this.arrayPrimaryKeys = arrayPrimaryKeys;
        this.patch = patch;
        this.forceGenericPatch = forceGenericPatch;
    }

    @Generated
    public static class GenericJsonPatchBuilder {
        @Generated
        private Map<String, List<String>> arrayPrimaryKeys;
        @Generated
        private List<PatchOp> patch;
        @Generated
        private boolean forceGenericPatch;

        @Generated
        GenericJsonPatchBuilder() {
        }

        @Generated
        public GenericJsonPatchBuilder arrayPrimaryKeys(@Nullable Map<String, List<String>> arrayPrimaryKeys) {
            this.arrayPrimaryKeys = arrayPrimaryKeys;
            return this;
        }

        @Generated
        public GenericJsonPatchBuilder patch(@Nonnull List<PatchOp> patch) {
            if (patch == null) {
                throw new NullPointerException("patch is marked non-null but is null");
            }
            this.patch = patch;
            return this;
        }

        @Generated
        public GenericJsonPatchBuilder forceGenericPatch(boolean forceGenericPatch) {
            this.forceGenericPatch = forceGenericPatch;
            return this;
        }

        @Generated
        public GenericJsonPatch build() {
            return new GenericJsonPatch(this.arrayPrimaryKeys, this.patch, this.forceGenericPatch);
        }

        @Generated
        public String toString() {
            return "GenericJsonPatch.GenericJsonPatchBuilder(arrayPrimaryKeys=" + String.valueOf(this.arrayPrimaryKeys) + ", patch=" + String.valueOf(this.patch) + ", forceGenericPatch=" + this.forceGenericPatch + ")";
        }
    }

    public static class PatchOp {
        @Nonnull
        private String op;
        @Nonnull
        private String path;
        @Nullable
        private Object value;

        public Map<String, ?> toMap() {
            if (this.value != null) {
                return Stream.of(Pair.of("op", this.op), Pair.of("path", this.path), Pair.of("value", this.value)).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            }
            return Stream.of(Pair.of("op", this.op), Pair.of("path", this.path)).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        }

        @Nonnull
        @Generated
        public String getOp() {
            return this.op;
        }

        @Nonnull
        @Generated
        public String getPath() {
            return this.path;
        }

        @Nullable
        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public void setOp(@Nonnull String op) {
            if (op == null) {
                throw new NullPointerException("op is marked non-null but is null");
            }
            this.op = op;
        }

        @Generated
        public void setPath(@Nonnull String path) {
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            this.path = path;
        }

        @Generated
        public void setValue(@Nullable Object value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PatchOp)) {
                return false;
            }
            PatchOp other = (PatchOp)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$op = this.getOp();
            String other$op = other.getOp();
            if (this$op == null ? other$op != null : !this$op.equals(other$op)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PatchOp;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $op = this.getOp();
            result = result * 59 + ($op == null ? 43 : $op.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GenericJsonPatch.PatchOp(op=" + this.getOp() + ", path=" + this.getPath() + ", value=" + String.valueOf(this.getValue()) + ")";
        }

        @Generated
        public PatchOp() {
        }
    }
}

