/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.HasTyperefInfo;
import com.linkedin.data.template.TyperefInfo;
import com.linkedin.data.template.UnionTemplate;
import com.linkedin.metadata.key.DataHubPolicyKey;
import com.linkedin.policy.DataHubPolicyInfo;
import java.util.List;
import java.util.function.Function;

public class DataHubPolicyAspect
extends UnionTemplate
implements HasTyperefInfo {
    private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema("union[{namespace com.linkedin.metadata.key/**Key for a DataHub Policy*/@Aspect.name=\"dataHubPolicyKey\"record DataHubPolicyKey{/**A unique id for the DataHub access policy record. Generated on the server side at policy creation time.*/id:string}}{namespace com.linkedin.policy/**Information about a DataHub (UI) access policy.*/@Aspect.name=\"dataHubPolicyInfo\"record DataHubPolicyInfo{/**Display name of the Policy*/@Searchable.fieldType=\"TEXT_PARTIAL\"displayName:string/**Description of the Policy*/@Searchable.fieldType=\"TEXT\"description:string/**The type of policy*/@Searchable.fieldType=\"KEYWORD\"type:string/**The state of policy, ACTIVE or INACTIVE*/@Searchable.fieldType=\"KEYWORD\"state:string/**The resource that the policy applies to. Not required for some 'Platform' privileges.*/resources:optional/**Information used to filter DataHub resource.*/record DataHubResourceFilter{/**The type of resource that the policy applies to. This will most often be a data asset entity name, for\nexample 'dataset'. It is not strictly required because in the future we will want to support filtering a resource\nby domain, as well.*/@deprecated,type:optional string/**A specific set of resources to apply the policy to, e.g. asset urns*/@deprecated,resources:optional array[string]/**Whether the policy should be applied to all assets matching the filter.*/@deprecated,allResources:boolean=false/**Filter to apply privileges to*/filter:optional/**The filter for specifying the resource or actor to apply privileges to*/record PolicyMatchFilter{/**A list of criteria to apply conjunctively (so all criteria must pass)*/criteria:array[/**A criterion for matching a field with given value*/record PolicyMatchCriterion{/**The name of the field that the criterion refers to*/field:string/**Values. Matches criterion if any one of the values matches condition (OR-relationship)*/values:array[string]/**The condition for the criterion*/condition:/**The matching condition in a filter criterion*/enum PolicyMatchCondition{/**Whether the field matches the value*/EQUALS/**Whether the field value starts with the value*/STARTS_WITH/**Whether the field does not match the value*/NOT_EQUALS}=\"EQUALS\"}]}/**Constraints around what sub-resources operations are allowed to modify, i.e. NOT_EQUALS - cannot modify a particular defined tag, EQUALS - can only modify a particular defined tag, STARTS_WITH - can only modify a tag starting with xyz*/privilegeConstraints:optional PolicyMatchFilter}/**The privileges that the policy grants.*/@Searchable.`/*`={\"addToFilters\":true,\"fieldType\":\"KEYWORD\"}privileges:array[string]/**The actors that the policy applies to.*/actors:/**Information used to filter DataHub actors.*/record DataHubActorFilter{/**A specific set of users to apply the policy to (disjunctive)*/@Searchable.`/*`.fieldType=\"URN\"users:optional array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**A specific set of groups to apply the policy to (disjunctive)*/@Searchable.`/*`.fieldType=\"URN\"groups:optional array[com.linkedin.common.Urn]/**Whether the filter should return true for owners of a particular resource.\nOnly applies to policies of type 'Metadata', which have a resource associated with them.*/resourceOwners:boolean=false/**Define type of ownership for the policy*/resourceOwnersTypes:optional array[com.linkedin.common.Urn]/**Whether the filter should apply to all users.*/@Searchable.fieldType=\"BOOLEAN\"allUsers:boolean=false/**Whether the filter should apply to all groups.*/@Searchable.fieldType=\"BOOLEAN\"allGroups:boolean=false/**A specific set of roles to apply the policy to (disjunctive).*/@Relationship.`/*`={\"entityTypes\":[\"dataHubRole\"],\"name\":\"IsAssociatedWithRole\"}@Searchable.`/*`.fieldType=\"URN\"roles:optional array[com.linkedin.common.Urn]}/**Whether the policy should be editable via the UI*/@Searchable.fieldType=\"BOOLEAN\"editable:boolean=true/**Timestamp when the policy was last updated*/@Searchable.fieldType=\"DATETIME\"lastUpdatedTimestamp:optional long}}]", SchemaFormatType.PDL);
    private DataHubPolicyKey _dataHubPolicyKeyMember = null;
    private DataHubPolicyInfo _dataHubPolicyInfoMember = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final DataSchema MEMBER_DataHubPolicyKey = SCHEMA.getTypeByMemberKey("com.linkedin.metadata.key.DataHubPolicyKey");
    public static final String MEMBERKEY_DataHubPolicyKey = "com.linkedin.metadata.key.DataHubPolicyKey";
    private static final DataSchema MEMBER_DataHubPolicyInfo = SCHEMA.getTypeByMemberKey("com.linkedin.policy.DataHubPolicyInfo");
    public static final String MEMBERKEY_DataHubPolicyInfo = "com.linkedin.policy.DataHubPolicyInfo";
    private static final TyperefInfo TYPEREFINFO = new UnionTyperefInfo();

    public DataHubPolicyAspect() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public DataHubPolicyAspect(Object data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static UnionDataSchema dataSchema() {
        return SCHEMA;
    }

    public static DataHubPolicyAspect create(DataHubPolicyKey value) {
        DataHubPolicyAspect newUnion = new DataHubPolicyAspect();
        newUnion.setDataHubPolicyKey(value);
        return newUnion;
    }

    public boolean isDataHubPolicyKey() {
        return this.memberIs(MEMBERKEY_DataHubPolicyKey);
    }

    public DataHubPolicyKey getDataHubPolicyKey() {
        this.checkNotNull();
        if (this._dataHubPolicyKeyMember != null) {
            return this._dataHubPolicyKeyMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_DataHubPolicyKey);
        this._dataHubPolicyKeyMember = __rawValue == null ? null : new DataHubPolicyKey(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._dataHubPolicyKeyMember;
    }

    public void setDataHubPolicyKey(DataHubPolicyKey value) {
        this.checkNotNull();
        this._map.clear();
        this._dataHubPolicyKeyMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_DataHubPolicyKey, value.data());
    }

    public static DataHubPolicyAspect create(DataHubPolicyInfo value) {
        DataHubPolicyAspect newUnion = new DataHubPolicyAspect();
        newUnion.setDataHubPolicyInfo(value);
        return newUnion;
    }

    public boolean isDataHubPolicyInfo() {
        return this.memberIs(MEMBERKEY_DataHubPolicyInfo);
    }

    public DataHubPolicyInfo getDataHubPolicyInfo() {
        this.checkNotNull();
        if (this._dataHubPolicyInfoMember != null) {
            return this._dataHubPolicyInfoMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_DataHubPolicyInfo);
        this._dataHubPolicyInfoMember = __rawValue == null ? null : new DataHubPolicyInfo(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._dataHubPolicyInfoMember;
    }

    public void setDataHubPolicyInfo(DataHubPolicyInfo value) {
        this.checkNotNull();
        this._map.clear();
        this._dataHubPolicyInfoMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_DataHubPolicyInfo, value.data());
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public DataHubPolicyAspect clone() throws CloneNotSupportedException {
        DataHubPolicyAspect __clone = (DataHubPolicyAspect)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataHubPolicyAspect copy() throws CloneNotSupportedException {
        DataHubPolicyAspect __copy = (DataHubPolicyAspect)super.copy();
        __copy._dataHubPolicyKeyMember = null;
        __copy._dataHubPolicyInfoMember = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    @Override
    public TyperefInfo typerefInfo() {
        return TYPEREFINFO;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataHubPolicyAspect __objectRef;

        private ChangeListener(DataHubPolicyAspect reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "com.linkedin.metadata.key.DataHubPolicyKey": {
                    this.__objectRef._dataHubPolicyKeyMember = null;
                    break;
                }
                case "com.linkedin.policy.DataHubPolicyInfo": {
                    this.__objectRef._dataHubPolicyInfoMember = null;
                }
            }
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private DataHubPolicyKey.ProjectionMask _DataHubPolicyKeyMask;
        private DataHubPolicyInfo.ProjectionMask _DataHubPolicyInfoMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withDataHubPolicyKey(Function<DataHubPolicyKey.ProjectionMask, DataHubPolicyKey.ProjectionMask> nestedMask) {
            this._DataHubPolicyKeyMask = nestedMask.apply(this._DataHubPolicyKeyMask == null ? DataHubPolicyKey.createMask() : this._DataHubPolicyKeyMask);
            this.getDataMap().put(DataHubPolicyAspect.MEMBERKEY_DataHubPolicyKey, this._DataHubPolicyKeyMask.getDataMap());
            return this;
        }

        public ProjectionMask withDataHubPolicyInfo(Function<DataHubPolicyInfo.ProjectionMask, DataHubPolicyInfo.ProjectionMask> nestedMask) {
            this._DataHubPolicyInfoMask = nestedMask.apply(this._DataHubPolicyInfoMask == null ? DataHubPolicyInfo.createMask() : this._DataHubPolicyInfoMask);
            this.getDataMap().put(DataHubPolicyAspect.MEMBERKEY_DataHubPolicyInfo, this._DataHubPolicyInfoMask.getDataMap());
            return this;
        }
    }

    private static final class UnionTyperefInfo
    extends TyperefInfo {
        private static final TyperefDataSchema SCHEMA = (TyperefDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a DataHub access policy.*/typeref DataHubPolicyAspect=union[{namespace com.linkedin.metadata.key/**Key for a DataHub Policy*/@Aspect.name=\"dataHubPolicyKey\"record DataHubPolicyKey{/**A unique id for the DataHub access policy record. Generated on the server side at policy creation time.*/id:string}}{namespace com.linkedin.policy/**Information about a DataHub (UI) access policy.*/@Aspect.name=\"dataHubPolicyInfo\"record DataHubPolicyInfo{/**Display name of the Policy*/@Searchable.fieldType=\"TEXT_PARTIAL\"displayName:string/**Description of the Policy*/@Searchable.fieldType=\"TEXT\"description:string/**The type of policy*/@Searchable.fieldType=\"KEYWORD\"type:string/**The state of policy, ACTIVE or INACTIVE*/@Searchable.fieldType=\"KEYWORD\"state:string/**The resource that the policy applies to. Not required for some 'Platform' privileges.*/resources:optional/**Information used to filter DataHub resource.*/record DataHubResourceFilter{/**The type of resource that the policy applies to. This will most often be a data asset entity name, for\nexample 'dataset'. It is not strictly required because in the future we will want to support filtering a resource\nby domain, as well.*/@deprecated,type:optional string/**A specific set of resources to apply the policy to, e.g. asset urns*/@deprecated,resources:optional array[string]/**Whether the policy should be applied to all assets matching the filter.*/@deprecated,allResources:boolean=false/**Filter to apply privileges to*/filter:optional/**The filter for specifying the resource or actor to apply privileges to*/record PolicyMatchFilter{/**A list of criteria to apply conjunctively (so all criteria must pass)*/criteria:array[/**A criterion for matching a field with given value*/record PolicyMatchCriterion{/**The name of the field that the criterion refers to*/field:string/**Values. Matches criterion if any one of the values matches condition (OR-relationship)*/values:array[string]/**The condition for the criterion*/condition:/**The matching condition in a filter criterion*/enum PolicyMatchCondition{/**Whether the field matches the value*/EQUALS/**Whether the field value starts with the value*/STARTS_WITH/**Whether the field does not match the value*/NOT_EQUALS}=\"EQUALS\"}]}/**Constraints around what sub-resources operations are allowed to modify, i.e. NOT_EQUALS - cannot modify a particular defined tag, EQUALS - can only modify a particular defined tag, STARTS_WITH - can only modify a tag starting with xyz*/privilegeConstraints:optional PolicyMatchFilter}/**The privileges that the policy grants.*/@Searchable.`/*`={\"addToFilters\":true,\"fieldType\":\"KEYWORD\"}privileges:array[string]/**The actors that the policy applies to.*/actors:/**Information used to filter DataHub actors.*/record DataHubActorFilter{/**A specific set of users to apply the policy to (disjunctive)*/@Searchable.`/*`.fieldType=\"URN\"users:optional array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**A specific set of groups to apply the policy to (disjunctive)*/@Searchable.`/*`.fieldType=\"URN\"groups:optional array[com.linkedin.common.Urn]/**Whether the filter should return true for owners of a particular resource.\nOnly applies to policies of type 'Metadata', which have a resource associated with them.*/resourceOwners:boolean=false/**Define type of ownership for the policy*/resourceOwnersTypes:optional array[com.linkedin.common.Urn]/**Whether the filter should apply to all users.*/@Searchable.fieldType=\"BOOLEAN\"allUsers:boolean=false/**Whether the filter should apply to all groups.*/@Searchable.fieldType=\"BOOLEAN\"allGroups:boolean=false/**A specific set of roles to apply the policy to (disjunctive).*/@Relationship.`/*`={\"entityTypes\":[\"dataHubRole\"],\"name\":\"IsAssociatedWithRole\"}@Searchable.`/*`.fieldType=\"URN\"roles:optional array[com.linkedin.common.Urn]}/**Whether the policy should be editable via the UI*/@Searchable.fieldType=\"BOOLEAN\"editable:boolean=true/**Timestamp when the policy was last updated*/@Searchable.fieldType=\"DATETIME\"lastUpdatedTimestamp:optional long}}]", SchemaFormatType.PDL);

        public UnionTyperefInfo() {
            super(SCHEMA);
        }

        public static TyperefDataSchema dataSchema() {
            return SCHEMA;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public DataHubPolicyKey.Fields DataHubPolicyKey() {
            return new DataHubPolicyKey.Fields(this.getPathComponents(), DataHubPolicyAspect.MEMBERKEY_DataHubPolicyKey);
        }

        public DataHubPolicyInfo.Fields DataHubPolicyInfo() {
            return new DataHubPolicyInfo.Fields(this.getPathComponents(), DataHubPolicyAspect.MEMBERKEY_DataHubPolicyInfo);
        }
    }
}

