/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.identity;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.CorpGroupUrnArray;
import com.linkedin.common.CorpuserUrnArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CorpGroupInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.identity/**Information about a Corp Group ingested from a third party source*/@Aspect={\"EntityUrns\":[\"com.linkedin.common.CorpGroupUrn\"],\"name\":\"corpGroupInfo\"}record CorpGroupInfo{/**The name of the group.*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"TEXT_PARTIAL\",\"queryByDefault\":true,\"searchLabel\":\"entityName\",\"searchTier\":1}displayName:optional string/**email of this group*/email:optional{namespace com.linkedin.common,typeref EmailAddress=string}/**owners of this group\nDeprecated! Replaced by Ownership aspect.*/@Relationship.`/*`={\"entityTypes\":[\"corpuser\"],\"name\":\"OwnedBy\"}@deprecated,admins:array[{namespace com.linkedin.common/**Corporate user's AD/LDAP login*/@java.class=\"com.linkedin.common.urn.CorpuserUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Corporate user's AD/LDAP login\",\"entityType\":\"corpuser\",\"fields\":[{\"doc\":\"The name of the AD/LDAP user.\",\"maxLength\":20,\"name\":\"username\",\"type\":\"string\"}],\"maxLength\":36,\"name\":\"Corpuser\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:security\"}typeref CorpuserUrn=string}]/**List of ldap urn in this group.\nDeprecated! Replaced by GroupMembership aspect.*/@Relationship.`/*`={\"entityTypes\":[\"corpuser\"],\"name\":\"IsPartOf\"}@deprecated,members:array[com.linkedin.common.CorpuserUrn]/**List of groups in this group.\nDeprecated! This field is unused.*/@Relationship.`/*`={\"entityTypes\":[\"corpGroup\"],\"name\":\"IsPartOf\"}@deprecated,groups:array[{namespace com.linkedin.common/**Corporate group's AD/LDAP login*/@java.class=\"com.linkedin.common.urn.CorpGroupUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Corporate group's AD/LDAP login\",\"entityType\":\"corpGroup\",\"fields\":[{\"doc\":\"The name of the AD/LDAP group.\",\"maxLength\":128,\"name\":\"groupName\",\"type\":\"string\"}],\"maxLength\":145,\"name\":\"CorpGroup\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:security\"}typeref CorpGroupUrn=string}]/**A description of the group.*/@Searchable={\"fieldType\":\"TEXT_PARTIAL\",\"searchTier\":2}description:optional string/**Slack channel for the group*/slack:optional string/**Created Audit stamp*/@Searchable.`/time`={\"fieldName\":\"createdTime\",\"fieldType\":\"DATETIME\",\"searchLabel\":\"createdAt\"}created:optional{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}", SchemaFormatType.PDL);
    private String _displayNameField = null;
    private String _emailField = null;
    private CorpuserUrnArray _adminsField = null;
    private CorpuserUrnArray _membersField = null;
    private CorpGroupUrnArray _groupsField = null;
    private String _descriptionField = null;
    private String _slackField = null;
    private AuditStamp _createdField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_DisplayName = SCHEMA.getField("displayName");
    private static final RecordDataSchema.Field FIELD_Email = SCHEMA.getField("email");
    private static final RecordDataSchema.Field FIELD_Admins = SCHEMA.getField("admins");
    private static final RecordDataSchema.Field FIELD_Members = SCHEMA.getField("members");
    private static final RecordDataSchema.Field FIELD_Groups = SCHEMA.getField("groups");
    private static final RecordDataSchema.Field FIELD_Description = SCHEMA.getField("description");
    private static final RecordDataSchema.Field FIELD_Slack = SCHEMA.getField("slack");
    private static final RecordDataSchema.Field FIELD_Created = SCHEMA.getField("created");

    public CorpGroupInfo() {
        super(new DataMap(11, 0.75f), SCHEMA, 6);
        this.addChangeListener(this.__changeListener);
    }

    public CorpGroupInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasDisplayName() {
        if (this._displayNameField != null) {
            return true;
        }
        return this._map.containsKey("displayName");
    }

    public void removeDisplayName() {
        this._map.remove("displayName");
    }

    @Nullable
    public String getDisplayName(GetMode mode) {
        return this.getDisplayName();
    }

    @Nullable
    public String getDisplayName() {
        if (this._displayNameField != null) {
            return this._displayNameField;
        }
        Object __rawValue = this._map.get("displayName");
        this._displayNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._displayNameField;
    }

    public CorpGroupInfo setDisplayName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDisplayName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDisplayName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
            }
        }
        return this;
    }

    public CorpGroupInfo setDisplayName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field displayName of com.linkedin.identity.CorpGroupInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "displayName", value);
        this._displayNameField = value;
        return this;
    }

    public boolean hasEmail() {
        if (this._emailField != null) {
            return true;
        }
        return this._map.containsKey("email");
    }

    public void removeEmail() {
        this._map.remove("email");
    }

    @Nullable
    public String getEmail(GetMode mode) {
        return this.getEmail();
    }

    @Nullable
    public String getEmail() {
        if (this._emailField != null) {
            return this._emailField;
        }
        Object __rawValue = this._map.get("email");
        this._emailField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._emailField;
    }

    public CorpGroupInfo setEmail(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEmail(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEmail();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "email", value);
                this._emailField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "email", value);
                this._emailField = value;
            }
        }
        return this;
    }

    public CorpGroupInfo setEmail(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field email of com.linkedin.identity.CorpGroupInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "email", value);
        this._emailField = value;
        return this;
    }

    @Deprecated
    public boolean hasAdmins() {
        if (this._adminsField != null) {
            return true;
        }
        return this._map.containsKey("admins");
    }

    @Deprecated
    public void removeAdmins() {
        this._map.remove("admins");
    }

    @Deprecated
    @Nullable
    public CorpuserUrnArray getAdmins(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAdmins();
            }
            case DEFAULT: 
            case NULL: {
                if (this._adminsField != null) {
                    return this._adminsField;
                }
                Object __rawValue = this._map.get("admins");
                this._adminsField = __rawValue == null ? null : new CorpuserUrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._adminsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Deprecated
    @Nonnull
    public CorpuserUrnArray getAdmins() {
        if (this._adminsField != null) {
            return this._adminsField;
        }
        Object __rawValue = this._map.get("admins");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("admins");
        }
        this._adminsField = __rawValue == null ? null : new CorpuserUrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._adminsField;
    }

    @Deprecated
    public CorpGroupInfo setAdmins(@Nullable CorpuserUrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAdmins(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field admins of com.linkedin.identity.CorpGroupInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "admins", value.data());
                this._adminsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAdmins();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "admins", value.data());
                this._adminsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "admins", value.data());
                this._adminsField = value;
            }
        }
        return this;
    }

    @Deprecated
    public CorpGroupInfo setAdmins(@Nonnull CorpuserUrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field admins of com.linkedin.identity.CorpGroupInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "admins", value.data());
        this._adminsField = value;
        return this;
    }

    @Deprecated
    public boolean hasMembers() {
        if (this._membersField != null) {
            return true;
        }
        return this._map.containsKey("members");
    }

    @Deprecated
    public void removeMembers() {
        this._map.remove("members");
    }

    @Deprecated
    @Nullable
    public CorpuserUrnArray getMembers(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getMembers();
            }
            case DEFAULT: 
            case NULL: {
                if (this._membersField != null) {
                    return this._membersField;
                }
                Object __rawValue = this._map.get("members");
                this._membersField = __rawValue == null ? null : new CorpuserUrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._membersField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Deprecated
    @Nonnull
    public CorpuserUrnArray getMembers() {
        if (this._membersField != null) {
            return this._membersField;
        }
        Object __rawValue = this._map.get("members");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("members");
        }
        this._membersField = __rawValue == null ? null : new CorpuserUrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._membersField;
    }

    @Deprecated
    public CorpGroupInfo setMembers(@Nullable CorpuserUrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMembers(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field members of com.linkedin.identity.CorpGroupInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "members", value.data());
                this._membersField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMembers();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "members", value.data());
                this._membersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "members", value.data());
                this._membersField = value;
            }
        }
        return this;
    }

    @Deprecated
    public CorpGroupInfo setMembers(@Nonnull CorpuserUrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field members of com.linkedin.identity.CorpGroupInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "members", value.data());
        this._membersField = value;
        return this;
    }

    @Deprecated
    public boolean hasGroups() {
        if (this._groupsField != null) {
            return true;
        }
        return this._map.containsKey("groups");
    }

    @Deprecated
    public void removeGroups() {
        this._map.remove("groups");
    }

    @Deprecated
    @Nullable
    public CorpGroupUrnArray getGroups(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getGroups();
            }
            case DEFAULT: 
            case NULL: {
                if (this._groupsField != null) {
                    return this._groupsField;
                }
                Object __rawValue = this._map.get("groups");
                this._groupsField = __rawValue == null ? null : new CorpGroupUrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._groupsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Deprecated
    @Nonnull
    public CorpGroupUrnArray getGroups() {
        if (this._groupsField != null) {
            return this._groupsField;
        }
        Object __rawValue = this._map.get("groups");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("groups");
        }
        this._groupsField = __rawValue == null ? null : new CorpGroupUrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._groupsField;
    }

    @Deprecated
    public CorpGroupInfo setGroups(@Nullable CorpGroupUrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setGroups(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field groups of com.linkedin.identity.CorpGroupInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeGroups();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
                this._groupsField = value;
            }
        }
        return this;
    }

    @Deprecated
    public CorpGroupInfo setGroups(@Nonnull CorpGroupUrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field groups of com.linkedin.identity.CorpGroupInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "groups", value.data());
        this._groupsField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public CorpGroupInfo setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public CorpGroupInfo setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.identity.CorpGroupInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasSlack() {
        if (this._slackField != null) {
            return true;
        }
        return this._map.containsKey("slack");
    }

    public void removeSlack() {
        this._map.remove("slack");
    }

    @Nullable
    public String getSlack(GetMode mode) {
        return this.getSlack();
    }

    @Nullable
    public String getSlack() {
        if (this._slackField != null) {
            return this._slackField;
        }
        Object __rawValue = this._map.get("slack");
        this._slackField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._slackField;
    }

    public CorpGroupInfo setSlack(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSlack(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSlack();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "slack", value);
                this._slackField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "slack", value);
                this._slackField = value;
            }
        }
        return this;
    }

    public CorpGroupInfo setSlack(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field slack of com.linkedin.identity.CorpGroupInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "slack", value);
        this._slackField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        return this.getCreated();
    }

    @Nullable
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public CorpGroupInfo setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public CorpGroupInfo setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.identity.CorpGroupInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    @Override
    public CorpGroupInfo clone() throws CloneNotSupportedException {
        CorpGroupInfo __clone = (CorpGroupInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public CorpGroupInfo copy() throws CloneNotSupportedException {
        CorpGroupInfo __copy = (CorpGroupInfo)super.copy();
        __copy._displayNameField = null;
        __copy._createdField = null;
        __copy._membersField = null;
        __copy._slackField = null;
        __copy._groupsField = null;
        __copy._descriptionField = null;
        __copy._emailField = null;
        __copy._adminsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final CorpGroupInfo __objectRef;

        private ChangeListener(CorpGroupInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "displayName": {
                    this.__objectRef._displayNameField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "members": {
                    this.__objectRef._membersField = null;
                    break;
                }
                case "slack": {
                    this.__objectRef._slackField = null;
                    break;
                }
                case "groups": {
                    this.__objectRef._groupsField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "email": {
                    this.__objectRef._emailField = null;
                    break;
                }
                case "admins": {
                    this.__objectRef._adminsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec displayName() {
            return new PathSpec(this.getPathComponents(), "displayName");
        }

        public PathSpec email() {
            return new PathSpec(this.getPathComponents(), "email");
        }

        @Deprecated
        public PathSpec admins() {
            return new PathSpec(this.getPathComponents(), "admins");
        }

        @Deprecated
        public PathSpec admins(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "admins");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        @Deprecated
        public PathSpec members() {
            return new PathSpec(this.getPathComponents(), "members");
        }

        @Deprecated
        public PathSpec members(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "members");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        @Deprecated
        public PathSpec groups() {
            return new PathSpec(this.getPathComponents(), "groups");
        }

        @Deprecated
        public PathSpec groups(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "groups");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public PathSpec slack() {
            return new PathSpec(this.getPathComponents(), "slack");
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _createdMask;

        ProjectionMask() {
            super(11);
        }

        public ProjectionMask withDisplayName() {
            this.getDataMap().put("displayName", 1);
            return this;
        }

        public ProjectionMask withEmail() {
            this.getDataMap().put("email", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withAdmins() {
            this.getDataMap().put("admins", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withAdmins(Integer start, Integer count) {
            this.getDataMap().put("admins", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("admins").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("admins").put("$count", count);
            }
            return this;
        }

        @Deprecated
        public ProjectionMask withMembers() {
            this.getDataMap().put("members", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withMembers(Integer start, Integer count) {
            this.getDataMap().put("members", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("members").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("members").put("$count", count);
            }
            return this;
        }

        @Deprecated
        public ProjectionMask withGroups() {
            this.getDataMap().put("groups", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withGroups(Integer start, Integer count) {
            this.getDataMap().put("groups", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("groups").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("groups").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withSlack() {
            this.getDataMap().put("slack", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }
    }
}

